/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.dao;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.TypedQuery;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.webconferencing.domain.CallEntity;

public class CallDAO
extends GenericDAOJPAImpl<CallEntity, String> {
    public static final int USER_CALL_DAYS_LIVETIME = 2;

    public CallEntity findGroupCallByOwnerId(String ownerId) throws PersistenceException, IllegalStateException, IllegalArgumentException {
        TypedQuery query = this.getEntityManager().createNamedQuery("WebConfCall.findGroupCallByOwnerId", CallEntity.class).setParameter("ownerId", (Object)ownerId);
        try {
            return (CallEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public CallEntity findGroupCallByOwnerTypeId(String ownerId, String ownerType) throws PersistenceException, IllegalStateException, IllegalArgumentException {
        TypedQuery query = this.getEntityManager().createNamedQuery("WebConfCall.findGroupCallByOwnerTypeId", CallEntity.class).setParameter("ownerId", (Object)ownerId).setParameter("ownerType", (Object)ownerType);
        try {
            return (CallEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<CallEntity> findGroupCallsByOwnerTypeId(String ownerId, String ownerType) throws PersistenceException, IllegalStateException, IllegalArgumentException {
        TypedQuery query = this.getEntityManager().createNamedQuery("WebConfCall.findGroupCallByOwnerTypeId", CallEntity.class).setParameter("ownerId", (Object)ownerId).setParameter("ownerType", (Object)ownerType);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<CallEntity> findUserGroupCalls(String userId) throws PersistenceException, IllegalStateException, IllegalArgumentException {
        TypedQuery query = this.getEntityManager().createNamedQuery("WebConfCall.findUserGroupCalls", CallEntity.class).setParameter("userId", (Object)userId);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public List<CallEntity> findCallsByState(String state) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WebConfCall.findCallsByState", CallEntity.class).setParameter("state", (Object)state);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public int deleteAllUsersCalls() throws PersistenceException, IllegalStateException, IllegalArgumentException {
        LocalDateTime expired = LocalDate.now().atStartOfDay().minusDays(2L);
        return this.getEntityManager().createNamedQuery("WebConfCall.deleteOwnerOlderCalls").setParameter("ownerType", (Object)"user").setParameter("expiredDate", (Object)Timestamp.valueOf(expired)).executeUpdate();
    }

    public void clear() {
        this.getEntityManager().clear();
    }
}

