/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.notification.provider;

import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.webconferencing.notification.utils.NotificationConstants;
import org.exoplatform.webui.utils.TimeConvertUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="CallRecordingPlugin", template="war:/notification/templates/web/CallRecordingPlugin.gtmpl")})
public class WebTemplateProvider
extends TemplateProvider {
    public WebTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"CallRecordingPlugin"), new TemplateBuilder());
    }

    private class TemplateBuilder
    extends AbstractTemplateBuilder {
        private TemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext notificationContext) {
            NotificationInfo notificationInfo = notificationContext.getNotificationInfo();
            String pluginId = notificationInfo.getKey().getId();
            String recordingStatus = notificationInfo.getValueOwnerParameter(NotificationConstants.RECORDING_STATUS.getKey());
            String fileName = notificationInfo.getValueOwnerParameter(NotificationConstants.FILE_NAME.getKey());
            String fileUrl = notificationInfo.getValueOwnerParameter(NotificationConstants.RECORDED_FILE_URL.getKey());
            String avatarUrl = notificationInfo.getValueOwnerParameter(NotificationConstants.AVATAR_URL.getKey());
            String callOwner = notificationInfo.getValueOwnerParameter(NotificationConstants.CALL_OWNER.getKey());
            String language = this.getLanguage(notificationInfo);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            templateContext.put((Object)"RECORDING_STATUS", (Object)recordingStatus);
            templateContext.put((Object)"FILE_NAME", (Object)fileName);
            templateContext.put((Object)"AVATAR", (Object)avatarUrl);
            templateContext.put((Object)"FILE_URL", (Object)fileUrl);
            templateContext.put((Object)"CALL_OWNER", (Object)callOwner);
            templateContext.put((Object)"USER", (Object)notificationInfo.getTo());
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTimeInMillis(notificationInfo.getLastModifiedDate());
            templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)lastModified.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
            boolean isRead = Boolean.parseBoolean(notificationInfo.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey()));
            templateContext.put((Object)"READ", (Object)(isRead ? "read" : "unread"));
            templateContext.put((Object)"NOTIFICATION_ID", (Object)notificationInfo.getId());
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            notificationContext.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext notificationContext, Writer writer) {
            return false;
        }
    }
}

