/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.common.router.ExoRouter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.webconferencing.CallInfo;
import org.exoplatform.webconferencing.ContextInfo;
import org.exoplatform.webconferencing.IdentityInfo;
import org.exoplatform.webconferencing.WebConferencingService;
import org.exoplatform.webconferencing.cometd.CometdWebConferencingService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;

public class Utils {
    public static String spaceRoomName(String spacePrettyName) {
        StringBuilder sname = new StringBuilder();
        sname.append("eXoWebConferencing");
        for (String s : spacePrettyName.split("_")) {
            if (s.length() <= 0) continue;
            sname.append(Character.toUpperCase(s.charAt(0)));
            if (s.length() <= 1) continue;
            sname.append(s.substring(1));
        }
        sname.append("Space");
        return sname.toString();
    }

    public static Space getSpaceByContext() {
        String spacePrettyName;
        SpaceService spaceService;
        WebuiRequestContext webuiContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (webuiContext != null && (spaceService = (SpaceService)webuiContext.getUIApplication().getApplicationComponent(SpaceService.class)) != null && (spacePrettyName = Utils.getSpaceNameByContext()) != null) {
            return spaceService.getSpaceByPrettyName(spacePrettyName);
        }
        return null;
    }

    public static String getSpaceNameByContext() {
        PortalRequestContext portlalContext;
        String requestPath;
        ExoRouter.Route route;
        WebuiRequestContext webuiContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (webuiContext != null && (route = ExoRouter.route((String)(requestPath = (portlalContext = webuiContext instanceof PortalRequestContext ? (PortalRequestContext)webuiContext : (PortalRequestContext)webuiContext.getParentAppRequestContext()).getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH)))) != null && portlalContext.getSiteType().equals((Object)SiteType.GROUP) && portlalContext.getSiteName().startsWith("/spaces")) {
            return (String)route.localArgs.get("spacePrettyName");
        }
        return null;
    }

    public static ContextInfo getCurrentContext(String userId, Locale locale) {
        return Utils.getCurrentContext(userId, null, locale);
    }

    public static ContextInfo getCurrentContext(String userId, String spaceId, Locale locale) {
        String spaceRoomName = "";
        String spacePrettyName = "";
        ExoContainer exo = ExoContainerContext.getCurrentContainer();
        SpaceService spaceService = (SpaceService)exo.getComponentInstanceOfType(SpaceService.class);
        if (StringUtils.isNotBlank((String)spaceId)) {
            Space space = spaceService.getSpaceById(spaceId);
            if (space != null) {
                spacePrettyName = space.getPrettyName();
                spaceRoomName = Utils.spaceRoomName(spacePrettyName);
            } else {
                spacePrettyName = spaceRoomName = IdentityInfo.EMPTY;
            }
        }
        WebConferencingService webConferencing = (WebConferencingService)exo.getComponentInstanceOfType(WebConferencingService.class);
        CometdWebConferencingService cometdService = (CometdWebConferencingService)exo.getComponentInstanceOfType(CometdWebConferencingService.class);
        ContextInfo context = cometdService != null ? new ContextInfo(exo.getContext().getName(), spacePrettyName, spaceRoomName, cometdService.getCometdServerPath(), cometdService.getUserToken(userId), webConferencing.getProviderConfigurations()) : new ContextInfo(exo.getContext().getName(), spacePrettyName, spaceRoomName, webConferencing.getProviderConfigurations());
        if (locale != null) {
            context.addMessages(Utils.getResourceMessages("locale.webconferencing.WebConferencingClient", locale));
        }
        return context;
    }

    public static Map<String, String> getResourceMessages(String bundleName, Locale locale) {
        ExoContainer exo = ExoContainerContext.getCurrentContainer();
        ResourceBundleService service = (ResourceBundleService)exo.getComponentInstanceOfType(ResourceBundleService.class);
        ResourceBundle res = service.getResourceBundle(bundleName, locale);
        HashMap<String, String> resMap = new HashMap<String, String>();
        Enumeration<String> keys = res.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            resMap.put(key, res.getString(key));
        }
        return resMap;
    }

    public static String getResourceMessage(String bundleName, Locale locale, String messageKey) {
        ExoContainer exo = ExoContainerContext.getCurrentContainer();
        ResourceBundleService service = (ResourceBundleService)exo.getComponentInstanceOfType(ResourceBundleService.class);
        ResourceBundle res = service.getResourceBundle(bundleName, locale);
        return res.getString(messageKey);
    }

    public static String asJSON(Object obj) throws JsonException {
        if (obj != null) {
            JsonGeneratorImpl gen = new JsonGeneratorImpl();
            if (obj.getClass().isArray()) {
                return gen.createJsonArray(obj).toString();
            }
            if (CallInfo.class.isAssignableFrom(obj.getClass())) {
                return ((CallInfo)CallInfo.class.cast(obj)).toJSON();
            }
            return gen.createJsonObject(obj).toString();
        }
        return "null";
    }

    public static Date parseISODate(String date) throws ParseException {
        if (date != null) {
            return ISO8601.parse((String)date).getTime();
        }
        return null;
    }

    public static String formatISODate(Date date) {
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
            return ISO8601.format((Calendar)calendar);
        }
        return null;
    }

    public static String buildUrl(String protocol, String hostname, int port, String path) throws MalformedURLException {
        return new URL(protocol, hostname, port, path).toString();
    }
}

