/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.cometd;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.cometd.annotation.Param;
import org.cometd.annotation.RemoteCall;
import org.cometd.annotation.ServerAnnotationProcessor;
import org.cometd.annotation.Service;
import org.cometd.annotation.Subscription;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.eclipse.jetty.util.component.LifeCycle;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.webconferencing.CallInfo;
import org.exoplatform.webconferencing.CallInfoException;
import org.exoplatform.webconferencing.CallNotFoundException;
import org.exoplatform.webconferencing.CallState;
import org.exoplatform.webconferencing.UserCallListener;
import org.exoplatform.webconferencing.Utils;
import org.exoplatform.webconferencing.WebConferencingService;
import org.exoplatform.webconferencing.client.ErrorInfo;
import org.exoplatform.webconferencing.support.CallLog;
import org.exoplatform.webconferencing.support.CallLogService;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;
import org.picocontainer.Startable;

public class CometdWebConferencingService
implements Startable {
    public static final String CALLS_CHANNEL_NAME = "/webconferencing/calls";
    public static final String LOGS_CHANNEL_NAME = "/webconferencing/logs";
    public static final String CALL_SUBSCRIPTION_CHANNEL_NAME = "/eXo/Application/WebConferencing/call";
    public static final String CALL_SUBSCRIPTION_CHANNEL_NAME_ALL = "/eXo/Application/WebConferencing/call/**";
    public static final String CALL_SUBSCRIPTION_CHANNEL_NAME_PARAMS = "/eXo/Application/WebConferencing/call/{callType}/{callInfo}";
    public static final String USER_SUBSCRIPTION_CHANNEL_NAME = "/eXo/Application/WebConferencing/user";
    public static final String USER_SUBSCRIPTION_CHANNEL_PATTERN = "/eXo/Application/WebConferencing/user/{userId}";
    public static final String COMMAND_GET = "get";
    public static final String COMMAND_CREATE = "create";
    public static final String COMMAND_UPDATE = "update";
    public static final String COMMAND_DELETE = "delete";
    public static final String COMMAND_GET_CALLS_STATE = "get_calls_state";
    public static final String LOG_OK = "{}";
    public static final int MIN_THREADS = 2;
    public static final int MIN_MAX_THREADS = 4;
    public static final int THREAD_IDLE_TIME = 120;
    public static final int CALL_MAX_FACTOR = 20;
    public static final int CALL_QUEUE_FACTOR = 40;
    public static final String CALL_THREAD_PREFIX = "webconferencing-call-thread-";
    private static final Log LOG = ExoLogger.getLogger(CometdWebConferencingService.class);
    protected final WebConferencingService webConferencing;
    protected final EXoContinuationBayeux exoBayeux;
    protected final CallService service;
    protected final OrganizationService organization;
    protected final SessionProviderService sessionProviders;
    protected final IdentityRegistry identityRegistry;
    protected final CallLogService callLogs;
    protected final ExecutorService callHandlers;

    public CometdWebConferencingService(SessionProviderService sessionProviders, IdentityRegistry identityRegistry, OrganizationService organization, WebConferencingService webConferencing, EXoContinuationBayeux exoBayeux, CallLogService callLogs) {
        this.sessionProviders = sessionProviders;
        this.identityRegistry = identityRegistry;
        this.organization = organization;
        this.webConferencing = webConferencing;
        this.exoBayeux = exoBayeux;
        this.callLogs = callLogs;
        this.service = new CallService();
        this.callHandlers = this.createThreadExecutor(CALL_THREAD_PREFIX, 20, 40);
    }

    public void start() {
        final AtomicReference processor = new AtomicReference();
        this.exoBayeux.addLifeCycleListener(new LifeCycle.Listener(){

            public void lifeCycleStarted(LifeCycle event) {
                ServerAnnotationProcessor p = new ServerAnnotationProcessor((BayeuxServer)CometdWebConferencingService.this.exoBayeux);
                processor.set(p);
                p.process((Object)CometdWebConferencingService.this.service);
            }

            public void lifeCycleStopped(LifeCycle event) {
                ServerAnnotationProcessor p = (ServerAnnotationProcessor)processor.get();
                if (p != null) {
                    p.deprocess((Object)CometdWebConferencingService.this.service);
                }
            }

            public void lifeCycleStarting(LifeCycle event) {
            }

            public void lifeCycleFailure(LifeCycle event, Throwable cause) {
            }

            public void lifeCycleStopping(LifeCycle event) {
            }
        });
        if (PropertyManager.isDevelopping()) {
            this.exoBayeux.addListener((BayeuxServer.BayeuxServerListener)new BayeuxServer.SessionListener(){

                public void sessionRemoved(ServerSession session, boolean timedout) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("sessionRemoved: " + session.getId() + " timedout:" + timedout + " channels: " + CometdWebConferencingService.this.channelsAsString(session.getSubscriptions())));
                    }
                }

                public void sessionAdded(ServerSession session, ServerMessage message) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("sessionAdded: " + session.getId() + " channels: " + CometdWebConferencingService.this.channelsAsString(session.getSubscriptions())));
                    }
                }
            });
        }
    }

    public void stop() {
    }

    public String getCometdServerPath() {
        return "/" + this.exoBayeux.getCometdContextName() + "/cometd";
    }

    public String getUserToken(String userId) {
        return this.exoBayeux.getUserToken(userId);
    }

    protected String currentUserId(ServerMessage message) {
        if (message != null) {
            return this.asString(message.get((Object)"exoId"));
        }
        ConversationState convo = ConversationState.getCurrent();
        if (convo != null) {
            return convo.getIdentity().getUserId();
        }
        return IdentityConstants.ANONIM;
    }

    protected String channelUserId(String channelId) throws IndexOutOfBoundsException {
        return channelId.substring(USER_SUBSCRIPTION_CHANNEL_NAME.length() + 1);
    }

    protected String channelsAsString(Set<ServerChannel> channels) {
        return channels.stream().map(c -> c.getId()).collect(Collectors.joining(", "));
    }

    protected String callId(String type, String info) {
        return new StringBuffer(type).append('/').append(info).toString();
    }

    protected String asString(Object obj) {
        if (obj != null && String.class.isAssignableFrom(obj.getClass())) {
            return (String)String.class.cast(obj);
        }
        return null;
    }

    protected ExecutorService createThreadExecutor(String threadNamePrefix, int maxFactor, int queueFactor) {
        int cpus = Runtime.getRuntime().availableProcessors();
        int poolThreads = cpus / 4;
        poolThreads = poolThreads < 2 ? 2 : poolThreads;
        int maxThreads = Math.round((float)cpus * 1.0f * (float)maxFactor);
        maxThreads = maxThreads > 0 ? maxThreads : 1;
        maxThreads = maxThreads < 4 ? 4 : maxThreads;
        int queueSize = cpus * queueFactor;
        int n = queueSize = queueSize < queueFactor ? queueFactor : queueSize;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating thread executor " + threadNamePrefix + "* for " + poolThreads + ".." + maxThreads + " threads, queue size " + queueSize));
        }
        return new ThreadPoolExecutor(poolThreads, maxThreads, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new CommandThreadFactory(threadNamePrefix), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    @Service(value="webconferencing")
    public class CallService {
        @Inject
        private BayeuxServer bayeux;
        @org.cometd.annotation.Session
        private LocalSession localSession;
        @org.cometd.annotation.Session
        private ServerSession serverSession;
        private final Map<String, UserChannelContext> userChannelContext = new ConcurrentHashMap<String, UserChannelContext>();
        private final Map<String, CallChannelContext> callChannelContext = new ConcurrentHashMap<String, CallChannelContext>();
        private final ChannelSubscriptionListener subscriptionListener = new ChannelSubscriptionListener();
        private final ClientChannelListener channelListener = new ClientChannelListener();

        @PostConstruct
        public void postConstruct() {
            this.bayeux.addListener((BayeuxServer.BayeuxServerListener)this.channelListener);
        }

        @PreDestroy
        public void preDestroy() {
            this.bayeux.removeListener((BayeuxServer.BayeuxServerListener)this.channelListener);
            for (UserChannelContext context : this.userChannelContext.values()) {
                CometdWebConferencingService.this.webConferencing.removeUserCallListener(context.getListener());
            }
            this.userChannelContext.clear();
        }

        @Subscription(value={"/eXo/Application/WebConferencing/call/{callType}/{callInfo}"})
        public void subscribeCalls(Message message, @Param(value="callType") String callType, @Param(value="callInfo") String callInfo) {
            if (LOG.isDebugEnabled()) {
                String callId = CometdWebConferencingService.this.callId(callType, callInfo);
                LOG.debug((Object)("Call published in " + message.getChannel() + " by " + message.getClientId() + " callId: " + callId + " data: " + message.getJSON()));
            }
        }

        @Subscription(value={"/eXo/Application/WebConferencing/user"})
        public void subscribeUser(Message message, @Param(value="userId") String userId) {
            String channelId = message.getChannel();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("User published in " + channelId + " by " + message.getClientId() + " userId: " + userId + " data: " + message.getJSON()));
            }
        }

        @RemoteCall(value={"/webconferencing/calls"})
        public void rcCalls(final RemoteCall.Caller caller, final Object data) {
            final ServerSession session = caller.getServerSession();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Remote call by " + session.getId() + " data: " + data));
            }
            final Map arguments = (Map)data;
            String containerName = CometdWebConferencingService.this.asString(arguments.get("exoContainerName"));
            CometdWebConferencingService.this.callHandlers.submit(new ContainerCommand(containerName){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                void execute(ExoContainer exoContainer) {
                    block51: {
                        try {
                            String currentUserId = CometdWebConferencingService.this.asString(arguments.get("exoId"));
                            if (WebConferencingService.isValidId(currentUserId)) {
                                String exoClientId = CometdWebConferencingService.this.asString(arguments.get("exoClientId"));
                                if (WebConferencingService.isValidId(exoClientId)) {
                                    IdentityRegistry identityRegistry = (IdentityRegistry)exoContainer.getComponentInstanceOfType(IdentityRegistry.class);
                                    SessionProviderService sessionProviders = (SessionProviderService)exoContainer.getComponentInstanceOfType(SessionProviderService.class);
                                    WebConferencingService webConferencing = (WebConferencingService)exoContainer.getComponentInstanceOfType(WebConferencingService.class);
                                    Identity userIdentity = identityRegistry.getIdentity(currentUserId);
                                    if (userIdentity == null) {
                                        try {
                                            Authenticator authenticator = (Authenticator)exoContainer.getComponentInstanceOfType(Authenticator.class);
                                            if (LOG.isDebugEnabled()) {
                                                LOG.debug((Object)("User identity not registered, trying to create it for: " + currentUserId));
                                            }
                                            userIdentity = authenticator.createIdentity(currentUserId);
                                        }
                                        catch (Exception e) {
                                            LOG.warn((Object)("Failed to create user identity: " + currentUserId), (Throwable)e);
                                        }
                                    }
                                    if (userIdentity != null) {
                                        ConversationState contextState = ConversationState.getCurrent();
                                        SessionProvider contextProvider = sessionProviders.getSessionProvider(null);
                                        try {
                                            ConversationState convState = new ConversationState(userIdentity);
                                            convState.setAttribute("subject", (Object)userIdentity.getSubject());
                                            ConversationState.setCurrent((ConversationState)convState);
                                            SessionProvider userProvider = new SessionProvider(convState);
                                            sessionProviders.setSessionProvider(null, userProvider);
                                            String id = CometdWebConferencingService.this.asString(arguments.get("id"));
                                            if (WebConferencingService.isValidId(id)) {
                                                String command = CometdWebConferencingService.this.asString(arguments.get("command"));
                                                if (WebConferencingService.isValidArg(command)) {
                                                    if (CometdWebConferencingService.COMMAND_GET.equals(command)) {
                                                        try {
                                                            CallInfo call = webConferencing.getCall(id);
                                                            if (call != null) {
                                                                caller.result((Object)Utils.asJSON(call));
                                                                break block51;
                                                            }
                                                            caller.failure((Object)ErrorInfo.notFoundError("Call not found").asJSON());
                                                        }
                                                        catch (Throwable e) {
                                                            LOG.error((Object)("Error reading call '" + id + "' by '" + currentUserId + "'"), e);
                                                            caller.failure((Object)ErrorInfo.serverError("Error reading call").asJSON());
                                                        }
                                                        break block51;
                                                    }
                                                    if (CometdWebConferencingService.COMMAND_UPDATE.equals(command)) {
                                                        String state = CometdWebConferencingService.this.asString(arguments.get("state"));
                                                        if (WebConferencingService.isValidArg(state)) {
                                                            try {
                                                                CallInfo call;
                                                                boolean stateRecognized = true;
                                                                if ("started".equals(state)) {
                                                                    call = webConferencing.startCall(id, exoClientId);
                                                                } else if ("stopped".equals(state)) {
                                                                    call = webConferencing.stopCall(id, false);
                                                                } else if ("joined".equals(state)) {
                                                                    call = webConferencing.joinCall(id, currentUserId, exoClientId);
                                                                } else if ("leaved".equals(state)) {
                                                                    call = webConferencing.leaveCall(id, currentUserId, exoClientId);
                                                                } else {
                                                                    call = null;
                                                                    stateRecognized = false;
                                                                }
                                                                if (stateRecognized) {
                                                                    if (call != null) {
                                                                        caller.result((Object)Utils.asJSON(call));
                                                                    } else {
                                                                        caller.failure((Object)ErrorInfo.notFoundError("Call not found").asJSON());
                                                                    }
                                                                    break block51;
                                                                }
                                                                caller.failure((Object)ErrorInfo.clientError("Wrong request parameters: state not recognized").asJSON());
                                                            }
                                                            catch (CallNotFoundException e) {
                                                                caller.failure((Object)ErrorInfo.clientError(e.getMessage()).asJSON());
                                                            }
                                                            catch (Throwable e) {
                                                                LOG.error((Object)("Error updating call '" + id + "' by '" + currentUserId + "'"), e);
                                                                caller.failure((Object)ErrorInfo.serverError("Error updating call record").asJSON());
                                                            }
                                                            break block51;
                                                        }
                                                        caller.failure((Object)ErrorInfo.clientError("Wrong request parameters: state").asJSON());
                                                        break block51;
                                                    }
                                                    if (CometdWebConferencingService.COMMAND_CREATE.equals(command)) {
                                                        String ownerId = CometdWebConferencingService.this.asString(arguments.get("owner"));
                                                        String ownerType = CometdWebConferencingService.this.asString(arguments.get("ownerType"));
                                                        String providerType = CometdWebConferencingService.this.asString(arguments.get("provider"));
                                                        String title = CometdWebConferencingService.this.asString(arguments.get("title"));
                                                        String pstr = CometdWebConferencingService.this.asString(arguments.get("participants"));
                                                        if (pstr != null) {
                                                            List<String> participants = Arrays.asList(pstr.split(";"));
                                                            try {
                                                                CallInfo call = webConferencing.addCall(id, ownerId, ownerType, title, providerType, participants);
                                                                caller.result((Object)Utils.asJSON(call));
                                                            }
                                                            catch (CallInfoException e) {
                                                                caller.failure((Object)ErrorInfo.clientError(e.getMessage()).asJSON());
                                                            }
                                                            catch (Throwable e) {
                                                                LOG.error((Object)("Error creating call for '" + id + "' by '" + currentUserId + "'"), e);
                                                                caller.failure((Object)ErrorInfo.serverError("Error creating call record").asJSON());
                                                            }
                                                        } else {
                                                            caller.failure((Object)ErrorInfo.clientError("Wrong request parameters: participants").asJSON());
                                                        }
                                                        break block51;
                                                    }
                                                    if (CometdWebConferencingService.COMMAND_DELETE.equals(command)) {
                                                        try {
                                                            CallInfo call = webConferencing.stopCall(id, true);
                                                            if (call != null) {
                                                                caller.result((Object)Utils.asJSON(call));
                                                                break block51;
                                                            }
                                                            caller.failure((Object)ErrorInfo.notFoundError("Call not found").asJSON());
                                                        }
                                                        catch (CallNotFoundException e) {
                                                            caller.failure((Object)ErrorInfo.clientError(e.getMessage()).asJSON());
                                                        }
                                                        catch (Throwable e) {
                                                            LOG.error((Object)("Error deleting call '" + id + "' by '" + currentUserId + "'"), e);
                                                            caller.failure((Object)ErrorInfo.serverError("Error deleting call record").asJSON());
                                                        }
                                                        break block51;
                                                    }
                                                    if (CometdWebConferencingService.COMMAND_GET_CALLS_STATE.equals(command)) {
                                                        if (id.equals(currentUserId)) {
                                                            try {
                                                                CallState[] calls = webConferencing.getUserCalls(id);
                                                                caller.result((Object)Utils.asJSON(calls));
                                                            }
                                                            catch (Throwable e) {
                                                                LOG.error((Object)("Error reading users calls for '" + id + "'"), e);
                                                                caller.failure((Object)ErrorInfo.serverError("Error reading user calls").asJSON());
                                                            }
                                                        } else {
                                                            caller.failure((Object)ErrorInfo.clientError("Wrong request parameters: id (does not match)").asJSON());
                                                        }
                                                    } else {
                                                        LOG.warn((Object)("Unknown call command " + command + " for '" + id + "' from '" + currentUserId + "'"));
                                                        caller.failure((Object)ErrorInfo.clientError("Unknown command").asJSON());
                                                    }
                                                    break block51;
                                                }
                                                caller.failure((Object)ErrorInfo.clientError("Wrong request parameters: command").asJSON());
                                                break block51;
                                            }
                                            caller.failure((Object)ErrorInfo.clientError("Wrong request parameters: id").asJSON());
                                            break block51;
                                        }
                                        finally {
                                            ConversationState.setCurrent((ConversationState)contextState);
                                            sessionProviders.setSessionProvider(null, contextProvider);
                                        }
                                    }
                                    LOG.warn((Object)("User identity not found " + currentUserId + " for remote call of " + CometdWebConferencingService.CALLS_CHANNEL_NAME));
                                    caller.failure((Object)ErrorInfo.clientError("User identity not found").asJSON());
                                    break block51;
                                }
                                caller.failure((Object)ErrorInfo.clientError("Bad client ID").asJSON());
                                break block51;
                            }
                            caller.failure((Object)ErrorInfo.clientError("Unauthorized user").asJSON());
                        }
                        catch (Throwable e) {
                            LOG.error((Object)("Error processing call request from client " + session.getId() + " with data: " + data), e);
                            caller.failure((Object)ErrorInfo.serverError("Error processing call request: " + e.getMessage()).asJSON());
                        }
                    }
                }

                @Override
                void onContainerError(String error) {
                    LOG.warn((Object)("Container error: " + error + " (" + this.containerName + ") for remote call of " + CometdWebConferencingService.CALLS_CHANNEL_NAME));
                    caller.failure((Object)ErrorInfo.clientError(error).asJSON());
                }
            });
        }

        @RemoteCall(value={"/webconferencing/logs"})
        public void rcLogs(RemoteCall.Caller caller, Object args) {
            block30: {
                ServerSession session = caller.getServerSession();
                Map params = (Map)args;
                try {
                    String currentUserId = CometdWebConferencingService.this.asString(params.get("exoId"));
                    if (WebConferencingService.isValidId(currentUserId)) {
                        String clientId = CometdWebConferencingService.this.asString(params.get("exoClientId"));
                        if (WebConferencingService.isValidArg(clientId)) {
                            String level = CometdWebConferencingService.this.asString(params.get("level"));
                            if (WebConferencingService.isValidArg(level)) {
                                String timestamp = CometdWebConferencingService.this.asString(params.get("timestamp"));
                                if (WebConferencingService.isValidArg(timestamp)) {
                                    String provider = CometdWebConferencingService.this.asString(params.get("provider"));
                                    if (WebConferencingService.isValidText(provider)) {
                                        String prefix = CometdWebConferencingService.this.asString(params.get("prefix"));
                                        if (WebConferencingService.isValidText(prefix)) {
                                            Object msgObj = params.get("data");
                                            if (msgObj != null) {
                                                LocalDateTime msgTimestamp;
                                                Map<String, Object> msgData;
                                                if (Map.class.isAssignableFrom(msgObj.getClass())) {
                                                    msgData = (HashMap)msgObj;
                                                } else if (String.class.isAssignableFrom(msgObj.getClass())) {
                                                    msgData = new HashMap();
                                                    msgData.put("message", String.class.cast(msgObj));
                                                } else {
                                                    LOG.warn((Object)"");
                                                    msgData = Collections.emptyMap();
                                                }
                                                String message = CallLog.validate(CometdWebConferencingService.this.asString(msgData.get("message")));
                                                CallLog callLog = CometdWebConferencingService.this.callLogs.getLog();
                                                StringBuilder msgLine = new StringBuilder();
                                                msgLine.append('[');
                                                if (provider != null) {
                                                    msgLine.append(provider);
                                                }
                                                if (prefix != null) {
                                                    if (msgLine.length() > 1) {
                                                        msgLine.append('.');
                                                    }
                                                    msgLine.append(prefix);
                                                }
                                                if (msgLine.length() > 1) {
                                                    msgLine.append("] ");
                                                } else {
                                                    msgLine.deleteCharAt(0);
                                                }
                                                msgLine.append(currentUserId);
                                                msgLine.append('-');
                                                msgLine.append(clientId);
                                                msgLine.append(' ');
                                                msgLine.append(message);
                                                msgLine.append(" -- ");
                                                msgLine.append(timestamp);
                                                try {
                                                    msgTimestamp = LocalDateTime.parse(timestamp, DateTimeFormatter.ISO_DATE_TIME);
                                                }
                                                catch (DateTimeParseException e) {
                                                    LOG.warn((Object)("Error parsing log timestamp '" + timestamp + "'"), (Throwable)e);
                                                    msgTimestamp = null;
                                                }
                                                if (CallLog.ERROR_LEVEL.equals(level)) {
                                                    callLog.error(msgLine.toString(), msgTimestamp);
                                                } else if (CallLog.WARN_LEVEL.equals(level)) {
                                                    callLog.warn(msgLine.toString(), msgTimestamp);
                                                } else if (CallLog.INFO_LEVEL.equals(level)) {
                                                    callLog.info(msgLine.toString(), msgTimestamp);
                                                } else if (CallLog.DEBUG_LEVEL.equals(level)) {
                                                    callLog.debug(msgLine.toString(), msgTimestamp);
                                                } else if (CallLog.TRACE_LEVEL.equals(level)) {
                                                    callLog.trace(msgLine.toString(), msgTimestamp);
                                                } else {
                                                    callLog.warn("Received not expected level: " + level);
                                                    caller.failure((Object)ErrorInfo.clientError("Not expected request parameters: level").asJSON());
                                                }
                                                caller.result((Object)CometdWebConferencingService.LOG_OK);
                                                break block30;
                                            }
                                            caller.failure((Object)ErrorInfo.clientError("Not found request parameters: data").asJSON());
                                            break block30;
                                        }
                                        caller.failure((Object)ErrorInfo.clientError("Wrong request parameters: prefix").asJSON());
                                        break block30;
                                    }
                                    caller.failure((Object)ErrorInfo.clientError("Wrong request parameters: provider").asJSON());
                                    break block30;
                                }
                                caller.failure((Object)ErrorInfo.clientError("Wrong request parameters: timestamp").asJSON());
                                break block30;
                            }
                            caller.failure((Object)ErrorInfo.clientError("Wrong request parameters: level").asJSON());
                            break block30;
                        }
                        caller.failure((Object)ErrorInfo.clientError("Wrong request parameters: clientId").asJSON());
                        break block30;
                    }
                    caller.failure((Object)ErrorInfo.clientError("Unauthorized user").asJSON());
                }
                catch (Throwable e) {
                    LOG.error((Object)("Error processing call request from client " + session.getId() + " with data: " + args), e);
                    caller.failure((Object)ErrorInfo.serverError("Error processing call request: " + e.getMessage()).asJSON());
                }
            }
        }

        class ClientChannelListener
        implements BayeuxServer.ChannelListener {
            ClientChannelListener() {
            }

            public void configureChannel(ConfigurableServerChannel channel) {
            }

            public void channelAdded(ServerChannel channel) {
                String channelId = channel.getId();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("> Channel added: " + channelId));
                }
                if (channelId.startsWith(CometdWebConferencingService.USER_SUBSCRIPTION_CHANNEL_NAME) || channelId.startsWith(CometdWebConferencingService.CALL_SUBSCRIPTION_CHANNEL_NAME)) {
                    channel.addListener((ConfigurableServerChannel.ServerChannelListener)CallService.this.subscriptionListener);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(">> Added subscription listener for channel: " + channelId));
                    }
                }
            }

            public void channelRemoved(final String channelId) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("< Channel removed: " + channelId));
                }
                if (channelId.startsWith(CometdWebConferencingService.USER_SUBSCRIPTION_CHANNEL_NAME)) {
                    UserChannelContext context = (UserChannelContext)CallService.this.userChannelContext.remove(channelId);
                    if (context != null) {
                        CometdWebConferencingService.this.webConferencing.removeUserCallListener(context.getListener());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("<< Removed user call listener for channel: " + channelId));
                        }
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("<< User call channel context not found for:" + channelId));
                    }
                } else if (channelId.startsWith(CometdWebConferencingService.CALL_SUBSCRIPTION_CHANNEL_NAME) && channelId.length() > CometdWebConferencingService.CALL_SUBSCRIPTION_CHANNEL_NAME.length()) {
                    final String callId = channelId.substring(CometdWebConferencingService.CALL_SUBSCRIPTION_CHANNEL_NAME.length() + 1);
                    CallChannelContext context = (CallChannelContext)CallService.this.callChannelContext.remove(channelId);
                    if (context != null) {
                        CometdWebConferencingService.this.callHandlers.submit(new ContainerCommand(context.getContainerName()){

                            @Override
                            void execute(ExoContainer exoContainer) {
                                try {
                                    CallInfo call = CometdWebConferencingService.this.webConferencing.getCall(callId);
                                    if (call != null) {
                                        CometdWebConferencingService.this.webConferencing.stopCall(callId, !call.getOwner().isGroup());
                                    }
                                }
                                catch (Exception e) {
                                    LOG.error((Object)("Error reading call " + callId), (Throwable)e);
                                }
                            }

                            @Override
                            void onContainerError(String error) {
                                LOG.error((Object)("Container error: " + error + " (" + this.containerName + ") for channel removal " + channelId));
                            }
                        });
                    } else {
                        LOG.warn((Object)("Call context not found for " + callId));
                    }
                }
            }
        }

        class ChannelSubscriptionListener
        implements ServerChannel.SubscriptionListener {
            ChannelSubscriptionListener() {
            }

            public void subscribed(ServerSession remote, ServerChannel channel, ServerMessage message) {
                block15: {
                    String sessionId = remote.getId();
                    final String channelId = channel.getId();
                    String currentUserId = CometdWebConferencingService.this.currentUserId(message);
                    String exoClientId = CometdWebConferencingService.this.asString(message.get((Object)"exoClientId"));
                    String exoContainerName = CometdWebConferencingService.this.asString(message.get((Object)"exoContainerName"));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(">> Subscribed: " + currentUserId + ", session:" + sessionId + " (" + exoContainerName + "@" + exoClientId + "), channel:" + channelId));
                    }
                    if (channelId.startsWith(CometdWebConferencingService.USER_SUBSCRIPTION_CHANNEL_NAME)) {
                        try {
                            if (currentUserId != null) {
                                String userId = CometdWebConferencingService.this.channelUserId(channelId);
                                if (currentUserId.equals(userId)) {
                                    CallService.this.userChannelContext.computeIfAbsent(channelId, k -> {
                                        UserCallListener listener = new UserCallListener(userId, exoClientId){

                                            @Override
                                            public void onPartLeaved(String callId, String providerType, String ownerId, String ownerType, String partId) {
                                                StringBuilder data = new StringBuilder();
                                                data.append('{');
                                                data.append("\"eventType\": \"call_leaved\",");
                                                data.append("\"callId\": \"");
                                                data.append(callId);
                                                data.append("\",\"providerType\": \"");
                                                data.append(providerType);
                                                data.append("\",\"part\": {");
                                                data.append("\"id\": \"");
                                                data.append(partId);
                                                data.append("\"},\"owner\": {");
                                                data.append("\"id\": \"");
                                                data.append(ownerId);
                                                data.append("\",\"type\": \"");
                                                data.append(ownerType);
                                                data.append("\"}");
                                                data.append('}');
                                                CallService.this.bayeux.getChannel(channelId).publish((Session)CallService.this.serverSession, (Object)data.toString());
                                            }

                                            @Override
                                            public void onPartJoined(String callId, String providerType, String ownerId, String ownerType, String partId) {
                                                StringBuilder data = new StringBuilder();
                                                data.append('{');
                                                data.append("\"eventType\": \"call_joined\",");
                                                data.append("\"callId\": \"");
                                                data.append(callId);
                                                data.append("\",\"providerType\": \"");
                                                data.append(providerType);
                                                data.append("\",\"part\": {");
                                                data.append("\"id\": \"");
                                                data.append(partId);
                                                data.append("\"},\"owner\": {");
                                                data.append("\"id\": \"");
                                                data.append(ownerId);
                                                data.append("\",\"type\": \"");
                                                data.append(ownerType);
                                                data.append("\"}");
                                                data.append('}');
                                                CallService.this.bayeux.getChannel(channelId).publish((Session)CallService.this.serverSession, (Object)data.toString());
                                            }

                                            @Override
                                            public void onCallStateChanged(String callId, String providerType, String callState, String ownerId, String ownerType) {
                                                StringBuilder data = new StringBuilder();
                                                data.append('{');
                                                data.append("\"eventType\": \"call_state\",");
                                                data.append("\"callId\": \"");
                                                data.append(callId);
                                                data.append("\",\"providerType\": \"");
                                                data.append(providerType);
                                                data.append("\",\"callState\": \"");
                                                data.append(callState);
                                                data.append("\",\"owner\": {");
                                                data.append("\"id\": \"");
                                                data.append(ownerId);
                                                data.append("\",\"type\": \"");
                                                data.append(ownerType);
                                                data.append("\"}");
                                                data.append('}');
                                                CallService.this.bayeux.getChannel(channelId).publish((Session)CallService.this.serverSession, (Object)data.toString());
                                                if (LOG.isDebugEnabled()) {
                                                    LOG.debug((Object)(">>>> Sent call state update to " + channelId + " by " + CometdWebConferencingService.this.currentUserId(null)));
                                                }
                                            }
                                        };
                                        if (LOG.isDebugEnabled()) {
                                            LOG.debug((Object)("<<< Created user channel context for " + userId + ", client:" + sessionId + ", channel:" + channelId));
                                        }
                                        return new UserChannelContext(listener);
                                    }).addClient(sessionId);
                                } else {
                                    LOG.warn((Object)("Subscribing to other user not possible, was user " + currentUserId + ", channel:" + channelId));
                                    remote.deliver((Session)CallService.this.serverSession, channelId, (Object)ErrorInfo.clientError("Subscribing to other user not possible").asJSON());
                                    if (!channel.unsubscribe(remote)) {
                                        LOG.warn((Object)("Unable to unsubscribe user " + currentUserId + " from channel " + channelId));
                                    }
                                }
                            } else {
                                LOG.warn((Object)("Subscribing by unauthorized user not possible, was channel: " + channelId));
                                remote.deliver((Session)CallService.this.serverSession, channelId, (Object)ErrorInfo.accessError("Unauthorized user").asJSON());
                                if (!channel.unsubscribe(remote)) {
                                    LOG.warn((Object)("Unable to unsubscribe unauthorized user from channel " + channelId));
                                }
                            }
                            break block15;
                        }
                        catch (IndexOutOfBoundsException e) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)(">> Ignore user channel w/o user ID at the end: " + channelId), (Throwable)e);
                            }
                            break block15;
                        }
                    }
                    if (channelId.startsWith(CometdWebConferencingService.CALL_SUBSCRIPTION_CHANNEL_NAME)) {
                        if (exoContainerName != null) {
                            CallService.this.callChannelContext.computeIfAbsent(channelId, k -> {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("<<< Created call channel context by " + currentUserId + ", client:" + sessionId + ", channel:" + channelId));
                                }
                                return new CallChannelContext(exoContainerName);
                            }).addUser(sessionId, currentUserId, exoClientId);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("<< Added call session for " + currentUserId + ", session:" + sessionId + " (" + exoContainerName + "@" + exoClientId + "), channel:" + channelId));
                            }
                        } else {
                            LOG.warn((Object)("eXo container not defined for " + currentUserId + ", client:" + sessionId + ", channel:" + channelId));
                        }
                    }
                }
            }

            public void unsubscribed(ServerSession session, ServerChannel channel, ServerMessage message) {
                final String sessionId = session.getId();
                final String channelId = channel.getId();
                String currentUserId = CometdWebConferencingService.this.currentUserId(message);
                String exoClientId = null;
                String exoContainerName = null;
                if (message != null) {
                    exoClientId = CometdWebConferencingService.this.asString(message.get((Object)"exoClientId"));
                    exoContainerName = CometdWebConferencingService.this.asString(message.get((Object)"exoContainerName"));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(">> Unsubscribed: " + currentUserId + ", session:" + sessionId + " (" + exoContainerName + "@" + exoClientId + "), channel:" + channelId));
                }
                if (channelId.startsWith(CometdWebConferencingService.USER_SUBSCRIPTION_CHANNEL_NAME)) {
                    UserChannelContext context = (UserChannelContext)CallService.this.userChannelContext.get(channelId);
                    if (context != null) {
                        context.removeClient(sessionId);
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("<<< User call channel context not found for session: " + sessionId + ", channel:" + channelId));
                    }
                } else if (channelId.startsWith(CometdWebConferencingService.CALL_SUBSCRIPTION_CHANNEL_NAME) && channelId.length() > CometdWebConferencingService.CALL_SUBSCRIPTION_CHANNEL_NAME.length()) {
                    final String callId = channelId.substring(CometdWebConferencingService.CALL_SUBSCRIPTION_CHANNEL_NAME.length() + 1);
                    final CallChannelContext context = (CallChannelContext)CallService.this.callChannelContext.get(channelId);
                    if (context != null) {
                        CometdWebConferencingService.this.callHandlers.submit(new ContainerCommand(context.getContainerName()){

                            @Override
                            void execute(ExoContainer exoContainer) {
                                try {
                                    CallInfo call = CometdWebConferencingService.this.webConferencing.getCall(callId);
                                    if (call != null) {
                                        CallChannelContext.CallClient client = context.removeUser(sessionId);
                                        if (client != null) {
                                            if (LOG.isDebugEnabled()) {
                                                LOG.debug((Object)(">>> Removed call session for " + client.getUserId() + ", session:" + sessionId + " (" + context.getContainerName() + "@" + client.getClientId() + "), channel:" + channelId));
                                            }
                                            CometdWebConferencingService.this.webConferencing.leaveCall(callId, client.getUserId(), client.getClientId());
                                        } else {
                                            LOG.warn((Object)("Client not found for session " + sessionId + " of " + channelId));
                                        }
                                    } else {
                                        CallService.this.callChannelContext.remove(channelId, context);
                                    }
                                }
                                catch (Exception e) {
                                    LOG.error((Object)("Error reading call " + callId), (Throwable)e);
                                }
                            }

                            @Override
                            void onContainerError(String error) {
                                LOG.error((Object)("Container error: " + error + " (" + this.containerName + ") for channel removal " + channelId));
                            }
                        });
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Call context not found for " + callId));
                    }
                }
            }
        }

        class CallChannelContext {
            final String containerName;
            final Map<String, CallClient> clients = new ConcurrentHashMap<String, CallClient>();

            CallChannelContext(String containerName) {
                this.containerName = containerName;
            }

            void addUser(String sessionId, String userId, String exoClientId) {
                this.clients.put(sessionId, new CallClient(userId, exoClientId));
            }

            CallClient getUser(String clientId) {
                return this.clients.get(clientId);
            }

            CallClient removeUser(String clientId) {
                return this.clients.remove(clientId);
            }

            String getContainerName() {
                return this.containerName;
            }

            boolean hasClients() {
                return this.clients.size() > 0;
            }

            class CallClient {
                final String userId;
                final String clientId;

                CallClient(String userId, String clientId) {
                    this.userId = userId;
                    this.clientId = clientId;
                }

                String getUserId() {
                    return this.userId;
                }

                String getClientId() {
                    return this.clientId;
                }
            }
        }

        class UserChannelContext {
            final Set<String> clients = ConcurrentHashMap.newKeySet();
            final UserCallListener listener;

            UserChannelContext(UserCallListener listener) {
                this.listener = listener;
            }

            UserCallListener getListener() {
                return this.listener;
            }

            boolean hasNoClients() {
                return this.clients.isEmpty();
            }

            boolean hasClient(String sessionId) {
                return this.clients.contains(sessionId);
            }

            boolean removeClient(String sessionId) {
                boolean res = this.clients.remove(sessionId);
                if (this.clients.size() == 0) {
                    CometdWebConferencingService.this.webConferencing.removeUserCallListener(this.listener);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("<<< Removed user call listener for " + this.listener.getUserId() + ", session:" + sessionId));
                    }
                } else if (res) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("<<< Removed user call session for " + this.listener.getUserId() + ", session:" + sessionId));
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("<<< User call session was not removed for " + this.listener.getUserId() + ", session:" + sessionId));
                }
                return res;
            }

            boolean addClient(String sessionId) {
                boolean wasEmpty = this.clients.size() == 0;
                boolean res = this.clients.add(sessionId);
                if (wasEmpty && res) {
                    CometdWebConferencingService.this.webConferencing.addUserCallListener(this.listener);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("<<< Added first user call listener for " + this.listener.getUserId() + ", session:" + sessionId));
                    }
                } else if (res) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("<<< Added user call session for " + this.listener.getUserId() + ", session:" + sessionId));
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("<<< User call session was not added for " + this.listener.getUserId() + ", session:" + sessionId));
                }
                return res;
            }
        }

        abstract class ContainerCommand
        implements Runnable {
            final String containerName;

            ContainerCommand(String containerName) {
                this.containerName = containerName;
            }

            abstract void execute(ExoContainer var1);

            abstract void onContainerError(String var1);

            @Override
            public void run() {
                if (WebConferencingService.isValidId(this.containerName)) {
                    ExoContainer exoContainer = ExoContainerContext.getContainerByName((String)this.containerName);
                    if (exoContainer != null) {
                        ExoContainer contextContainer = ExoContainerContext.getCurrentContainerIfPresent();
                        try {
                            ExoContainerContext.setCurrentContainer((ExoContainer)exoContainer);
                            RequestLifeCycle.begin((ExoContainer)exoContainer);
                            this.execute(exoContainer);
                        }
                        finally {
                            RequestLifeCycle.end();
                            ExoContainerContext.setCurrentContainer((ExoContainer)contextContainer);
                        }
                    } else {
                        this.onContainerError("Container not found");
                    }
                } else {
                    this.onContainerError("Container required");
                }
            }
        }
    }

    static class CommandThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        CommandThreadFactory(String namePrefix) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = namePrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L){

                protected void finalize() throws Throwable {
                    super.finalize();
                    threadNumber.decrementAndGet();
                }
            };
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

