/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webconferencing.admin.portlet;

import java.io.IOException;
import java.util.Locale;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webconferencing.ContextInfo;
import org.exoplatform.webconferencing.UserInfo;
import org.exoplatform.webconferencing.Utils;
import org.exoplatform.webconferencing.WebConferencingService;

public class WebConferencingAdminPortlet
extends GenericPortlet {
    private static final Log LOG = ExoLogger.getLogger(WebConferencingAdminPortlet.class);
    private WebConferencingService webConferencing;

    public void init() throws PortletException {
        super.init();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.webConferencing = (WebConferencingService)container.getComponentInstanceOfType(WebConferencingService.class);
    }

    public void doView(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        String remoteUser = request.getRemoteUser();
        try {
            UserInfo exoUser = this.webConferencing.getUserInfo(remoteUser);
            if (exoUser != null) {
                String exoUserJson = Utils.asJSON((Object)exoUser);
                ContextInfo context = Utils.getCurrentContext((String)remoteUser, (Locale)request.getLocale());
                String contextJson = Utils.asJSON((Object)context);
                request.setAttribute("user", (Object)exoUserJson);
                request.setAttribute("context", (Object)contextJson);
                PortletRequestDispatcher prDispatcher = this.getPortletContext().getRequestDispatcher("/WEB-INF/pages/admin.jsp");
                prDispatcher.include(request, response);
            } else {
                LOG.warn((Object)("Web Conferencing Admin portlet cannot be initialized: user info cannot be obtained for " + remoteUser));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error processing Web Conferencing Admin portlet for user " + remoteUser), (Throwable)e);
        }
    }
}

