/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.utils.videocall;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import org.exoplatform.model.videocall.VideoCallModel;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.videocall.VideoCallService;

public class PropertyManager {
    private static Properties properties = null;
    private static final String PROPERTIES_PATH = System.getProperty("catalina.base") + "/gatein/conf/weemo/weemo.properties";
    private static final String PROPERTIES_CERT_BASE_PATH = System.getProperty("catalina.base") + "/gatein/conf/weemo/";
    public static final String PROPERTY_WEEMO_KEY = "weemo.webappId";
    public static final String PROPERTY_CLIENT_KEY_AUTH = "weemo.authClientId";
    public static final String PROPERTY_CLIENT_SECRET_AUTH = "weemo.authSecretId";
    public static final String PROPERTY_PASSPHRASE = "weemo.customerCertificatePassphrase";
    public static final String PROPERTY_AUTH_URL = "weemo.authURL";
    public static final String PROPERTY_DEFAULT_PERMISSION = "weemo.defaultPermission";
    public static final String PROPERTY_USER_ID_AUTH = "user_id_auth";
    public static final String PROPERTY_VIDEOCALL_VERSION = "videocall.version";
    public static final String PROPERTY_DOMAIN_ID = "domain_id";
    public static final String PROPERTY_CA_FILE = "weemo.commonCertificateFile";
    public static final String PROPERTY_P12_FILE = "weemo.customerCertificateFile";
    public static final String PROPERTY_PASS_AUTH = "pass_auth";
    public static final String PROPERTY_USER_ID_ALLOW = "user_id_allow";
    public static final String PROPERTY_PASS_ALLOW = "pass_allow";
    public static final String PROPERTY_CLIENT_KEY_ALLOW = "client_key_allow";
    public static final String PROPERTY_CLIENT_SECRET_ALLOW = "client_secret_allow";
    public static final String PROPERTY_VIDEO_PROFILE = "video_profile";
    public static VideoCallService videoCallService = null;
    private static final Log LOG = ExoLogger.getLogger((String)PropertyManager.class.getName());

    public static String getProperty(String key) {
        String value = (String)PropertyManager.properties().get(key);
        return value;
    }

    private static Properties properties() {
        if (properties == null) {
            properties = new Properties();
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(PROPERTIES_PATH);
                properties.load(stream);
                ((InputStream)stream).close();
            }
            catch (Exception e) {
                LOG.warn((Object)"Can not find weemo.properties. Default values will be used instead");
            }
            PropertyManager.overridePropertyIfNotSet(PROPERTY_DOMAIN_ID, "");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_VIDEO_PROFILE, "basic");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_AUTH_URL, "https://auth.rtccloud.net/auth/");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_USER_ID_AUTH, "");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_WEEMO_KEY, "");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_CLIENT_KEY_AUTH, "");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_PASSPHRASE, "");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_CLIENT_SECRET_AUTH, "");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_DEFAULT_PERMISSION, "*:/platform/users#true#true");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_CA_FILE, "weemo.pem");
            PropertyManager.overridePropertyIfNotSet(PROPERTY_P12_FILE, "client.p12");
            videoCallService = new VideoCallService();
            if (!videoCallService.isExistVideoCallProfile()) {
                VideoCallModel videoCallModel = new VideoCallModel();
                videoCallModel.setDisableVideoCall(Boolean.toString(false));
                if (PropertyManager.properties().getProperty(PROPERTY_WEEMO_KEY) == null) {
                    videoCallModel.setWeemoKey("");
                } else {
                    videoCallModel.setWeemoKey(PropertyManager.properties().getProperty(PROPERTY_WEEMO_KEY));
                }
                String authId = PropertyManager.properties().getProperty(PROPERTY_CLIENT_KEY_AUTH) == null ? "" : PropertyManager.properties().getProperty(PROPERTY_CLIENT_KEY_AUTH);
                String authSecret = PropertyManager.properties().getProperty(PROPERTY_CLIENT_SECRET_AUTH) == null ? "" : PropertyManager.properties().getProperty(PROPERTY_CLIENT_SECRET_AUTH);
                String passPhrase = PropertyManager.properties().getProperty(PROPERTY_PASSPHRASE) == null ? "" : PropertyManager.properties().getProperty(PROPERTY_PASSPHRASE);
                String domainId = PropertyManager.properties().getProperty(PROPERTY_DOMAIN_ID) == null ? "" : PropertyManager.properties().getProperty(PROPERTY_DOMAIN_ID);
                String profileId = PropertyManager.properties().getProperty(PROPERTY_VIDEO_PROFILE) == null ? "" : PropertyManager.properties().getProperty(PROPERTY_VIDEO_PROFILE);
                InputStream isPem = null;
                String pemName = null;
                try {
                    isPem = new FileInputStream(PROPERTIES_CERT_BASE_PATH + PropertyManager.properties().getProperty(PROPERTY_CA_FILE));
                    if (isPem != null) {
                        pemName = PropertyManager.properties().getProperty(PROPERTY_CA_FILE);
                    }
                }
                catch (FileNotFoundException ex) {
                    isPem = null;
                }
                if (isPem == null && (isPem = videoCallService.getClass().getResourceAsStream("/cert/authCA.crt")) != null) {
                    pemName = "authCA.crt";
                }
                FileInputStream isP12 = null;
                String p12Name = null;
                try {
                    isP12 = new FileInputStream(PROPERTIES_CERT_BASE_PATH + PropertyManager.properties().getProperty(PROPERTY_P12_FILE));
                    if (isP12 != null) {
                        p12Name = PropertyManager.properties().getProperty(PROPERTY_P12_FILE);
                    }
                }
                catch (FileNotFoundException ex) {
                    isP12 = null;
                }
                videoCallModel.setVideoCallPermissions(PropertyManager.properties().getProperty(PROPERTY_DEFAULT_PERMISSION));
                videoCallModel.setCustomerCertificatePassphrase(passPhrase);
                videoCallModel.setAuthId(authId);
                videoCallModel.setAuthSecret(authSecret);
                videoCallModel.setDomainId(domainId);
                videoCallModel.setProfileId(profileId);
                if (isPem != null) {
                    videoCallModel.setPemCert(isPem);
                    videoCallModel.setPemCertName(pemName);
                }
                if (isP12 != null) {
                    videoCallModel.setP12Cert(isP12);
                    videoCallModel.setP12CertName(p12Name);
                }
                videoCallService.saveVideoCallProfile(videoCallModel);
            }
        }
        return properties;
    }

    private static void overridePropertyIfNotSet(String key, String value) {
        if (PropertyManager.properties().getProperty(key) == null) {
            PropertyManager.properties().setProperty(key, value);
            if (System.getProperty(key) != null) {
                PropertyManager.properties().setProperty(key, System.getProperty(key));
            }
        }
    }
}

