/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.videocall;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.model.videocall.VideoCallModel;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.videocall.IDType;
import org.exoplatform.services.videocall.VideoCallService;
import org.exoplatform.utils.videocall.PropertyManager;
import org.json.JSONObject;

public class AuthService {
    private String authUrl = PropertyManager.getProperty("weemo.authURL");
    private String clientId = null;
    private String clientSecret = null;
    private InputStream caFile = null;
    private InputStream p12File = null;
    private String passphrase = null;
    private String domain_id = null;
    private static final Log LOG = ExoLogger.getLogger((String)AuthService.class.getName());

    public JSONObject verifyPermission(String entry) throws Exception {
        PortalContainer container = PortalContainer.getInstance();
        OrganizationService orgService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        UserACL userACL = (UserACL)container.getComponentInstanceOfType(UserACL.class);
        JSONObject json = new JSONObject();
        IDType idType = entry.startsWith("/") ? IDType.GROUP : (entry.contains(":") ? IDType.MEMBERSHIP : IDType.USER);
        boolean isExistEntry = false;
        if (idType == IDType.USER) {
            if (IdentityConstants.ANY.equalsIgnoreCase(entry) || userACL.getSuperUser().equalsIgnoreCase(entry)) {
                isExistEntry = true;
            }
            isExistEntry = orgService.getUserHandler().findUserByName(entry) != null;
            json.put("isExist", isExistEntry);
            if (isExistEntry) {
                User user = orgService.getUserHandler().findUserByName(entry);
                String userName = user.getDisplayName();
                if (userName == null) {
                    userName = user.getFirstName() + " " + user.getLastName();
                }
                json.put("displayName", (Object)userName);
                json.put("type", (Object)"USER");
            }
            return json;
        }
        if (idType == IDType.GROUP) {
            isExistEntry = orgService.getGroupHandler().findGroupById(entry) != null;
            json.put("isExist", isExistEntry);
            if (isExistEntry) {
                json.put("displayName", (Object)orgService.getGroupHandler().findGroupById(entry).getLabel());
                json.put("type", (Object)"GROUP");
            }
        }
        String[] membership = entry.split(":");
        Group group = orgService.getGroupHandler().findGroupById(membership[1]);
        isExistEntry = group == null ? false : ("*".equals(membership[0]) ? true : orgService.getMembershipTypeHandler().findMembershipType(membership[0]) != null);
        json.put("isExist", isExistEntry);
        if (isExistEntry) {
            json.put("displayName", (Object)orgService.getGroupHandler().findGroupById(membership[1]).getLabel());
            json.put("type", (Object)"MEMBERSHIP");
        }
        return json;
    }

    public String authenticate(VideoCallModel videoCallModel, String profile_id) {
        VideoCallService videoCallService = new VideoCallService();
        if (videoCallModel == null) {
            this.caFile = videoCallService.getPemCertInputStream();
            this.p12File = videoCallService.getP12CertInputStream();
            videoCallModel = videoCallService.getVideoCallProfile();
        } else {
            this.caFile = videoCallModel.getPemCert();
            this.p12File = videoCallModel.getP12Cert();
        }
        if (videoCallModel != null) {
            this.domain_id = videoCallModel.getDomainId();
            this.clientId = videoCallModel.getAuthId();
            this.clientSecret = videoCallModel.getAuthSecret();
            this.passphrase = videoCallModel.getCustomerCertificatePassphrase();
        }
        String responseContent = null;
        if (StringUtils.isEmpty((String)this.passphrase)) {
            return null;
        }
        if (this.caFile == null || this.p12File == null) {
            return null;
        }
        try {
            String line;
            HttpsURLConnection connection;
            block22: {
                block21: {
                    SSLContext ctx;
                    block20: {
                        URL url;
                        block19: {
                            String userId = ConversationState.getCurrent().getIdentity().getUserId();
                            ctx = SSLContext.getInstance("SSL");
                            url = null;
                            try {
                                StringBuilder urlBuilder = new StringBuilder();
                                urlBuilder.append(this.authUrl).append("?client_id=" + this.clientId).append("&client_secret=" + this.clientSecret).append("&uid=weemo" + userId);
                                if (!VideoCallService.isCloudRunning()) {
                                    urlBuilder.append("&identifier_client=" + URLEncoder.encode(this.domain_id, "UTF-8")).append("&id_profile=" + URLEncoder.encode(profile_id, "UTF-8"));
                                }
                                url = new URL(urlBuilder.toString());
                            }
                            catch (MalformedURLException e) {
                                if (!LOG.isErrorEnabled()) break block19;
                                LOG.error((Object)"Could not create valid URL with base", (Throwable)e);
                            }
                        }
                        connection = null;
                        try {
                            connection = (HttpsURLConnection)url.openConnection();
                        }
                        catch (IOException e) {
                            if (!LOG.isErrorEnabled()) break block20;
                            LOG.error((Object)"Could not connect", (Throwable)e);
                        }
                    }
                    TrustManager[] trustManagers = AuthService.getTrustManagers(this.caFile, this.passphrase);
                    KeyManager[] keyManagers = AuthService.getKeyManagers("PKCS12", this.p12File, this.passphrase);
                    ctx.init(keyManagers, trustManagers, new SecureRandom());
                    try {
                        connection.setSSLSocketFactory(ctx.getSocketFactory());
                        connection.setRequestMethod("GET");
                        connection.setDoOutput(true);
                        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    }
                    catch (Exception e) {
                        if (!LOG.isErrorEnabled()) break block21;
                        LOG.error((Object)"Could not configure request for POST", (Throwable)e);
                    }
                }
                try {
                    connection.connect();
                }
                catch (IOException e) {
                    if (!LOG.isErrorEnabled()) break block22;
                    LOG.error((Object)"Could not connect to weemo", (Throwable)e);
                }
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder sbuilder = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sbuilder.append(line + "\n");
            }
            br.close();
            responseContent = sbuilder.toString();
            String tokenKey = "";
            if (!StringUtils.isEmpty((String)responseContent) && responseContent.contains("token")) {
                JSONObject json = new JSONObject(responseContent);
                tokenKey = json.get("token").toString();
            } else {
                tokenKey = "";
            }
            videoCallService.setTokenKey(tokenKey);
        }
        catch (Exception ex) {
            LOG.error((Object)"Have problem during authenticating process.", (Throwable)ex);
            videoCallService.setTokenKey("");
        }
        return responseContent;
    }

    protected static KeyManager[] getKeyManagers(String keyStoreType, InputStream keyStoreFile, String keyStorePassword) throws Exception {
        KeyStore keyStore;
        block10: {
            keyStore = null;
            try {
                keyStore = KeyStore.getInstance(keyStoreType);
                keyStore.load(keyStoreFile, keyStorePassword.toCharArray());
            }
            catch (NoSuchAlgorithmException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Java implementation cannot manipulate PKCS12 keystores");
                }
            }
            catch (KeyStoreException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"Java implementation cannot manipulate PKCS12 keystores");
                }
            }
            catch (CertificateException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Bad key or certificate in " + keyStoreFile, new Object[]{e.getMessage()});
                }
            }
            catch (FileNotFoundException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Could not find or read " + keyStoreFile, new Object[]{e.getMessage()});
                }
            }
            catch (IOException e) {
                if (!LOG.isErrorEnabled()) break block10;
                LOG.error((Object)("PKCS12 password is incorrect or keystore is inconsistent: " + keyStoreFile));
            }
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, keyStorePassword.toCharArray());
        return kmf.getKeyManagers();
    }

    protected static TrustManager[] getTrustManagers(InputStream trustStoreFile, String trustStorePassword) throws Exception {
        KeyStore trustStore;
        block21: {
            Certificate caCert;
            block20: {
                block19: {
                    CertificateFactory certificateFactory;
                    block18: {
                        certificateFactory = null;
                        try {
                            certificateFactory = CertificateFactory.getInstance("X.509");
                        }
                        catch (CertificateException e) {
                            if (!LOG.isErrorEnabled()) break block18;
                            LOG.error((Object)("Could not initialize the certificate " + e.getMessage()));
                        }
                    }
                    caCert = null;
                    try {
                        caCert = certificateFactory.generateCertificate(trustStoreFile);
                    }
                    catch (CertificateException e) {
                        if (!LOG.isErrorEnabled()) break block19;
                        LOG.error("Bad key or certificate in " + trustStoreFile, new Object[]{e.getMessage()});
                    }
                }
                trustStore = null;
                try {
                    trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    trustStore.load(null, null);
                }
                catch (KeyStoreException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("Java implementation cannot manipulate " + KeyStore.getDefaultType() + " keystores"));
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)"Could not initialize truststore ", (Throwable)e);
                    }
                }
                catch (CertificateException e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)"Could not initialize truststore ", (Throwable)e);
                    }
                }
                catch (IOException e) {
                    if (!LOG.isErrorEnabled()) break block20;
                    LOG.error((Object)"Could not initialize truststore ", (Throwable)e);
                }
            }
            try {
                trustStore.setCertificateEntry("CA", caCert);
            }
            catch (KeyStoreException e) {
                if (!LOG.isErrorEnabled()) break block21;
                LOG.error((Object)(trustStoreFile + " cannot be used as a CA"), (Throwable)e);
            }
        }
        TrustManagerFactory tmf = null;
        try {
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
        }
        catch (NoSuchAlgorithmException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Java implementation cannot manipulate " + KeyStore.getDefaultType() + " trusts"), (Throwable)e);
            }
        }
        catch (KeyStoreException e) {
            LOG.error((Object)("Java implementation cannot manipulate " + KeyStore.getDefaultType() + " trusts"), (Throwable)e);
        }
        return tmf.getTrustManagers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File convertInputStreamToFile(InputStream inputStream, String fileName) {
        File file = null;
        OutputStream outputStream = null;
        try {
            file = new File(fileName);
            outputStream = new FileOutputStream(file);
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Unknown Exception", (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Unknown Exception", (Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    LOG.error((Object)"Unknown Exception", (Throwable)e);
                }
            }
        }
        return file;
    }
}

