/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portlet.administration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpSession;
import juzu.Action;
import juzu.Method;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.Route;
import juzu.View;
import juzu.impl.request.Request;
import juzu.plugin.ajax.Ajax;
import juzu.request.HttpContext;
import juzu.request.RenderContext;
import juzu.template.Template;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.model.videocall.VideoCallModel;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portlet.administration.VideoCallAdministration_;
import org.exoplatform.portlet.administration.VideoCalls;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.videocall.VideoCallService;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.utils.videocall.PropertyManager;
import org.exoplatform.webui.core.UIPageIterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class VideoCallAdministration {
    @Inject
    @Path(value="index.gtmpl")
    Template index;
    @Inject
    VideoCalls videoCalls;
    Log log = ExoLogger.getLogger((String)"VideoCallAdministration");
    OrganizationService organizationService_;
    SpaceService spaceService_;
    VideoCallService videoCallService_;
    public static String USER_NAME = "userName";
    public static String LAST_NAME = "lastName";
    public static String FIRST_NAME = "firstName";
    public static String EMAIL = "email";
    public static String MODEL_FROM_AUTH = "VideoCallsAuth";
    private static final Log LOG = ExoLogger.getLogger((String)VideoCallAdministration.class.getName());
    @Inject
    Provider<PortletPreferences> providerPreferences;

    @Inject
    public VideoCallAdministration(OrganizationService organizationService, SpaceService spaceService, VideoCallService videoCallService) {
        this.organizationService_ = organizationService;
        this.spaceService_ = spaceService;
        this.videoCallService_ = videoCallService;
    }

    @View
    @Route(value="/")
    public void index(RenderContext renderContext) throws Exception {
        String weemoKey = "";
        String passPhrase = "";
        String authId = "";
        String authSecret = "";
        String p12CertName = "";
        String pemCertName = "";
        String videoPermissions = "";
        boolean turnOffVideoCall = true;
        boolean isFromAuth = false;
        VideoCallModel videoModel = null;
        PortalRequestContext requestContext = Util.getPortalRequestContext();
        HttpSession httpSession = requestContext.getRequest().getSession();
        if (httpSession.getAttribute(MODEL_FROM_AUTH) != null) {
            videoModel = (VideoCallModel)httpSession.getAttribute(MODEL_FROM_AUTH);
            isFromAuth = true;
            httpSession.removeAttribute(MODEL_FROM_AUTH);
        } else {
            videoModel = this.videoCallService_.getVideoCallProfile();
            isFromAuth = false;
        }
        if (videoModel != null) {
            weemoKey = videoModel.getWeemoKey();
            passPhrase = videoModel.getCustomerCertificatePassphrase();
            authId = videoModel.getAuthId();
            authSecret = videoModel.getAuthSecret();
            videoPermissions = videoModel.getVideoCallPermissions();
            turnOffVideoCall = Boolean.parseBoolean(videoModel.getDisableVideoCall());
            if (this.videoCallService_.getP12CertInputStream() != null) {
                p12CertName = videoModel.getP12CertName();
            }
            if (this.videoCallService_.getPemCertInputStream() != null) {
                pemCertName = videoModel.getPemCertName();
            }
        } else {
            weemoKey = PropertyManager.getProperty((String)"weemo.webappId");
            passPhrase = PropertyManager.getProperty((String)"weemo.customerCertificatePassphrase");
            authId = PropertyManager.getProperty((String)"weemo.authClientId");
            authSecret = PropertyManager.getProperty((String)"weemo.authSecretId");
            videoPermissions = PropertyManager.getProperty((String)"weemo.defaultPermission");
        }
        this.index.with().set("turnOffVideoCall", (Object)turnOffVideoCall).set("isDisplaySuccessMsg", (Object)this.videoCalls.isDisplaySuccessMsg()).set("isDisplayAuthSuccessMsg", (Object)this.videoCalls.isDisplayAuthSuccessMsg()).set("weemoKey", (Object)weemoKey).set("isFromAuth", (Object)isFromAuth).set("customerCertificatePassphrase", (Object)passPhrase).set("authId", (Object)authId).set("authSecret", (Object)authSecret).set("videoCallPermissions", (Object)this.getListOfPermissions(videoPermissions)).set("p12CertName", (Object)p12CertName).set("pemCertName", (Object)pemCertName).render();
        this.videoCalls.setDisplaySuccessMsg(false);
        this.videoCalls.setAuthDisplaySuccessMsg(false);
    }

    @Action
    @Route(value="/save")
    public Response save(String disableVideoCall, String videoCallPermissions, HttpContext context) throws Exception {
        VideoCallModel jcrModel;
        if (context.getMethod().equals((Object)Method.GET)) {
            this.videoCalls.setDisplaySuccessMsg(false);
            return VideoCallAdministration_.index();
        }
        VideoCallService videoCallService = new VideoCallService();
        VideoCallModel videoCallModel = new VideoCallModel();
        if (videoCallService != null && (jcrModel = videoCallService.getVideoCallProfile()) != null) {
            videoCallModel.setWeemoKey(jcrModel.getWeemoKey());
            videoCallModel.setAuthId(jcrModel.getAuthId());
            videoCallModel.setAuthSecret(jcrModel.getAuthSecret());
            videoCallModel.setCustomerCertificatePassphrase(jcrModel.getCustomerCertificatePassphrase());
            videoCallModel.setDomainId(jcrModel.getDomainId());
            videoCallModel.setProfileId(jcrModel.getProfileId());
            videoCallModel.setVideoCallPermissions(jcrModel.getVideoCallPermissions());
        }
        boolean disableCall = StringUtils.isEmpty((String)disableVideoCall) ? false : Boolean.parseBoolean(disableVideoCall);
        videoCallModel.setDisableVideoCall(disableVideoCall);
        if (!disableCall) {
            if (videoCallPermissions == null) {
                videoCallPermissions = "";
            }
            videoCallModel.setVideoCallPermissions(videoCallPermissions.trim());
        }
        videoCallService.saveVideoCallProfile(videoCallModel);
        this.videoCalls.setDisplaySuccessMsg(true);
        return VideoCallAdministration_.index();
    }

    @Ajax
    @Resource
    public Response.Content openUserPermission() throws Exception {
        ObjectPageList objPageList = new ObjectPageList(this.organizationService_.getUserHandler().findUsers(new Query()).getAll(), 10);
        UIPageIterator uiIterator = new UIPageIterator();
        uiIterator.setPageList((PageList)objPageList);
        List users = uiIterator.getCurrentPageData();
        JSONArray arrays = new JSONArray();
        for (int i = 0; i < users.size(); ++i) {
            User user = (User)users.get(i);
            if (StringUtils.isEmpty((String)user.getDisplayName())) {
                user.setDisplayName(user.getFirstName() + " " + user.getLastName());
            }
            JSONObject obj = new JSONObject();
            obj.put("userName", (Object)user.getUserName());
            obj.put("firstName", (Object)user.getFirstName());
            obj.put("lastName", (Object)user.getLastName());
            obj.put("displayName", (Object)user.getDisplayName());
            obj.put("email", (Object)user.getEmail());
            arrays.put((Object)obj.toString());
        }
        return Response.ok((CharSequence)arrays.toString()).withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Ajax
    @Resource
    public Response.Content searchUserPermission(String keyword, String filter) throws Exception {
        Query q = new Query();
        if (keyword != null && (keyword = keyword.trim()).length() != 0) {
            if (keyword.indexOf("*") < 0) {
                if (keyword.charAt(0) != '*') {
                    keyword = "*" + keyword;
                }
                if (keyword.charAt(keyword.length() - 1) != '*') {
                    keyword = keyword + "*";
                }
            }
            keyword = keyword.replace('?', '_');
            if (USER_NAME.equals(filter)) {
                q.setUserName(keyword);
            }
            if (LAST_NAME.equals(filter)) {
                q.setLastName(keyword);
            }
            if (FIRST_NAME.equals(filter)) {
                q.setFirstName(keyword);
            }
            if (EMAIL.equals(filter)) {
                q.setEmail(keyword);
            }
        }
        List users = this.organizationService_.getUserHandler().findUsers(q).getAll();
        JSONArray arrays = new JSONArray();
        for (int i = 0; i < users.size(); ++i) {
            User user = (User)users.get(i);
            if (StringUtils.isEmpty((String)user.getDisplayName())) {
                user.setDisplayName(user.getFirstName() + " " + user.getLastName());
            }
            JSONObject obj = new JSONObject();
            obj.put("userName", (Object)user.getUserName());
            obj.put("firstName", (Object)user.getFirstName());
            obj.put("lastName", (Object)user.getLastName());
            obj.put("displayName", (Object)user.getDisplayName());
            obj.put("email", (Object)user.getEmail());
            arrays.put((Object)obj.toString());
        }
        return Response.ok((CharSequence)arrays.toString()).withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Ajax
    @Resource
    public Response.Content openGroupPermission(String groupId) throws Exception {
        Collection collection = this.organizationService_.getMembershipTypeHandler().findMembershipTypes();
        ArrayList<String> listMemberhip = new ArrayList<String>(5);
        StringBuffer sb = new StringBuffer();
        String memberships = "";
        for (Object obj : collection) {
            listMemberhip.add(((MembershipType)obj).getName());
        }
        if (!listMemberhip.contains("*")) {
            listMemberhip.add("*");
        }
        Collections.sort(listMemberhip);
        for (String string : listMemberhip) {
            sb.append(string).append(",");
        }
        memberships = sb.toString();
        memberships = memberships.substring(0, memberships.length() - 1);
        String groups = "[";
        StringBuffer sbGroups = new StringBuffer();
        Collection sibblingsGroup = null;
        if (StringUtils.isEmpty((String)groupId)) {
            sibblingsGroup = this.organizationService_.getGroupHandler().findGroups(null);
        } else {
            Group group = this.organizationService_.getGroupHandler().findGroupById(groupId);
            String parentId = group.getParentId();
            Group parentGroup = null;
            if (parentId != null) {
                parentGroup = this.organizationService_.getGroupHandler().findGroupById(parentId);
            }
            sibblingsGroup = this.organizationService_.getGroupHandler().findGroups(parentGroup);
        }
        if (sibblingsGroup != null && sibblingsGroup.size() > 0) {
            for (Object obj : sibblingsGroup) {
                String groupLabel = ((Group)obj).getLabel();
                if (groupId != null && ((Group)obj).getId().equalsIgnoreCase(groupId)) {
                    String groupObj = this.loadChildrenGroups(groupId, groupLabel);
                    sbGroups.append(groupObj).append(",");
                    continue;
                }
                sb = new StringBuffer();
                sb.append("{\"group\":\"" + ((Group)obj).getId() + "\",\"label\":\"" + groupLabel + "\"}");
                sbGroups.append(sb.toString()).append(",");
            }
        }
        if ((groups = groups.concat(sbGroups.toString())).length() > 1) {
            groups = groups.substring(0, groups.length() - 1);
        }
        groups = groups.concat("]");
        StringBuffer sbResponse = new StringBuffer();
        sbResponse.append("{\"memberships\":\"" + memberships + "\", \"groups\":" + groups + "}");
        return Response.ok((CharSequence)sbResponse.toString()).withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    public String loadChildrenGroups(String groupId, String groupLabel) throws Exception {
        Collection collection;
        JSONObject objGroup = new JSONObject();
        Group group = this.organizationService_.getGroupHandler().findGroupById(groupId);
        objGroup.put("group", (Object)groupId);
        objGroup.put("label", (Object)groupLabel);
        if (group != null && (collection = this.organizationService_.getGroupHandler().findGroups(group)).size() > 0) {
            StringBuffer sbChildren = new StringBuffer();
            sbChildren.append("[");
            for (Object obj : collection) {
                sbChildren.append("{\"group\":\"" + ((Group)obj).getId() + "\",\"label\":\"" + ((Group)obj).getLabel() + "\"},");
            }
            String childrenGroups = sbChildren.toString();
            if (childrenGroups.length() > 1) {
                childrenGroups = childrenGroups.substring(0, childrenGroups.length() - 1);
            }
            childrenGroups = childrenGroups.concat("]");
            objGroup.put("children", (Object)childrenGroups);
        }
        return objGroup.toString();
    }

    public String getListOfPermissions(String videoPermissions) {
        String result;
        block7: {
            result = "";
            Request request = Request.getCurrent();
            Locale locale = request.getContext().getUserContext().getLocale();
            ResourceBundle resoureBundle = request.getContext().getApplicationContext().resolveBundle(locale);
            StringBuffer sb = new StringBuffer();
            try {
                if (videoPermissions != null && videoPermissions.length() > 0) {
                    String[] arrPermissions;
                    for (String string : arrPermissions = videoPermissions.split(",")) {
                        if (string.split("#").length < 2) continue;
                        String permissionId = string.split("#")[0];
                        String enableVideoCalls = string.split("#")[1];
                        sb.append("#").append(permissionId).append(",").append(enableVideoCalls);
                        if (permissionId.indexOf(":") > 0) {
                            String membership;
                            String memebershipLabel = membership = permissionId.split(":")[0].trim();
                            String groupId = permissionId.split(":")[1];
                            Group group = this.organizationService_.getGroupHandler().findGroupById(groupId);
                            if (group == null) continue;
                            sb.append(",").append(VideoCallAdministration.capitalize(memebershipLabel) + " " + resoureBundle.getString("exoplatform.videocall.administration.permission.in") + " " + group.getLabel()).append(" (").append(permissionId).append(")");
                            continue;
                        }
                        User user = this.organizationService_.getUserHandler().findUserByName(permissionId.trim());
                        if (user == null) continue;
                        if (StringUtils.isEmpty((String)user.getDisplayName())) {
                            user.setDisplayName(user.getFirstName() + " " + user.getLastName());
                        }
                        sb.append(",").append(user.getDisplayName()).append(" (").append(user.getUserName()).append(")");
                    }
                    if (sb.length() >= 1) {
                        result = sb.substring(1);
                    }
                }
            }
            catch (Exception ex) {
                if (!this.log.isErrorEnabled()) break block7;
                this.log.error((Object)"getListOfPermissions() failed because of ", (Throwable)ex);
            }
        }
        return result;
    }

    public static String capitalize(String s) {
        if (s.length() == 0) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }
}

