/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portlet.administration;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Scanner;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpSession;
import juzu.Action;
import juzu.HttpMethod;
import juzu.Path;
import juzu.Resource;
import juzu.Response;
import juzu.Route;
import juzu.View;
import juzu.impl.request.Request;
import juzu.plugin.ajax.Ajax;
import juzu.request.HttpContext;
import juzu.template.Template;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.model.videocall.VideoCallModel;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portlet.administration.VideoCallAdministration_;
import org.exoplatform.portlet.administration.VideoCalls;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.videocall.AuthService;
import org.exoplatform.services.videocall.VideoCallService;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.utils.videocall.PropertyManager;
import org.exoplatform.webui.core.UIPageIterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VideoCallAdministration {
    @Inject
    @Path(value="index.gtmpl")
    Template index;
    @Inject
    VideoCalls videoCalls;
    Log log = ExoLogger.getLogger((String)"VideoCallAdministration");
    OrganizationService organizationService_;
    SpaceService spaceService_;
    VideoCallService videoCallService_;
    public static String USER_NAME = "userName";
    public static String LAST_NAME = "lastName";
    public static String FIRST_NAME = "firstName";
    public static String EMAIL = "email";
    public static String MODEL_FROM_AUTH = "VideoCallsAuth";
    private static final Log LOG = ExoLogger.getLogger((String)VideoCallAdministration.class.getName());
    @Inject
    Provider<PortletPreferences> providerPreferences;

    @Inject
    public VideoCallAdministration(OrganizationService organizationService, SpaceService spaceService, VideoCallService videoCallService) {
        this.organizationService_ = organizationService;
        this.spaceService_ = spaceService;
        this.videoCallService_ = videoCallService;
    }

    @View
    @Route(value="/")
    public Response.Content index() throws Exception {
        String weemoKey = "";
        String passPhrase = "";
        String authId = "";
        String authSecret = "";
        String p12CertName = "";
        String pemCertName = "";
        String videoPermissions = "";
        boolean turnOffVideoCall = true;
        boolean isFromAuth = false;
        VideoCallModel videoModel = null;
        PortalRequestContext requestContext = Util.getPortalRequestContext();
        HttpSession httpSession = requestContext.getRequest().getSession();
        if (httpSession.getAttribute(MODEL_FROM_AUTH) != null) {
            videoModel = (VideoCallModel)httpSession.getAttribute(MODEL_FROM_AUTH);
            isFromAuth = true;
            httpSession.removeAttribute(MODEL_FROM_AUTH);
        } else {
            videoModel = this.videoCallService_.getVideoCallProfile();
            isFromAuth = false;
        }
        if (videoModel != null) {
            weemoKey = videoModel.getWeemoKey();
            passPhrase = videoModel.getCustomerCertificatePassphrase();
            authId = videoModel.getAuthId();
            authSecret = videoModel.getAuthSecret();
            videoPermissions = videoModel.getVideoCallPermissions();
            turnOffVideoCall = Boolean.parseBoolean(videoModel.getDisableVideoCall());
            if (this.videoCallService_.getP12CertInputStream() != null) {
                p12CertName = videoModel.getP12CertName();
            }
            if (this.videoCallService_.getPemCertInputStream() != null) {
                pemCertName = videoModel.getPemCertName();
            }
        } else {
            weemoKey = PropertyManager.getProperty((String)"weemo.webappId");
            passPhrase = PropertyManager.getProperty((String)"weemo.customerCertificatePassphrase");
            authId = PropertyManager.getProperty((String)"weemo.authClientId");
            authSecret = PropertyManager.getProperty((String)"weemo.authSecretId");
            videoPermissions = PropertyManager.getProperty((String)"weemo.defaultPermission");
        }
        boolean isDisplaySuccessMsg = this.videoCalls.isDisplaySuccessMsg();
        boolean isDisplayAuthSuccessMsg = this.videoCalls.isDisplayAuthSuccessMsg();
        this.videoCalls.setDisplaySuccessMsg(false);
        this.videoCalls.setAuthDisplaySuccessMsg(false);
        return this.index.with().set("turnOffVideoCall", (Object)turnOffVideoCall).set("isDisplaySuccessMsg", (Object)isDisplaySuccessMsg).set("isDisplayAuthSuccessMsg", (Object)isDisplayAuthSuccessMsg).set("weemoKey", (Object)weemoKey).set("isFromAuth", (Object)isFromAuth).set("customerCertificatePassphrase", (Object)passPhrase).set("authId", (Object)authId).set("authSecret", (Object)authSecret).set("videoCallPermissions", (Object)this.getListOfPermissions(videoPermissions)).set("p12CertName", (Object)p12CertName).set("pemCertName", (Object)pemCertName).set("isCloudRunning", (Object)VideoCallService.isCloudRunning()).ok();
    }

    @Action
    @Route(value="/saveCloud")
    public Response saveCloud(String disableVideoCall, String videoCallPermissions, HttpContext context) throws Exception {
        VideoCallModel jcrModel;
        if (context.getMethod().equals((Object)HttpMethod.GET)) {
            this.videoCalls.setDisplaySuccessMsg(false);
            return VideoCallAdministration_.index();
        }
        VideoCallService videoCallService = new VideoCallService();
        VideoCallModel videoCallModel = new VideoCallModel();
        if (videoCallService != null && (jcrModel = videoCallService.getVideoCallProfile()) != null) {
            videoCallModel.setWeemoKey(jcrModel.getWeemoKey());
            videoCallModel.setAuthId(jcrModel.getAuthId());
            videoCallModel.setAuthSecret(jcrModel.getAuthSecret());
            videoCallModel.setCustomerCertificatePassphrase(jcrModel.getCustomerCertificatePassphrase());
            videoCallModel.setDomainId(jcrModel.getDomainId());
            videoCallModel.setProfileId(jcrModel.getProfileId());
            videoCallModel.setVideoCallPermissions(jcrModel.getVideoCallPermissions());
        }
        boolean disableCall = StringUtils.isEmpty((String)disableVideoCall) ? false : Boolean.parseBoolean(disableVideoCall);
        videoCallModel.setDisableVideoCall(disableVideoCall);
        if (!disableCall) {
            if (videoCallPermissions == null) {
                videoCallPermissions = "";
            }
            videoCallModel.setVideoCallPermissions(videoCallPermissions.trim());
        }
        videoCallService.saveVideoCallProfile(videoCallModel);
        this.videoCalls.setDisplaySuccessMsg(true);
        return VideoCallAdministration_.index();
    }

    @Action
    @Route(value="/save")
    public Response save(String disableVideoCall, String weemoKey, String authId, String authSecret, String customerCertificatePassphrase, String videoCallPermissions, FileItem p12Cert, FileItem pemCert, HttpContext context) throws Exception {
        if (context.getMethod().equals((Object)HttpMethod.GET)) {
            this.videoCalls.setDisplaySuccessMsg(false);
            return VideoCallAdministration_.index();
        }
        VideoCallService videoCallService = new VideoCallService();
        VideoCallModel videoCallModel = new VideoCallModel();
        if (StringUtils.isEmpty((String)disableVideoCall)) {
            videoCallModel.setDisableVideoCall("false");
        } else {
            videoCallModel.setDisableVideoCall(disableVideoCall);
        }
        if (Boolean.parseBoolean(disableVideoCall)) {
            videoCallModel = videoCallService.getVideoCallProfile();
            videoCallModel.setDisableVideoCall(disableVideoCall);
        } else {
            if (weemoKey == null) {
                weemoKey = "";
            }
            if (authId == null) {
                authId = "";
            }
            if (authSecret == null) {
                authSecret = "";
            }
            if (customerCertificatePassphrase == null) {
                customerCertificatePassphrase = "";
            }
            if (videoCallPermissions == null) {
                videoCallPermissions = "";
            }
            videoCallModel.setWeemoKey(weemoKey.trim());
            videoCallModel.setAuthId(authId.trim());
            videoCallModel.setAuthSecret(authSecret.trim());
            videoCallModel.setCustomerCertificatePassphrase(customerCertificatePassphrase.trim());
            videoCallModel.setVideoCallPermissions(videoCallPermissions.trim());
            videoCallModel.setDomainId(PropertyManager.getProperty((String)"domain_id"));
            videoCallModel.setProfileId(PropertyManager.getProperty((String)"video_profile"));
            if (p12Cert != null) {
                videoCallModel.setP12Cert(p12Cert.getInputStream());
                videoCallModel.setP12CertName(p12Cert.getName());
            }
            if (pemCert != null) {
                videoCallModel.setPemCert(pemCert.getInputStream());
                videoCallModel.setPemCertName(pemCert.getName());
            }
        }
        videoCallService.saveVideoCallProfile(videoCallModel);
        this.videoCalls.setDisplaySuccessMsg(true);
        return VideoCallAdministration_.index();
    }

    @Action
    @Route(value="/auth")
    public Response auth(String disableVideoCall, String weemoKey, String authId, String authSecret, String customerCertificatePassphrase, String videoCallPermissions, FileItem p12Cert, FileItem pemCert, HttpContext context) throws Exception {
        PortalRequestContext requestContext = Util.getPortalRequestContext();
        HttpSession httpSession = requestContext.getRequest().getSession();
        if (context.getMethod().equals((Object)HttpMethod.GET)) {
            httpSession.removeAttribute(MODEL_FROM_AUTH);
            return VideoCallAdministration_.index();
        }
        VideoCallModel videoCallModel = new VideoCallModel();
        VideoCallService videoCallService = new VideoCallService();
        String p12CertName = "";
        String pemCertName = "";
        InputStream isP12 = null;
        InputStream isPem = null;
        if (weemoKey == null) {
            weemoKey = "";
        }
        if (authId == null) {
            authId = "";
        }
        if (authSecret == null) {
            authSecret = "";
        }
        if (customerCertificatePassphrase == null) {
            customerCertificatePassphrase = "";
        }
        if (videoCallPermissions == null) {
            videoCallPermissions = "";
        }
        VideoCallModel profile = videoCallService.getVideoCallProfile();
        if (p12Cert == null) {
            isP12 = videoCallService.getP12CertInputStream();
            p12CertName = profile.getP12CertName();
        } else {
            isP12 = p12Cert.getInputStream();
            p12CertName = p12Cert.getName();
        }
        if (pemCert == null) {
            isPem = videoCallService.getPemCertInputStream();
            pemCertName = profile.getPemCertName();
        } else {
            isPem = pemCert.getInputStream();
            pemCertName = pemCert.getName();
        }
        videoCallModel.setWeemoKey(weemoKey);
        videoCallModel.setDisableVideoCall(disableVideoCall);
        videoCallModel.setAuthId(authId.trim());
        videoCallModel.setAuthSecret(authSecret.trim());
        videoCallModel.setCustomerCertificatePassphrase(customerCertificatePassphrase.trim());
        videoCallModel.setP12Cert(isP12);
        videoCallModel.setPemCert(isPem);
        videoCallModel.setP12CertName(p12CertName);
        videoCallModel.setPemCertName(pemCertName);
        videoCallModel.setVideoCallPermissions(videoCallPermissions.trim());
        videoCallModel.setDomainId(PropertyManager.getProperty((String)"domain_id"));
        videoCallModel.setProfileId(PropertyManager.getProperty((String)"video_profile"));
        videoCallModel.setVideoCallPermissions(videoCallPermissions);
        if (StringUtils.isEmpty((String)weemoKey)) {
            this.videoCalls.setAuthDisplaySuccessMsg(false);
            httpSession.setAttribute(MODEL_FROM_AUTH, (Object)videoCallModel);
            return VideoCallAdministration_.index();
        }
        URL url = new URL("https://cjs.weemo.com/js/webappid/" + weemoKey + "");
        InputStream in = url.openStream();
        Scanner scan = new Scanner(in);
        StringBuffer sb = new StringBuffer();
        while (scan.hasNext()) {
            String str = scan.nextLine();
            sb.append(str);
        }
        scan.close();
        try {
            JSONObject json = new JSONObject(sb.toString());
            this.videoCalls.setAuthDisplaySuccessMsg(false);
            httpSession.setAttribute(MODEL_FROM_AUTH, (Object)videoCallModel);
            return VideoCallAdministration_.index();
        }
        catch (JSONException ex) {
            LOG.info((Object)"Weemo key is right");
            AuthService authService = new AuthService();
            String profileId = PropertyManager.getProperty((String)"video_profile");
            String content = authService.authenticate(videoCallModel, profileId);
            if (content != null && content.length() > 0) {
                this.videoCalls.setAuthDisplaySuccessMsg(true);
            } else {
                this.videoCalls.setAuthDisplaySuccessMsg(false);
            }
            httpSession.setAttribute(MODEL_FROM_AUTH, (Object)videoCallModel);
            return VideoCallAdministration_.index();
        }
    }

    @Ajax
    @Resource
    public Response.Content openUserPermission() throws Exception {
        ObjectPageList objPageList = new ObjectPageList(this.organizationService_.getUserHandler().findUsers(new Query()).getAll(), 10);
        UIPageIterator uiIterator = new UIPageIterator();
        uiIterator.setPageList((PageList)objPageList);
        List users = uiIterator.getCurrentPageData();
        JSONArray arrays = new JSONArray();
        for (int i = 0; i < users.size(); ++i) {
            User user = (User)users.get(i);
            if (StringUtils.isEmpty((String)user.getDisplayName())) {
                user.setDisplayName(user.getFirstName() + " " + user.getLastName());
            }
            JSONObject obj = new JSONObject();
            obj.put("userName", (Object)user.getUserName());
            obj.put("firstName", (Object)user.getFirstName());
            obj.put("lastName", (Object)user.getLastName());
            obj.put("displayName", (Object)user.getDisplayName());
            obj.put("email", (Object)user.getEmail());
            arrays.put((Object)obj.toString());
        }
        return Response.ok((CharSequence)arrays.toString()).withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Ajax
    @Resource
    public Response.Content searchUserPermission(String keyword, String filter) throws Exception {
        Query q = new Query();
        if (keyword != null && (keyword = keyword.trim()).length() != 0) {
            if (keyword.indexOf("*") < 0) {
                if (keyword.charAt(0) != '*') {
                    keyword = "*" + keyword;
                }
                if (keyword.charAt(keyword.length() - 1) != '*') {
                    keyword = keyword + "*";
                }
            }
            keyword = keyword.replace('?', '_');
            if (USER_NAME.equals(filter)) {
                q.setUserName(keyword);
            }
            if (LAST_NAME.equals(filter)) {
                q.setLastName(keyword);
            }
            if (FIRST_NAME.equals(filter)) {
                q.setFirstName(keyword);
            }
            if (EMAIL.equals(filter)) {
                q.setEmail(keyword);
            }
        }
        List users = this.organizationService_.getUserHandler().findUsers(q).getAll();
        JSONArray arrays = new JSONArray();
        for (int i = 0; i < users.size(); ++i) {
            User user = (User)users.get(i);
            if (StringUtils.isEmpty((String)user.getDisplayName())) {
                user.setDisplayName(user.getFirstName() + " " + user.getLastName());
            }
            JSONObject obj = new JSONObject();
            obj.put("userName", (Object)user.getUserName());
            obj.put("firstName", (Object)user.getFirstName());
            obj.put("lastName", (Object)user.getLastName());
            obj.put("displayName", (Object)user.getDisplayName());
            obj.put("email", (Object)user.getEmail());
            arrays.put((Object)obj.toString());
        }
        return Response.ok((CharSequence)arrays.toString()).withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    @Ajax
    @Resource
    public Response.Content openGroupPermission(String groupId) throws Exception {
        Collection collection = this.organizationService_.getMembershipTypeHandler().findMembershipTypes();
        ArrayList<String> listMemberhip = new ArrayList<String>(5);
        StringBuffer sb = new StringBuffer();
        String memberships = "";
        for (Object obj : collection) {
            listMemberhip.add(((MembershipType)obj).getName());
        }
        if (!listMemberhip.contains("*")) {
            listMemberhip.add("*");
        }
        Collections.sort(listMemberhip);
        for (String string : listMemberhip) {
            sb.append(string).append(",");
        }
        memberships = sb.toString();
        memberships = memberships.substring(0, memberships.length() - 1);
        String groups = "[";
        StringBuffer sbGroups = new StringBuffer();
        Collection sibblingsGroup = null;
        if (StringUtils.isEmpty((String)groupId)) {
            sibblingsGroup = this.organizationService_.getGroupHandler().findGroups(null);
        } else {
            Group group = this.organizationService_.getGroupHandler().findGroupById(groupId);
            String parentId = group.getParentId();
            Group parentGroup = null;
            if (parentId != null) {
                parentGroup = this.organizationService_.getGroupHandler().findGroupById(parentId);
            }
            sibblingsGroup = this.organizationService_.getGroupHandler().findGroups(parentGroup);
        }
        if (sibblingsGroup != null && sibblingsGroup.size() > 0) {
            for (Object obj : sibblingsGroup) {
                String groupLabel = ((Group)obj).getLabel();
                String groupIdObj = ((Group)obj).getId();
                if (groupId != null && groupIdObj.equalsIgnoreCase(groupId)) {
                    String groupObj = this.loadChildrenGroups(groupId, groupLabel);
                    sbGroups.append(groupObj).append(",");
                    continue;
                }
                sb = new StringBuffer();
                sb.append("{\"group\":\"").append(groupIdObj).append("\",\"label\":\"").append(groupLabel).append("\"}");
                sbGroups.append(sb.toString()).append(",");
            }
        }
        if ((groups = groups.concat(sbGroups.toString())).length() > 1) {
            groups = groups.substring(0, groups.length() - 1);
        }
        groups = groups.concat("]");
        StringBuffer sbResponse = new StringBuffer();
        sbResponse.append("{\"memberships\":\"").append(memberships).append("\", \"groups\":").append(groups).append("}");
        return Response.ok((CharSequence)sbResponse.toString()).withMimeType("application/json; charset=UTF-8").withHeader("Cache-Control", new String[]{"no-cache"});
    }

    public String loadChildrenGroups(String groupId, String groupLabel) throws Exception {
        Collection collection;
        JSONObject objGroup = new JSONObject();
        Group group = this.organizationService_.getGroupHandler().findGroupById(groupId);
        objGroup.put("group", (Object)groupId);
        objGroup.put("label", (Object)groupLabel);
        if (group != null && (collection = this.organizationService_.getGroupHandler().findGroups(group)).size() > 0) {
            StringBuffer sbChildren = new StringBuffer();
            sbChildren.append("[");
            for (Object obj : collection) {
                String groupIdObj = ((Group)obj).getId();
                String groupLabelObj = ((Group)obj).getLabel();
                sbChildren.append("{\"group\":\"").append(groupIdObj).append("\",\"label\":\"").append(groupLabelObj).append("\"},");
            }
            String childrenGroups = sbChildren.toString();
            if (childrenGroups.length() > 1) {
                childrenGroups = childrenGroups.substring(0, childrenGroups.length() - 1);
            }
            childrenGroups = childrenGroups.concat("]");
            objGroup.put("children", (Object)childrenGroups);
        }
        return objGroup.toString();
    }

    public String getListOfPermissions(String videoPermissions) {
        String result;
        block7: {
            result = "";
            Request request = Request.getCurrent();
            Locale locale = request.getUserContext().getLocale();
            ResourceBundle resoureBundle = request.getApplicationContext().resolveBundle(locale);
            StringBuffer sb = new StringBuffer();
            try {
                if (videoPermissions != null && videoPermissions.length() > 0) {
                    String[] arrPermissions;
                    for (String string : arrPermissions = videoPermissions.split(",")) {
                        if (string.split("#").length < 3) continue;
                        String permissionId = string.split("#")[0];
                        String enableVideoCalls = string.split("#")[1];
                        sb.append("#").append(permissionId).append(",").append(enableVideoCalls);
                        String enableVideoGroupCalls = string.split("#")[2];
                        sb.append(",").append(enableVideoGroupCalls);
                        if (permissionId.indexOf(":") > 0) {
                            String membership;
                            String memebershipLabel = membership = permissionId.split(":")[0].trim();
                            String groupId = permissionId.split(":")[1];
                            Group group = this.organizationService_.getGroupHandler().findGroupById(groupId);
                            if (group == null) continue;
                            sb.append(",").append(VideoCallAdministration.capitalize(memebershipLabel)).append(" ").append(resoureBundle.getString("exoplatform.videocall.administration.permission.in")).append(" ").append(group.getLabel()).append(" (").append(permissionId).append(")");
                            continue;
                        }
                        User user = this.organizationService_.getUserHandler().findUserByName(permissionId.trim());
                        if (user == null) continue;
                        if (StringUtils.isEmpty((String)user.getDisplayName())) {
                            user.setDisplayName(user.getFirstName() + " " + user.getLastName());
                        }
                        sb.append(",").append(user.getDisplayName()).append(" (").append(user.getUserName()).append(")");
                    }
                    if (sb.length() >= 1) {
                        result = sb.substring(1);
                    }
                }
            }
            catch (Exception ex) {
                if (!this.log.isErrorEnabled()) break block7;
                this.log.error((Object)"getListOfPermissions() failed because of ", (Throwable)ex);
            }
        }
        return result;
    }

    public static String capitalize(String s) {
        if (s.length() == 0) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }
}

