/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portlet.videocallpopup;

import java.io.InputStream;
import java.util.Properties;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import juzu.Path;
import juzu.Response;
import juzu.View;
import juzu.request.SecurityContext;
import juzu.template.Template;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.model.videocall.VideoCallModel;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.videocall.AuthService;
import org.exoplatform.services.videocall.VideoCallService;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.json.JSONObject;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

public class VideoCallPopupApplication {
    @Inject
    @Path(value="index.gtmpl")
    Template index;
    String remoteUser_ = null;
    OrganizationService organizationService_;
    SpaceService spaceService_;
    VideoCallService videoCallService_;
    ConversationRegistry conversationRegistry_;
    ContinuationService continuationService_;
    EXoContinuationBayeux exoContinuationBayeux_;

    @Inject
    public VideoCallPopupApplication(OrganizationService organizationService, SpaceService spaceService, VideoCallService videoCallService, ConversationRegistry conversationRegistry, ContinuationService continuationService, EXoContinuationBayeux exoContinuationBayeux) {
        this.organizationService_ = organizationService;
        this.spaceService_ = spaceService;
        this.videoCallService_ = videoCallService;
        this.conversationRegistry_ = conversationRegistry;
        this.continuationService_ = continuationService;
        this.exoContinuationBayeux_ = exoContinuationBayeux;
    }

    @View
    public Response.Content index(SecurityContext securityContext) throws Exception {
        HttpServletRequest requestContext = Util.getPortalRequestContext().getRequest();
        this.remoteUser_ = securityContext.getRemoteUser();
        String callMode = this.getParam("mode");
        String callee = this.getParam("callee");
        String calleeFullName = VideoCallService.getFullName((String)callee);
        String caller = this.getParam("caller");
        String callerFullName = VideoCallService.getFullName((String)caller);
        boolean hasChatMessage = Boolean.parseBoolean(this.getParam("hasChatMessage"));
        boolean isSpace = Boolean.parseBoolean(this.getParam("isSpace"));
        String spaceOrTeamName = this.getParam("spaceOrTeamName");
        VideoCallModel videoCallModel = this.videoCallService_.getVideoCallProfile();
        if (videoCallModel == null) {
            videoCallModel = new VideoCallModel();
        }
        String weemoKey = videoCallModel.getWeemoKey();
        String tokenKey = null;
        HttpSession httpSession = requestContext.getSession();
        tokenKey = httpSession.getAttribute("tokenKey") != null ? httpSession.getAttribute("tokenKey").toString() : this.videoCallService_.getTokenKey();
        AuthService authService = new AuthService();
        if (StringUtils.isEmpty((CharSequence)tokenKey)) {
            String profile_id = videoCallModel.getProfileId();
            String content = authService.authenticate(null, profile_id);
            if (!StringUtils.isEmpty((CharSequence)content)) {
                JSONObject json = new JSONObject(content);
                tokenKey = json.get("token").toString();
                httpSession.setAttribute("tokenKey", (Object)tokenKey);
                this.videoCallService_.setTokenKey(tokenKey);
            } else {
                tokenKey = "";
                this.videoCallService_.setTokenKey("");
            }
        }
        String videoCallVersion = null;
        InputStream isProperties = this.videoCallService_.getClass().getResourceAsStream("/extension.properties");
        if (isProperties != null) {
            Properties properties = new Properties();
            properties.load(isProperties);
            videoCallVersion = properties.getProperty("videocall.version");
        }
        videoCallVersion = videoCallVersion == null ? "" : videoCallVersion;
        return this.index.with().set("user", (Object)this.remoteUser_).set("mode", (Object)callMode).set("callee", (Object)callee).set("calleeFullName", (Object)calleeFullName).set("caller", (Object)caller).set("callerFullName", (Object)callerFullName).set("hasChatMessage", (Object)hasChatMessage).set("isSpace", (Object)isSpace).set("spaceOrTeamName", (Object)spaceOrTeamName).set("weemoKey", (Object)weemoKey).set("tokenKey", (Object)tokenKey).set("videoCallVersion", (Object)videoCallVersion).set("cometdUserToken", (Object)this.continuationService_.getUserToken(this.remoteUser_)).set("cometdContextName", (Object)(this.exoContinuationBayeux_ == null ? "cometd" : this.exoContinuationBayeux_.getCometdContextName())).ok();
    }

    private String getParam(String paramName) {
        HttpServletRequest requestContext = Util.getPortalRequestContext().getRequest();
        String paramValue = requestContext.getParameter(paramName);
        if (paramValue == null) {
            paramValue = "";
        }
        return paramValue;
    }
}

