/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portlet.videocall;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import juzu.Path;
import juzu.Response;
import juzu.View;
import juzu.request.ApplicationContext;
import juzu.request.SecurityContext;
import juzu.request.UserContext;
import juzu.template.Template;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.exoplatform.model.videocall.VideoCallModel;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portlet.videocall.BundleService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.videocall.AuthService;
import org.exoplatform.services.videocall.VideoCallService;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.utils.videocall.PropertyManager;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.json.JSONException;
import org.json.JSONObject;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;
import sun.misc.BASE64Encoder;

public class VideoCallApplication {
    @Inject
    @Path(value="index.gtmpl")
    Template index;
    String REST_URL = "/mgt-rest/v1/addons/";
    String DEFAULT_PROTOCOL = "http";
    String WEEMO_ADDON_ID = "EXO_VIDEO_CALL";
    String remoteUser_ = null;
    private static final Log LOG = ExoLogger.getLogger((String)VideoCallApplication.class.getName());
    OrganizationService organizationService_;
    SpaceService spaceService_;
    VideoCallService videoCallService_;
    ConversationRegistry conversationRegistry_;
    @Inject
    BundleService bundleService_;
    ContinuationService continuationService_;
    EXoContinuationBayeux exoContinuationBayeux_;

    @Inject
    public VideoCallApplication(OrganizationService organizationService, SpaceService spaceService, VideoCallService videoCallService, ConversationRegistry conversationRegistry, ContinuationService continuationService, EXoContinuationBayeux exoContinuationBayeux) {
        this.organizationService_ = organizationService;
        this.spaceService_ = spaceService;
        this.videoCallService_ = videoCallService;
        this.conversationRegistry_ = conversationRegistry;
        this.continuationService_ = continuationService;
        this.exoContinuationBayeux_ = exoContinuationBayeux;
    }

    @View
    public Response.Content index(ApplicationContext applicationContext, SecurityContext securityContext, UserContext userContext) throws Exception {
        PortalRequestContext requestContext = Util.getPortalRequestContext();
        HttpServletRequest request = requestContext.getRequest();
        HttpSession httpSession = request.getSession();
        this.remoteUser_ = securityContext.getRemoteUser();
        VideoCallModel videoCallModel = this.videoCallService_.getVideoCallProfile();
        if (videoCallModel == null) {
            videoCallModel = new VideoCallModel();
        }
        String weemoKey = videoCallModel.getWeemoKey();
        String tokenKey = null;
        tokenKey = httpSession.getAttribute("tokenKey") != null ? httpSession.getAttribute("tokenKey").toString() : this.videoCallService_.getTokenKey();
        if (StringUtils.isEmpty((CharSequence)tokenKey)) {
            AuthService authService = new AuthService();
            String profile_id = PropertyManager.getProperty((String)"video_profile");
            String content = authService.authenticate(null, profile_id);
            if (!StringUtils.isEmpty((CharSequence)content) && content.contains("token")) {
                JSONObject json = new JSONObject(content);
                tokenKey = json.get("token").toString();
                httpSession.setAttribute("tokenKey", (Object)tokenKey);
                this.videoCallService_.setTokenKey(tokenKey);
            } else {
                tokenKey = "";
                this.videoCallService_.setTokenKey("");
            }
        }
        String videoCallVersion = null;
        InputStream isProperties = this.videoCallService_.getClass().getResourceAsStream("/extension.properties");
        if (isProperties != null) {
            Properties properties = new Properties();
            properties.load(isProperties);
            videoCallVersion = properties.getProperty("videocall.version");
        }
        videoCallVersion = videoCallVersion == null ? "" : videoCallVersion;
        boolean turnOffVideoCallForUser = this.videoCallService_.isTurnOffVideoCallForUser();
        boolean turnOffVideoCall = this.videoCallService_.isTurnOffVideoCall();
        Locale locale = userContext.getLocale();
        ResourceBundle bundle = applicationContext.resolveBundle(locale);
        String messages = this.bundleService_.getBundle("weemoBundleData", bundle, locale);
        Template.Builder builder = this.index.with().set("user", (Object)this.remoteUser_).set("weemoKey", (Object)weemoKey).set("tokenKey", (Object)tokenKey).set("turnOffVideoCallForUser", (Object)turnOffVideoCallForUser).set("turnOffVideoCall", (Object)turnOffVideoCall).set("videoCallVersion", (Object)videoCallVersion).set("messages", (Object)messages).set("isCloudRunning", (Object)VideoCallService.isCloudRunning()).set("cometdUserToken", (Object)this.continuationService_.getUserToken(this.remoteUser_)).set("cometdContextName", (Object)(this.exoContinuationBayeux_ == null ? "cometd" : this.exoContinuationBayeux_.getCometdContextName()));
        if (VideoCallService.isCloudRunning()) {
            String statusRestUrl;
            String addonstatus;
            String serverName = request.getServerName();
            String tenantName = "";
            tenantName = serverName.indexOf(".") != -1 ? serverName.substring(0, serverName.indexOf(".")) : serverName;
            String trialStatus = "";
            int trialDay = 0;
            int remainDay = 0;
            String username = System.getProperty("cloud.management.username");
            String password = System.getProperty("cloud.management.password");
            String restUrl = this.getBaseUrl() + "trial/" + tenantName + "/" + this.WEEMO_ADDON_ID;
            String trialInformation = this.callBOService(restUrl, username, password);
            String encodedKey = "Basic " + new BASE64Encoder().encode((username + ":" + password).getBytes());
            if (!StringUtils.isEmpty((CharSequence)trialInformation)) {
                try {
                    JSONObject output = new JSONObject(trialInformation);
                    trialStatus = output.getString("status");
                    trialDay = output.getInt("trialDay");
                    long endDate = output.getLong("endDate");
                    long currentTime = System.currentTimeMillis();
                    if (currentTime > endDate && trialStatus.equals("active")) {
                        trialStatus = "expired";
                        this.callBOService(restUrl + "/" + trialStatus, username, password);
                    }
                    if (trialStatus.equals("active")) {
                        remainDay = (int)((endDate - currentTime) / 86400000L) + 1;
                    }
                }
                catch (JSONException jse) {
                    LOG.warn((Object)"Cannot load addon's trial information");
                }
            }
            if ((addonstatus = this.callBOService(statusRestUrl = this.getBaseUrl() + "isActive/" + tenantName + "/" + this.WEEMO_ADDON_ID, username, password)) == null) {
                addonstatus = "";
            }
            builder.set("trialStatus", (Object)trialStatus).set("trialDay", (Object)trialDay).set("remainDay", (Object)remainDay).set("tenantName", (Object)tenantName).set("encodedKey", (Object)encodedKey).set("addonstatus", (Object)addonstatus).set("turnOffVideoGroupCallForUser", (Object)true);
        } else {
            boolean turnOffVideoGroupCallForUser = this.videoCallService_.isTurnOffVideoCallForUser(true);
            builder.set("turnOffVideoGroupCallForUser", (Object)turnOffVideoGroupCallForUser);
        }
        return builder.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String callBOService(String url, String username, String password) {
        try {
            URI uri = new URI(url);
            DefaultHttpClient client = new DefaultHttpClient();
            client.getCredentialsProvider().setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)new UsernamePasswordCredentials(username, password));
            HttpGet request = new HttpGet(url);
            CloseableHttpResponse response = null;
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                response = client.execute((HttpUriRequest)request);
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new Exception("Couldn't get information from backoffice. Response status code - " + response.getStatusLine().getStatusCode());
                }
                InputStream in = response.getEntity().getContent();
                BufferedReader rd = new BufferedReader(new InputStreamReader(in));
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
                rd.close();
            }
            finally {
                if (response != null) {
                    response.getEntity().getContent().close();
                }
            }
            return sb.toString();
        }
        catch (URISyntaxException urie) {
            LOG.error((Object)("The service url " + url + " is in wrong format"), (Throwable)urie);
        }
        catch (IOException ioe) {
            LOG.error((Object)("Cannot read data from response - Cause : " + ioe.getMessage()), (Throwable)ioe);
        }
        catch (Exception e) {
            LOG.error((Object)("A problem happened while calling backoffice service - Cause : " + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    private String getBaseUrl() {
        String mgtHost = System.getProperty("cloud.management.host");
        String mgtPort = System.getProperty("cloud.management.tomcat.port");
        String baseUrl = this.DEFAULT_PROTOCOL + "://" + mgtHost + ":" + mgtPort + this.REST_URL;
        return baseUrl;
    }
}

