/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.organization;

import java.util.List;
import org.exoplatform.addons.es.index.IndexingService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.wiki.jpa.dao.PageDAO;
import org.exoplatform.wiki.jpa.dao.TemplateDAO;
import org.exoplatform.wiki.jpa.dao.WikiDAO;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.jpa.entity.TemplateEntity;
import org.exoplatform.wiki.jpa.entity.WikiEntity;
import org.exoplatform.wiki.mow.api.WikiType;

public class WikiUserEventListener
extends UserEventListener {
    private static final Log LOG = ExoLogger.getLogger(WikiUserEventListener.class);
    private WikiDAO wikiDAO;
    private PageDAO pageDAO;
    private TemplateDAO templateDAO;
    private IndexingService indexingService;

    public WikiUserEventListener(WikiDAO wikiDAO, PageDAO pageDAO, TemplateDAO templateDAO, IndexingService indexingService) {
        this.wikiDAO = wikiDAO;
        this.pageDAO = pageDAO;
        this.templateDAO = templateDAO;
        this.indexingService = indexingService;
    }

    public void postDelete(User user) throws Exception {
        WikiEntity wikiUser;
        List<TemplateEntity> templates;
        LOG.info((Object)("Removing all wiki data of the user " + user.getUserName()));
        List<PageEntity> pages = this.pageDAO.getPagesOfWiki(WikiType.USER.toString().toLowerCase(), user.getUserName());
        if (pages != null) {
            for (PageEntity page : pages) {
                this.indexingService.unindex("wiki-page", String.valueOf(page.getId()));
            }
            this.pageDAO.deleteAll(pages);
        }
        if ((templates = this.templateDAO.getTemplatesOfWiki(WikiType.USER.toString().toLowerCase(), user.getUserName())) != null) {
            this.templateDAO.deleteAll(templates);
        }
        if ((wikiUser = this.wikiDAO.getWikiByTypeAndOwner(WikiType.USER.toString().toLowerCase(), user.getUserName())) != null) {
            this.wikiDAO.delete(wikiUser);
        }
    }
}

