/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addons.es.domain.Document;
import org.exoplatform.addons.es.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.jpa.dao.PageAttachmentDAO;
import org.exoplatform.wiki.jpa.entity.PageAttachmentEntity;
import org.exoplatform.wiki.jpa.entity.PageEntity;
import org.exoplatform.wiki.jpa.entity.PermissionEntity;
import org.exoplatform.wiki.mow.api.PermissionType;
import org.exoplatform.wiki.utils.Utils;
import org.json.simple.JSONObject;

public class AttachmentIndexingServiceConnector
extends ElasticIndexingServiceConnector {
    private static final Log LOGGER = ExoLogger.getExoLogger(AttachmentIndexingServiceConnector.class);
    public static final String TYPE = "wiki-attachment";
    private final PageAttachmentDAO attachmentDAO;

    public AttachmentIndexingServiceConnector(InitParams initParams, PageAttachmentDAO attachmentDAO) {
        super(initParams);
        this.attachmentDAO = attachmentDAO;
    }

    public Document create(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("Id is null");
        }
        PageAttachmentEntity attachment = (PageAttachmentEntity)this.attachmentDAO.find(Long.valueOf(Long.parseLong(id)));
        if (attachment == null) {
            LOGGER.info("The attachment entity with id {} doesn't exist.", new Object[]{id});
            return null;
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        Document doc = new Document(TYPE, id, this.getUrl(attachment), attachment.getUpdatedDate(), this.computePermissions(attachment), fields);
        doc.addField("title", attachment.getTitle());
        doc.addField("file", attachment.getContent());
        doc.addField("name", attachment.getName());
        doc.addField("createdDate", String.valueOf(attachment.getCreatedDate().getTime()));
        doc.addField("updatedDate", String.valueOf(attachment.getUpdatedDate().getTime()));
        PageEntity page = attachment.getPage();
        doc.addField("pageName", page.getName());
        fields.put("wikiType", page.getWiki().getType());
        fields.put("wikiOwner", Utils.validateWikiOwner((String)page.getWiki().getType(), (String)page.getWiki().getOwner()));
        return doc;
    }

    public Document update(String id) {
        return this.create(id);
    }

    private String[] computePermissions(PageAttachmentEntity attachment) {
        ArrayList<String> permissions = new ArrayList<String>();
        permissions.add(attachment.getCreator());
        List<PermissionEntity> pagePermission = attachment.getPage().getPermissions();
        if (pagePermission != null) {
            for (PermissionEntity permission : pagePermission) {
                if (!permission.getPermissionType().equals((Object)PermissionType.VIEWPAGE) && !permission.getPermissionType().equals((Object)PermissionType.VIEW_ATTACHMENT)) continue;
                permissions.add(permission.getIdentity());
            }
        }
        String[] result = new String[permissions.size()];
        return permissions.toArray(result);
    }

    private String getUrl(PageAttachmentEntity attachment) {
        return attachment.getPage().getUrl();
    }

    public String getMapping() {
        JSONObject notAnalyzedField = new JSONObject();
        notAnalyzedField.put((Object)"type", (Object)"string");
        notAnalyzedField.put((Object)"index", (Object)"not_analyzed");
        JSONObject fastVectorHighlighterField = new JSONObject();
        fastVectorHighlighterField.put((Object)"term_vector", (Object)"with_positions_offsets");
        fastVectorHighlighterField.put((Object)"store", (Object)true);
        JSONObject postingHighlighterField = new JSONObject();
        postingHighlighterField.put((Object)"type", (Object)"string");
        postingHighlighterField.put((Object)"index_options", (Object)"offsets");
        JSONObject attachmentFields = new JSONObject();
        attachmentFields.put((Object)"content", (Object)fastVectorHighlighterField);
        attachmentFields.put((Object)"title", (Object)postingHighlighterField);
        JSONObject attachmentField = new JSONObject();
        attachmentField.put((Object)"type", (Object)"attachment");
        attachmentField.put((Object)"fields", (Object)attachmentFields);
        JSONObject properties = new JSONObject();
        properties.put((Object)"file", (Object)attachmentField);
        properties.put((Object)"permissions", (Object)notAnalyzedField);
        properties.put((Object)"url", (Object)notAnalyzedField);
        properties.put((Object)"sites", (Object)notAnalyzedField);
        properties.put((Object)"wikiType", (Object)notAnalyzedField);
        properties.put((Object)"wikiOwner", (Object)notAnalyzedField);
        properties.put((Object)"name", (Object)postingHighlighterField);
        properties.put((Object)"title", (Object)postingHighlighterField);
        JSONObject mappingProperties = new JSONObject();
        mappingProperties.put((Object)"properties", (Object)properties);
        JSONObject mappingJSON = new JSONObject();
        mappingJSON.put((Object)this.getType(), (Object)mappingProperties);
        return mappingJSON.toJSONString();
    }

    public List<String> getAllIds(int offset, int limit) {
        ArrayList<String> result;
        List<Long> ids = this.attachmentDAO.findAllIds(offset, limit);
        if (ids == null) {
            result = new ArrayList<String>(0);
        } else {
            result = new ArrayList(ids.size());
            for (Long id : ids) {
                result.add(String.valueOf(id));
            }
        }
        return result;
    }
}

