/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.liquibase;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import liquibase.change.custom.CustomSqlChange;
import liquibase.database.Database;
import liquibase.exception.CustomChangeException;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.ModifyDataTypeStatement;

public class TimestampChange
implements CustomSqlChange {
    private String tableName;
    private String columnName;

    public SqlStatement[] generateStatements(Database database) throws CustomChangeException {
        SqlStatement[] sqlStatements = new SqlStatement[]{new ModifyDataTypeStatement(database.getDefaultCatalogName(), database.getDefaultSchemaName(), this.tableName, this.columnName, "TIMESTAMP NOT NULL DEFAULT '" + TimestampChange.getLocalToUtcDelta() + "'")};
        return sqlStatements;
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
        try {
            resourceAccessor.getResourcesAsStream("tableName");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ValidationErrors validate(Database database) {
        return null;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public static String getLocalToUtcDelta() {
        Calendar utcDate = Calendar.getInstance();
        utcDate.set(1970, 0, 1, 0, 0, 1);
        String format = "yyyy/MM/dd HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        TimeZone tz = TimeZone.getDefault();
        Date local = utcDate.getTime();
        if (tz.getRawOffset() > 0) {
            local = new Date(utcDate.getTime().getTime() + (long)tz.getRawOffset());
        }
        return sdf.format(local);
    }
}

