Introduction
============

In this addon, I use the term LDAP as protocol name. This addon should works with LDAP like OpenLdap or Active Directory

This addon contains 2 features, linked to LDAP write
- Push user information in target ldap : when a user is created in eXo or modified in eXo, the modification is sent to the 
  LDAP
  
- Allow the user to change his password in the targeted LDAP

Installation
============

The following command must be executed from the root folder of the eXoPlatfominstannce to install it:

    ./addon install exo-write-in-ldap

Feature activation
==================

By default, features "Write users in LDAP" and "Modify password" in add are both enabled when the addon is installed.
To deactivate feature "Write users in LDAP" add this property in exo.properties

    exo.feature.write-in-ldap.enabled=false

To deactivate feature "Modify Password in LDAP', add this property in exo.properties

    exo.portal.allow.change.external.password=false
  

Properties
==========
By default, the addon take the same configuration as eXoPlatform LDAP configuration.
This configuration can be override if needed.

| Property      |     Default Value    |How to override         |
| ------------- |: ------------------: | -------------------:   |
| Type          |exo.ldap.type         |write-in-ldap.ldap.type   |
| LDAP Url        |exo.ldap.url          |write-in-ldap.ldap.url    |
| LDAP Login      |exo.ldap.admin.dn     |write-in-ldap.ldap.admin.dn  |
| LDAP Password   |exo.ldap.admin.password|write-in-ldap.ldap.admin.password |
| Users Base DN |exo.ldap.users.base.dn |write-in-ldap.ldap.users.base.dn |
| Users Filter |exo.ldap.users.filter |write-in-ldap.ldap.users.filter |
| Users Attributes Names |exo.ldap.users.attributes.{firstName&#124;lastName&#124;email}.mapping	 |write-in-ldap.ldap.users.attributes.{firstName&#124;lastName&#124;email}.mapping 	|
| Users Filter |exo.ldap.users.filter |write-in-ldap.ldap.users.filter |

Remark : the LDAP credentials must have rights to write in LDAP

From change password part, needed properties are the same for when eXo is configured to connect to an LDAP/AD
The only difference is that the ldap user must have write access on LDAP/AD

Default Ldap Group
==================

When a user is created or modified in the LDAP/AD, it is possible to put in a list of default groups. 
For that, configure this property :

    write-in-ldap.defaultGroups=CN=Group1,OU=Groups,DC=exoplatform,DC=com

If you want more than one group, separator is '/' :

    write-in-ldap.defaultGroups=CN=Group1,OU=Groups,DC=exoplatform,DC=com/CN=Group2,OU=Groups,DC=exoplatform,DC=com

