/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.writeinldap.services;

import java.util.Hashtable;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.PicketLinkIDMServiceImpl;
import org.exoplatform.services.organization.idm.externalstore.PicketLinkIDMExternalStoreService;
import org.exoplatform.web.login.recovery.ChangePasswordConnector;
import org.exoplatform.web.login.recovery.DefaultChangePasswordConnector;
import org.gatein.portal.idm.impl.repository.ExoFallbackIdentityStoreRepository;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.impl.api.session.IdentitySessionImpl;
import org.picketlink.idm.impl.api.session.context.IdentitySessionContext;
import org.picketlink.idm.impl.model.ldap.LDAPIdentityObjectImpl;
import org.picketlink.idm.spi.configuration.metadata.IdentityConfigurationMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityObjectTypeMetaData;
import org.picketlink.idm.spi.configuration.metadata.IdentityStoreConfigurationMetaData;
import org.picketlink.idm.spi.model.IdentityObject;
import org.picketlink.idm.spi.repository.IdentityStoreRepository;
import org.picketlink.idm.spi.store.IdentityStoreInvocationContext;

public class LdapChangePasswordConnector
extends ChangePasswordConnector {
    private OrganizationService organizationService;
    private PicketLinkIDMService picketLinkIDMService;
    private PicketLinkIDMExternalStoreService picketLinkIDMExternalStoreService;
    public static final String LOG_SERVICE_NAME = "changePassword";
    protected static Log log = ExoLogger.getLogger(DefaultChangePasswordConnector.class);
    private boolean allowChangeExternalPassword;
    private String ldapWriteUser;
    private String ldapWritePwd;

    public LdapChangePasswordConnector(InitParams initParams, OrganizationService organizationService, PicketLinkIDMService picketLinkIDMService, PicketLinkIDMExternalStoreService picketLinkIDMExternalStoreService) {
        this.organizationService = organizationService;
        this.picketLinkIDMService = picketLinkIDMService;
        this.picketLinkIDMExternalStoreService = picketLinkIDMExternalStoreService;
        ValueParam allowChangeExternalPasswordValue = initParams.getValueParam("allowChangeExternalPassword");
        this.allowChangeExternalPassword = allowChangeExternalPasswordValue != null ? Boolean.parseBoolean(allowChangeExternalPasswordValue.getValue()) : true;
        this.ldapWriteUser = initParams.getValueParam("ldapWriteUser") != null ? initParams.getValueParam("ldapWriteUser").getValue() : "";
        this.ldapWritePwd = initParams.getValueParam("ldapWritePwd") != null ? initParams.getValueParam("ldapWritePwd").getValue() : "";
    }

    public boolean isAllowChangeExternalPassword() {
        return this.allowChangeExternalPassword;
    }

    public void changePassword(String username, String password) throws Exception {
        User user = this.organizationService.getUserHandler().findUserByName(username);
        if (user.isInternalStore()) {
            this.changeInternalPassword(user, password);
        } else if (this.allowChangeExternalPassword) {
            this.changeExternalPassword(user, password);
        } else {
            throw new Exception("Change password in external store in not allowed");
        }
    }

    private void changeExternalPassword(User user, String password) throws Exception {
        String ldapType;
        String ldapUrl = "";
        String passwordAttribute = "";
        long startTime = System.currentTimeMillis();
        IdentityConfigurationMetaData config = ((PicketLinkIDMServiceImpl)this.picketLinkIDMService).getConfigMD();
        IdentityStoreConfigurationMetaData identityStoreConfig = config.getIdentityStores().stream().filter(identityStoreConfigurationMetaData -> identityStoreConfigurationMetaData.getId().equals("PortalLDAPStore")).findFirst().orElse(null);
        if (identityStoreConfig != null) {
            ldapUrl = identityStoreConfig.getOptionSingleValue("providerURL");
        }
        if ((ldapType = System.getProperty("exo.ldap.type")) == null) {
            throw new UnsupportedOperationException("No configured LDAP, unable to change external password");
        }
        IdentityObjectTypeMetaData identityObjectTypeMetaData = identityStoreConfig.getSupportedIdentityTypes().stream().filter(i -> i.getName().equals("USER")).findFirst().orElse(null);
        if (identityObjectTypeMetaData != null) {
            passwordAttribute = identityObjectTypeMetaData.getOptionSingleValue("passwordAttributeName");
        }
        String userDN = this.getUserDN(user);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapUrl);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.ldapWriteUser);
        env.put("java.naming.security.credentials", this.ldapWritePwd);
        try (InitialDirContext initialContext = null;){
            Attribute mod0;
            InitialDirContext ctx = initialContext = new InitialDirContext(env);
            ModificationItem[] mods = new ModificationItem[1];
            if (ldapType.equals("ad")) {
                mod0 = this.encodeAdPassword(password, passwordAttribute);
            } else if (ldapType.equals("ldap")) {
                mod0 = this.encodeLdapPassword(password, passwordAttribute);
            } else {
                throw new UnsupportedOperationException("No configured LDAP, unable to change external password");
            }
            mods[0] = new ModificationItem(2, mod0);
            ctx.modifyAttributes(userDN, mods);
            long totalTime = System.currentTimeMillis() - startTime;
            log.info("service={} operation={} parameters=\"user:{}\" status=ok duration_ms={}", new Object[]{LOG_SERVICE_NAME, "changeExternalPassword", user.getUserName(), totalTime});
        }
    }

    private Attribute encodeLdapPassword(String password, String passwordAttribute) {
        BasicAttribute mod0 = new BasicAttribute(passwordAttribute, password);
        return mod0;
    }

    private Attribute encodeAdPassword(String password, String passwordAttribute) {
        String quotedPassword = "\"" + password + "\"";
        char[] unicodePwd = quotedPassword.toCharArray();
        byte[] pwdArray = new byte[unicodePwd.length * 2];
        for (int i = 0; i < unicodePwd.length; ++i) {
            pwdArray[i * 2 + 1] = (byte)(unicodePwd[i] >>> 8);
            pwdArray[i * 2 + 0] = (byte)(unicodePwd[i] & 0xFF);
        }
        BasicAttribute mod0 = new BasicAttribute(passwordAttribute, pwdArray);
        return mod0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUserDN(User user) throws Exception {
        IdentityStoreRepository repository;
        IdentitySession identitySession = this.picketLinkIDMService.getIdentitySession();
        IdentitySessionContext identitySessionContext = null;
        if (identitySession instanceof IdentitySessionImpl && (repository = (identitySessionContext = ((IdentitySessionImpl)identitySession).getSessionContext()).getIdentityStoreRepository()) instanceof ExoFallbackIdentityStoreRepository) {
            IdentityStoreInvocationContext invocationContext = identitySessionContext.resolveStoreInvocationContext();
            ExoFallbackIdentityStoreRepository exoFallbackIdentityStoreRepository = (ExoFallbackIdentityStoreRepository)repository;
            exoFallbackIdentityStoreRepository.setUseExternalStore(Boolean.valueOf(true));
            try {
                IdentityObject identityObject = exoFallbackIdentityStoreRepository.findIdentityObject(invocationContext, user.getUserName(), identitySessionContext.getIdentityObjectTypeMapper().getIdentityObjectType());
                if (identityObject instanceof LDAPIdentityObjectImpl) {
                    String string = ((LDAPIdentityObjectImpl)identityObject).getDn();
                    return string;
                }
            }
            finally {
                exoFallbackIdentityStoreRepository.setUseExternalStore(Boolean.valueOf(false));
            }
        }
        return null;
    }

    private void changeInternalPassword(User user, String password) throws Exception {
        long startTime = System.currentTimeMillis();
        user.setPassword(password);
        this.organizationService.getUserHandler().saveUser(user, true);
        long totalTime = System.currentTimeMillis() - startTime;
        log.info("service={} operation={} parameters=\"user:{}\" status=ok duration_ms={}", new Object[]{LOG_SERVICE_NAME, "changeInternalPassword", user.getUserName(), totalTime});
    }
}

