/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.writeinldap.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.externalstore.IDMExternalStoreImportService;
import org.exoplatform.services.organization.externalstore.model.IDMEntityType;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

public class ActiveDirectoryService {
    private static final Log LOG = ExoLogger.getLogger(ActiveDirectoryService.class);
    private static final String LDAP_SERVICE_NAME = "ldapService";
    private static final String LDAP_TYPE = "ldap";
    private static final String AD_TYPE = "ad";
    private static final int UF_ACCOUNTDISABLE = 2;
    private static final String USER_ACCOUNT_CONTROL = "userAccountControl";
    private String ldapUrl;
    private String ldapType;
    private String ldapPrincipal;
    private String ldapCredentials;
    private String userBaseDn;
    private String userFilter;
    private String userAttributeUserName;
    private String userAttributeFirstName;
    private String userAttributeEmail;
    private String userAttributeLastName;
    private String userAttributePassword;
    private List<String> defaultLdapGroups;
    private boolean isFeatureEnabled;
    private IDMExternalStoreImportService externalStoreImportService;
    private IdentityManager identityManager;
    private final ListenerService listenerService;
    private Hashtable env;
    private String userAccountControl = "userAccountControl";

    public ActiveDirectoryService(InitParams initParams, ExoFeatureService exoFeatureService, IDMExternalStoreImportService externalStoreImportService, ListenerService listenerService, IdentityManager identityManager) {
        this.isFeatureEnabled = exoFeatureService.isActiveFeature("write-in-ldap");
        this.externalStoreImportService = externalStoreImportService;
        this.listenerService = listenerService;
        if (initParams.getValueParam("ldapType") != null && !initParams.getValueParam("ldapType").getValue().isEmpty()) {
            this.ldapType = initParams.getValueParam("ldapType").getValue();
        } else if (System.getProperty("exo.ldap.type") != null && !System.getProperty("exo.ldap.type").isEmpty()) {
            this.ldapType = System.getProperty("exo.ldap.type");
        } else {
            this.isFeatureEnabled = false;
        }
        this.ldapCredentials = initParams.getValueParam("ldapCredentials") != null && !initParams.getValueParam("ldapCredentials").getValue().isEmpty() ? initParams.getValueParam("ldapCredentials").getValue() : (System.getProperty("exo.ldap.admin.password") != null && !System.getProperty("exo.ldap.admin.password").isEmpty() ? System.getProperty("exo.ldap.admin.password") : "");
        this.ldapPrincipal = initParams.getValueParam("ldapPrincipal") != null && !initParams.getValueParam("ldapPrincipal").getValue().isEmpty() ? initParams.getValueParam("ldapPrincipal").getValue() : (System.getProperty("exo.ldap.admin.dn") != null && !System.getProperty("exo.ldap.admin.dn").isEmpty() ? System.getProperty("exo.ldap.admin.dn") : "cn=admin");
        this.ldapUrl = initParams.getValueParam("ldapUrl") != null && !initParams.getValueParam("ldapUrl").getValue().isEmpty() ? initParams.getValueParam("ldapUrl").getValue() : (System.getProperty("exo.ldap.url") != null && !System.getProperty("exo.ldap.url").isEmpty() ? System.getProperty("exo.ldap.url") : "http://localhost:389");
        this.userBaseDn = initParams.getValueParam("userBaseDn") != null && !initParams.getValueParam("userBaseDn").getValue().isEmpty() ? initParams.getValueParam("userBaseDn").getValue() : (System.getProperty("exo.ldap.users.base.dn") != null && !System.getProperty("exo.ldap.users.base.dn").isEmpty() ? System.getProperty("exo.ldap.users.base.dn") : "ou=users,dc=company,dc=org");
        if (initParams.getValueParam("userAttributeUserName") != null && !initParams.getValueParam("userAttributeUserName").getValue().isEmpty()) {
            this.userAttributeUserName = initParams.getValueParam("userAttributeUserName").getValue();
        } else if (System.getProperty("exo.ldap.users.id.attributeName") != null && !System.getProperty("exo.ldap.users.id.attributeName").isEmpty()) {
            this.userAttributeUserName = System.getProperty("exo.ldap.users.id.attributeName");
        } else {
            String string = this.userAttributeUserName = this.ldapType.equals(LDAP_TYPE) ? "uid" : "samAccountName";
        }
        this.userFilter = initParams.getValueParam("userFilter") != null && !initParams.getValueParam("userFilter").getValue().isEmpty() ? initParams.getValueParam("userFilter").getValue() : (System.getProperty("exo.ldap.users.filter") != null && !System.getProperty("exo.ldap.users.filter").isEmpty() ? System.getProperty("exo.ldap.users.filter") : null);
        if (initParams.getValueParam("userAttributeFirstName") != null && !initParams.getValueParam("userAttributeFirstName").getValue().isEmpty()) {
            this.userAttributeFirstName = initParams.getValueParam("userAttributeFirstName").getValue();
        } else if (System.getProperty("exo.ldap.users.attributes.firstName.mapping") != null && !System.getProperty("exo.ldap.users.attributes.firstName.mapping").isEmpty()) {
            this.userAttributeFirstName = System.getProperty("exo.ldap.users.attributes.firstName.mapping");
        } else {
            String string = this.userAttributeFirstName = this.ldapType.equals(LDAP_TYPE) ? "cn" : "givenName";
        }
        this.userAttributeLastName = initParams.getValueParam("userAttributeLastName") != null && !initParams.getValueParam("userAttributeLastName").getValue().isEmpty() ? initParams.getValueParam("userAttributeLastName").getValue() : (System.getProperty("exo.ldap.users.attributes.lastName.mapping") != null && !System.getProperty("exo.ldap.users.attributes.lastName.mapping").isEmpty() ? System.getProperty("exo.ldap.users.attributes.lastName.mapping") : "sn");
        this.userAttributeEmail = initParams.getValueParam("userAttributeEmail") != null && !initParams.getValueParam("userAttributeEmail").getValue().isEmpty() ? initParams.getValueParam("userAttributeEmail").getValue() : (System.getProperty("exo.ldap.users.attributes.email.mapping") != null && !System.getProperty("exo.ldap.users.attributes.email.mapping").isEmpty() ? System.getProperty("exo.ldap.users.attributes.email.mapping") : "mail");
        this.userAttributePassword = initParams.getValueParam("userAttributePassword") != null && !initParams.getValueParam("userAttributePassword").getValue().isEmpty() ? initParams.getValueParam("userAttributePassword").getValue() : (System.getProperty("exo.ldap.users.password.attributeName") != null && !System.getProperty("exo.ldap.users.password.attributeName").isEmpty() ? System.getProperty("exo.ldap.users.password.attributeName") : (this.ldapType.equals(LDAP_TYPE) ? "userPassword" : "unicodePwd"));
        this.defaultLdapGroups = new ArrayList<String>();
        if (initParams.getValueParam("defaultLdapGroups") != null && !initParams.getValueParam("defaultLdapGroups").getValue().isEmpty()) {
            this.defaultLdapGroups.addAll(Arrays.asList(initParams.getValueParam("defaultLdapGroups").getValue().split("/")));
        }
        this.env = new Hashtable();
        this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.env.put("java.naming.provider.url", this.ldapUrl);
        this.env.put("com.sun.jndi.ldap.connect.pool", "true");
        this.env.put("java.naming.security.authentication", "simple");
        this.env.put("java.naming.security.principal", this.ldapPrincipal);
        this.env.put("java.naming.security.credentials", this.ldapCredentials);
        this.identityManager = identityManager;
    }

    public boolean isFeatureEnabled() {
        return this.isFeatureEnabled;
    }

    public boolean mustBeUpdated(User user, boolean isNew) {
        LOG.debug("Check if user {} must be updated", new Object[]{user.getUserName()});
        if (isNew) {
            LOG.debug("User {} is new, do not push it in LDAP", new Object[]{user.getUserName()});
            return false;
        }
        SearchResult adUser = null;
        try {
            adUser = this.searchUser(user);
        }
        catch (NamingException e) {
            LOG.error((Object)"Unable to connect LDAP", (Throwable)e);
            return false;
        }
        if (adUser == null) {
            LOG.debug((Object)"User is not present in LDAP, need to add it");
            Identity identity = this.identityManager.getOrCreateIdentity("organization", user.getUserName());
            if (identity != null && identity.getProfile() != null && Boolean.parseBoolean((String)identity.getProfile().getProperty("external"))) {
                LOG.debug((Object)"User is external, don't put him in LDAP");
                return false;
            }
            if (user.getPassword() == null) {
                LOG.debug((Object)"User password is unknown, unable to add it in LDAP");
                return false;
            }
            LOG.debug((Object)"User password known, add it in LDAP");
            return true;
        }
        boolean result = false;
        try {
            result = user.getFirstName() != null && !user.getFirstName().equals(adUser.getAttributes().get(this.userAttributeFirstName).get()) || user.getLastName() != null && !user.getLastName().equals(adUser.getAttributes().get(this.userAttributeLastName).get()) || user.getEmail() != null && !user.getEmail().equals(adUser.getAttributes().get(this.userAttributeEmail).get());
        }
        catch (NamingException e) {
            LOG.error((Object)("Error when reading attributes for user {}" + String.valueOf(adUser)));
            return false;
        }
        LOG.debug("User is present in AD, needUpdate={}", new Object[]{result});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResult searchUser(User user) throws NamingException {
        long startTime = System.currentTimeMillis();
        InitialDirContext ldapContext = null;
        SearchResult result = null;
        Object searchQuery = "";
        try {
            ldapContext = new InitialDirContext(this.env);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchQuery = "(" + this.userAttributeUserName + "=" + user.getUserName() + ")";
            NamingEnumeration<SearchResult> searchResult = ldapContext.search(this.userBaseDn, (String)searchQuery, searchControls);
            if (searchResult.hasMore()) {
                result = (SearchResult)searchResult.nextElement();
            }
        }
        finally {
            if (ldapContext != null) {
                ldapContext.close();
            }
        }
        LOG.info("remote_service={} operation={} parameters=\"user:{},userFound:{}\" status=ok duration_ms={}", new Object[]{LDAP_SERVICE_NAME, "searchUser", user.getUserName(), result != null ? result.getAttributes().get(this.userAttributeUserName) : null, System.currentTimeMillis() - startTime});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(User user) throws NamingException {
        if (this.ldapType.equals(AD_TYPE)) {
            int userAccountControlValue;
            int userAccountControlOrig;
            LOG.debug("Push enabled status {} to AD for user {}", new Object[]{user.isEnabled(), user.getUserName()});
            SearchResult adUser = null;
            try {
                adUser = this.searchUser(user);
            }
            catch (NamingException e) {
                LOG.error((Object)"Unable to connect LDAP", (Throwable)e);
            }
            if (adUser != null && (userAccountControlOrig = Integer.parseInt((String)adUser.getAttributes().get(this.userAccountControl).get())) != (userAccountControlValue = user.isEnabled() ? userAccountControlOrig & 0xFFFFFFFD : userAccountControlOrig | 2)) {
                ArrayList<ModificationItem> mods = new ArrayList<ModificationItem>();
                mods.add(new ModificationItem(2, new BasicAttribute(this.userAccountControl, "" + userAccountControlValue)));
                long startTime = System.currentTimeMillis();
                Object result = null;
                try (InitialDirContext ldapContext = null;){
                    ldapContext = new InitialDirContext(this.env);
                    ldapContext.modifyAttributes(adUser.getNameInNamespace(), (ModificationItem[])mods.stream().toArray(ModificationItem[]::new));
                    this.forceImportEntityForUser(user);
                    LOG.info("remote_service={} operation={} parameters=\"user:{},enabled={},oldUserAccountControl={},newUserAccountControl={}\" status=ok duration_ms={}", new Object[]{LDAP_SERVICE_NAME, "setEnabled", user.getUserName(), user.isEnabled(), userAccountControlOrig, userAccountControlValue, System.currentTimeMillis() - startTime});
                }
            }
        } else {
            LOG.debug((Object)"User status changed, but ldapType is ldap, so it is not possible to push the modification");
        }
    }

    public void saveModification(User user) {
        LOG.debug("Push modification to AD for user {}", new Object[]{user.getUserName()});
        SearchResult adUser = null;
        try {
            adUser = this.searchUser(user);
        }
        catch (NamingException e) {
            LOG.error((Object)"Unable to connect LDAP", (Throwable)e);
        }
        if (adUser == null) {
            try {
                LOG.debug((Object)"User is not present in AD, need to add it");
                this.addUser(user);
            }
            catch (NamingException e) {
                LOG.error((Object)"Unable to connect LDAP", (Throwable)e);
            }
        } else {
            try {
                this.updateUser(user, adUser);
            }
            catch (NamingException e) {
                LOG.error((Object)"Unable to connect LDAP", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUser(User user, SearchResult adUser) throws NamingException {
        long startTime = System.currentTimeMillis();
        Object result = null;
        try (InitialDirContext ldapContext = null;){
            BasicAttribute attribute;
            ldapContext = new InitialDirContext(this.env);
            ArrayList<ModificationItem> mods = new ArrayList<ModificationItem>();
            if (!(this.ldapType.equals(LDAP_TYPE) && this.userAttributeFirstName.equals("cn") || user.getFirstName().equals(adUser.getAttributes().get(this.userAttributeFirstName).get()))) {
                attribute = new BasicAttribute(this.userAttributeFirstName, user.getFirstName());
                mods.add(new ModificationItem(2, attribute));
            }
            if (this.ldapType.equals(AD_TYPE)) {
                String dc = this.userBaseDn.toLowerCase().substring(this.userBaseDn.toLowerCase().indexOf("dc=") + 3).replace(",dc=", ".");
                String userPrincipalName = user.getUserName() + "@" + dc;
                if (adUser.getAttributes().get("userPrincipalName") == null) {
                    attribute = new BasicAttribute("userPrincipalName", userPrincipalName);
                    mods.add(new ModificationItem(1, attribute));
                } else if (!userPrincipalName.equals(adUser.getAttributes().get("userPrincipalName").get())) {
                    attribute = new BasicAttribute("userPrincipalName", userPrincipalName);
                    mods.add(new ModificationItem(2, attribute));
                }
            }
            if (!user.getLastName().equals(adUser.getAttributes().get(this.userAttributeLastName).get())) {
                attribute = new BasicAttribute(this.userAttributeLastName, user.getLastName());
                mods.add(new ModificationItem(2, attribute));
            }
            if (!user.getEmail().equals(adUser.getAttributes().get(this.userAttributeEmail).get())) {
                attribute = new BasicAttribute(this.userAttributeEmail, user.getEmail());
                mods.add(new ModificationItem(2, attribute));
            }
            ldapContext.modifyAttributes(adUser.getNameInNamespace(), (ModificationItem[])mods.stream().toArray(ModificationItem[]::new));
            ArrayList currentGroups = new ArrayList();
            try {
                adUser.getAttributes().get("memberOf").getAll().asIterator().forEachRemaining(o -> currentGroups.add(((String)o).toLowerCase()));
            }
            catch (Exception e) {
                LOG.error("Error when reading groups of user {}", new Object[]{adUser.getNameInNamespace()});
            }
            this.defaultLdapGroups.stream().forEach(groupDn -> {
                if (!currentGroups.contains(groupDn.toLowerCase())) {
                    this.addInLdapGroup(adUser.getNameInNamespace(), groupDn.toLowerCase());
                }
            });
            if (this.ldapType.equals(LDAP_TYPE) && this.userAttributeFirstName.equals("cn") && !user.getFirstName().equals(adUser.getAttributes().get(this.userAttributeFirstName).get())) {
                String oldDn = adUser.getNameInNamespace();
                String newDn = oldDn.replace("cn=" + String.valueOf(adUser.getAttributes().get(this.userAttributeFirstName).get()), "cn=" + user.getFirstName());
                ldapContext.rename(oldDn, newDn);
            }
            this.forceImportEntityForUser(user);
            LOG.info("remote_service={} operation={} parameters=\"user:{}\" status=ok duration_ms={}", new Object[]{LDAP_SERVICE_NAME, "updateUser", user.getUserName(), System.currentTimeMillis() - startTime});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUser(User user) throws NamingException {
        long startTime = System.currentTimeMillis();
        SearchResult result = null;
        try (InitialDirContext ldapContext = null;){
            ldapContext = new InitialDirContext(this.env);
            BasicAttributes attrs = new BasicAttributes();
            BasicAttribute classes = new BasicAttribute("objectclass");
            if (this.ldapType.equals(LDAP_TYPE)) {
                classes.add("inetOrgPerson");
            } else {
                classes.add("user");
            }
            attrs.put(classes);
            attrs.put(this.userAttributeUserName, user.getUserName());
            attrs.put(this.userAttributeEmail, user.getEmail());
            attrs.put(this.userAttributeFirstName, user.getFirstName());
            attrs.put(this.userAttributeLastName, user.getLastName());
            if (this.ldapType.equals(LDAP_TYPE)) {
                attrs.put(this.encodeLdapPassword(user.getPassword(), this.userAttributePassword));
            } else {
                attrs.put(this.encodeAdPassword(user.getPassword(), this.userAttributePassword));
                attrs.put(USER_ACCOUNT_CONTROL, "512");
                String dc = this.userBaseDn.toLowerCase().substring(this.userBaseDn.toLowerCase().indexOf("dc=") + 3).replace(",dc=", ".");
                String userPrincipalName = user.getUserName() + "@" + dc;
                attrs.put("userPrincipalName", userPrincipalName);
            }
            String dn = this.computeDn(user);
            ldapContext.createSubcontext(dn, (Attributes)attrs);
            this.defaultLdapGroups.stream().forEach(groupDn -> this.addInLdapGroup(dn, (String)groupDn));
            this.forceImportEntityForUser(user);
            LOG.info("remote_service={} operation={} parameters=\"user:{}\" status=ok duration_ms={}", new Object[]{LDAP_SERVICE_NAME, "addUser", user.getUserName(), result != null ? result.getAttributes().get(this.userAttributeUserName) : null, System.currentTimeMillis() - startTime});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInLdapGroup(String userDn, String groupDn) {
        InitialDirContext groupLdapContext = null;
        try {
            groupLdapContext = new InitialDirContext(this.env);
            ModificationItem[] mods = new ModificationItem[1];
            BasicAttribute mod = new BasicAttribute("member", userDn);
            mods[0] = new ModificationItem(1, mod);
            groupLdapContext.modifyAttributes(groupDn, mods);
        }
        catch (NamingException e) {
            LOG.error("Error adding user {} in group {}", new Object[]{userDn, groupDn, e});
        }
        finally {
            if (groupLdapContext != null) {
                try {
                    groupLdapContext.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    private String computeDn(User user) {
        Object dn = "cn=";
        dn = this.ldapType.equals(LDAP_TYPE) ? (String)dn + user.getFirstName() : (String)dn + user.getDisplayName();
        dn = (String)dn + "," + this.userBaseDn;
        return dn;
    }

    private Attribute encodeLdapPassword(String password, String passwordAttribute) {
        BasicAttribute mod0 = new BasicAttribute(passwordAttribute, password);
        return mod0;
    }

    private Attribute encodeAdPassword(String password, String passwordAttribute) {
        String quotedPassword = "\"" + password + "\"";
        char[] unicodePwd = quotedPassword.toCharArray();
        byte[] pwdArray = new byte[unicodePwd.length * 2];
        for (int i = 0; i < unicodePwd.length; ++i) {
            pwdArray[i * 2 + 1] = (byte)(unicodePwd[i] >>> 8);
            pwdArray[i * 2 + 0] = (byte)(unicodePwd[i] & 0xFF);
        }
        BasicAttribute mod0 = new BasicAttribute(passwordAttribute, pwdArray);
        return mod0;
    }

    public void forceImportEntityForUser(User user) {
        try {
            this.externalStoreImportService.importEntityToInternalStore(IDMEntityType.USER, (Object)user.getUserName(), true, true);
        }
        catch (Exception e) {
            LOG.error((Object)"Error when forcing sync", (Throwable)e);
        }
        try {
            this.listenerService.broadcast("exo.idm.externalStore.user.modified", (Object)this.externalStoreImportService, (Object)user);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error while triggering event on user '" + user.getUserName() + "' data import (modification) from external store"), (Throwable)e);
        }
    }
}

