/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.model;

import groovy.transform.ToString;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;

@ToString
public class WebSocketMessage {
    String wsEventName;
    Map<String, Object> params;

    public WebSocketMessage(String wsEventName) {
        this.wsEventName = wsEventName;
    }

    public WebSocketMessage(String wsEventId, Object ... data) {
        this.wsEventName = wsEventId;
        if (data != null && data.length > 0) {
            this.params = new HashMap<String, Object>();
            for (Object object : data) {
                if (object == null) continue;
                this.params.put(object.getClass().getSimpleName().toLowerCase(), object);
            }
        }
    }

    public Object addParam(String key, Object value) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        return this.params.put(key, value);
    }

    public String toString() {
        try {
            return new JsonGeneratorImpl().createJsonObject((Object)this).toString();
        }
        catch (JsonException e) {
            throw new IllegalStateException("Error parsing current global object to string", e);
        }
    }

    public String getWsEventName() {
        return this.wsEventName;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setWsEventName(String wsEventName) {
        this.wsEventName = wsEventName;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebSocketMessage)) {
            return false;
        }
        WebSocketMessage other = (WebSocketMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$wsEventName = this.getWsEventName();
        String other$wsEventName = other.getWsEventName();
        if (this$wsEventName == null ? other$wsEventName != null : !this$wsEventName.equals(other$wsEventName)) {
            return false;
        }
        Map<String, Object> this$params = this.getParams();
        Map<String, Object> other$params = other.getParams();
        return !(this$params == null ? other$params != null : !((Object)this$params).equals(other$params));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebSocketMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $wsEventName = this.getWsEventName();
        result = result * 59 + ($wsEventName == null ? 43 : $wsEventName.hashCode());
        Map<String, Object> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        return result;
    }

    public WebSocketMessage(String wsEventName, Map<String, Object> params) {
        this.wsEventName = wsEventName;
        this.params = params;
    }
}

