/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.storage;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.agenda.dao.EventAttachmentDAO;
import org.exoplatform.agenda.dao.EventDAO;
import org.exoplatform.agenda.entity.EventAttachmentEntity;
import org.exoplatform.agenda.entity.EventEntity;
import org.exoplatform.agenda.model.EventAttachment;
import org.exoplatform.agenda.util.EntityMapper;
import org.exoplatform.agenda.util.Utils;
import org.exoplatform.services.listener.ListenerService;

public class AgendaEventAttachmentStorage {
    private EventDAO eventDAO;
    private EventAttachmentDAO eventAttachmentDAO;
    private ListenerService listenerService;

    public AgendaEventAttachmentStorage(EventDAO eventDAO, EventAttachmentDAO eventAttachmentDAO, ListenerService listenerService) {
        this.eventDAO = eventDAO;
        this.eventAttachmentDAO = eventAttachmentDAO;
        this.listenerService = listenerService;
    }

    public void createEventAttachment(long eventId, String fileId) {
        EventAttachmentEntity eventAttachmentEntity = new EventAttachmentEntity();
        EventEntity eventEntity = (EventEntity)this.eventDAO.find(Long.valueOf(eventId));
        if (eventEntity == null) {
            throw new IllegalStateException("Can't find event with id : " + eventId);
        }
        eventAttachmentEntity.setEvent(eventEntity);
        eventAttachmentEntity.setFileId(fileId);
        this.eventAttachmentDAO.create(eventAttachmentEntity);
        Utils.broadcastEvent(this.listenerService, "exo.agenda.event.attachment.created", eventId, fileId);
    }

    public void removeEventAttachment(long attachmentId) {
        EventAttachmentEntity eventAttachmentEntity = (EventAttachmentEntity)this.eventAttachmentDAO.find(Long.valueOf(attachmentId));
        if (eventAttachmentEntity != null) {
            this.eventAttachmentDAO.delete(eventAttachmentEntity);
            Utils.broadcastEvent(this.listenerService, "exo.agenda.event.attachment.deleted", eventAttachmentEntity.getEvent().getId(), eventAttachmentEntity.getFileId());
        }
    }

    public List<EventAttachment> getEventAttachments(long eventId) {
        List<EventAttachmentEntity> eventAttachments = this.eventAttachmentDAO.getEventAttachments(eventId);
        if (eventAttachments == null) {
            return Collections.emptyList();
        }
        return eventAttachments.stream().map(EntityMapper::fromEntity).collect(Collectors.toList());
    }

    public EventAttachment getEventAttachmentById(long attachmentId) {
        EventAttachmentEntity eventAttachmentEntity = (EventAttachmentEntity)this.eventAttachmentDAO.find(Long.valueOf(attachmentId));
        if (eventAttachmentEntity == null) {
            return null;
        }
        return EntityMapper.fromEntity(eventAttachmentEntity);
    }
}

