/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.codec.binary.StringUtils;
import org.exoplatform.agenda.model.Calendar;
import org.exoplatform.agenda.model.Permission;
import org.exoplatform.agenda.service.AgendaCalendarService;
import org.exoplatform.agenda.storage.AgendaCalendarStorage;
import org.exoplatform.agenda.util.Utils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class AgendaCalendarServiceImpl
implements AgendaCalendarService {
    private AgendaCalendarStorage agendaCalendarStorage;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private List<String> defaultColors;

    public AgendaCalendarServiceImpl(AgendaCalendarStorage agendaCalendarStorage, IdentityManager identityManager, SpaceService spaceService, InitParams initParams) {
        this.agendaCalendarStorage = agendaCalendarStorage;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.defaultColors = initParams.getValuesParam("defaultColors").getValues();
    }

    public List<Calendar> getCalendars(int offset, int limit, String username) throws Exception {
        if (username == null) {
            throw new IllegalArgumentException("Username is mandatory");
        }
        Identity identity = this.identityManager.getOrCreateIdentity("organization", username);
        if (identity == null) {
            throw new IllegalStateException("User with name " + username + " is not found");
        }
        ArrayList<Long> identityIds = new ArrayList<Long>();
        identityIds.add(Long.parseLong(identity.getId()));
        Utils.addUserSpacesIdentities(this.spaceService, this.identityManager, username, identityIds);
        Long[] ownerIds = identityIds.toArray(new Long[0]);
        List<Long> calendarsIds = this.agendaCalendarStorage.getCalendarIdsByOwnerIds(offset, limit, ownerIds);
        ArrayList<Calendar> calendars = new ArrayList<Calendar>();
        for (Long calendarId : calendarsIds) {
            Calendar calendar = this.getCalendarById(calendarId, username);
            if (calendar.isDeleted()) continue;
            calendars.add(calendar);
        }
        return calendars;
    }

    public List<Calendar> getCalendarsByOwnerIds(List<Long> ownerIds, String username) throws IllegalAccessException {
        if (username == null) {
            throw new IllegalArgumentException("Username is mandatory");
        }
        Identity identity = this.identityManager.getOrCreateIdentity("organization", username);
        if (identity == null) {
            throw new IllegalStateException("User with name " + username + " is not found");
        }
        List<Long> calendarsIds = this.agendaCalendarStorage.getCalendarIdsByOwnerIds(0, Integer.MAX_VALUE, ownerIds.toArray(new Long[0]));
        ArrayList<Calendar> calendars = new ArrayList<Calendar>();
        for (Long calendarId : calendarsIds) {
            Calendar calendar = this.getCalendarById(calendarId, username);
            if (calendar.isDeleted()) continue;
            calendars.add(calendar);
        }
        return calendars;
    }

    public int countCalendars(String username) throws Exception {
        if (username == null) {
            throw new IllegalArgumentException("Username is mandatory");
        }
        Identity identity = this.identityManager.getOrCreateIdentity("organization", username);
        if (identity == null) {
            throw new IllegalStateException("User with name " + username + " is not found");
        }
        ArrayList<Long> identityIds = new ArrayList<Long>();
        identityIds.add(Long.parseLong(identity.getId()));
        Utils.addUserSpacesIdentities(this.spaceService, this.identityManager, username, identityIds);
        Long[] ownerIds = identityIds.toArray(new Long[0]);
        return this.agendaCalendarStorage.countCalendarsByOwners(ownerIds);
    }

    public Calendar getCalendarById(long calendarId, String username) throws IllegalAccessException {
        if (calendarId <= 0L) {
            throw new IllegalArgumentException("Calendar id has to be positive integer");
        }
        if (username == null) {
            throw new IllegalArgumentException("Username is mandatory");
        }
        Identity userIdentity = this.identityManager.getOrCreateIdentity("organization", username);
        if (userIdentity == null) {
            throw new IllegalStateException("User with name " + username + " is not found");
        }
        Calendar calendar = this.agendaCalendarStorage.getCalendarById(calendarId);
        if (calendar == null) {
            return null;
        }
        Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(calendar.getOwnerId()));
        if (ownerIdentity == null) {
            calendar.setDeleted(true);
            calendar.setAcl(new Permission(false, false));
        } else {
            boolean canEditCalendar = Utils.checkAclByCalendarOwner(this.identityManager, this.spaceService, calendar.getOwnerId(), username, true);
            calendar.setAcl(new Permission(canEditCalendar, false));
            this.fillCalendarTitleByOwnerName(calendar);
        }
        return calendar;
    }

    public Calendar getCalendarById(long calendarId) {
        if (calendarId <= 0L) {
            throw new IllegalArgumentException("Calendar id has to be positive integer");
        }
        Calendar calendar = this.agendaCalendarStorage.getCalendarById(calendarId);
        if (calendar == null) {
            return null;
        }
        Identity ownerIdentity = this.identityManager.getIdentity(String.valueOf(calendar.getOwnerId()));
        if (ownerIdentity == null) {
            calendar.setDeleted(true);
        } else {
            this.fillCalendarTitleByOwnerName(calendar);
        }
        return calendar;
    }

    public Calendar getOrCreateCalendarByOwnerId(long ownerId) {
        if (ownerId <= 0L) {
            throw new IllegalArgumentException("Calendar ownerId has to be positive integer");
        }
        Identity userIdentity = this.identityManager.getIdentity(String.valueOf(ownerId));
        if (userIdentity == null) {
            throw new IllegalStateException("User with technical identifier " + ownerId + " is not found");
        }
        int countCalendarsByOwners = this.agendaCalendarStorage.countCalendarsByOwners(ownerId);
        if (countCalendarsByOwners == 0) {
            Calendar calendar = this.createCalendarInstance(ownerId);
            calendar = this.agendaCalendarStorage.createCalendar(calendar);
            return calendar;
        }
        List<Long> calendarIds = this.agendaCalendarStorage.getCalendarIdsByOwnerIds(0, 1, ownerId);
        long calendarId = calendarIds.get(0);
        return this.getCalendarById(calendarId);
    }

    public Calendar createCalendarInstance(long ownerId) {
        return new Calendar(0L, ownerId, true, null, null, null, null, this.getRandomDefaultColor(), null);
    }

    public Calendar createCalendarInstance(long ownerId, String username) throws IllegalAccessException {
        boolean canEditCalendar = Utils.checkAclByCalendarOwner(this.identityManager, this.spaceService, ownerId, username, true);
        return new Calendar(0L, ownerId, true, null, null, null, null, this.getRandomDefaultColor(), new Permission(canEditCalendar, false));
    }

    public Calendar createCalendar(Calendar calendar, String username) throws IllegalAccessException {
        if (calendar == null) {
            throw new IllegalArgumentException("Calendar is mandatory");
        }
        if (calendar.getId() != 0L) {
            throw new IllegalArgumentException("Calendar id must be equal to 0");
        }
        if (username == null) {
            throw new IllegalArgumentException("Username is mandatory");
        }
        long ownerId = calendar.getOwnerId();
        if (ownerId <= 0L) {
            Identity userIdentity = this.identityManager.getOrCreateIdentity("organization", username);
            if (userIdentity == null) {
                throw new IllegalStateException("User with name " + username + " is not found");
            }
            calendar.setOwnerId(Long.parseLong(userIdentity.getId()));
        } else {
            Utils.checkAclByCalendarOwner(this.identityManager, this.spaceService, calendar.getOwnerId(), username, false);
        }
        calendar.setSystem(false);
        calendar = this.agendaCalendarStorage.createCalendar(calendar);
        return this.getCalendarById(calendar.getId(), username);
    }

    public Calendar createCalendar(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("Calendar is mandatory");
        }
        if (calendar.getId() != 0L) {
            throw new IllegalArgumentException("Calendar id must be equal to 0");
        }
        if (calendar.getOwnerId() <= 0L) {
            throw new IllegalArgumentException("Calendar owner is missing");
        }
        Identity calendarOwnerIdentity = this.identityManager.getIdentity(String.valueOf(calendar.getOwnerId()));
        if (calendarOwnerIdentity == null) {
            throw new IllegalStateException("Calendar owner is not found");
        }
        if (!StringUtils.equals((CharSequence)"organization", (CharSequence)calendarOwnerIdentity.getProviderId()) && !StringUtils.equals((CharSequence)"space", (CharSequence)calendarOwnerIdentity.getProviderId())) {
            throw new IllegalStateException("Calendar owner providerId '" + calendarOwnerIdentity.getProviderId() + "' is not managed by Calendar API");
        }
        calendar.setSystem(true);
        return this.agendaCalendarStorage.createCalendar(calendar);
    }

    public void updateCalendar(Calendar calendar, String username) throws IllegalAccessException, ObjectNotFoundException {
        if (calendar == null) {
            throw new IllegalArgumentException("Calendar is mandatory");
        }
        if (username == null) {
            throw new IllegalArgumentException("Username is mandatory");
        }
        if (calendar.getId() <= 0L) {
            throw new IllegalArgumentException("Calendar id has to be positive integer");
        }
        this.refillReadOnlyFields(calendar);
        Utils.checkAclByCalendarOwner(this.identityManager, this.spaceService, calendar.getOwnerId(), username, false);
        this.agendaCalendarStorage.updateCalendar(calendar);
    }

    public void updateCalendar(Calendar calendar) throws ObjectNotFoundException {
        if (calendar == null) {
            throw new IllegalArgumentException("Calendar is mandatory");
        }
        if (calendar.getId() <= 0L) {
            throw new IllegalArgumentException("Calendar id has to be positive integer");
        }
        this.refillReadOnlyFields(calendar);
        this.agendaCalendarStorage.updateCalendar(calendar);
    }

    public void deleteCalendarById(long calendarId, String username) throws IllegalAccessException, ObjectNotFoundException {
        if (username == null) {
            throw new IllegalArgumentException("Username is mandatory");
        }
        if (calendarId <= 0L) {
            throw new IllegalArgumentException("Calendar id has to be positive integer");
        }
        Calendar calendar = this.agendaCalendarStorage.getCalendarById(calendarId);
        if (calendar == null) {
            throw new ObjectNotFoundException("Calendar with id " + calendarId + " wasn't found");
        }
        if (calendar.isSystem()) {
            throw new IllegalStateException("Calendar with id " + calendarId + " is a system calendar, thus it couldn't be deleted");
        }
        Utils.checkAclByCalendarOwner(this.identityManager, this.spaceService, calendar.getOwnerId(), username, false);
        this.deleteCalendarById(calendarId);
    }

    public void deleteCalendarById(long calendarId) throws ObjectNotFoundException {
        if (calendarId <= 0L) {
            throw new IllegalArgumentException("Calendar id has to be positive integer");
        }
        Calendar calendar = this.agendaCalendarStorage.getCalendarById(calendarId);
        if (calendar == null) {
            throw new ObjectNotFoundException("Calendar with id " + calendarId + " doesn't exists");
        }
        this.agendaCalendarStorage.deleteCalendarById(calendarId);
    }

    private String getRandomDefaultColor() {
        int size = this.defaultColors.size();
        int index = new Random().nextInt(size);
        return this.defaultColors.get(index);
    }

    private void refillReadOnlyFields(Calendar calendar) throws ObjectNotFoundException {
        long calendarId = calendar.getId();
        Calendar storedCalendar = this.agendaCalendarStorage.getCalendarById(calendarId);
        if (storedCalendar == null) {
            throw new ObjectNotFoundException("Calendar with id " + calendarId + " wasn't found");
        }
        calendar.setCreated(storedCalendar.getCreated());
        calendar.setOwnerId(storedCalendar.getOwnerId());
    }

    private void fillCalendarTitleByOwnerName(Calendar calendar) {
        Identity requestedOwner = this.identityManager.getIdentity(String.valueOf(calendar.getOwnerId()));
        if (StringUtils.equals((CharSequence)requestedOwner.getProviderId(), (CharSequence)"organization")) {
            calendar.setTitle(requestedOwner.getProfile().getFullName());
        } else if (StringUtils.equals((CharSequence)requestedOwner.getProviderId(), (CharSequence)"space")) {
            Space space = this.spaceService.getSpaceByPrettyName(requestedOwner.getRemoteId());
            calendar.setTitle(space.getDisplayName());
        }
    }
}

