/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.listener;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import org.exoplatform.agenda.service.AgendaEventReminderService;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

public class AgendaEventReminderComputingListener
extends Listener<Long, Object> {
    private AgendaEventReminderService agendaEventReminderService;
    private AgendaEventService agendaEventService;

    public void onEvent(Event<Long, Object> event) throws Exception {
        Long eventId = (Long)event.getSource();
        org.exoplatform.agenda.model.Event agendaEvent = this.getAgendaEventService().getEventById(eventId.longValue());
        if (agendaEvent != null && agendaEvent.getRecurrence() != null) {
            ZonedDateTime start = ZonedDateTime.now();
            ZonedDateTime end = start.plusDays(this.getAgendaEventReminderService().getReminderComputingPeriod());
            List occurrences = this.getAgendaEventService().getEventOccurrencesInPeriod(agendaEvent, start, end, ZoneId.systemDefault(), 0);
            for (org.exoplatform.agenda.model.Event occurrence : occurrences) {
                ZonedDateTime occurrenceId = occurrence.getOccurrence().getId();
                this.getAgendaEventService().saveEventExceptionalOccurrence(eventId.longValue(), occurrenceId);
            }
        }
    }

    public AgendaEventReminderService getAgendaEventReminderService() {
        if (this.agendaEventReminderService == null) {
            this.agendaEventReminderService = (AgendaEventReminderService)ExoContainerContext.getService(AgendaEventReminderService.class);
        }
        return this.agendaEventReminderService;
    }

    public AgendaEventService getAgendaEventService() {
        if (this.agendaEventService == null) {
            this.agendaEventService = (AgendaEventService)ExoContainerContext.getService(AgendaEventService.class);
        }
        return this.agendaEventService;
    }
}

