/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.notification.plugin;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.agenda.constant.EventModificationType;
import org.exoplatform.agenda.model.Calendar;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.service.AgendaCalendarService;
import org.exoplatform.agenda.util.NotificationUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;

public class AgendaNotificationPlugin
extends BaseNotificationPlugin {
    private static final String AGENDA_NOTIFICATION_PLUGIN_NAME = "agenda.notification.plugin.key";
    private static final Log LOG = ExoLogger.getLogger(AgendaNotificationPlugin.class);
    private String notificationId;
    private IdentityManager identityManager;
    private AgendaCalendarService calendarService;
    private SpaceService spaceService;

    public AgendaNotificationPlugin(InitParams initParams, IdentityManager identityManager, AgendaCalendarService calendarService, SpaceService spaceService) {
        super(initParams);
        this.identityManager = identityManager;
        this.calendarService = calendarService;
        this.spaceService = spaceService;
        ValueParam notificationIdParam = initParams.getValueParam(AGENDA_NOTIFICATION_PLUGIN_NAME);
        if (notificationIdParam == null || StringUtils.isBlank((String)notificationIdParam.getValue())) {
            throw new IllegalStateException("'agenda.notification.plugin.key' parameter is mandatory");
        }
        this.notificationId = notificationIdParam.getValue();
    }

    public String getId() {
        return this.notificationId;
    }

    public boolean isValid(NotificationContext ctx) {
        if (NotificationUtils.getEventId(ctx) == 0L) {
            LOG.warn("Notification type '{}' isn't valid because the event wasn't found", new Object[]{this.getId()});
            return false;
        }
        return true;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        List eventAttendees = (List)ctx.value(NotificationUtils.EVENT_ATTENDEE);
        Event event = (Event)ctx.value(NotificationUtils.EVENT_AGENDA);
        String typeModification = (String)ctx.value(NotificationUtils.EVENT_MODIFICATION_TYPE);
        typeModification = StringUtils.isNotBlank((String)typeModification) ? typeModification : EventModificationType.ADDED.name();
        Calendar calendar = this.calendarService.getCalendarById(event.getCalendarId());
        NotificationInfo notification = NotificationInfo.instance();
        notification.key(this.getId());
        if (event.getId() > 0L) {
            NotificationUtils.setNotificationRecipients(this.identityManager, notification, this.spaceService, eventAttendees, event, typeModification);
        }
        if (notification.getSendToUserIds() == null || notification.getSendToUserIds().isEmpty()) {
            LOG.debug("Notification type '{}' doesn't have a recipient", new Object[]{this.getId()});
            return null;
        }
        NotificationUtils.storeEventParameters(this.identityManager, notification, event, calendar, typeModification);
        return notification.end();
    }
}

