/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.agenda.exception.AgendaException;
import org.exoplatform.agenda.exception.AgendaExceptionType;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.model.EventReminder;
import org.exoplatform.agenda.model.EventReminderParameter;
import org.exoplatform.agenda.service.AgendaEventReminderService;
import org.exoplatform.agenda.storage.AgendaEventAttendeeStorage;
import org.exoplatform.agenda.storage.AgendaEventReminderStorage;
import org.exoplatform.agenda.storage.AgendaEventStorage;
import org.exoplatform.agenda.util.NotificationUtils;
import org.exoplatform.agenda.util.Utils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.command.NotificationCommand;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;

public class AgendaEventReminderServiceImpl
implements AgendaEventReminderService {
    private AgendaEventReminderStorage reminderStorage;
    private AgendaEventStorage eventStorage;
    private AgendaEventAttendeeStorage attendeeStorage;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private ListenerService listenerService;
    private List<EventReminderParameter> defaultReminders = new ArrayList<EventReminderParameter>();
    private long reminderComputingPeriod = 2L;

    public AgendaEventReminderServiceImpl(AgendaEventReminderStorage reminderStorage, AgendaEventStorage eventStorage, AgendaEventAttendeeStorage attendeeStorage, IdentityManager identityManager, SpaceService spaceService, ListenerService listenerService, InitParams initParams) {
        ValueParam reminderComputingPeriodParam;
        this.reminderStorage = reminderStorage;
        this.eventStorage = eventStorage;
        this.attendeeStorage = attendeeStorage;
        this.listenerService = listenerService;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        Iterator objectParamIterator = initParams.getObjectParamIterator();
        if (objectParamIterator != null) {
            while (objectParamIterator.hasNext()) {
                ObjectParameter objectParameter = (ObjectParameter)objectParamIterator.next();
                Object objectParam = objectParameter.getObject();
                if (!(objectParam instanceof EventReminderParameter)) continue;
                EventReminderParameter eventReminderParameter = (EventReminderParameter)objectParam;
                this.defaultReminders.add(eventReminderParameter);
            }
        }
        if ((reminderComputingPeriodParam = initParams.getValueParam("period.computing.days")) != null && reminderComputingPeriodParam.getValue() != null) {
            this.reminderComputingPeriod = Long.parseLong(reminderComputingPeriodParam.getValue());
        }
    }

    public List<EventReminder> getEventReminders(long eventId, long userIdentityId) {
        return this.reminderStorage.getEventReminders(eventId, userIdentityId);
    }

    public List<EventReminder> getEventReminders(long eventId) {
        return this.reminderStorage.getEventReminders(eventId);
    }

    public void saveEventReminders(Event event, List<EventReminder> reminders) throws AgendaException {
        long eventId = event.getId();
        List<EventReminder> savedReminders = this.getEventReminders(eventId);
        List<Object> newReminders = reminders == null ? Collections.emptyList() : reminders;
        List remindersToDelete = savedReminders.stream().filter(reminder -> newReminders.stream().noneMatch(newReminder -> newReminder.getId() == reminder.getId())).collect(Collectors.toList());
        for (EventReminder eventReminder : remindersToDelete) {
            this.reminderStorage.removeEventReminder(eventReminder.getId());
        }
        if (reminders != null && !reminders.isEmpty()) {
            for (EventReminder eventReminder : reminders) {
                ZonedDateTime reminderDate = this.computeReminderDateTime(event, eventReminder);
                eventReminder.setDatetime(reminderDate);
                eventReminder.setEventId(eventId);
                this.reminderStorage.saveEventReminder(eventReminder);
            }
        }
        Utils.broadcastEvent(this.listenerService, "exo.agenda.event.reminders.saved", eventId, 0);
    }

    public void saveEventReminders(Event event, List<EventReminder> reminders, long identityId) throws AgendaException {
        long eventId = event.getId();
        List<EventReminder> savedReminders = this.getEventReminders(eventId, identityId);
        List<Object> newReminders = reminders == null ? Collections.emptyList() : reminders;
        List remindersToDelete = savedReminders.stream().filter(reminder -> newReminders.stream().noneMatch(newReminder -> newReminder.getId() == reminder.getId())).collect(Collectors.toList());
        for (EventReminder eventReminder : remindersToDelete) {
            this.reminderStorage.removeEventReminder(eventReminder.getId());
        }
        if (reminders != null && !reminders.isEmpty()) {
            for (EventReminder eventReminder : reminders) {
                ZonedDateTime reminderDate = this.computeReminderDateTime(event, eventReminder);
                eventReminder.setDatetime(reminderDate);
                eventReminder.setReceiverId(identityId);
                eventReminder.setEventId(eventId);
                this.reminderStorage.saveEventReminder(eventReminder);
            }
        }
        Utils.broadcastEvent(this.listenerService, "exo.agenda.event.reminders.saved", eventId, identityId);
        if (this.eventStorage.isRecurrentEvent(eventId)) {
            List<Long> exceptionalOccurenceEventIds = this.eventStorage.getExceptionalOccurenceIds(eventId);
            for (long exceptionalOccurenceEventId : exceptionalOccurenceEventIds) {
                List<EventAttendee> eventAttendees = this.attendeeStorage.getEventAttendees(exceptionalOccurenceEventId);
                if (!Utils.isEventAttendee(this.identityManager, this.spaceService, identityId, eventAttendees)) continue;
                Event exceptionalOccurrenceEvent = this.eventStorage.getEventById(exceptionalOccurenceEventId);
                if (reminders != null && !reminders.isEmpty()) {
                    reminders.forEach(reminder -> reminder.setId(0L));
                }
                this.saveEventReminders(exceptionalOccurrenceEvent, reminders, identityId);
            }
        }
    }

    public void sendReminders() {
        ZonedDateTime currentMinute = ZonedDateTime.now(ZoneOffset.UTC).withNano(0).withSecond(0);
        ZonedDateTime endCurrentMinute = currentMinute.plusMinutes(1L);
        List<EventReminder> reminders = this.reminderStorage.getEventReminders(currentMinute, endCurrentMinute);
        for (EventReminder eventReminder : reminders) {
            this.sendReminderNotification(eventReminder);
        }
    }

    public void removeEventReminders(long eventId) {
        this.reminderStorage.removeEventReminders(eventId);
    }

    public void removeUserReminders(long eventId, long identityId) {
        this.reminderStorage.removeEventReminders(eventId, identityId);
    }

    public long getReminderComputingPeriod() {
        return this.reminderComputingPeriod;
    }

    public void setReminderComputingPeriod(long reminderComputingPeriod) {
        this.reminderComputingPeriod = reminderComputingPeriod;
    }

    public List<EventReminderParameter> getDefaultReminders() {
        return Collections.unmodifiableList(this.defaultReminders);
    }

    private ZonedDateTime computeReminderDateTime(Event event, EventReminder eventReminder) throws AgendaException {
        ZonedDateTime eventStartDate = event.getStart();
        if (eventReminder.getBefore() < 0 || eventReminder.getBeforePeriodType() == null) {
            throw new AgendaException(AgendaExceptionType.REMINDER_DATE_CANT_COMPUTE);
        }
        ZonedDateTime reminderDate = null;
        reminderDate = eventReminder.getBefore() > 0 ? eventStartDate.minus(eventReminder.getBefore(), eventReminder.getBeforePeriodType().getTemporalUnit()).withZoneSameInstant(ZoneOffset.UTC) : eventStartDate;
        return reminderDate;
    }

    private void sendReminderNotification(EventReminder eventReminder) {
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(NotificationUtils.EVENT_AGENDA_REMINDER, (Object)eventReminder);
        NotificationCommand command = ctx.makeCommand(PluginKey.key((String)"EventReminderNotificationPlugin"));
        ctx.getNotificationExecutor().with(command).execute(ctx);
    }
}

