/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.listener;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.agenda.constant.AgendaEventModificationType;
import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.model.AgendaEventModification;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.model.EventDateOption;
import org.exoplatform.agenda.service.AgendaEventAttendeeService;
import org.exoplatform.agenda.service.AgendaEventDatePollService;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AgendaReplyOnSaveListener
extends Listener<AgendaEventModification, Object> {
    private static final Log LOG = ExoLogger.getExoLogger(AgendaReplyOnSaveListener.class);
    private final PortalContainer container;
    private AgendaEventService agendaEventService;
    private AgendaEventDatePollService agendaEventDatePollService;
    private AgendaEventAttendeeService agendaEventAttendeeService;

    public AgendaReplyOnSaveListener(PortalContainer container) {
        this.container = container;
    }

    public void onEvent(Event<AgendaEventModification, Object> event) throws Exception {
        AgendaEventModification eventModification = (AgendaEventModification)event.getSource();
        long eventId = eventModification.getEventId();
        long modifierId = eventModification.getModifierId();
        try {
            org.exoplatform.agenda.model.Event agendaEvent = this.getAgendaEventService().getEventById(eventId);
            List eventAttendees = this.getAgendaEventAttendeeService().getEventAttendees(eventId).getEventAttendees();
            switch (agendaEvent.getStatus()) {
                case CONFIRMED: {
                    if (!eventModification.hasModification(AgendaEventModificationType.START_DATE_UPDATED) && !eventModification.hasModification(AgendaEventModificationType.END_DATE_UPDATED) && !eventModification.hasModification(AgendaEventModificationType.SWITCHED_DATE_POLL_TO_EVENT) && !eventModification.hasModification(AgendaEventModificationType.ADDED)) break;
                    HashSet<Long> identityIds = new HashSet<Long>();
                    boolean updateModifierResponse = eventModification.hasModification(AgendaEventModificationType.ADDED);
                    boolean isModifierAttendee = false;
                    for (EventAttendee eventAttendee : eventAttendees) {
                        if (modifierId == eventAttendee.getIdentityId()) {
                            isModifierAttendee = true;
                            if (eventAttendee.getResponse() == EventAttendeeResponse.ACCEPTED) continue;
                            updateModifierResponse = true;
                            continue;
                        }
                        if (modifierId == eventAttendee.getIdentityId() || eventAttendee.getResponse() == EventAttendeeResponse.NEEDS_ACTION) continue;
                        identityIds.add(eventAttendee.getIdentityId());
                    }
                    for (Long identityId : identityIds) {
                        this.getAgendaEventAttendeeService().sendEventResponse(eventId, identityId.longValue(), EventAttendeeResponse.NEEDS_ACTION, false);
                    }
                    if (isModifierAttendee && updateModifierResponse) {
                        this.getAgendaEventAttendeeService().sendEventResponse(eventId, modifierId, EventAttendeeResponse.ACCEPTED, false);
                    }
                    break;
                }
                case TENTATIVE: {
                    if (!eventModification.hasModification(AgendaEventModificationType.START_DATE_UPDATED) && !eventModification.hasModification(AgendaEventModificationType.END_DATE_UPDATED) && !eventModification.hasModification(AgendaEventModificationType.DATE_OPTION_CREATED) && !eventModification.hasModification(AgendaEventModificationType.DATE_OPTION_DELETED) && !eventModification.hasModification(AgendaEventModificationType.DATE_OPTION_UPDATED) && !eventModification.hasModification(AgendaEventModificationType.SWITCHED_EVENT_TO_DATE_POLL) && !eventModification.hasModification(AgendaEventModificationType.ADDED)) break;
                    if (!eventModification.hasModification(AgendaEventModificationType.ADDED)) {
                        this.getAgendaEventDatePollService().resetEventVotes(eventId);
                    }
                    if (this.getAgendaEventAttendeeService().isEventAttendee(eventId, modifierId)) {
                        List eventDateOptions = this.getAgendaEventDatePollService().getEventDateOptions(eventId, (ZoneId)ZoneOffset.UTC);
                        List acceptedDatePollIds = eventDateOptions.stream().map(EventDateOption::getId).collect(Collectors.toList());
                        this.getAgendaEventDatePollService().saveEventVotes(eventId, acceptedDatePollIds, modifierId);
                    }
                    if (eventModification.hasModification(AgendaEventModificationType.ADDED)) break;
                    HashSet<Long> identityIds = new HashSet<Long>();
                    for (EventAttendee eventAttendee : eventAttendees) {
                        if (modifierId == eventAttendee.getIdentityId() || eventAttendee.getResponse() == EventAttendeeResponse.NEEDS_ACTION) continue;
                        identityIds.add(eventAttendee.getIdentityId());
                    }
                    for (Long identityId : identityIds) {
                        this.getAgendaEventAttendeeService().sendEventResponse(eventId, identityId.longValue(), EventAttendeeResponse.NEEDS_ACTION, false);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.warn("An error occurred while changing event '{}' response of user '{}'", new Object[]{eventId, modifierId, e});
        }
    }

    private AgendaEventService getAgendaEventService() {
        if (this.agendaEventService == null) {
            this.agendaEventService = (AgendaEventService)this.container.getComponentInstanceOfType(AgendaEventService.class);
        }
        return this.agendaEventService;
    }

    private AgendaEventDatePollService getAgendaEventDatePollService() {
        if (this.agendaEventDatePollService == null) {
            this.agendaEventDatePollService = (AgendaEventDatePollService)this.container.getComponentInstanceOfType(AgendaEventDatePollService.class);
        }
        return this.agendaEventDatePollService;
    }

    private AgendaEventAttendeeService getAgendaEventAttendeeService() {
        if (this.agendaEventAttendeeService == null) {
            this.agendaEventAttendeeService = (AgendaEventAttendeeService)this.container.getComponentInstanceOfType(AgendaEventAttendeeService.class);
        }
        return this.agendaEventAttendeeService;
    }
}

