/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.agenda.constant.ReminderPeriodType;
import org.exoplatform.commons.api.persistence.ExoEntity;

@Entity(name="AgendaEventReminder")
@ExoEntity
@Table(name="EXO_AGENDA_REMINDER")
@NamedQueries(value={@NamedQuery(name="AgendaEventReminder.deleteCalendarReminders", query="DELETE FROM AgendaEventReminder a WHERE a.eventId IN (SELECT evt.id FROM AgendaEvent evt WHERE evt.calendar.id = :calendarId)"), @NamedQuery(name="AgendaEventReminder.deleteEventReminders", query="DELETE FROM AgendaEventReminder a WHERE a.eventId = :eventId"), @NamedQuery(name="AgendaEventReminder.getEventRemindersByEventIdAndUserId", query="SELECT a FROM AgendaEventReminder a WHERE a.eventId = :eventId AND a.receiverId = :userId"), @NamedQuery(name="AgendaEventReminder.getEventRemindersByEventId", query="SELECT a FROM AgendaEventReminder a WHERE a.eventId = :eventId"), @NamedQuery(name="AgendaEventReminder.getEventRemindersByPeriod", query="SELECT a FROM AgendaEventReminder a WHERE a.triggerDate >= :start AND a.triggerDate < :end")})
public class EventReminderEntity
implements Serializable {
    private static final long serialVersionUID = 6460217989840428489L;
    @Id
    @SequenceGenerator(name="SEQ_AGENDA_EVENT_REMINDER_ID", sequenceName="SEQ_AGENDA_EVENT_REMINDER_ID")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_AGENDA_EVENT_REMINDER_ID")
    @Column(name="EVENT_REMINDER_ID")
    private Long id;
    @Column(name="EVENT_ID", nullable=false)
    private Long eventId;
    @Column(name="RECEIVER_ID", nullable=false)
    private long receiverId;
    @Column(name="BEFORE_VALUE", nullable=false)
    private int before;
    @Column(name="BEFORE_PERIOD_TYPE", nullable=false)
    private ReminderPeriodType beforeType;
    @Column(name="TRIGGER_DATE", nullable=true)
    private Date triggerDate;
    @Column(name="FROM_OCCURRENCE_ID")
    private Date fromOccurrenceId;
    @Column(name="UNTIL_OCCURRENCE_ID")
    private Date untilOccurrenceId;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getEventId() {
        return this.eventId;
    }

    public void setEventId(Long eventId) {
        this.eventId = eventId;
    }

    public int getBefore() {
        return this.before;
    }

    public void setBefore(int before) {
        this.before = before;
    }

    public ReminderPeriodType getBeforeType() {
        return this.beforeType;
    }

    public void setBeforeType(ReminderPeriodType beforeType) {
        this.beforeType = beforeType;
    }

    public Date getTriggerDate() {
        return this.triggerDate;
    }

    public void setTriggerDate(Date triggerDate) {
        this.triggerDate = triggerDate;
    }

    public long getReceiverId() {
        return this.receiverId;
    }

    public void setReceiverId(long receiverId) {
        this.receiverId = receiverId;
    }

    public Date getFromOccurrenceId() {
        return this.fromOccurrenceId;
    }

    public void setFromOccurrenceId(Date fromOccurrenceId) {
        this.fromOccurrenceId = fromOccurrenceId;
    }

    public Date getUntilOccurrenceId() {
        return this.untilOccurrenceId;
    }

    public void setUntilOccurrenceId(Date untilOccurrenceId) {
        this.untilOccurrenceId = untilOccurrenceId;
    }
}

