/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.exoplatform.agenda.constant.AgendaEventModificationType;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventDateOption;
import org.exoplatform.agenda.service.AgendaEventAttendeeService;
import org.exoplatform.agenda.service.AgendaEventDatePollService;
import org.exoplatform.agenda.storage.AgendaEventDatePollStorage;
import org.exoplatform.agenda.storage.AgendaEventStorage;
import org.exoplatform.agenda.util.Utils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

public class AgendaEventDatePollServiceImpl
implements AgendaEventDatePollService {
    private static final Log LOG = ExoLogger.getLogger(AgendaEventDatePollServiceImpl.class);
    private IdentityManager identityManager;
    private ListenerService listenerService;
    private AgendaEventAttendeeService eventAttendeeService;
    private AgendaEventDatePollStorage datePollStorage;
    private AgendaEventStorage eventStorage;

    public AgendaEventDatePollServiceImpl(AgendaEventDatePollStorage datePollStorage, AgendaEventStorage eventStorage, AgendaEventAttendeeService eventAttendeeService, IdentityManager identityManager, ListenerService listenerService) {
        this.eventAttendeeService = eventAttendeeService;
        this.datePollStorage = datePollStorage;
        this.eventStorage = eventStorage;
        this.identityManager = identityManager;
        this.listenerService = listenerService;
    }

    public List<EventDateOption> createEventPoll(long eventId, List<EventDateOption> dateOptions, long userIdentityId) {
        if (dateOptions == null || dateOptions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EventDateOption> createdDateOptions = new ArrayList<EventDateOption>();
        for (EventDateOption eventDateOption : dateOptions) {
            eventDateOption.setId(0L);
            eventDateOption.setEventId(eventId);
            eventDateOption.setSelected(false);
            EventDateOption createdDateOption = this.datePollStorage.createDateOption(eventDateOption);
            createdDateOptions.add(createdDateOption);
        }
        return createdDateOptions;
    }

    public Set<AgendaEventModificationType> updateEventDateOptions(long eventId, List<EventDateOption> dateOptions) {
        List<EventDateOption> dateOptionsToDelete;
        List<EventDateOption> dateOptionsToUpdate;
        if (dateOptions == null) {
            dateOptions = Collections.emptyList();
        }
        HashSet<AgendaEventModificationType> dateOptionModifications = new HashSet<AgendaEventModificationType>();
        List<EventDateOption> existingDateOptions = this.getEventDateOptions(eventId, ZoneOffset.UTC);
        List<EventDateOption> dateOptionsToCreate = this.getDateOptionsToCreate(dateOptions);
        if (!dateOptionsToCreate.isEmpty()) {
            dateOptionModifications.add(AgendaEventModificationType.DATE_OPTION_CREATED);
        }
        if (!(dateOptionsToUpdate = this.getDateOptionsToUpdate(dateOptions, existingDateOptions)).isEmpty()) {
            dateOptionModifications.add(AgendaEventModificationType.DATE_OPTION_UPDATED);
        }
        if (!(dateOptionsToDelete = this.getDateOptionsToDelete(dateOptions, existingDateOptions)).isEmpty()) {
            dateOptionModifications.add(AgendaEventModificationType.DATE_OPTION_DELETED);
        }
        for (EventDateOption eventDateOption : dateOptionsToCreate) {
            eventDateOption.setEventId(eventId);
            EventDateOption createdDateOption = this.datePollStorage.createDateOption(eventDateOption);
            eventDateOption.setId(createdDateOption.getId());
        }
        for (EventDateOption eventDateOption : dateOptionsToUpdate) {
            eventDateOption.setEventId(eventId);
            try {
                this.datePollStorage.updateDateOption(eventDateOption);
            }
            catch (ObjectNotFoundException e) {
                LOG.debug("Date option with id '{}' on event with id '{}' doesn't exist. A new date option will be created", new Object[]{eventDateOption.getId(), eventId, e});
                this.datePollStorage.createDateOption(eventDateOption);
            }
        }
        for (EventDateOption eventDateOption : dateOptionsToDelete) {
            this.datePollStorage.deleteDateOption(eventDateOption);
        }
        return dateOptionModifications;
    }

    public List<EventDateOption> getEventDateOptions(long eventId, ZoneId userTimeZone) {
        List<EventDateOption> eventDateOptions = this.datePollStorage.getEventDateOptions(eventId);
        eventDateOptions.forEach(eventDateOption -> this.transformDatesTimeZone((EventDateOption)eventDateOption, userTimeZone));
        return eventDateOptions;
    }

    public EventDateOption getEventDateOption(long dateOptionId, ZoneId userTimeZone) {
        EventDateOption dateOption = this.datePollStorage.getDateOption(dateOptionId, true, true);
        if (dateOption != null) {
            this.transformDatesTimeZone(dateOption, userTimeZone);
        }
        return dateOption;
    }

    public void saveEventVotes(long eventId, List<Long> acceptedDatePollIds, long identityId) throws ObjectNotFoundException, IllegalAccessException {
        Event event = this.eventStorage.getEventById(eventId);
        if (event == null) {
            throw new ObjectNotFoundException("Event with id " + eventId + " wasn't found");
        }
        Identity userIdentity = this.identityManager.getIdentity(String.valueOf(identityId));
        if (userIdentity == null) {
            throw new ObjectNotFoundException("Identity with id " + identityId + " wasn't found");
        }
        if (!this.eventAttendeeService.isEventAttendee(eventId, identityId)) {
            throw new IllegalAccessException("User with identity id " + identityId + " isn't attendee of event with id " + eventId);
        }
        if (acceptedDatePollIds == null) {
            acceptedDatePollIds = Collections.emptyList();
        }
        List<EventDateOption> eventDateOptions = this.datePollStorage.getEventDateOptions(eventId);
        for (EventDateOption eventDateOption : eventDateOptions) {
            long dateOptionId = eventDateOption.getId();
            if (acceptedDatePollIds.contains(dateOptionId)) {
                this.datePollStorage.vote(dateOptionId, identityId);
                continue;
            }
            this.datePollStorage.dismiss(dateOptionId, identityId);
        }
        Utils.broadcastEvent(this.listenerService, "exo.agenda.event.poll.voted.all", eventId, identityId);
    }

    public void voteDateOption(long dateOptionId, long identityId) throws ObjectNotFoundException, IllegalAccessException {
        EventDateOption dateOption = this.datePollStorage.getDateOption(dateOptionId, false, false);
        if (dateOption == null) {
            throw new ObjectNotFoundException("EventDateOption with id " + dateOptionId + " wasn't found");
        }
        Identity userIdentity = this.identityManager.getIdentity(String.valueOf(identityId));
        if (userIdentity == null) {
            throw new ObjectNotFoundException("Identity with id " + identityId + " wasn't found");
        }
        long eventId = dateOption.getEventId();
        if (!this.eventAttendeeService.isEventAttendee(eventId, identityId)) {
            throw new IllegalAccessException("User with identity id " + identityId + " isn't attendee of event with id " + eventId);
        }
        this.datePollStorage.vote(dateOptionId, identityId);
        Utils.broadcastEvent(this.listenerService, "exo.agenda.event.poll.voted", dateOptionId, identityId);
    }

    public void dismissDateOption(long dateOptionId, long identityId) throws ObjectNotFoundException {
        EventDateOption dateOption = this.datePollStorage.getDateOption(dateOptionId, false, false);
        if (dateOption == null) {
            throw new ObjectNotFoundException("EventDateOption with id " + dateOptionId + " wasn't found");
        }
        Identity userIdentity = this.identityManager.getIdentity(String.valueOf(identityId));
        if (userIdentity == null) {
            throw new ObjectNotFoundException("Identity with id " + identityId + " wasn't found");
        }
        this.datePollStorage.dismiss(dateOptionId, identityId);
        Utils.broadcastEvent(this.listenerService, "exo.agenda.event.poll.dismissed", dateOptionId, identityId);
    }

    public void selectEventDateOption(long dateOptionId) throws ObjectNotFoundException {
        this.datePollStorage.selectDateOption(dateOptionId);
    }

    public void resetEventVotes(long eventId) {
        this.datePollStorage.deleteEventVotes(eventId);
    }

    private List<EventDateOption> getDateOptionsToCreate(List<EventDateOption> dateOptions) {
        return dateOptions.stream().filter(dateOption -> dateOption.getId() == 0L).collect(Collectors.toList());
    }

    private List<EventDateOption> getDateOptionsToUpdate(List<EventDateOption> dateOptions, List<EventDateOption> existingDateOptions) {
        return dateOptions.stream().filter(dateOption -> {
            if (dateOption.getId() <= 0L) {
                return false;
            }
            EventDateOption existingDateOption = existingDateOptions.stream().filter(tmp -> tmp.getId() == dateOption.getId()).findAny().orElse(null);
            return !this.sameDateOption(existingDateOption, (EventDateOption)dateOption);
        }).collect(Collectors.toList());
    }

    private List<EventDateOption> getDateOptionsToDelete(List<EventDateOption> dateOptions, List<EventDateOption> existingDateOptions) {
        return existingDateOptions.stream().filter(existingDateOption -> {
            EventDateOption dateOption = dateOptions.stream().filter(tmp -> tmp.getId() == existingDateOption.getId()).findAny().orElse(null);
            return dateOption == null;
        }).collect(Collectors.toList());
    }

    private void transformDatesTimeZone(EventDateOption dateOption, ZoneId userTimeZone) {
        ZoneId timeZone;
        ZonedDateTime start = dateOption.getStart();
        ZonedDateTime end = dateOption.getEnd();
        ZoneId zoneId = timeZone = userTimeZone == null ? ZoneOffset.UTC : userTimeZone;
        if (dateOption.isAllDay()) {
            start = start.withZoneSameLocal(ZoneOffset.UTC).toLocalDate().atStartOfDay(timeZone);
            end = end.withZoneSameLocal(ZoneOffset.UTC).toLocalDate().atStartOfDay(timeZone).plusDays(1L).minusSeconds(1L);
        } else {
            start = start.withZoneSameInstant(timeZone);
            end = end.withZoneSameInstant(timeZone);
        }
        dateOption.setStart(start);
        dateOption.setEnd(end);
    }

    private boolean sameDateOption(EventDateOption dateOption1, EventDateOption dateOption2) {
        return dateOption1.isAllDay() == dateOption2.isAllDay() && dateOption1.getStart().withZoneSameInstant(ZoneOffset.UTC).isEqual(dateOption2.getStart().withZoneSameInstant(ZoneOffset.UTC)) && dateOption1.getEnd().withZoneSameInstant(ZoneOffset.UTC).isEqual(dateOption2.getEnd().withZoneSameInstant(ZoneOffset.UTC));
    }
}

