/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import org.exoplatform.agenda.exception.AgendaException;
import org.exoplatform.agenda.model.Calendar;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.model.EventConference;
import org.exoplatform.agenda.model.EventDateOption;
import org.exoplatform.agenda.model.EventFilter;
import org.exoplatform.agenda.model.EventReminder;
import org.exoplatform.agenda.model.EventSearchResult;
import org.exoplatform.agenda.model.GuestUser;
import org.exoplatform.agenda.model.RemoteEvent;
import org.exoplatform.commons.exception.ObjectNotFoundException;

public interface AgendaEventService {
    public List<Event> getEvents(EventFilter var1, ZoneId var2, long var3) throws IllegalAccessException;

    public List<Event> getParentRecurrentEvents(ZonedDateTime var1, ZonedDateTime var2, ZoneId var3);

    public Event getEventById(long var1, ZoneId var3, long var4) throws IllegalAccessException;

    public Event getEventById(long var1);

    public Event getEventOccurrence(long var1, ZonedDateTime var3, ZoneId var4, long var5) throws IllegalAccessException;

    public List<Event> getExceptionalOccurrenceEvents(long var1, ZoneId var3, long var4) throws IllegalAccessException;

    public Event getExceptionalOccurrenceEvent(long var1, ZonedDateTime var3);

    public Event createEventExceptionalOccurrence(long var1, List<EventAttendee> var3, List<EventConference> var4, List<EventReminder> var5, ZonedDateTime var6) throws AgendaException;

    public Event createEventExceptionalOccurrence(long var1, List<EventAttendee> var3, List<GuestUser> var4, List<EventConference> var5, List<EventReminder> var6, ZonedDateTime var7) throws AgendaException;

    public Event saveEventExceptionalOccurrence(long var1, ZonedDateTime var3) throws AgendaException;

    public Event createEvent(Event var1, List<EventAttendee> var2, List<GuestUser> var3, List<EventConference> var4, List<EventReminder> var5, List<EventDateOption> var6, RemoteEvent var7, boolean var8, long var9) throws IllegalAccessException, AgendaException;

    public Event createEvent(Event var1, List<EventAttendee> var2, List<EventConference> var3, List<EventReminder> var4, List<EventDateOption> var5, RemoteEvent var6, boolean var7, long var8) throws IllegalAccessException, AgendaException;

    public Event updateEvent(Event var1, List<EventAttendee> var2, List<GuestUser> var3, List<EventConference> var4, List<EventReminder> var5, List<EventDateOption> var6, RemoteEvent var7, boolean var8, long var9) throws IllegalAccessException, ObjectNotFoundException, AgendaException;

    public Event updateEvent(Event var1, List<EventAttendee> var2, List<EventConference> var3, List<EventReminder> var4, List<EventDateOption> var5, RemoteEvent var6, boolean var7, long var8) throws IllegalAccessException, ObjectNotFoundException, AgendaException;

    public void updateEventFields(long var1, Map<String, List<String>> var3, boolean var4, boolean var5, long var6) throws IllegalAccessException, ObjectNotFoundException, AgendaException;

    public Event deleteEventById(long var1, long var3) throws IllegalAccessException, ObjectNotFoundException;

    public boolean canAccessEvent(Event var1, long var2);

    public boolean canUpdateEvent(Event var1, long var2);

    public boolean canCreateEvent(Calendar var1, long var2);

    public List<EventSearchResult> search(long var1, ZoneId var3, String var4, int var5, int var6);

    public List<Event> getEventOccurrencesInPeriod(Event var1, ZonedDateTime var2, ZonedDateTime var3, ZoneId var4, int var5);

    public void selectEventDateOption(long var1, long var3, long var5) throws ObjectNotFoundException, IllegalAccessException;

    public List<Event> getEventDatePolls(EventFilter var1, ZoneId var2, long var3) throws IllegalAccessException;

    public long countEventDatePolls(List<Long> var1, long var2) throws IllegalAccessException;

    public List<Event> getPendingEvents(List<Long> var1, long var2, ZoneId var4, int var5, int var6) throws IllegalAccessException;

    public long countPendingEvents(List<Long> var1, long var2) throws IllegalAccessException;
}

