/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.storage;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.agenda.dao.EventDAO;
import org.exoplatform.agenda.dao.GuestUserDAO;
import org.exoplatform.agenda.entity.EventEntity;
import org.exoplatform.agenda.entity.GuestUserEntity;
import org.exoplatform.agenda.model.GuestUser;
import org.exoplatform.agenda.util.EntityMapper;

public class AgendaEventGuestStorage {
    private EventDAO eventDAO;
    private GuestUserDAO guestUserDAO;

    public AgendaEventGuestStorage(EventDAO eventDAO, GuestUserDAO guestUserDAO) {
        this.eventDAO = eventDAO;
        this.guestUserDAO = guestUserDAO;
    }

    public void saveEventGuestUser(GuestUser guestUser, long eventId) {
        EventEntity eventEntity = (EventEntity)this.eventDAO.find(Long.valueOf(eventId));
        GuestUserEntity guestUserEntity = EntityMapper.toEntity(guestUser, eventEntity);
        guestUserEntity.setId(null);
        guestUserEntity = (GuestUserEntity)this.guestUserDAO.create(guestUserEntity);
        long eventGuestId = guestUserEntity.getId();
        guestUser.setId(eventGuestId);
    }

    public List<GuestUser> getEventGuests(long eventId) {
        List<GuestUserEntity> guestUserEntities = this.guestUserDAO.getEventGuests(eventId);
        ArrayList<GuestUser> guestUserList = new ArrayList<GuestUser>();
        for (GuestUserEntity guestUserEntity : guestUserEntities) {
            GuestUser guestUser = EntityMapper.fromEntity(guestUserEntity, eventId);
            guestUserList.add(guestUser);
        }
        return guestUserList;
    }

    public void deleteGuest(long eventId, long guestId) {
        this.guestUserDAO.deleteGuest(eventId, guestId);
    }

    public void deleteEventGuests(long eventId) {
        this.guestUserDAO.deleteEventGuests(eventId);
    }
}

