/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.dao;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.constant.EventStatus;
import org.exoplatform.agenda.dao.EventAttendeeDAO;
import org.exoplatform.agenda.dao.EventConferenceDAO;
import org.exoplatform.agenda.dao.EventDAO$AjcClosure1;
import org.exoplatform.agenda.dao.EventDAO$AjcClosure3;
import org.exoplatform.agenda.dao.EventDAO$AjcClosure5;
import org.exoplatform.agenda.dao.EventDAO$AjcClosure7;
import org.exoplatform.agenda.dao.EventDateOptionDAO;
import org.exoplatform.agenda.dao.EventDatePollDAO;
import org.exoplatform.agenda.dao.EventRecurrenceDAO;
import org.exoplatform.agenda.dao.EventReminderDAO;
import org.exoplatform.agenda.dao.RemoteEventDAO;
import org.exoplatform.agenda.entity.EventEntity;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class EventDAO
extends GenericDAOJPAImpl<EventEntity, Long> {
    private static final int DEFAULT_LIMIT = 10;
    private EventConferenceDAO eventConferenceDAO;
    private EventAttendeeDAO eventAttendeeDAO;
    private EventReminderDAO eventReminderDAO;
    private EventRecurrenceDAO eventRecurrenceDAO;
    private RemoteEventDAO remoteEventDAO;
    private EventDateOptionDAO dateOptionDAO;
    private EventDatePollDAO datePollDAO;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public EventDAO(EventConferenceDAO eventConferenceDAO, EventAttendeeDAO eventAttendeeDAO, EventReminderDAO eventReminderDAO, EventRecurrenceDAO eventRecurrenceDAO, RemoteEventDAO remoteEventDAO, EventDateOptionDAO dateOptionDAO, EventDatePollDAO datePollDAO) {
        this.eventConferenceDAO = eventConferenceDAO;
        this.eventAttendeeDAO = eventAttendeeDAO;
        this.eventReminderDAO = eventReminderDAO;
        this.eventRecurrenceDAO = eventRecurrenceDAO;
        this.remoteEventDAO = remoteEventDAO;
        this.dateOptionDAO = dateOptionDAO;
        this.datePollDAO = datePollDAO;
    }

    @ExoTransactional
    public void delete(EventEntity entity) {
        EventEntity eventEntity = entity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)eventEntity);
        Object[] objectArray = new Object[]{this, eventEntity, joinPoint};
        EventDAO$AjcClosure1 eventDAO$AjcClosure1 = new EventDAO$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(eventDAO$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public void deleteCalendarEvents(long calendarId) {
        this.eventConferenceDAO.deleteCalendarConferences(calendarId);
        this.eventAttendeeDAO.deleteCalendarAttendees(calendarId);
        this.eventReminderDAO.deleteCalendarReminders(calendarId);
        this.eventRecurrenceDAO.deleteCalendarRecurrences(calendarId);
        this.remoteEventDAO.deleteCalendarRemoteEvents(calendarId);
        List<Long> calendarEventIds = this.getCalendarEventIds(calendarId);
        for (Long eventId : calendarEventIds) {
            this.datePollDAO.deleteEventPoll(eventId);
            this.dateOptionDAO.deleteEventDateOptions(eventId);
        }
        if (this.getEntityManager().getTransaction() != null && this.getEntityManager().getTransaction().isActive()) {
            this.getEntityManager().getTransaction().commit();
        }
        this.executeDeleteCalendarEventsQuery(calendarId);
    }

    public EventEntity deleteEvent(long eventId) {
        EventEntity eventEntity = (EventEntity)this.find(Long.valueOf(eventId));
        if (eventEntity == null) {
            return null;
        }
        List<Long> childEventIds = this.getChildEvents(eventId);
        for (Long childEventId : childEventIds) {
            this.deleteEvent(childEventId);
        }
        this.eventConferenceDAO.deleteEventConferences(eventId);
        this.eventAttendeeDAO.deleteEventAttendees(eventId);
        this.eventReminderDAO.deleteEventReminders(eventId);
        this.remoteEventDAO.deleteRemoteEvents(eventId);
        if (eventEntity.getRecurrence() != null) {
            this.eventRecurrenceDAO.delete(eventEntity.getRecurrence());
        }
        this.delete(eventEntity);
        return eventEntity;
    }

    @ExoTransactional
    public EventEntity create(EventEntity entity) {
        EventEntity eventEntity = entity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)eventEntity);
        Object[] objectArray = new Object[]{this, eventEntity, joinPoint};
        EventDAO$AjcClosure3 eventDAO$AjcClosure3 = new EventDAO$AjcClosure3(objectArray);
        return (EventEntity)ExoTransactionalAspect.aspectOf().around(eventDAO$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public EventEntity update(EventEntity entity) {
        EventEntity eventEntity = entity;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)eventEntity);
        Object[] objectArray = new Object[]{this, eventEntity, joinPoint};
        EventDAO$AjcClosure5 eventDAO$AjcClosure5 = new EventDAO$AjcClosure5(objectArray);
        return (EventEntity)ExoTransactionalAspect.aspectOf().around(eventDAO$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    public void deleteAll() {
        throw new UnsupportedOperationException();
    }

    public void updateAll(List<EventEntity> entities) {
        throw new UnsupportedOperationException();
    }

    @ExoTransactional
    public void executeDeleteCalendarEventsQuery(long calendarId) {
        long l = calendarId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        EventDAO$AjcClosure7 eventDAO$AjcClosure7 = new EventDAO$AjcClosure7(objectArray);
        ExoTransactionalAspect.aspectOf().around(eventDAO$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    public List<Long> getEventIds(Date startDate, Date endDate, List<Long> ownerIds, List<Long> attendeeIds, List<EventAttendeeResponse> responseTypes, int limit) {
        List resultList;
        this.verifyLimit(endDate, limit);
        boolean filterAttendees = attendeeIds != null && !attendeeIds.isEmpty();
        boolean filterOwners = ownerIds != null && !ownerIds.isEmpty();
        StringBuilder jpql = new StringBuilder("SELECT DISTINCT(ev.id), ev.startDate FROM AgendaEvent ev");
        if (filterAttendees) {
            jpql.append(" INNER JOIN ev.attendees att");
        }
        jpql.append(" INNER JOIN ev.calendar cal");
        jpql.append(" WHERE ev.status = :status");
        jpql.append(" AND (ev.endDate IS NULL OR ev.endDate >= :start)");
        if (endDate != null) {
            jpql.append(" AND ev.startDate < :end");
        }
        if (filterOwners) {
            jpql.append(" AND cal.ownerId IN (:ownerIds)");
        }
        if (filterAttendees) {
            jpql.append(" AND att.identityId IN (:attendeeIds)");
            if (responseTypes != null && !responseTypes.isEmpty()) {
                jpql.append(" AND att.response IN (:responseTypes)");
            }
        }
        jpql.append(" ORDER BY ev.startDate DESC");
        TypedQuery query = this.getEntityManager().createQuery(jpql.toString(), Tuple.class);
        query.setParameter("start", (Object)startDate);
        query.setParameter("status", (Object)EventStatus.CONFIRMED);
        if (endDate != null) {
            query.setParameter("end", (Object)endDate);
        }
        if (filterOwners) {
            query.setParameter("ownerIds", ownerIds);
        }
        if (filterAttendees) {
            query.setParameter("attendeeIds", attendeeIds);
            if (responseTypes != null) {
                query.setParameter("responseTypes", responseTypes);
            }
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList.stream().map(tuple -> (Long)tuple.get(0, Long.class)).collect(Collectors.toList());
    }

    public List<Long> getPendingEventIds(Long userIdentityId, List<Long> attendeeIds, Date fromDate, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("AgendaEvent.getPendingEventIds", Tuple.class);
        query.setParameter("status", (Object)EventStatus.CONFIRMED);
        query.setParameter("response", (Object)EventAttendeeResponse.NEEDS_ACTION);
        query.setParameter("userIdentityId", (Object)userIdentityId);
        query.setParameter("attendeeIds", attendeeIds);
        query.setParameter("date", (Object)fromDate);
        if (offset >= 0) {
            query.setFirstResult(offset);
        } else {
            query.setFirstResult(0);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        } else {
            query.setMaxResults(10);
        }
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptyList() : resultList.stream().map(tuple -> (Long)tuple.get(0, Long.class)).collect(Collectors.toList());
    }

    public Long countPendingEvents(Long userIdentityId, List<Long> attendeeIds, Date fromDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("AgendaEvent.countPendingEvents", Long.class);
        query.setParameter("status", (Object)EventStatus.CONFIRMED);
        query.setParameter("response", (Object)EventAttendeeResponse.NEEDS_ACTION);
        query.setParameter("userIdentityId", (Object)userIdentityId);
        query.setParameter("attendeeIds", attendeeIds);
        query.setParameter("date", (Object)fromDate);
        try {
            Long count = (Long)query.getSingleResult();
            return count == null ? 0L : count;
        }
        catch (NoResultException e) {
            return 0L;
        }
    }

    public List<Long> getPendingEventIdsByOwnerIds(Long userIdentityId, List<Long> ownerIds, List<Long> attendeeIds, Date fromDate, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("AgendaEvent.getPendingEventIdsByOwnerIds", Tuple.class);
        query.setParameter("status", (Object)EventStatus.CONFIRMED);
        query.setParameter("response", (Object)EventAttendeeResponse.NEEDS_ACTION);
        query.setParameter("userIdentityId", (Object)userIdentityId);
        query.setParameter("attendeeIds", attendeeIds);
        query.setParameter("ownerIds", ownerIds);
        query.setParameter("date", (Object)fromDate);
        if (offset >= 0) {
            query.setFirstResult(offset);
        } else {
            query.setFirstResult(0);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        } else {
            query.setMaxResults(10);
        }
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptyList() : resultList.stream().map(tuple -> (Long)tuple.get(0, Long.class)).collect(Collectors.toList());
    }

    public long countPendingEventsByOwnerIds(Long userIdentityId, List<Long> ownerIds, List<Long> attendeeIds, Date fromDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("AgendaEvent.countPendingEventsByOwnerIds", Long.class);
        query.setParameter("status", (Object)EventStatus.CONFIRMED);
        query.setParameter("response", (Object)EventAttendeeResponse.NEEDS_ACTION);
        query.setParameter("userIdentityId", (Object)userIdentityId);
        query.setParameter("attendeeIds", attendeeIds);
        query.setParameter("ownerIds", ownerIds);
        query.setParameter("date", (Object)fromDate);
        try {
            Long count = (Long)query.getSingleResult();
            return count == null ? 0L : count;
        }
        catch (NoResultException e) {
            return 0L;
        }
    }

    public List<Long> getEventDatePollIds(Long userIdentityId, List<Long> attendeeIds, Date fromDate, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("AgendaEvent.getPendingDatePollIds", Tuple.class);
        query.setParameter("status", (Object)EventStatus.TENTATIVE);
        query.setParameter("attendeeIds", attendeeIds);
        query.setParameter("userIdentityId", (Object)userIdentityId);
        query.setParameter("date", (Object)fromDate);
        if (offset >= 0) {
            query.setFirstResult(offset);
        } else {
            query.setFirstResult(0);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        } else {
            query.setMaxResults(10);
        }
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptyList() : resultList.stream().map(tuple -> (Long)tuple.get(0, Long.class)).collect(Collectors.toList());
    }

    public List<Long> getEventDatePollIds(Long userIdentityId, List<Long> attendeeIds, Date start, Date end) {
        TypedQuery query = this.getEntityManager().createNamedQuery("AgendaEvent.getDatePollIdsByDates", Tuple.class);
        query.setParameter("status", (Object)EventStatus.TENTATIVE);
        query.setParameter("attendeeIds", attendeeIds);
        query.setParameter("start", (Object)start);
        query.setParameter("end", (Object)end);
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptyList() : resultList.stream().map(tuple -> (Long)tuple.get(0, Long.class)).collect(Collectors.toList());
    }

    public Long countEventDatePolls(List<Long> attendeeIds, Date fromDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("AgendaEvent.countPendingDatePoll", Long.class);
        query.setParameter("status", (Object)EventStatus.TENTATIVE);
        query.setParameter("attendeeIds", attendeeIds);
        query.setParameter("date", (Object)fromDate);
        try {
            Long count = (Long)query.getSingleResult();
            return count == null ? 0L : count;
        }
        catch (NoResultException e) {
            return 0L;
        }
    }

    public List<Long> getEventDatePollIdsByOwnerIds(Long userIdentityId, List<Long> ownerIds, List<Long> attendeeIds, Date fromDate, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("AgendaEvent.getPendingDatePollIdsByOwnerIds", Tuple.class);
        query.setParameter("status", (Object)EventStatus.TENTATIVE);
        query.setParameter("attendeeIds", attendeeIds);
        query.setParameter("ownerIds", ownerIds);
        query.setParameter("date", (Object)fromDate);
        query.setParameter("userIdentityId", (Object)userIdentityId);
        if (offset >= 0) {
            query.setFirstResult(offset);
        } else {
            query.setFirstResult(0);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        } else {
            query.setMaxResults(10);
        }
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptyList() : resultList.stream().map(tuple -> (Long)tuple.get(0, Long.class)).collect(Collectors.toList());
    }

    public List<Long> getEventDatePollIdsByOwnerIds(Long userIdentityId, List<Long> ownerIds, List<Long> attendeeIds, Date start, Date end) {
        TypedQuery query = this.getEntityManager().createNamedQuery("AgendaEvent.getDatePollIdsByOwnerIdsAndDates", Tuple.class);
        query.setParameter("status", (Object)EventStatus.TENTATIVE);
        query.setParameter("attendeeIds", attendeeIds);
        query.setParameter("ownerIds", ownerIds);
        query.setParameter("start", (Object)start);
        query.setParameter("end", (Object)end);
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptyList() : resultList.stream().map(tuple -> (Long)tuple.get(0, Long.class)).collect(Collectors.toList());
    }

    public Long countEventDatePollsByOwnerIds(List<Long> ownerIds, List<Long> attendeeIds, Date fromDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("AgendaEvent.countPendingDatePollByOwnerIds", Long.class);
        query.setParameter("status", (Object)EventStatus.TENTATIVE);
        query.setParameter("attendeeIds", attendeeIds);
        query.setParameter("ownerIds", ownerIds);
        query.setParameter("date", (Object)fromDate);
        try {
            Long count = (Long)query.getSingleResult();
            return count == null ? 0L : count;
        }
        catch (NoResultException e) {
            return 0L;
        }
    }

    public List<EventEntity> getParentRecurrentEventIds(Date startDate, Date endDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("AgendaEvent.getParentRecurrentEventIds", EventEntity.class);
        query.setParameter("start", (Object)startDate);
        query.setParameter("end", (Object)endDate);
        query.setParameter("status", (Object)EventStatus.CONFIRMED);
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptyList() : resultList;
    }

    public List<Long> getExceptionalOccurenceIdsByPeriod(long parentRecurrentEventId, Date startDate, Date endDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("AgendaEvent.getExceptionalOccurenceIdsByPeriod", Long.class);
        query.setParameter("parentEventId", (Object)parentRecurrentEventId);
        query.setParameter("start", (Object)startDate);
        query.setParameter("end", (Object)endDate);
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptyList() : resultList;
    }

    public List<Long> getExceptionalOccurenceIdsByStart(long parentRecurrentEventId, Date startDate) {
        TypedQuery query = this.getEntityManager().createNamedQuery("AgendaEvent.getExceptionalOccurenceIdsByStart", Long.class);
        query.setParameter("parentEventId", (Object)parentRecurrentEventId);
        query.setParameter("start", (Object)startDate);
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptyList() : resultList;
    }

    public List<Long> getExceptionalOccurenceIds(long parentRecurrentEventId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("AgendaEvent.getExceptionalOccurenceIds", Tuple.class);
        query.setParameter("parentEventId", (Object)parentRecurrentEventId);
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptyList() : resultList.stream().map(tuple -> (Long)tuple.get(0, Long.class)).collect(Collectors.toList());
    }

    public void deleteExceptionalOccurences(long parentRecurrentEventId) {
        List<Long> result = this.getExceptionalOccurenceIds(parentRecurrentEventId);
        for (Long id : result) {
            this.deleteEvent(id);
        }
    }

    private List<Long> getChildEvents(long eventId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("AgendaEvent.getChildEvents", Long.class);
        query.setParameter("parentEventId", (Object)eventId);
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptyList() : resultList;
    }

    private List<Long> getCalendarEventIds(long calendarId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("AgendaEvent.getCalendarEventIds", Long.class);
        query.setParameter("calendarId", (Object)calendarId);
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptyList() : resultList;
    }

    private void verifyLimit(Date endDate, int limit) {
        if (limit <= 0 && endDate == null) {
            throw new IllegalStateException("Limit of events to retrieve is missing, whether us endDate or limit parameters");
        }
    }

    static {
        EventDAO.ajc$preClinit();
    }

    static /* synthetic */ void delete_aroundBody0(EventDAO ajc$this, EventEntity entity, JoinPoint joinPoint) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity is mandatory");
        }
        if (entity.getId() == null) {
            throw new IllegalArgumentException("Entity with valid identifier is mandatory");
        }
        ajc$this.eventConferenceDAO.deleteEventConferences(entity.getId());
        ajc$this.eventAttendeeDAO.deleteEventAttendees(entity.getId());
        ajc$this.eventReminderDAO.deleteEventReminders(entity.getId());
        ajc$this.eventRecurrenceDAO.deleteEventRecurrences(entity.getId());
        ajc$this.remoteEventDAO.deleteRemoteEvents(entity.getId());
        ajc$this.datePollDAO.deleteEventPoll(entity.getId());
        ajc$this.dateOptionDAO.deleteEventDateOptions(entity.getId());
        super.delete((Object)entity);
    }

    static /* synthetic */ EventEntity create_aroundBody2(EventDAO ajc$this, EventEntity entity, JoinPoint joinPoint) {
        entity.setCreatedDate(new Date());
        return (EventEntity)super.create((Object)entity);
    }

    static /* synthetic */ EventEntity update_aroundBody4(EventDAO ajc$this, EventEntity entity, JoinPoint joinPoint) {
        entity.setUpdatedDate(new Date());
        return (EventEntity)super.update((Object)entity);
    }

    static /* synthetic */ void executeDeleteCalendarEventsQuery_aroundBody6(EventDAO ajc$this, long calendarId, JoinPoint joinPoint) {
        Query deleteEventsQuery = ajc$this.getEntityManager().createNamedQuery("AgendaEvent.deleteCalendarEvents");
        deleteEventsQuery.setParameter("calendarId", (Object)calendarId);
        deleteEventsQuery.executeUpdate();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EventDAO.java", EventDAO.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "delete", "org.exoplatform.agenda.dao.EventDAO", "org.exoplatform.agenda.entity.EventEntity", "entity", "", "void"), 67);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "create", "org.exoplatform.agenda.dao.EventDAO", "org.exoplatform.agenda.entity.EventEntity", "entity", "", "org.exoplatform.agenda.entity.EventEntity"), 133);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "update", "org.exoplatform.agenda.dao.EventDAO", "org.exoplatform.agenda.entity.EventEntity", "entity", "", "org.exoplatform.agenda.entity.EventEntity"), 140);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeDeleteCalendarEventsQuery", "org.exoplatform.agenda.dao.EventDAO", "long", "calendarId", "", "void"), 156);
    }
}

