/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.listener;

import java.time.ZoneId;
import java.time.ZoneOffset;
import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.model.EventDateOption;
import org.exoplatform.agenda.service.AgendaEventAttendeeService;
import org.exoplatform.agenda.service.AgendaEventDatePollService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

public class AgendaVoteListener
extends Listener<Long, Long> {
    private PortalContainer container;
    private AgendaEventDatePollService datePollService;
    private AgendaEventAttendeeService attendeeService;

    public AgendaVoteListener(PortalContainer container) {
        this.container = container;
    }

    public void onEvent(Event<Long, Long> event) throws Exception {
        long dateOptionId = (Long)event.getSource();
        long identityId = (Long)event.getData();
        EventDateOption dateOption = this.getDatePollService().getEventDateOption(dateOptionId, (ZoneId)ZoneOffset.UTC);
        long eventId = dateOption.getEventId();
        this.getAttendeeService().sendEventResponse(eventId, identityId, EventAttendeeResponse.TENTATIVE);
    }

    private AgendaEventAttendeeService getAttendeeService() {
        if (this.attendeeService == null) {
            this.attendeeService = (AgendaEventAttendeeService)this.container.getComponentInstanceOfType(AgendaEventAttendeeService.class);
        }
        return this.attendeeService;
    }

    private AgendaEventDatePollService getDatePollService() {
        if (this.datePollService == null) {
            this.datePollService = (AgendaEventDatePollService)this.container.getComponentInstanceOfType(AgendaEventDatePollService.class);
        }
        return this.datePollService;
    }
}

