/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.agenda.constant.AgendaEventModificationType;
import org.exoplatform.agenda.model.EventConference;
import org.exoplatform.agenda.service.AgendaEventConferenceService;
import org.exoplatform.agenda.storage.AgendaEventConferenceStorage;
import org.exoplatform.agenda.util.Utils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.ListenerService;

public class AgendaEventConferenceServiceImpl
implements AgendaEventConferenceService {
    private static final String WEB_CONFERENCING_ENABLED_TYPE_PARAM = "webConferencing.default";
    private static final String AGENDA_WEB_CONFERENCING_KEY = "AgendaWebConference";
    private static final Scope AGENDA_SCOPE = Scope.APPLICATION.id("Agenda");
    private static final Context AGENDA_CONTEXT = Context.GLOBAL.id("Agenda");
    private AgendaEventConferenceStorage conferenceStorage;
    private SettingService settingService;
    private ListenerService listenerService;
    private List<String> defaultEnabledWebConferences;

    public AgendaEventConferenceServiceImpl(AgendaEventConferenceStorage conferenceStorage, ListenerService listenerService, SettingService settingService, InitParams params) {
        this.conferenceStorage = conferenceStorage;
        this.listenerService = listenerService;
        this.settingService = settingService;
        if (params != null && params.containsKey((Object)WEB_CONFERENCING_ENABLED_TYPE_PARAM)) {
            this.defaultEnabledWebConferences = Arrays.asList(params.getValueParam(WEB_CONFERENCING_ENABLED_TYPE_PARAM).getValue());
        }
    }

    public Set<AgendaEventModificationType> saveEventConferences(long eventId, List<EventConference> conferences) {
        List<EventConference> savedConferences = this.getEventConferences(eventId);
        List<Object> newConferences = conferences == null ? Collections.emptyList() : conferences;
        ArrayList<EventConference> conferencesToDelete = new ArrayList<EventConference>(savedConferences);
        conferencesToDelete.removeAll(newConferences);
        ArrayList conferencesToCreate = new ArrayList(newConferences);
        conferencesToCreate.removeAll(savedConferences);
        for (EventConference eventConference : conferencesToDelete) {
            this.conferenceStorage.removeEventConference(eventConference.getId());
        }
        for (EventConference eventConference : conferencesToCreate) {
            eventConference.setEventId(eventId);
            this.conferenceStorage.saveEventConference(eventConference);
        }
        HashSet<AgendaEventModificationType> conferenceModificationTypes = new HashSet<AgendaEventModificationType>();
        if (!conferencesToDelete.isEmpty()) {
            conferenceModificationTypes.add(AgendaEventModificationType.CONFERENCE_DELETED);
        }
        if (!conferencesToCreate.isEmpty()) {
            conferenceModificationTypes.add(AgendaEventModificationType.CONFERENCE_ADDED);
        }
        Utils.broadcastEvent(this.listenerService, "exo.agenda.event.conferences.saved", eventId, 0);
        return conferenceModificationTypes;
    }

    public List<EventConference> getEventConferences(long eventId) {
        return this.conferenceStorage.getEventConferences(eventId);
    }

    public void saveEnabledWebConferenceProviders(List<String> enabledProviders) {
        SettingValue webConferencingSetting = SettingValue.create((String)StringUtils.join(enabledProviders, (String)","));
        this.settingService.set(AGENDA_CONTEXT, AGENDA_SCOPE, AGENDA_WEB_CONFERENCING_KEY, webConferencingSetting);
    }

    public List<String> getEnabledWebConferenceProviders() {
        SettingValue webConferencingSetting = this.settingService.get(AGENDA_CONTEXT, AGENDA_SCOPE, AGENDA_WEB_CONFERENCING_KEY);
        if (webConferencingSetting == null || webConferencingSetting.getValue() == null) {
            return this.defaultEnabledWebConferences;
        }
        return Arrays.asList(StringUtils.split((String)webConferencingSetting.getValue().toString(), (String)","));
    }
}

