/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.job;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.service.AgendaEventReminderService;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class DailyReminderComputingJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(DailyReminderComputingJob.class);
    private ExoContainer container = PortalContainer.getInstance();
    private AgendaEventService agendaEventService;
    private AgendaEventReminderService agendaEventReminderService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            ZonedDateTime start = ZonedDateTime.now();
            ZonedDateTime end = start.plusDays(this.getAgendaEventReminderService().getReminderComputingPeriod());
            List events = this.getAgendaEventService().getParentRecurrentEvents(start, end, (ZoneId)ZoneOffset.UTC);
            for (Event recurrentEvent : events) {
                List occurrences = this.getAgendaEventService().getEventOccurrencesInPeriod(recurrentEvent, start, end, (ZoneId)ZoneOffset.UTC, 0);
                for (Event occurrence : occurrences) {
                    this.getAgendaEventService().saveEventExceptionalOccurrence(recurrentEvent.getId(), occurrence.getOccurrence().getId());
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while computing reminder date of events", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
        }
    }

    private AgendaEventService getAgendaEventService() {
        if (this.agendaEventService == null) {
            this.agendaEventService = (AgendaEventService)this.container.getComponentInstanceOfType(AgendaEventService.class);
        }
        return this.agendaEventService;
    }

    public AgendaEventReminderService getAgendaEventReminderService() {
        if (this.agendaEventReminderService == null) {
            this.agendaEventReminderService = (AgendaEventReminderService)this.container.getComponentInstanceOfType(AgendaEventReminderService.class);
        }
        return this.agendaEventReminderService;
    }
}

