/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.agenda.constant.AgendaEventModificationType;
import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.constant.EventAvailability;
import org.exoplatform.agenda.constant.EventStatus;
import org.exoplatform.agenda.exception.AgendaException;
import org.exoplatform.agenda.exception.AgendaExceptionType;
import org.exoplatform.agenda.model.AgendaEventModification;
import org.exoplatform.agenda.model.Calendar;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.model.EventAttendeeList;
import org.exoplatform.agenda.model.EventConference;
import org.exoplatform.agenda.model.EventDateOption;
import org.exoplatform.agenda.model.EventFilter;
import org.exoplatform.agenda.model.EventOccurrence;
import org.exoplatform.agenda.model.EventPermission;
import org.exoplatform.agenda.model.EventRecurrence;
import org.exoplatform.agenda.model.EventReminder;
import org.exoplatform.agenda.model.EventSearchResult;
import org.exoplatform.agenda.model.GuestUser;
import org.exoplatform.agenda.model.RemoteEvent;
import org.exoplatform.agenda.search.AgendaSearchConnector;
import org.exoplatform.agenda.service.AgendaCalendarService;
import org.exoplatform.agenda.service.AgendaEventAttendeeService;
import org.exoplatform.agenda.service.AgendaEventConferenceService;
import org.exoplatform.agenda.service.AgendaEventDatePollService;
import org.exoplatform.agenda.service.AgendaEventGuestService;
import org.exoplatform.agenda.service.AgendaEventReminderService;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.agenda.service.AgendaRemoteEventService;
import org.exoplatform.agenda.storage.AgendaEventStorage;
import org.exoplatform.agenda.util.AgendaDateUtils;
import org.exoplatform.agenda.util.Utils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;

public class AgendaEventServiceImpl
implements AgendaEventService {
    private static final Log LOG = ExoLogger.getLogger(AgendaEventServiceImpl.class);
    private AgendaCalendarService agendaCalendarService;
    private AgendaEventAttendeeService attendeeService;
    private AgendaEventGuestService agendaEventGuestService;
    private AgendaEventConferenceService conferenceService;
    private AgendaEventReminderService reminderService;
    private AgendaRemoteEventService remoteEventService;
    private AgendaEventDatePollService datePollService;
    private AgendaEventStorage agendaEventStorage;
    private AgendaSearchConnector agendaSearchConnector;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private ListenerService listenerService;

    public AgendaEventServiceImpl(AgendaCalendarService agendaCalendarService, AgendaEventAttendeeService attendeeService, AgendaEventGuestService agendaEventGuestService, AgendaEventConferenceService conferenceService, AgendaEventReminderService reminderService, AgendaRemoteEventService remoteEventService, AgendaEventDatePollService datePollService, AgendaSearchConnector agendaSearchConnector, AgendaEventStorage agendaEventStorage, IdentityManager identityManager, SpaceService spaceService, ListenerService listenerService) {
        this.agendaCalendarService = agendaCalendarService;
        this.attendeeService = attendeeService;
        this.agendaEventGuestService = agendaEventGuestService;
        this.conferenceService = conferenceService;
        this.reminderService = reminderService;
        this.remoteEventService = remoteEventService;
        this.datePollService = datePollService;
        this.agendaEventStorage = agendaEventStorage;
        this.agendaSearchConnector = agendaSearchConnector;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.listenerService = listenerService;
    }

    public Event getEventById(long eventId, ZoneId timeZone, long userIdentityId) throws IllegalAccessException {
        Event event = this.agendaEventStorage.getEventById(eventId);
        if (event == null) {
            return null;
        }
        if (this.canAccessEvent(event, userIdentityId)) {
            this.adjustEventDatesForRead(event, timeZone);
            boolean canUpdateEvent = this.canUpdateEvent(event, userIdentityId);
            boolean isEventAttendee = this.attendeeService.isEventAttendee(this.getEventIdOrParentId(event), userIdentityId);
            event.setAcl(new EventPermission(canUpdateEvent, isEventAttendee));
            return event;
        }
        throw new IllegalAccessException("User with identity id " + userIdentityId + "is not allowed to access event with id " + eventId);
    }

    public Event getEventById(long eventId) {
        return this.agendaEventStorage.getEventById(eventId);
    }

    public Event getEventOccurrence(long parentEventId, ZonedDateTime occurrenceId, ZoneId timeZone, long userIdentityId) throws IllegalAccessException {
        Event recurrentEvent = this.agendaEventStorage.getEventById(parentEventId);
        if (recurrentEvent == null) {
            return null;
        }
        if (recurrentEvent.getRecurrence() == null) {
            throw new IllegalStateException("Event with id " + parentEventId + " is not a recurrent event");
        }
        Event event = null;
        Event exceptionalOccurrenceEvent = this.agendaEventStorage.getExceptionalOccurrenceEvent(parentEventId, occurrenceId);
        if (exceptionalOccurrenceEvent != null) {
            if (!this.canAccessEvent(exceptionalOccurrenceEvent, userIdentityId)) {
                throw new IllegalAccessException("");
            }
            event = exceptionalOccurrenceEvent;
        } else {
            List<Event> occurrences = Utils.getOccurrences(recurrentEvent, occurrenceId.toLocalDate().minusDays(1L), occurrenceId.toLocalDate().plusDays(1L), 3);
            ZonedDateTime occurrenceIdUTC = occurrenceId.withZoneSameInstant(ZoneOffset.UTC);
            event = occurrences.stream().filter(occ -> occ.getOccurrence().getId().withZoneSameInstant(ZoneOffset.UTC).equals(occurrenceIdUTC)).findFirst().orElse(null);
            if (event == null) {
                event = occurrences.stream().filter(occ -> occ.getOccurrence().getId().withZoneSameInstant(ZoneOffset.UTC).toLocalDate().equals(occurrenceIdUTC.toLocalDate())).findFirst().orElse(null);
            }
        }
        if (event != null) {
            this.adjustEventDatesForRead(event, timeZone);
            boolean canUpdateEvent = this.canUpdateEvent(event, userIdentityId);
            boolean isEventAttendee = this.attendeeService.isEventAttendee(this.getEventIdOrParentId(event), userIdentityId);
            event.setAcl(new EventPermission(canUpdateEvent, isEventAttendee));
        }
        return event;
    }

    public List<Event> getExceptionalOccurrenceEvents(long parentEventId, ZoneId timeZone, long userIdentityId) throws IllegalAccessException {
        Event parentEvent = this.agendaEventStorage.getEventById(parentEventId);
        if (parentEvent == null) {
            return Collections.emptyList();
        }
        if (!this.canAccessEvent(parentEvent, userIdentityId)) {
            throw new IllegalAccessException("User " + userIdentityId + "is not allowed to access event with id " + parentEventId);
        }
        List<Long> exceptionalOccurenceIds = this.agendaEventStorage.getExceptionalOccurenceIds(parentEventId);
        return exceptionalOccurenceIds.stream().map(eventId -> {
            try {
                return this.getEventById((long)eventId, timeZone, userIdentityId);
            }
            catch (IllegalAccessException e) {
                LOG.debug("User is not allowed to access exceptional event {}. Ignore retrieving this exceptional event", new Object[]{eventId, e});
                return null;
            }
        }).filter(event -> event != null).collect(Collectors.toList());
    }

    public Event getExceptionalOccurrenceEvent(long eventId, ZonedDateTime occurrenceId) {
        return this.agendaEventStorage.getExceptionalOccurrenceEvent(eventId, occurrenceId);
    }

    public Event createEvent(Event event, List<EventAttendee> attendees, List<EventConference> conferences, List<EventReminder> reminders, List<EventDateOption> dateOptions, RemoteEvent remoteEvent, boolean sendInvitation, long userIdentityId) throws IllegalAccessException, AgendaException {
        return this.createEvent(event, attendees, new ArrayList<GuestUser>(), conferences, reminders, dateOptions, remoteEvent, sendInvitation, userIdentityId);
    }

    public Event createEvent(Event event, List<EventAttendee> attendees, List<GuestUser> guestUsers, List<EventConference> conferences, List<EventReminder> reminders, List<EventDateOption> dateOptions, RemoteEvent remoteEvent, boolean sendInvitation, long userIdentityId) throws IllegalAccessException, AgendaException {
        Identity userIdentity;
        EventRecurrence recurrence;
        if (userIdentityId <= 0L) {
            throw new IllegalArgumentException("userIdentityId is mandatory");
        }
        if (event == null) {
            throw new IllegalArgumentException("Event is mandatory");
        }
        if (event.getId() > 0L) {
            throw new IllegalArgumentException("Event id must be null");
        }
        long calendarId = event.getCalendarId();
        if (calendarId <= 0L) {
            throw new IllegalArgumentException("Event calendar id must be positive");
        }
        if (dateOptions != null) {
            dateOptions = new ArrayList<EventDateOption>(dateOptions);
            this.checkAndComputeDateOptions(event, dateOptions);
        }
        if (event.getStart() == null) {
            throw new AgendaException(AgendaExceptionType.EVENT_START_DATE_MANDATORY);
        }
        if (event.getEnd() == null) {
            throw new AgendaException(AgendaExceptionType.EVENT_END_DATE_MANDATORY);
        }
        if (event.getStart().isAfter(event.getEnd())) {
            throw new AgendaException(AgendaExceptionType.EVENT_START_DATE_BEFORE_END_DATE);
        }
        if (event.getAvailability() == null) {
            event.setAvailability(EventAvailability.DEFAULT);
        }
        if (event.getStatus() == null) {
            event.setStatus(EventStatus.CONFIRMED);
        }
        if ((recurrence = event.getRecurrence()) != null) {
            if (recurrence.getFrequency() == null) {
                throw new AgendaException(AgendaExceptionType.EVENT_RECURRENCE_FREQUENCY_MANDATORY);
            }
            if (recurrence.getInterval() <= 0) {
                throw new AgendaException(AgendaExceptionType.EVENT_RECURRENCE_INTERVAL_MANDATORY);
            }
        }
        if ((userIdentity = this.identityManager.getIdentity(String.valueOf(userIdentityId))) == null) {
            throw new IllegalAccessException("User '" + userIdentityId + "' doesn't exist");
        }
        Calendar calendar = this.agendaCalendarService.getCalendarById(calendarId);
        if (calendar == null) {
            throw new AgendaException(AgendaExceptionType.CALENDAR_NOT_FOUND);
        }
        boolean canCreateCalendarEvents = this.canCreateEvent(calendar, userIdentityId);
        if (!canCreateCalendarEvents) {
            throw new IllegalAccessException("User '" + userIdentityId + "' can't create an event in calendar " + calendar.getTitle());
        }
        EventOccurrence occurrence = event.getOccurrence();
        if (occurrence != null && occurrence.getId() != null) {
            event.setRecurrence(null);
        }
        this.adjustEventDatesForWrite(event);
        Event eventToCreate = new Event(0L, event.getParentId(), calendarId, userIdentityId, 0L, ZonedDateTime.now(), null, event.getSummary(), event.getDescription(), event.getLocation(), event.getColor(), event.getTimeZoneId(), event.getStart(), event.getEnd(), event.isAllDay(), event.getAvailability(), event.getStatus(), event.getRecurrence(), event.getOccurrence(), null, event.isAllowAttendeeToUpdate(), event.isAllowAttendeeToInvite());
        Event createdEvent = this.agendaEventStorage.createEvent(eventToCreate);
        long eventId = createdEvent.getId();
        createdEvent = this.getEventById(eventId, event.getTimeZoneId(), userIdentityId);
        AgendaEventModification eventModifications = new AgendaEventModification(eventId, createdEvent.getCalendarId(), userIdentityId, Collections.singleton(AgendaEventModificationType.ADDED));
        if (conferences != null && !conferences.isEmpty()) {
            this.conferenceService.saveEventConferences(eventId, conferences);
        }
        if (dateOptions != null && !dateOptions.isEmpty()) {
            this.datePollService.createEventPoll(eventId, dateOptions, userIdentityId);
        }
        if (reminders != null) {
            this.reminderService.saveEventReminders(createdEvent, reminders, userIdentityId);
        }
        if (remoteEvent != null) {
            remoteEvent.setIdentityId(userIdentityId);
            remoteEvent.setEventId(createdEvent.getId());
            this.remoteEventService.saveRemoteEvent(remoteEvent);
        }
        if (guestUsers != null && !guestUsers.isEmpty()) {
            this.agendaEventGuestService.saveEventGuests(eventId, guestUsers);
        }
        if (attendees != null && !attendees.isEmpty()) {
            this.attendeeService.saveEventAttendees(createdEvent, attendees, guestUsers, conferences, userIdentityId, sendInvitation, false, eventModifications);
        }
        if (createdEvent.getStatus() == EventStatus.TENTATIVE) {
            Utils.broadcastEvent(this.listenerService, "exo.agenda.event.poll.created", eventModifications, null);
        } else if (createdEvent.getStatus() == EventStatus.CONFIRMED) {
            Utils.broadcastEvent(this.listenerService, "exo.agenda.event.created", eventModifications, null);
        } else if (createdEvent.getStatus() == EventStatus.CANCELLED) {
            Utils.broadcastEvent(this.listenerService, "exo.agenda.event.deleted", eventModifications, null);
        }
        return createdEvent;
    }

    public Event saveEventExceptionalOccurrence(long eventId, ZonedDateTime occurrenceId) throws AgendaException {
        Event exceptionalOccurrenceEvent = this.getExceptionalOccurrenceEvent(eventId, occurrenceId);
        if (exceptionalOccurrenceEvent != null) {
            return exceptionalOccurrenceEvent;
        }
        List attendees = this.attendeeService.getEventAttendees(eventId).getEventAttendees(occurrenceId);
        this.cleanupAttendeeIds(attendees);
        List conferences = this.conferenceService.getEventConferences(eventId);
        this.cleanupConferenceIds(conferences);
        List reminders = this.reminderService.getEventReminders(eventId);
        this.cleanupReminderIds(reminders);
        return this.createEventExceptionalOccurrence(eventId, attendees, conferences, reminders, occurrenceId);
    }

    public Event createEventExceptionalOccurrence(long eventId, List<EventAttendee> attendees, List<EventConference> conferences, List<EventReminder> reminders, ZonedDateTime occurrenceId) throws AgendaException {
        return this.createEventExceptionalOccurrence(eventId, attendees, new ArrayList<GuestUser>(), conferences, reminders, occurrenceId);
    }

    public Event createEventExceptionalOccurrence(long eventId, List<EventAttendee> attendees, List<GuestUser> guestUsers, List<EventConference> conferences, List<EventReminder> reminders, ZonedDateTime occurrenceId) throws AgendaException {
        LocalDate overAllEndDate;
        Event parentEvent = this.agendaEventStorage.getEventById(eventId);
        if (parentEvent == null) {
            throw new AgendaException(AgendaExceptionType.EVENT_NOT_FOUND);
        }
        if (parentEvent.getRecurrence() == null) {
            throw new IllegalStateException("Event with id " + eventId + " isn't a recurrent event");
        }
        boolean allDay = parentEvent.isAllDay();
        occurrenceId = Utils.getOccurrenceId(allDay, occurrenceId, parentEvent.getTimeZoneId());
        LocalDate occurrenceDateUTC = occurrenceId.toLocalDate();
        LocalDate overallStartDate = parentEvent.getRecurrence().getOverallStart().withZoneSameInstant(ZoneOffset.UTC).toLocalDate();
        if (overallStartDate.minusDays(1L).isAfter(occurrenceDateUTC)) {
            throw new IllegalStateException("Event with id " + eventId + " doesn't have an occurrence with id " + occurrenceDateUTC + ". Recurrent Event overall start equals to " + overallStartDate);
        }
        ZonedDateTime overallEnd = parentEvent.getRecurrence().getOverallEnd();
        LocalDate localDate = overAllEndDate = overallEnd == null ? null : overallEnd.withZoneSameInstant(ZoneOffset.UTC).toLocalDate();
        if (overAllEndDate != null && overAllEndDate.isBefore(occurrenceDateUTC)) {
            throw new IllegalStateException("Event with id " + eventId + " doesn't have an occurrence with id " + occurrenceId);
        }
        Event exceptionalEvent = parentEvent.clone();
        exceptionalEvent.setId(0L);
        exceptionalEvent.setParentId(parentEvent.getId());
        exceptionalEvent.setRecurrence(null);
        exceptionalEvent.setOccurrence(new EventOccurrence(occurrenceId, true, false));
        ZonedDateTime start = exceptionalEvent.getStart();
        ZonedDateTime end = exceptionalEvent.getEnd();
        long diffInSeconds = end.toEpochSecond() - start.toEpochSecond();
        ZonedDateTime occurrenceStart = null;
        if (allDay) {
            ZonedDateTime occurrenceStartTime = occurrenceId.withZoneSameInstant(parentEvent.getTimeZoneId());
            occurrenceStart = start.withYear(occurrenceStartTime.getYear()).withMonth(occurrenceStartTime.getMonthValue()).withDayOfMonth(occurrenceStartTime.getDayOfMonth());
        } else {
            ZonedDateTime startStartTime = start.withZoneSameInstant(parentEvent.getTimeZoneId());
            occurrenceStart = startStartTime.withYear(occurrenceId.getYear()).withMonth(occurrenceId.getMonthValue()).withDayOfMonth(occurrenceId.getDayOfMonth()).withHour(startStartTime.getHour()).withMinute(startStartTime.getMinute());
        }
        ZonedDateTime occurrenceEnd = occurrenceStart.plusSeconds(diffInSeconds);
        exceptionalEvent.setStart(occurrenceStart);
        exceptionalEvent.setEnd(occurrenceEnd);
        this.adjustEventDatesForWrite(exceptionalEvent);
        exceptionalEvent = this.agendaEventStorage.createEvent(exceptionalEvent);
        long exceptionalEventId = exceptionalEvent.getId();
        if (conferences != null && !conferences.isEmpty()) {
            conferences.forEach(conference -> {
                conference.setId(0L);
                conference.setEventId(exceptionalEventId);
            });
            this.conferenceService.saveEventConferences(exceptionalEventId, conferences);
        }
        if (reminders != null && !reminders.isEmpty()) {
            reminders.forEach(reminder -> {
                reminder.setId(0L);
                reminder.setEventId(exceptionalEventId);
            });
            this.reminderService.saveEventReminders(exceptionalEvent, reminders);
        }
        if (attendees != null && !attendees.isEmpty()) {
            attendees.forEach(attendee -> {
                attendee.setId(0L);
                attendee.setEventId(exceptionalEventId);
            });
            this.attendeeService.saveEventAttendees(exceptionalEvent, attendees, guestUsers, conferences, 0L, false, exceptionalEvent.getStatus() != EventStatus.CONFIRMED, null);
        }
        return exceptionalEvent;
    }

    public Event updateEvent(Event event, List<EventAttendee> attendees, List<EventConference> conferences, List<EventReminder> reminders, List<EventDateOption> dateOptions, RemoteEvent remoteEvent, boolean sendInvitation, long userIdentityId) throws AgendaException, IllegalAccessException, ObjectNotFoundException {
        return this.updateEvent(event, attendees, new ArrayList<GuestUser>(), conferences, reminders, dateOptions, remoteEvent, sendInvitation, userIdentityId);
    }

    public Event updateEvent(Event event, List<EventAttendee> attendees, List<GuestUser> guestUsers, List<EventConference> conferences, List<EventReminder> reminders, List<EventDateOption> dateOptions, RemoteEvent remoteEvent, boolean sendInvitation, long userIdentityId) throws IllegalAccessException, ObjectNotFoundException, AgendaException {
        boolean allowAttendeeToUpdate;
        Identity userIdentity;
        EventRecurrence recurrence;
        if (userIdentityId <= 0L) {
            throw new IllegalArgumentException("userIdentityId is mandatory");
        }
        if (event == null) {
            throw new IllegalArgumentException("Event is null");
        }
        if (event.getId() <= 0L) {
            throw new IllegalArgumentException("Event id must not be null");
        }
        long calendarId = event.getCalendarId();
        if (calendarId <= 0L) {
            throw new IllegalArgumentException("Event calendar id must be positive");
        }
        if (dateOptions != null) {
            dateOptions = new ArrayList<EventDateOption>(dateOptions);
            this.checkAndComputeDateOptions(event, dateOptions);
        }
        if (event.getStart() == null) {
            throw new AgendaException(AgendaExceptionType.EVENT_START_DATE_MANDATORY);
        }
        if (event.getEnd() == null) {
            throw new AgendaException(AgendaExceptionType.EVENT_END_DATE_MANDATORY);
        }
        if (event.getStart().isAfter(event.getEnd())) {
            throw new AgendaException(AgendaExceptionType.EVENT_START_DATE_BEFORE_END_DATE);
        }
        if (event.getParentId() == event.getId()) {
            throw new AgendaException(AgendaExceptionType.EVENT_CYCLIC_DEPENDENCY);
        }
        if (event.getAvailability() == null) {
            event.setAvailability(EventAvailability.DEFAULT);
        }
        if (event.getStatus() == null) {
            event.setStatus(EventStatus.CONFIRMED);
        }
        if ((recurrence = event.getRecurrence()) != null) {
            if (recurrence.getFrequency() == null) {
                throw new AgendaException(AgendaExceptionType.EVENT_RECURRENCE_FREQUENCY_MANDATORY);
            }
            if (recurrence.getInterval() <= 0) {
                throw new AgendaException(AgendaExceptionType.EVENT_RECURRENCE_INTERVAL_MANDATORY);
            }
        }
        if ((userIdentity = this.identityManager.getIdentity(String.valueOf(userIdentityId))) == null) {
            throw new IllegalAccessException("User '" + userIdentityId + "' doesn't exist");
        }
        Calendar calendar = this.agendaCalendarService.getCalendarById(calendarId);
        if (calendar == null) {
            throw new AgendaException(AgendaExceptionType.CALENDAR_NOT_FOUND);
        }
        long eventId = event.getId();
        Event storedEvent = this.getEventById(eventId);
        if (storedEvent == null) {
            throw new AgendaException(AgendaExceptionType.EVENT_NOT_FOUND);
        }
        if (!this.canUpdateEvent(storedEvent, userIdentityId)) {
            throw new IllegalAccessException("User '" + userIdentityId + "' can't update event " + eventId);
        }
        EventOccurrence occurrence = event.getOccurrence();
        if (occurrence != null && occurrence.getId() != null) {
            event.setRecurrence(null);
        }
        this.adjustEventDatesForWrite(event);
        boolean bl = allowAttendeeToUpdate = storedEvent.getCreatorId() == userIdentityId ? event.isAllowAttendeeToUpdate() : storedEvent.isAllowAttendeeToUpdate();
        boolean allowAttendeeToInvite = allowAttendeeToUpdate || (storedEvent.getCreatorId() == userIdentityId ? event.isAllowAttendeeToInvite() : storedEvent.isAllowAttendeeToInvite());
        Event eventToUpdate = new Event(event.getId(), event.getParentId(), event.getCalendarId(), storedEvent.getCreatorId(), userIdentityId, storedEvent.getCreated(), ZonedDateTime.now(), event.getSummary(), event.getDescription(), event.getLocation(), event.getColor(), event.getTimeZoneId(), event.getStart(), event.getEnd(), event.isAllDay(), event.getAvailability(), event.getStatus(), event.getRecurrence(), event.getOccurrence(), null, allowAttendeeToUpdate, allowAttendeeToInvite);
        if (eventToUpdate.getRecurrence() != null || storedEvent.getRecurrence() != null) {
            this.agendaEventStorage.deleteExceptionalOccurences(eventToUpdate.getId());
        }
        AgendaEventModification eventModifications = new AgendaEventModification(eventId, event.getCalendarId(), userIdentityId);
        eventModifications.addModificationType(AgendaEventModificationType.UPDATED);
        Utils.detectEventModifiedFields(event, storedEvent, eventModifications);
        if (eventToUpdate.getOccurrence() != null && eventModifications.hasModifiedDate()) {
            eventToUpdate.getOccurrence().setDatesModified(true);
        }
        Event updatedEvent = this.agendaEventStorage.updateEvent(eventToUpdate);
        Set conferenceModifications = this.conferenceService.saveEventConferences(eventId, conferences);
        eventModifications.addModificationTypes(conferenceModifications);
        Set reminderModifications = this.reminderService.saveEventReminders(updatedEvent, reminders, userIdentityId);
        eventModifications.addModificationTypes(reminderModifications);
        this.remoteEventService.saveRemoteEvent(eventId, remoteEvent, userIdentityId);
        boolean resetResponses = (updatedEvent.getStatus() == EventStatus.TENTATIVE || storedEvent.getStatus() == EventStatus.TENTATIVE) && updatedEvent.getStatus() != storedEvent.getStatus();
        conferences = conferences == null ? new ArrayList() : conferences;
        Set attendeeModifications = this.attendeeService.saveEventAttendees(updatedEvent, attendees, guestUsers, conferences, userIdentityId, sendInvitation, resetResponses, eventModifications);
        eventModifications.addModificationTypes(attendeeModifications);
        if (eventModifications.hasModification(AgendaEventModificationType.START_DATE_UPDATED)) {
            List allReminders = this.reminderService.getEventReminders(eventId);
            this.reminderService.saveEventReminders(updatedEvent, allReminders);
        }
        if (dateOptions != null && !dateOptions.isEmpty()) {
            Set dateOptionModifications = this.datePollService.updateEventDateOptions(eventId, dateOptions);
            eventModifications.addModificationTypes(dateOptionModifications);
            eventModifications.removeModification(AgendaEventModificationType.START_DATE_UPDATED);
            eventModifications.removeModification(AgendaEventModificationType.END_DATE_UPDATED);
        }
        if (guestUsers != null && !guestUsers.isEmpty()) {
            this.agendaEventGuestService.saveEventGuests(eventId, guestUsers);
        } else {
            this.agendaEventGuestService.deleteEventGuests(eventId);
        }
        Utils.broadcastEvent(this.listenerService, "exo.agenda.event.updated", eventModifications, null);
        return updatedEvent;
    }

    public void updateEventFields(long eventId, Map<String, List<String>> fields, boolean updateAllOccurrences, boolean sendInvitations, long userIdentityId) throws IllegalAccessException, ObjectNotFoundException, AgendaException {
        if (userIdentityId <= 0L) {
            throw new IllegalArgumentException("userIdentityId is mandatory");
        }
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("fields is mandatory");
        }
        if (eventId <= 0L) {
            throw new IllegalArgumentException("Event id must not be null");
        }
        Event event = this.getEventById(eventId);
        if (event == null) {
            throw new AgendaException(AgendaExceptionType.EVENT_NOT_FOUND);
        }
        Event originalEvent = event.clone();
        Identity userIdentity = this.identityManager.getIdentity(String.valueOf(userIdentityId));
        if (userIdentity == null) {
            throw new IllegalAccessException("User '" + userIdentityId + "' doesn't exist");
        }
        if (!this.canUpdateEvent(event, userIdentityId)) {
            throw new IllegalAccessException("User '" + userIdentityId + "' can't update event " + eventId);
        }
        Set<Map.Entry<String, List<String>>> fieldsEntrySet = fields.entrySet();
        for (Map.Entry<String, List<String>> entry : fieldsEntrySet) {
            String fieldName = entry.getKey();
            String fieldValue = null;
            List<String> fieldValues = entry.getValue();
            if (fieldValues != null) {
                if (fieldValues.size() > 1) {
                    throw new AgendaException(AgendaExceptionType.EVENT_FIELD_VALUE_NOT_MULTIVALUED);
                }
                if (!fieldValues.isEmpty()) {
                    fieldValue = fieldValues.get(0);
                }
            }
            this.updateEventField(event, fieldName, fieldValue);
        }
        if (event.getStart().isAfter(event.getEnd())) {
            throw new AgendaException(AgendaExceptionType.EVENT_START_DATE_BEFORE_END_DATE);
        }
        if (updateAllOccurrences && event.getRecurrence() != null) {
            this.agendaEventStorage.deleteExceptionalOccurences(event.getId());
        }
        event.setModifierId(Long.parseLong(userIdentity.getId()));
        AgendaEventModification eventModifications = new AgendaEventModification(eventId, event.getCalendarId(), userIdentityId);
        eventModifications.addModificationType(AgendaEventModificationType.UPDATED);
        Utils.detectEventModifiedFields(event, originalEvent, eventModifications);
        if (event.getOccurrence() != null && eventModifications.hasModifiedDate()) {
            event.getOccurrence().setDatesModified(true);
        }
        event = this.agendaEventStorage.updateEvent(event);
        if (fields.containsKey("start")) {
            List reminders = this.reminderService.getEventReminders(event.getId());
            this.reminderService.saveEventReminders(event, reminders);
        }
        if (sendInvitations) {
            List eventAttendees = this.attendeeService.getEventAttendees(eventId).getEventAttendees();
            List guestUsers = this.agendaEventGuestService.getEventGuests(eventId);
            List conferences = this.conferenceService.getEventConferences(eventId);
            this.attendeeService.sendInvitations(event, eventAttendees, guestUsers, conferences, eventModifications);
        }
        Utils.broadcastEvent(this.listenerService, "exo.agenda.event.updated", eventModifications, null);
    }

    public Event deleteEventById(long eventId, long userIdentityId) throws IllegalAccessException, ObjectNotFoundException {
        if (userIdentityId <= 0L) {
            throw new IllegalArgumentException("userIdentityId is mandatory");
        }
        if (eventId <= 0L) {
            throw new IllegalArgumentException("eventId must be positive");
        }
        Event event = this.agendaEventStorage.getEventById(eventId);
        if (event == null) {
            throw new ObjectNotFoundException("Event with id " + eventId + " is not found");
        }
        if (!this.canUpdateEvent(event, userIdentityId)) {
            throw new IllegalAccessException("User " + userIdentityId + " hasn't enough privileges to delete event with id " + eventId);
        }
        EventAttendeeList eventAttendeeList = this.attendeeService.getEventAttendees(event.getId());
        List guestUsers = this.agendaEventGuestService.getEventGuests(eventId);
        List conferences = this.conferenceService.getEventConferences(eventId);
        this.agendaEventStorage.deleteEventById(eventId);
        event.setModifierId(userIdentityId);
        AgendaEventModification eventModifications = new AgendaEventModification(eventId, event.getCalendarId(), userIdentityId);
        eventModifications.addModificationType(AgendaEventModificationType.DELETED);
        this.attendeeService.sendInvitations(event, eventAttendeeList.getEventAttendees(), guestUsers, conferences, eventModifications);
        Utils.broadcastEvent(this.listenerService, "exo.agenda.event.deleted", eventModifications, null);
        return event;
    }

    public List<Event> getEvents(EventFilter eventFilter, ZoneId userTimeZone, long userIdentityId) throws IllegalAccessException {
        long attendeeId;
        if (eventFilter == null) {
            throw new IllegalArgumentException("eventFilter is mandatory");
        }
        Identity userIdentity = this.identityManager.getIdentity(String.valueOf(userIdentityId));
        if (userIdentity == null) {
            throw new IllegalAccessException("User with name " + userIdentityId + " doesn't exist");
        }
        List<Long> ownerIds = eventFilter.getOwnerIds();
        if (ownerIds != null) {
            for (Long ownerId : ownerIds) {
                if (Utils.canAccessCalendar(this.identityManager, this.spaceService, ownerId, userIdentityId)) continue;
                throw new IllegalAccessException("User '" + userIdentity.getId() + "' is not allowed to access calendar of identity '" + ownerIds + "'");
            }
        }
        if ((attendeeId = eventFilter.getAttendeeId()) > 0L) {
            if (!String.valueOf(attendeeId).contentEquals(userIdentity.getId())) {
                throw new IllegalAccessException("User '" + userIdentity.getId() + "' is not allowed to access calendar of identity '" + attendeeId + "'");
            }
            List<Long> attendeeSpaceIds = Utils.getCalendarOwnersOfUser(this.spaceService, this.identityManager, userIdentity);
            eventFilter.setAttendeeWithSpacesIds(attendeeSpaceIds);
        } else if (ownerIds == null) {
            ownerIds = Utils.getCalendarOwnersOfUser(this.spaceService, this.identityManager, userIdentity);
        }
        ZonedDateTime start = eventFilter.getStart();
        ZonedDateTime end = eventFilter.getEnd();
        ZonedDateTime startMinusADay = start.minusDays(1L);
        ZonedDateTime endPlusADay = end == null ? null : end.plusDays(1L);
        int limit = eventFilter.getLimit();
        if (limit > 0) {
            EventFilter maxEndDateFilter = eventFilter.clone();
            maxEndDateFilter.setOwnerIds(ownerIds);
            maxEndDateFilter.setStart(startMinusADay);
            maxEndDateFilter.setEnd(endPlusADay);
            ZonedDateTime maxEndDate = this.getMaxEndDate(maxEndDateFilter, userTimeZone);
            if (maxEndDate == null) {
                return Collections.emptyList();
            }
            endPlusADay = maxEndDate.plusDays(1L);
        }
        EventFilter requestEventFilter = eventFilter.clone();
        requestEventFilter.setOwnerIds(ownerIds);
        requestEventFilter.setStart(startMinusADay);
        requestEventFilter.setEnd(endPlusADay);
        List<Long> eventIds = this.agendaEventStorage.getEventIds(requestEventFilter);
        return this.computeEventsProperties(eventIds, start, end, userTimeZone, false, limit, userIdentity, startMinusADay, endPlusADay);
    }

    public List<Event> getParentRecurrentEvents(ZonedDateTime start, ZonedDateTime end, ZoneId timeZone) {
        List<Event> events = this.agendaEventStorage.getParentRecurrentEventIds(start, end);
        events.forEach(event -> this.adjustEventDatesForRead((Event)event, timeZone));
        return events;
    }

    public boolean canAccessEvent(Event event, long identityId) {
        long calendarId = event.getCalendarId();
        Calendar calendar = this.agendaCalendarService.getCalendarById(calendarId);
        if (calendar.isDeleted()) {
            return false;
        }
        Identity identity = this.identityManager.getIdentity(String.valueOf(identityId));
        if (identity == null) {
            return false;
        }
        if (StringUtils.equals((CharSequence)"organization", (CharSequence)identity.getProviderId())) {
            return Utils.canAccessCalendar(this.identityManager, this.spaceService, calendar.getOwnerId(), identityId) || this.attendeeService.isEventAttendee(this.getEventIdOrParentId(event), identityId);
        }
        return this.attendeeService.isEventAttendee(this.getEventIdOrParentId(event), identityId);
    }

    public boolean canUpdateEvent(Event event, long userIdentityId) {
        Calendar calendar = null;
        if (userIdentityId == event.getCreatorId()) {
            calendar = this.agendaCalendarService.getCalendarById(event.getCalendarId());
            if (calendar.isDeleted()) {
                return false;
            }
            if (Utils.canAccessCalendar(this.identityManager, this.spaceService, calendar.getOwnerId(), userIdentityId)) {
                return true;
            }
        }
        if (event.isAllowAttendeeToUpdate() && this.attendeeService.isEventAttendee(this.getEventIdOrParentId(event), userIdentityId)) {
            return true;
        }
        if (calendar == null && (calendar = this.agendaCalendarService.getCalendarById(event.getCalendarId())).isDeleted()) {
            return false;
        }
        return Utils.canEditCalendar(this.identityManager, this.spaceService, calendar.getOwnerId(), userIdentityId);
    }

    public boolean canCreateEvent(Calendar calendar, long userIdentityId) {
        return Utils.canCreateEvent(this.identityManager, this.spaceService, calendar.getOwnerId(), userIdentityId);
    }

    public List<EventSearchResult> search(long userIdentityId, ZoneId userTimeZone, String query, int offset, int limit) {
        if (userTimeZone == null) {
            userTimeZone = ZoneOffset.UTC;
        }
        List<EventSearchResult> searchResults = this.agendaSearchConnector.search(userIdentityId, userTimeZone, query, offset, limit);
        ZoneId timeZone = userTimeZone;
        return searchResults.stream().map(event -> {
            if (event.isRecurrent()) {
                ZonedDateTime today;
                Event recurrentEvent = this.agendaEventStorage.getEventById(event.getId());
                List<Event> occurrences = this.getEventOccurrencesInPeriod(recurrentEvent, today = ZonedDateTime.now().toLocalDate().atStartOfDay(timeZone), null, timeZone, 10);
                if (occurrences == null || occurrences.isEmpty()) {
                    occurrences = this.getEventOccurrencesInPeriod(recurrentEvent, recurrentEvent.getStart(), today, timeZone, 10);
                    Collections.reverse(occurrences);
                }
                if (occurrences != null && !occurrences.isEmpty()) {
                    Event occurrenceEvent = occurrences.get(0);
                    if (occurrenceEvent.getOccurrence().isExceptional()) {
                        event.setSummary(occurrenceEvent.getSummary());
                        event.setDescription(occurrenceEvent.getDescription());
                        event.setLocation(occurrenceEvent.getLocation());
                    }
                    event.setStart(occurrenceEvent.getStart());
                    event.setEnd(occurrenceEvent.getEnd());
                }
            }
            return event;
        }).collect(Collectors.toList());
    }

    public List<Event> getEventOccurrencesInPeriod(Event recurrentEvent, ZonedDateTime start, ZonedDateTime end, ZoneId timezone, int limit) {
        LocalDate endDate;
        if (recurrentEvent == null) {
            throw new IllegalArgumentException("recurrentEvent is mandatory");
        }
        if (start == null) {
            throw new IllegalArgumentException("start is mandatory");
        }
        if (timezone == null) {
            throw new IllegalArgumentException("timezone is mandatory");
        }
        if (end == null && limit == 0) {
            throw new IllegalArgumentException("whether use end or limit");
        }
        LocalDate startDate = start.withZoneSameInstant(timezone).toLocalDate();
        List<Event> occurrences = Utils.getOccurrences(recurrentEvent, startDate, endDate = end == null ? null : end.withZoneSameInstant(timezone).toLocalDate(), limit);
        if (!occurrences.isEmpty()) {
            ZonedDateTime endDateOfOccurrences;
            ZonedDateTime zonedDateTime = endDateOfOccurrences = endDate == null ? null : endDate.atStartOfDay(ZoneOffset.UTC);
            if (endDateOfOccurrences == null) {
                Event eventWithMaxDate = occurrences.stream().max((event1, event2) -> event1.getEnd().compareTo(event2.getEnd())).orElse(null);
                endDateOfOccurrences = eventWithMaxDate.getEnd();
                endDateOfOccurrences = endDateOfOccurrences.withZoneSameInstant(timezone).toLocalDate().atStartOfDay(ZoneOffset.UTC).plusDays(1L);
            }
            ZonedDateTime startOfDay = startDate.atStartOfDay(ZoneOffset.UTC);
            ZonedDateTime endOfDay = endDateOfOccurrences;
            occurrences = this.filterExceptionalEvents(recurrentEvent, occurrences, startOfDay, endOfDay.plusDays(1L));
        }
        occurrences.forEach(occurrence -> this.adjustEventDatesForRead((Event)occurrence, timezone));
        return limit > 0 && occurrences.size() > limit ? occurrences.subList(0, limit) : occurrences;
    }

    public void selectEventDateOption(long eventId, long dateOptionId, long userIdentityId) throws ObjectNotFoundException, IllegalAccessException {
        Event event = this.agendaEventStorage.getEventById(eventId);
        if (event == null) {
            throw new ObjectNotFoundException("Event with id " + eventId + " not found");
        }
        if (event.getStatus() != EventStatus.TENTATIVE) {
            throw new IllegalStateException("Event with id " + eventId + " has a different event status than 'TENTATIVE': " + event.getStatus());
        }
        if (!this.canUpdateEvent(event, userIdentityId)) {
            throw new IllegalAccessException("User " + userIdentityId + " can't update event with id " + eventId);
        }
        EventDateOption dateOption = this.datePollService.getEventDateOption(dateOptionId, (ZoneId)ZoneOffset.UTC);
        if (dateOption == null) {
            throw new ObjectNotFoundException("Event Date Option with id " + dateOptionId + " not found");
        }
        if (dateOption.getEventId() != eventId) {
            throw new IllegalStateException("Event Date Option with id " + dateOptionId + " has different event id than " + eventId);
        }
        event.setStart(dateOption.getStart());
        event.setEnd(dateOption.getEnd());
        event.setAllDay(dateOption.isAllDay());
        event.setStatus(EventStatus.CONFIRMED);
        event.setModifierId(userIdentityId);
        Event updatedEvent = this.agendaEventStorage.updateEvent(event);
        List allReminders = this.reminderService.getEventReminders(eventId);
        this.reminderService.saveEventReminders(updatedEvent, allReminders);
        EventAttendeeList eventAttendeeList = this.attendeeService.getEventAttendees(eventId);
        List eventAttendees = eventAttendeeList.getEventAttendees();
        for (EventAttendee eventAttendee : eventAttendees) {
            if (eventAttendee.getIdentityId() == userIdentityId) continue;
            this.attendeeService.sendEventResponse(eventId, eventAttendee.getIdentityId(), EventAttendeeResponse.NEEDS_ACTION);
        }
        this.attendeeService.sendEventResponse(eventId, userIdentityId, EventAttendeeResponse.ACCEPTED);
        this.datePollService.selectEventDateOption(dateOptionId);
        List guestUsers = this.agendaEventGuestService.getEventGuests(eventId);
        HashSet<AgendaEventModificationType> modificationTypes = new HashSet<AgendaEventModificationType>();
        modificationTypes.add(AgendaEventModificationType.UPDATED);
        modificationTypes.add(AgendaEventModificationType.DATE_OPTION_SELECTED);
        modificationTypes.add(AgendaEventModificationType.SWITCHED_DATE_POLL_TO_EVENT);
        AgendaEventModification eventModifications = new AgendaEventModification(eventId, event.getCalendarId(), userIdentityId, modificationTypes);
        List conferences = this.conferenceService.getEventConferences(eventId);
        this.attendeeService.sendInvitations(event, eventAttendees, guestUsers, conferences, eventModifications);
        Utils.broadcastEvent(this.listenerService, "exo.agenda.event.updated", eventModifications, null);
    }

    public List<Event> getPendingEvents(List<Long> ownerIds, long userIdentityId, ZoneId userTimeZone, int offset, int limit) throws IllegalAccessException {
        Identity userIdentity = this.identityManager.getIdentity(String.valueOf(userIdentityId));
        if (userIdentity == null) {
            throw new IllegalStateException("User with identity id " + userIdentityId + " doesn't exist");
        }
        if (ownerIds != null) {
            for (Long ownerId : ownerIds) {
                if (Utils.canAccessCalendar(this.identityManager, this.spaceService, ownerId, userIdentityId)) continue;
                throw new IllegalAccessException("User '" + userIdentity.getId() + "' is not allowed to access calendar of identity '" + ownerIds + "'");
            }
        }
        List<Long> attendeeIds = Utils.getCalendarOwnersOfUser(this.spaceService, this.identityManager, userIdentity);
        List<Long> eventIds = this.agendaEventStorage.getPendingEventIds(userIdentityId, ownerIds, attendeeIds, offset, limit);
        return this.computeEventsProperties(eventIds, null, null, userTimeZone, true, limit, userIdentity, null, null);
    }

    public long countPendingEvents(List<Long> ownerIds, long userIdentityId) throws IllegalAccessException {
        Identity userIdentity = this.identityManager.getIdentity(String.valueOf(userIdentityId));
        if (userIdentity == null) {
            throw new IllegalStateException("User with identity id " + userIdentityId + " doesn't exist");
        }
        if (ownerIds != null) {
            for (Long ownerId : ownerIds) {
                if (Utils.canAccessCalendar(this.identityManager, this.spaceService, ownerId, userIdentityId)) continue;
                throw new IllegalAccessException("User '" + userIdentity.getId() + "' is not allowed to access calendar of identity '" + ownerIds + "'");
            }
        }
        List<Long> attendeeIds = Utils.getCalendarOwnersOfUser(this.spaceService, this.identityManager, userIdentity);
        return this.agendaEventStorage.countPendingEvents(userIdentityId, ownerIds, attendeeIds);
    }

    public List<Event> getEventDatePolls(EventFilter eventFilter, ZoneId userTimeZone, long userIdentityId) throws IllegalAccessException {
        Identity userIdentity = this.identityManager.getIdentity(String.valueOf(userIdentityId));
        if (userIdentity == null) {
            throw new IllegalStateException("User with identity id " + userIdentityId + " doesn't exist");
        }
        List ownerIds = eventFilter.getOwnerIds();
        if (ownerIds != null) {
            for (Long ownerId : ownerIds) {
                if (Utils.canAccessCalendar(this.identityManager, this.spaceService, ownerId, userIdentityId)) continue;
                throw new IllegalAccessException("User '" + userIdentity.getId() + "' is not allowed to access calendar of identity '" + ownerIds + "'");
            }
        }
        List<Long> attendeeIds = Utils.getCalendarOwnersOfUser(this.spaceService, this.identityManager, userIdentity);
        List<Long> eventIds = null;
        eventIds = eventFilter.isUseDates() ? this.agendaEventStorage.getEventDatePollIds(userIdentityId, (List<Long>)ownerIds, attendeeIds, eventFilter.getStart(), eventFilter.getEnd()) : this.agendaEventStorage.getEventDatePollIds((Long)userIdentityId, (List<Long>)ownerIds, attendeeIds, eventFilter.getOffset(), eventFilter.getLimit());
        return this.computeEventsProperties(eventIds, null, null, userTimeZone, true, eventFilter.getLimit(), userIdentity, null, null);
    }

    public long countEventDatePolls(List<Long> ownerIds, long userIdentityId) throws IllegalAccessException {
        Identity userIdentity = this.identityManager.getIdentity(String.valueOf(userIdentityId));
        if (userIdentity == null) {
            throw new IllegalStateException("User with identity id " + userIdentityId + " doesn't exist");
        }
        if (ownerIds != null) {
            for (Long ownerId : ownerIds) {
                if (Utils.canAccessCalendar(this.identityManager, this.spaceService, ownerId, userIdentityId)) continue;
                throw new IllegalAccessException("User '" + userIdentity.getId() + "' is not allowed to access calendar of identity '" + ownerIds + "'");
            }
        }
        List<Long> attendeeIds = Utils.getCalendarOwnersOfUser(this.spaceService, this.identityManager, userIdentity);
        return this.agendaEventStorage.countEventDatePolls(ownerIds, attendeeIds);
    }

    private void checkAndComputeDateOptions(Event event, List<EventDateOption> dateOptions) throws AgendaException {
        if (dateOptions != null && dateOptions.size() == 1) {
            EventDateOption eventDateOption = dateOptions.get(0);
            event.setStart(eventDateOption.getStart());
            event.setEnd(eventDateOption.getEnd());
            event.setAllDay(eventDateOption.isAllDay());
            dateOptions.clear();
        }
        if (dateOptions == null || dateOptions.isEmpty()) {
            if (event.getStart() == null) {
                throw new AgendaException(AgendaExceptionType.EVENT_START_DATE_MANDATORY);
            }
            if (event.getEnd() == null) {
                throw new AgendaException(AgendaExceptionType.EVENT_END_DATE_MANDATORY);
            }
            if (event.getStart().isAfter(event.getEnd())) {
                throw new AgendaException(AgendaExceptionType.EVENT_START_DATE_BEFORE_END_DATE);
            }
            if (event.getStatus() == null || event.getStatus() == EventStatus.TENTATIVE) {
                event.setStatus(EventStatus.CONFIRMED);
            }
        } else {
            event.setStart(this.getMinOptionStartDate(dateOptions));
            event.setEnd(this.getMaxOptionEndDate(dateOptions));
            event.setStatus(EventStatus.TENTATIVE);
            for (EventDateOption dateOption : dateOptions) {
                if (dateOption.getStart() == null) {
                    throw new AgendaException(AgendaExceptionType.EVENT_DATE_OPTION_START_DATE_MANDATORY);
                }
                if (dateOption.getEnd() == null) {
                    throw new AgendaException(AgendaExceptionType.EVENT_DATE_OPTION_END_DATE_MANDATORY);
                }
                if (!dateOption.getStart().isAfter(dateOption.getEnd())) continue;
                throw new AgendaException(AgendaExceptionType.EVENT_DATE_OPTION_START_DATE_BEFORE_END_DATE);
            }
        }
    }

    private ZonedDateTime getMaxEndDate(EventFilter eventFilter, ZoneId userTimeZone) {
        List<Long> eventIds;
        int initialSize = 0;
        int storageLimit = eventFilter.getLimit();
        List<Event> events = null;
        do {
            initialSize = events == null ? 0 : events.size();
        } while ((events = this.getEventsList(eventIds = this.agendaEventStorage.getEventIds(eventFilter), eventFilter.getStart(), eventFilter.getEnd(), userTimeZone, false, storageLimit *= 5)).size() > initialSize && events.size() < eventFilter.getLimit());
        return this.getMaxEndDate(events);
    }

    private ZonedDateTime getMaxEndDate(List<Event> events) {
        Event eventWithMaxDate;
        if (events != null && !events.isEmpty() && (eventWithMaxDate = (Event)events.stream().max((event1, event2) -> event1.getEnd().compareTo(event2.getEnd())).orElse(null)) != null) {
            return eventWithMaxDate.getEnd();
        }
        return null;
    }

    private List<Event> getEventsList(List<Long> eventIds, ZonedDateTime startMinusADay, ZonedDateTime endPlusADay, ZoneId timeZone, boolean ignoreComputeOccurrences, int limit) {
        List<Event> events = eventIds.stream().map(this::getEventById).collect(Collectors.toList());
        events.forEach(event -> {
            if (event.getRecurrence() == null || event.getTimeZoneId() == null) {
                this.adjustEventDatesForRead((Event)event, timeZone);
            } else {
                this.adjustEventDatesForRead((Event)event, event.getTimeZoneId());
            }
        });
        return this.computeRecurrentEvents(events, startMinusADay, endPlusADay, timeZone, ignoreComputeOccurrences, limit);
    }

    private List<Event> computeEventsProperties(List<Long> eventIds, ZonedDateTime start, ZonedDateTime end, ZoneId timeZone, boolean ignoreComputeOccurrences, int limit, Identity userIdentity, ZonedDateTime startMinusADay, ZonedDateTime endPlusADay) {
        if (eventIds == null || eventIds.isEmpty()) {
            return Collections.emptyList();
        }
        List<Event> events = this.getEventsList(eventIds, startMinusADay, endPlusADay, timeZone, ignoreComputeOccurrences, limit);
        if (start != null && (end != null || limit > 0)) {
            events = this.filterEvents(events, start, end, limit);
        }
        this.computeEventsAcl(events, userIdentity);
        return events;
    }

    private void computeEventsAcl(List<Event> events, Identity userIdentity) {
        long userIdentityId = Long.parseLong(userIdentity.getId());
        HashMap eventPermissionsMap = new HashMap();
        events.forEach(event -> {
            long eventId = this.getEventIdOrParentId((Event)event);
            EventPermission permission = (EventPermission)eventPermissionsMap.get(eventId);
            if (permission == null) {
                boolean canUpdateEvent = this.canUpdateEvent((Event)event, userIdentityId);
                boolean isEventAttendee = this.attendeeService.isEventAttendee(eventId, userIdentityId);
                permission = new EventPermission(canUpdateEvent, isEventAttendee);
                eventPermissionsMap.put(eventId, permission);
            }
            event.setAcl(permission);
        });
    }

    private List<Event> filterEvents(List<Event> events, ZonedDateTime start, ZonedDateTime end, int limit) {
        events = events.stream().filter(event -> {
            if ((end == null || event.getStart().isBefore(end)) && (event.getEnd() == null || event.getEnd().isAfter(start))) {
                Calendar calendar = this.agendaCalendarService.getCalendarById(event.getCalendarId());
                return calendar != null && !calendar.isDeleted();
            }
            return false;
        }).collect(Collectors.toList());
        this.sortEvents(events);
        if (limit > 0 && events.size() > limit) {
            events = events.subList(0, limit);
        }
        return events;
    }

    private void updateEventField(Event event, String fieldName, String fieldValue) throws AgendaException {
        switch (fieldName) {
            case "calendarId": {
                long calendarId = Long.parseLong(fieldValue);
                if (calendarId <= 0L) {
                    throw new IllegalArgumentException("Event calendar id must be positive");
                }
                Calendar calendar = this.agendaCalendarService.getCalendarById(calendarId);
                if (calendar == null) {
                    throw new IllegalArgumentException("Event calendar with id " + calendarId + " wasn't found");
                }
                event.setCalendarId(calendarId);
                break;
            }
            case "summary": {
                event.setSummary(fieldValue);
                break;
            }
            case "description": {
                event.setDescription(fieldValue);
                break;
            }
            case "location": {
                event.setLocation(fieldValue);
                break;
            }
            case "color": {
                event.setColor(fieldValue);
                break;
            }
            case "timeZoneId": {
                if (StringUtils.isBlank((CharSequence)fieldValue)) {
                    throw new IllegalArgumentException("Event timeZoneId is mandatory");
                }
                event.setTimeZoneId(ZoneId.of(fieldValue));
                break;
            }
            case "start": {
                if (StringUtils.isBlank((CharSequence)fieldValue)) {
                    throw new AgendaException(AgendaExceptionType.EVENT_START_DATE_MANDATORY);
                }
                ZonedDateTime startDate = event.isAllDay() ? AgendaDateUtils.parseAllDayDateToZonedDateTime(fieldValue) : AgendaDateUtils.parseRFC3339ToZonedDateTime(fieldValue, event.getTimeZoneId(), false);
                event.setStart(startDate);
                break;
            }
            case "end": {
                if (StringUtils.isBlank((CharSequence)fieldValue)) {
                    throw new AgendaException(AgendaExceptionType.EVENT_END_DATE_MANDATORY);
                }
                ZonedDateTime endDate = event.isAllDay() ? AgendaDateUtils.parseAllDayDateToZonedDateTime(fieldValue) : AgendaDateUtils.parseRFC3339ToZonedDateTime(fieldValue, event.getTimeZoneId(), false);
                event.setEnd(endDate);
                break;
            }
            case "allDay": {
                boolean allDay = Boolean.parseBoolean(fieldValue);
                event.setAllDay(allDay);
                break;
            }
            case "availability": {
                if (StringUtils.isBlank((CharSequence)fieldValue)) {
                    event.setAvailability(EventAvailability.DEFAULT);
                    break;
                }
                event.setAvailability(EventAvailability.valueOf((String)fieldValue.toUpperCase()));
                break;
            }
            case "status": {
                if (StringUtils.isBlank((CharSequence)fieldValue)) {
                    event.setStatus(EventStatus.CONFIRMED);
                    break;
                }
                event.setStatus(EventStatus.valueOf((String)fieldValue.toUpperCase()));
                break;
            }
            case "allowAttendeeToUpdate": {
                event.setAllowAttendeeToUpdate(Boolean.parseBoolean(fieldValue));
                break;
            }
            case "allowAttendeeToInvite": {
                event.setAllowAttendeeToInvite(Boolean.parseBoolean(fieldValue));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void adjustEventDatesForRead(Event event, ZoneId timeZone) {
        EventRecurrence recurrence;
        ZonedDateTime start = event.getStart();
        ZonedDateTime end = event.getEnd();
        ZoneId eventTimeZoneId = event.getTimeZoneId();
        if (timeZone == null) {
            timeZone = eventTimeZoneId == null ? ZoneOffset.UTC : eventTimeZoneId;
        }
        if (start != null && end != null) {
            if (event.isAllDay()) {
                start = start.withZoneSameLocal(ZoneOffset.UTC).toLocalDate().atStartOfDay(timeZone);
                end = end.withZoneSameLocal(ZoneOffset.UTC).toLocalDate().atStartOfDay(timeZone).plusDays(1L).minusSeconds(1L);
            } else {
                start = start.withZoneSameInstant(timeZone);
                end = end.withZoneSameInstant(timeZone);
            }
            event.setStart(start);
            event.setEnd(end);
        }
        if (event.getStatus() == EventStatus.CONFIRMED && (recurrence = event.getRecurrence()) != null) {
            if (recurrence.getUntil() != null) {
                LocalDate recurrenceUntil = recurrence.getUntil();
                recurrenceUntil = LocalDate.of(recurrenceUntil.getYear(), recurrenceUntil.getMonthValue(), recurrenceUntil.getDayOfMonth());
                recurrence.setUntil(recurrenceUntil);
            }
            ZonedDateTime overallStart = recurrence.getOverallStart();
            ZonedDateTime overallEnd = recurrence.getOverallEnd();
            if (event.isAllDay()) {
                overallStart = overallStart.withZoneSameInstant(eventTimeZoneId).toLocalDate().atStartOfDay(timeZone);
                overallEnd = overallEnd == null ? null : overallEnd.withZoneSameInstant(eventTimeZoneId).toLocalDate().atStartOfDay(timeZone).plusDays(1L).minusSeconds(1L);
            } else {
                overallStart = overallStart.withZoneSameInstant(timeZone);
                overallEnd = overallEnd == null ? null : overallEnd.withZoneSameInstant(timeZone);
            }
            recurrence.setOverallStart(overallStart);
            recurrence.setOverallEnd(overallEnd);
        }
    }

    private void adjustEventDatesForWrite(Event event) {
        ZonedDateTime start = event.getStart();
        ZonedDateTime end = event.getEnd();
        if (start != null && end != null) {
            if (event.isAllDay()) {
                start = start.toLocalDate().atStartOfDay(ZoneOffset.UTC);
                end = end.toLocalDate().atStartOfDay(ZoneOffset.UTC).plusDays(1L).minusSeconds(1L);
            } else {
                start = start.withZoneSameInstant(ZoneOffset.UTC);
                end = end.withZoneSameInstant(ZoneOffset.UTC);
            }
            event.setStart(start);
            event.setEnd(end);
        }
    }

    private List<Event> computeRecurrentEvents(List<Event> events, ZonedDateTime start, ZonedDateTime end, ZoneId userTimezone, boolean ignoreComputeOccurrences, int limit) {
        ArrayList<Event> computedEvents = new ArrayList<Event>();
        for (Event event : events) {
            List<Event> occurrences;
            if (ignoreComputeOccurrences || event.getRecurrence() == null || event.getStatus() != EventStatus.CONFIRMED) {
                computedEvents.add(event);
                continue;
            }
            if (userTimezone == null) {
                userTimezone = ZoneOffset.UTC;
            }
            if ((occurrences = this.getEventOccurrencesInPeriod(event, start, end, userTimezone, limit)) == null || occurrences.isEmpty()) continue;
            computedEvents.addAll(occurrences);
        }
        return computedEvents;
    }

    private void sortEvents(List<Event> computedEvents) {
        computedEvents.sort((event1, event2) -> ObjectUtils.compare((Comparable)event1.getStart(), (Comparable)event2.getStart()));
    }

    private List<Event> filterExceptionalEvents(Event recurrentEvent, List<Event> occurrences, ZonedDateTime start, ZonedDateTime end) {
        List<Long> exceptionalOccurenceEventIds = this.agendaEventStorage.getExceptionalOccurenceIdsByPeriod(recurrentEvent.getId(), start, end);
        List exceptionalEvents = exceptionalOccurenceEventIds == null || exceptionalOccurenceEventIds.isEmpty() ? Collections.emptyList() : exceptionalOccurenceEventIds.stream().map(this::getEventById).collect(Collectors.toList());
        return occurrences.stream().filter(occurrence -> {
            ZonedDateTime occurrenceId = occurrence.getOccurrence().getId();
            LocalDate occurrenceDate = occurrenceId.withZoneSameInstant(ZoneOffset.UTC).toLocalDate();
            return exceptionalEvents.stream().noneMatch(exceptionalOccurence -> {
                ZonedDateTime exceptionalOccurenceId = exceptionalOccurence.getOccurrence().getId();
                LocalDate exceptionalOccurenceDate = exceptionalOccurenceId.withZoneSameInstant(ZoneOffset.UTC).toLocalDate();
                return occurrenceDate.isEqual(exceptionalOccurenceDate) || Math.abs(exceptionalOccurenceId.toEpochSecond() - occurrenceId.toEpochSecond()) < 43200L;
            });
        }).collect(Collectors.toList());
    }

    private long getEventIdOrParentId(Event event) {
        if (event != null) {
            if (event.getId() > 0L) {
                return event.getId();
            }
            if (event.getParentId() > 0L) {
                return event.getParentId();
            }
        }
        return 0L;
    }

    private List<EventAttendee> cleanupAttendeeIds(List<EventAttendee> attendees) {
        if (attendees != null && !attendees.isEmpty()) {
            return attendees.stream().map(attendee -> {
                attendee = attendee.clone();
                attendee.setId(0L);
                return attendee;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<EventConference> cleanupConferenceIds(List<EventConference> conferences) {
        if (conferences != null && !conferences.isEmpty()) {
            return conferences.stream().map(conference -> {
                conference = conference.clone();
                conference.setId(0L);
                return conference;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<EventReminder> cleanupReminderIds(List<EventReminder> reminders) {
        if (reminders != null && !reminders.isEmpty()) {
            return reminders.stream().map(reminder -> {
                reminder = reminder.clone();
                reminder.setId(0L);
                return reminder;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private ZonedDateTime getMinOptionStartDate(List<EventDateOption> dateOptions) {
        return dateOptions.stream().min((option1, option2) -> ObjectUtils.compare((Comparable)option1.getStart(), (Comparable)option2.getStart())).map(EventDateOption::getStart).orElse(null);
    }

    private ZonedDateTime getMaxOptionEndDate(List<EventDateOption> dateOptions) {
        return dateOptions.stream().max((option1, option2) -> ObjectUtils.compare((Comparable)option1.getEnd(), (Comparable)option2.getEnd())).map(EventDateOption::getEnd).orElse(null);
    }
}

