/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service;

import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.agenda.entity.RemoteEventEntity;
import org.exoplatform.agenda.model.RemoteEvent;
import org.exoplatform.agenda.model.RemoteProvider;
import org.exoplatform.agenda.plugin.RemoteProviderDefinitionPlugin;
import org.exoplatform.agenda.service.AgendaRemoteEventService;
import org.exoplatform.agenda.storage.AgendaRemoteEventStorage;
import org.exoplatform.agenda.util.EntityMapper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class AgendaRemoteEventServiceImpl
implements AgendaRemoteEventService {
    private static final Log LOG = ExoLogger.getLogger(AgendaRemoteEventServiceImpl.class);
    private PortalContainer portalContainer;
    private AgendaRemoteEventStorage remoteEventStorage;

    public AgendaRemoteEventServiceImpl(PortalContainer container, AgendaRemoteEventStorage agendaRemoteEventStorage) {
        this.portalContainer = container;
        this.remoteEventStorage = agendaRemoteEventStorage;
    }

    public void addRemoteProvider(final RemoteProviderDefinitionPlugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("plugin is mandatory");
        }
        PortalContainer.addInitTask((ServletContext)this.portalContainer.getPortalContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostCreateTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(ServletContext context, PortalContainer portalContainer) {
                ExoContainerContext.setCurrentContainer((ExoContainer)portalContainer);
                RequestLifeCycle.begin((ExoContainer)portalContainer);
                try {
                    AgendaRemoteEventServiceImpl.this.saveRemoteProviderPlugin(plugin);
                }
                catch (Exception e) {
                    LOG.warn("Error saving remote provider: {}", new Object[]{plugin.getConnectorName(), e});
                }
                finally {
                    RequestLifeCycle.end();
                }
            }
        });
    }

    public List<RemoteProvider> getRemoteProviders() {
        return this.remoteEventStorage.getRemoteProviders();
    }

    public RemoteProvider saveRemoteProvider(RemoteProvider remoteProvider) {
        if (remoteProvider.isEnabled() && StringUtils.isBlank((CharSequence)remoteProvider.getApiKey()) && Boolean.TRUE.equals(remoteProvider.getOauth())) {
            LOG.info("Turning off Agenda remote provider '{}' because no API Key is provided yet", new Object[]{remoteProvider.getName()});
            remoteProvider.setEnabled(false);
        }
        return this.remoteEventStorage.saveRemoteProvider(remoteProvider);
    }

    public RemoteProvider saveRemoteProviderStatus(String remoteProviderName, boolean enabled, boolean isOauth) {
        if (StringUtils.isBlank((CharSequence)remoteProviderName)) {
            throw new IllegalStateException("remoteProviderName is mandatory");
        }
        RemoteProvider remoteProvider = this.remoteEventStorage.getRemoteProviderByName(remoteProviderName);
        if (remoteProvider == null) {
            throw new IllegalStateException("Remote provider not found with name " + remoteProviderName);
        }
        if (enabled && StringUtils.isBlank((CharSequence)remoteProvider.getApiKey()) && isOauth) {
            throw new IllegalStateException("Can't enable connector " + remoteProviderName + " since it doesn't have an API Key");
        }
        remoteProvider.setEnabled(enabled);
        return this.remoteEventStorage.saveRemoteProvider(remoteProvider);
    }

    public RemoteProvider saveRemoteProviderApiKey(String remoteProviderName, String apiKey) {
        if (StringUtils.isBlank((CharSequence)remoteProviderName)) {
            throw new IllegalStateException("remoteProviderName is mandatory");
        }
        RemoteProvider remoteProvider = this.remoteEventStorage.getRemoteProviderByName(remoteProviderName);
        if (remoteProvider == null) {
            throw new IllegalStateException("Remote provider not found with name " + remoteProviderName);
        }
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            remoteProvider.setEnabled(false);
        }
        remoteProvider.setApiKey(apiKey);
        return this.remoteEventStorage.saveRemoteProvider(remoteProvider);
    }

    public RemoteEvent saveRemoteEvent(RemoteEvent remoteEvent) {
        return this.remoteEventStorage.saveRemoteEvent(remoteEvent);
    }

    public RemoteEvent saveRemoteEvent(long eventId, RemoteEvent remoteEvent, long userIdentityId) {
        if (eventId <= 0L) {
            throw new IllegalArgumentException("eventId is mandatory");
        }
        if (userIdentityId <= 0L) {
            throw new IllegalArgumentException("userIdentityId is mandatory");
        }
        if (remoteEvent == null || StringUtils.isBlank((CharSequence)remoteEvent.getRemoteId()) || remoteEvent.getRemoteProviderId() <= 0L && StringUtils.isBlank((CharSequence)remoteEvent.getRemoteProviderName())) {
            RemoteEventEntity deletedRemoteEvent = this.remoteEventStorage.deleteRemoteEvent(eventId, userIdentityId);
            return deletedRemoteEvent == null ? null : EntityMapper.fromEntity(deletedRemoteEvent, null);
        }
        remoteEvent.setIdentityId(userIdentityId);
        remoteEvent.setEventId(eventId);
        return this.saveRemoteEvent(remoteEvent);
    }

    public RemoteEvent findRemoteEvent(long eventId, long userIdentityId) {
        return this.remoteEventStorage.findRemoteEvent(eventId, userIdentityId);
    }

    public RemoteProvider saveRemoteProviderPlugin(RemoteProviderDefinitionPlugin plugin) {
        RemoteProvider remoteProvider = this.remoteEventStorage.getRemoteProviderByName(plugin.getConnectorName());
        if (remoteProvider == null) {
            remoteProvider = new RemoteProvider(0L, plugin.getConnectorName(), plugin.getConnectorAPIKey(), plugin.isEnabled(), Boolean.valueOf(plugin.isConnectorOauth()));
            remoteProvider = this.saveRemoteProvider(remoteProvider);
        } else if (StringUtils.isBlank((CharSequence)remoteProvider.getApiKey()) && plugin.isConnectorOauth()) {
            if (StringUtils.isBlank((CharSequence)plugin.getConnectorAPIKey())) {
                LOG.warn("Agenda connector {} has an empty API key, thus the connector will be disabled", new Object[]{plugin.getConnectorName()});
                remoteProvider.setEnabled(false);
            } else {
                remoteProvider.setApiKey(plugin.getConnectorAPIKey());
            }
            remoteProvider = this.saveRemoteProvider(remoteProvider);
        }
        return remoteProvider;
    }
}

