/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.math.RandomUtils;
import org.exoplatform.agenda.constant.EventAvailability;
import org.exoplatform.agenda.constant.EventRecurrenceFrequency;
import org.exoplatform.agenda.constant.EventRecurrenceType;
import org.exoplatform.agenda.constant.EventStatus;
import org.exoplatform.agenda.constant.ReminderPeriodType;
import org.exoplatform.agenda.model.AgendaEventModification;
import org.exoplatform.agenda.model.Calendar;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.model.EventConference;
import org.exoplatform.agenda.model.EventOccurrence;
import org.exoplatform.agenda.model.EventRecurrence;
import org.exoplatform.agenda.model.EventReminder;
import org.exoplatform.agenda.model.RemoteEvent;
import org.exoplatform.agenda.model.RemoteProvider;
import org.exoplatform.agenda.service.AgendaCalendarService;
import org.exoplatform.agenda.service.AgendaEventAttendeeService;
import org.exoplatform.agenda.service.AgendaEventConferenceService;
import org.exoplatform.agenda.service.AgendaEventDatePollService;
import org.exoplatform.agenda.service.AgendaEventReminderService;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.agenda.service.AgendaRemoteEventService;
import org.exoplatform.agenda.service.AgendaUserSettingsService;
import org.exoplatform.agenda.storage.AgendaEventStorage;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.After;
import org.junit.Before;

public abstract class BaseAgendaEventTest {
    protected static final String CALENDAR_DESCRIPTION = "calendarDescription";
    protected static final String CALENDAR_COLOR = "calendarColor";
    protected static final ArrayList<EventAttendee> ATTENDEES = new ArrayList();
    protected static final ArrayList<EventConference> CONFERENCES = new ArrayList();
    protected static final ArrayList<EventReminder> REMINDERS = new ArrayList();
    protected static final RemoteEvent REMOTE_EVENT = null;
    protected static AtomicReference<AgendaEventModification> eventCreationReference;
    protected static AtomicReference<AgendaEventModification> eventPollCreationReference;
    protected static AtomicReference<AgendaEventModification> eventDeletionReference;
    protected static AtomicReference<AgendaEventModification> eventUpdateReference;
    protected PortalContainer container;
    protected IdentityManager identityManager;
    protected SpaceService spaceService;
    protected AgendaCalendarService agendaCalendarService;
    protected AgendaUserSettingsService agendaUserSettingsService;
    protected AgendaEventService agendaEventService;
    protected AgendaEventConferenceService agendaEventConferenceService;
    protected AgendaEventAttendeeService agendaEventAttendeeService;
    protected AgendaEventReminderService agendaEventReminderService;
    protected AgendaRemoteEventService agendaRemoteEventService;
    protected AgendaEventDatePollService agendaEventDatePollService;
    protected ListenerService listenerService;
    protected AgendaEventStorage agendaEventStorage;
    protected RemoteProvider remoteProvider;
    protected Calendar calendar;
    protected Calendar spaceCalendar;
    protected Space space;
    protected Identity spaceIdentity;
    protected Identity testuser1Identity;
    protected Identity testuser2Identity;
    protected Identity testuser3Identity;
    protected Identity testuser4Identity;
    protected Identity testuser5Identity;

    @Before
    public void setUp() throws ObjectNotFoundException {
        this.container = PortalContainer.getInstance();
        this.initServices();
        TimeZone.setDefault(TimeZone.getTimeZone("US/Hawaii"));
        this.begin();
        this.injectData();
    }

    private void initServices() {
        this.agendaCalendarService = (AgendaCalendarService)this.container.getComponentInstanceOfType(AgendaCalendarService.class);
        this.agendaEventService = (AgendaEventService)this.container.getComponentInstanceOfType(AgendaEventService.class);
        this.agendaUserSettingsService = (AgendaUserSettingsService)this.container.getComponentInstanceOfType(AgendaUserSettingsService.class);
        this.agendaEventConferenceService = (AgendaEventConferenceService)this.container.getComponentInstanceOfType(AgendaEventConferenceService.class);
        this.agendaEventAttendeeService = (AgendaEventAttendeeService)this.container.getComponentInstanceOfType(AgendaEventAttendeeService.class);
        this.agendaEventReminderService = (AgendaEventReminderService)this.container.getComponentInstanceOfType(AgendaEventReminderService.class);
        this.agendaRemoteEventService = (AgendaRemoteEventService)this.container.getComponentInstanceOfType(AgendaRemoteEventService.class);
        this.agendaEventDatePollService = (AgendaEventDatePollService)this.container.getComponentInstanceOfType(AgendaEventDatePollService.class);
        this.identityManager = (IdentityManager)this.container.getComponentInstanceOfType(IdentityManager.class);
        this.spaceService = (SpaceService)this.container.getComponentInstanceOfType(SpaceService.class);
        this.listenerService = (ListenerService)this.container.getComponentInstanceOfType(ListenerService.class);
        this.agendaEventStorage = (AgendaEventStorage)this.container.getComponentInstanceOfType(AgendaEventStorage.class);
        if (eventCreationReference == null) {
            eventCreationReference = new AtomicReference();
            Listener<AgendaEventModification, Object> creationListener = new Listener<AgendaEventModification, Object>(){

                public void onEvent(Event<AgendaEventModification, Object> event) throws Exception {
                    eventCreationReference.set((AgendaEventModification)event.getSource());
                }
            };
            this.listenerService.addListener("exo.agenda.event.created", (Listener)creationListener);
        }
        if (eventPollCreationReference == null) {
            eventPollCreationReference = new AtomicReference();
            Listener<AgendaEventModification, Object> pollCreationListener = new Listener<AgendaEventModification, Object>(){

                public void onEvent(Event<AgendaEventModification, Object> event) throws Exception {
                    eventPollCreationReference.set((AgendaEventModification)event.getSource());
                }
            };
            this.listenerService.addListener("exo.agenda.event.poll.created", (Listener)pollCreationListener);
        }
        if (eventUpdateReference == null) {
            eventUpdateReference = new AtomicReference();
            Listener<AgendaEventModification, Object> updateListener = new Listener<AgendaEventModification, Object>(){

                public void onEvent(Event<AgendaEventModification, Object> event) throws Exception {
                    eventUpdateReference.set((AgendaEventModification)event.getSource());
                }
            };
            this.listenerService.addListener("exo.agenda.event.updated", (Listener)updateListener);
        }
        if (eventDeletionReference == null) {
            eventDeletionReference = new AtomicReference();
            Listener<AgendaEventModification, Object> deletionListener = new Listener<AgendaEventModification, Object>(){

                public void onEvent(Event<AgendaEventModification, Object> event) throws Exception {
                    eventDeletionReference.set((AgendaEventModification)event.getSource());
                }
            };
            this.listenerService.addListener("exo.agenda.event.deleted", (Listener)deletionListener);
        }
    }

    @After
    public void tearDown() throws ObjectNotFoundException {
        this.purgeData();
        this.end();
    }

    protected ZonedDateTime getDate() {
        return ZonedDateTime.of(LocalDate.now(), LocalTime.of(10, 0), ZoneOffset.UTC).withZoneSameInstant(ZoneId.systemDefault());
    }

    protected void injectData() throws ObjectNotFoundException {
        this.purgeData();
        this.testuser1Identity = this.identityManager.getOrCreateIdentity("organization", "testuser1");
        this.testuser2Identity = this.identityManager.getOrCreateIdentity("organization", "testuser2");
        this.testuser3Identity = this.identityManager.getOrCreateIdentity("organization", "testuser3");
        this.testuser4Identity = this.identityManager.getOrCreateIdentity("organization", "testuser4");
        this.testuser5Identity = this.identityManager.getOrCreateIdentity("organization", "testuser5");
        this.calendar = this.agendaCalendarService.createCalendar(new Calendar(0L, Long.parseLong(this.testuser1Identity.getId()), false, null, CALENDAR_DESCRIPTION, null, null, CALENDAR_COLOR, null));
        String displayName = "testSpaceAgenda" + RandomUtils.nextInt();
        this.space = this.spaceService.getSpaceByDisplayName(displayName);
        if (this.space == null) {
            this.space = this.createSpace(displayName, this.testuser1Identity.getRemoteId(), this.testuser2Identity.getRemoteId(), this.testuser3Identity.getRemoteId());
        }
        if (!this.spaceService.isMember(this.space, this.testuser1Identity.getRemoteId())) {
            this.spaceService.addMember(this.space, this.testuser1Identity.getRemoteId());
        }
        if (!this.spaceService.isMember(this.space, this.testuser2Identity.getRemoteId())) {
            this.spaceService.addMember(this.space, this.testuser2Identity.getRemoteId());
        }
        if (!this.spaceService.isMember(this.space, this.testuser3Identity.getRemoteId())) {
            this.spaceService.addMember(this.space, this.testuser3Identity.getRemoteId());
        }
        this.spaceIdentity = this.identityManager.getOrCreateIdentity("space", this.space.getPrettyName());
        this.spaceCalendar = this.agendaCalendarService.createCalendar(new Calendar(0L, Long.parseLong(this.spaceIdentity.getId()), false, null, CALENDAR_DESCRIPTION, null, null, CALENDAR_COLOR, null));
        if (this.remoteProvider == null) {
            this.remoteProvider = this.agendaRemoteEventService.saveRemoteProvider(new RemoteProvider(0L, "newRemoteProvider", "Client API Key", true, Boolean.valueOf(true)));
        }
    }

    protected void purgeData() throws ObjectNotFoundException {
        if (this.spaceCalendar != null) {
            this.agendaCalendarService.deleteCalendarById(this.spaceCalendar.getId());
            this.spaceCalendar = null;
        }
        if (this.calendar != null) {
            this.agendaCalendarService.deleteCalendarById(this.calendar.getId());
            this.calendar = null;
        }
        eventCreationReference.set(null);
        eventPollCreationReference.set(null);
        eventUpdateReference.set(null);
        eventDeletionReference.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected org.exoplatform.agenda.model.Event createEvent(org.exoplatform.agenda.model.Event event, long userIdentityId, Identity ... attendeesArray) throws Exception {
        try {
            ATTENDEES.clear();
            for (Identity attendeeIdentity : attendeesArray) {
                EventAttendee userAttendee = new EventAttendee(0L, 0L, Long.parseLong(attendeeIdentity.getId()), null);
                ATTENDEES.add(userAttendee);
            }
            CONFERENCES.clear();
            EventConference conference = new EventConference(0L, 0L, "webrtc", "conf_uri", "+123456", "654321", "confDescription");
            CONFERENCES.add(conference);
            REMINDERS.clear();
            REMINDERS.add(new EventReminder(0L, 0L, 1L, 1, ReminderPeriodType.MINUTE, null));
            org.exoplatform.agenda.model.Event event2 = this.agendaEventService.createEvent(event.clone(), (List)((ArrayList)ATTENDEES.clone()), (List)((ArrayList)CONFERENCES.clone()), (List)((ArrayList)REMINDERS.clone()), null, REMOTE_EVENT, true, userIdentityId);
            return event2;
        }
        finally {
            TimeZone.setDefault(TimeZone.getTimeZone("Japan"));
        }
    }

    protected org.exoplatform.agenda.model.Event newEventInstance(ZonedDateTime start, ZonedDateTime end, boolean allDay) {
        long calendarId = this.calendar.getId();
        long modifierId = 0L;
        ZonedDateTime created = ZonedDateTime.now();
        ZonedDateTime updated = ZonedDateTime.now();
        String summary = "eventSummary";
        String description = "eventDescription";
        String location = "eventLocation";
        String color = "eventColor";
        ZonedDateTime until = end.plusDays(2L);
        EventRecurrence recurrence = new EventRecurrence(0L, until.toLocalDate(), 0, EventRecurrenceType.DAILY, EventRecurrenceFrequency.DAILY, 1, null, null, null, null, null, null, null, null, null, null, null);
        EventOccurrence occurrence = null;
        return new org.exoplatform.agenda.model.Event(0L, 0L, calendarId, 0L, modifierId, created, updated, summary, description, location, color, ZoneId.systemDefault(), start, end, allDay, EventAvailability.FREE, EventStatus.CONFIRMED, recurrence, occurrence, null, false, false);
    }

    protected void begin() {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
    }

    protected void end() {
        RequestLifeCycle.end();
    }

    protected void restartTransaction() {
        int i = 0;
        boolean success = true;
        do {
            try {
                this.end();
                ++i;
            }
            catch (IllegalStateException e) {
                success = false;
            }
        } while (success);
        for (int j = 0; j < i; ++j) {
            this.begin();
        }
    }

    protected Space createSpace(String displayName, String ... members) {
        Space newSpace = new Space();
        newSpace.setDisplayName(displayName);
        newSpace.setPrettyName(displayName);
        newSpace.setManagers(new String[]{"root"});
        newSpace.setMembers(members);
        newSpace.setRegistration("open");
        newSpace.setVisibility("private");
        return this.spaceService.createSpace(newSpace, "root");
    }

    protected Map<String, List<String>> getFields(String fieldName, String fieldValue) {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        fields.put(fieldName, Collections.singletonList(fieldValue));
        return fields;
    }
}

