/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.search;

import java.io.InputStream;
import java.text.Normalizer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.agenda.constant.EventStatus;
import org.exoplatform.agenda.model.EventSearchResult;
import org.exoplatform.agenda.storage.AgendaEventStorage;
import org.exoplatform.agenda.util.Utils;
import org.exoplatform.commons.search.es.ElasticSearchException;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class AgendaSearchConnector {
    private static final Log LOG = ExoLogger.getLogger(AgendaSearchConnector.class);
    private static final String SEARCH_QUERY_FILE_PATH_PARAM = "query.file.path";
    private final ConfigurationManager configurationManager;
    private final IdentityManager identityManager;
    private final SpaceService spaceService;
    private final AgendaEventStorage agendaEventStorage;
    private final ElasticSearchingClient client;
    private String index;
    private String searchQueryFilePath;
    private String searchQuery;

    public AgendaSearchConnector(ConfigurationManager configurationManager, IdentityManager identityManager, SpaceService spaceService, AgendaEventStorage agendaEventStorage, ElasticSearchingClient client, InitParams initParams) {
        this.configurationManager = configurationManager;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.agendaEventStorage = agendaEventStorage;
        this.client = client;
        PropertiesParam param = initParams.getPropertiesParam("constructor.params");
        this.index = param.getProperty("index");
        if (initParams.containsKey((Object)SEARCH_QUERY_FILE_PATH_PARAM)) {
            this.searchQueryFilePath = initParams.getValueParam(SEARCH_QUERY_FILE_PATH_PARAM).getValue();
            try {
                this.retrieveSearchQuery();
            }
            catch (Exception e) {
                LOG.error("Can't read elasticsearch search query from path {}", new Object[]{this.searchQueryFilePath, e});
            }
        }
    }

    public List<EventSearchResult> search(long userIdentityId, ZoneId userTimeZone, String term, long offset, long limit) {
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset must be positive");
        }
        if (limit < 0L) {
            throw new IllegalArgumentException("Limit must be positive");
        }
        if (StringUtils.isBlank((String)term)) {
            throw new IllegalArgumentException("Filter term is mandatory");
        }
        if (userIdentityId < 0L) {
            throw new IllegalArgumentException("User identity id must be positive");
        }
        Identity userIdentity = Utils.getIdentityById(this.identityManager, userIdentityId);
        Set calendarOwnersOfUser = Optional.ofNullable(Utils.getCalendarOwnersOfUser(this.spaceService, this.identityManager, userIdentity)).map(HashSet::new).orElse(new HashSet());
        calendarOwnersOfUser.add(userIdentityId);
        String esQuery = this.buildQueryStatement(calendarOwnersOfUser, term, offset, limit);
        String jsonResponse = this.client.sendRequest(esQuery, this.index);
        return this.buildResult(jsonResponse, userTimeZone);
    }

    private String buildQueryStatement(Set<Long> calendarOwnersOfUser, String term, long offset, long limit) {
        term = this.removeSpecialCharacters(term);
        List termsQuery = Arrays.stream(term.split(" ")).filter(StringUtils::isNotBlank).map(word -> {
            if (((String)(word = ((String)word).trim())).length() > 5) {
                word = (String)word + "~1";
            }
            return word;
        }).collect(Collectors.toList());
        String termQuery = StringUtils.join(termsQuery, (String)" AND ");
        return this.retrieveSearchQuery().replace("@term@", term).replace("@term_query@", termQuery).replace("@permissions@", StringUtils.join(calendarOwnersOfUser, (String)",")).replace("@offset@", String.valueOf(offset)).replace("@limit@", String.valueOf(limit));
    }

    private List<EventSearchResult> buildResult(String jsonResponse, ZoneId userTimeZone) {
        LOG.debug("Search Query response from ES : {} ", new Object[]{jsonResponse});
        ArrayList<EventSearchResult> results = new ArrayList<EventSearchResult>();
        JSONParser parser = new JSONParser();
        Map json = null;
        try {
            json = (Map)parser.parse(jsonResponse);
        }
        catch (ParseException e) {
            throw new ElasticSearchException("Unable to parse JSON response", (Throwable)e);
        }
        JSONObject jsonResult = (JSONObject)json.get("hits");
        if (jsonResult == null) {
            return results;
        }
        JSONArray jsonHits = (JSONArray)jsonResult.get((Object)"hits");
        for (Object jsonHit : jsonHits) {
            try {
                EventSearchResult eventSearchResult = new EventSearchResult();
                JSONObject jsonHitObject = (JSONObject)jsonHit;
                JSONObject hitSource = (JSONObject)jsonHitObject.get((Object)"_source");
                long id = this.parseLong(hitSource, "id");
                String summary = (String)hitSource.get((Object)"summary");
                String status = (String)hitSource.get((Object)"status");
                long calendarId = this.parseLong(hitSource, "calendarId");
                String startTime = (String)hitSource.get((Object)"startTime");
                String endTime = (String)hitSource.get((Object)"endTime");
                String location = (String)hitSource.get((Object)"location");
                String description = (String)hitSource.get((Object)"description");
                JSONObject highlightSource = (JSONObject)jsonHitObject.get((Object)"highlight");
                ArrayList<String> excerpts = new ArrayList<String>();
                if (highlightSource != null) {
                    if (highlightSource.get((Object)"summary") != null) {
                        summary = ((JSONArray)highlightSource.get((Object)"summary")).get(0).toString();
                        highlightSource.remove((Object)"summary");
                    }
                    for (Object value : highlightSource.values()) {
                        JSONArray excerptValue = (JSONArray)value;
                        if (excerptValue == null || excerptValue.isEmpty()) continue;
                        excerpts.add(excerptValue.get(0).toString());
                    }
                }
                eventSearchResult.setId(id);
                eventSearchResult.setCalendarId(calendarId);
                eventSearchResult.setSummary(summary);
                eventSearchResult.setStart(Utils.toDateTime(startTime, userTimeZone));
                eventSearchResult.setEnd(Utils.toDateTime(endTime, userTimeZone));
                eventSearchResult.setLocation(location);
                eventSearchResult.setSummary(summary);
                eventSearchResult.setDescription(description);
                eventSearchResult.setExcerpts(excerpts);
                eventSearchResult.setStatus(status == null ? EventStatus.CONFIRMED : EventStatus.valueOf((String)status));
                eventSearchResult.setRecurrent(this.agendaEventStorage.isRecurrentEvent(id));
                results.add(eventSearchResult);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error processing event search result item, ignore it from results", (Throwable)e);
            }
        }
        return results;
    }

    private Long parseLong(JSONObject hitSource, String key) {
        String value = (String)hitSource.get((Object)key);
        return StringUtils.isBlank((String)value) ? null : Long.valueOf(Long.parseLong(value));
    }

    private String retrieveSearchQuery() {
        if (StringUtils.isBlank((String)this.searchQuery) || PropertyManager.isDevelopping()) {
            try {
                InputStream queryFileIS = this.configurationManager.getInputStream(this.searchQueryFilePath);
                this.searchQuery = IOUtil.getStreamContentAsString((InputStream)queryFileIS);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error retrieving search query from file: " + this.searchQueryFilePath, e);
            }
        }
        return this.searchQuery;
    }

    private String removeSpecialCharacters(String string) {
        string = Normalizer.normalize(string, Normalizer.Form.NFD);
        string = string.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "").replace("'", " ");
        return string;
    }
}

