/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.exoplatform.agenda.constant.EventRecurrenceFrequency;
import org.exoplatform.agenda.constant.EventRecurrenceType;
import org.exoplatform.agenda.constant.EventStatus;
import org.exoplatform.agenda.constant.ReminderPeriodType;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventRecurrence;
import org.exoplatform.agenda.model.EventReminder;
import org.exoplatform.agenda.model.EventReminderParameter;
import org.exoplatform.agenda.service.BaseAgendaEventTest;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.junit.Assert;
import org.junit.Test;

public class AgendaEventReminderServiceTest
extends BaseAgendaEventTest {
    @Test
    public void testSaveEventReminders() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        boolean allDay = false;
        Event event = this.newEventInstance(start, start, allDay);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser5Identity);
        long eventId = event.getId();
        long userIdentityId = Long.parseLong(this.testuser1Identity.getId());
        List eventReminders = this.agendaEventReminderService.getEventReminders(eventId, userIdentityId);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)1L, (long)eventReminders.size());
        EventReminder eventReminder = (EventReminder)eventReminders.get(0);
        Assert.assertNotNull((Object)eventReminder);
        eventReminder = eventReminder.clone();
        eventReminder.setId(0L);
        eventReminder.setBefore(eventReminder.getBefore() + 1);
        eventReminders.add(eventReminder);
        this.agendaEventReminderService.saveEventReminders(event, eventReminders, userIdentityId);
        eventReminders = this.agendaEventReminderService.getEventReminders(eventId, userIdentityId);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)2L, (long)eventReminders.size());
        this.agendaEventReminderService.saveEventReminders(event, Collections.emptyList(), userIdentityId);
        eventReminders = this.agendaEventReminderService.getEventReminders(eventId, userIdentityId);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)0L, (long)eventReminders.size());
    }

    @Test
    public void testUpdateEventStatus() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        boolean allDay = false;
        long userIdentityId = Long.parseLong(this.testuser1Identity.getId());
        Event event = this.newEventInstance(start, start, allDay);
        event = this.createEvent(event.clone(), userIdentityId, this.testuser5Identity);
        long eventId = event.getId();
        List eventReminders = this.agendaEventReminderService.getEventReminders(eventId, userIdentityId);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)1L, (long)eventReminders.size());
        Assert.assertNotNull((Object)((EventReminder)eventReminders.get(0)).getDatetime());
        ArrayList origEventReminders = new ArrayList(eventReminders);
        List attendees = this.agendaEventAttendeeService.getEventAttendees(eventId).getEventAttendees();
        event.setStatus(EventStatus.CANCELLED);
        event = this.agendaEventService.updateEvent(event, attendees, null, origEventReminders, null, REMOTE_EVENT, allDay, userIdentityId);
        eventReminders = this.agendaEventReminderService.getEventReminders(eventId, userIdentityId);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)0L, (long)eventReminders.size());
        event.setStatus(EventStatus.TENTATIVE);
        event = this.agendaEventService.updateEvent(event, attendees, null, origEventReminders, null, null, false, userIdentityId);
        eventReminders = this.agendaEventReminderService.getEventReminders(eventId, userIdentityId);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)1L, (long)eventReminders.size());
        Assert.assertNull((Object)((EventReminder)eventReminders.get(0)).getDatetime());
        event.setStatus(EventStatus.CONFIRMED);
        this.agendaEventService.updateEvent(event, attendees, Collections.emptyList(), origEventReminders, null, null, false, userIdentityId);
        eventReminders = this.agendaEventReminderService.getEventReminders(eventId, userIdentityId);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)1L, (long)eventReminders.size());
        Assert.assertNotNull((Object)((EventReminder)eventReminders.get(0)).getDatetime());
    }

    @Test
    public void testSaveRecurrentEventReminders() throws Exception {
        ZonedDateTime start = this.getDate().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        EventRecurrence recurrence = new EventRecurrence(0L, start.plusDays(2L).toLocalDate(), 0, EventRecurrenceType.DAILY, EventRecurrenceFrequency.DAILY, 1, null, null, null, null, null, null, null, null, null, null, null);
        event.setRecurrence(recurrence);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser2Identity);
        long eventId = event.getId();
        try {
            this.agendaEventService.saveEventExceptionalOccurrence(eventId, start.plusDays(4L));
            Assert.fail((String)"Shouldn't be able to create an exceptional occurrence out of range");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Event exceptionalOccurrence = this.agendaEventService.saveEventExceptionalOccurrence(eventId, start.plusDays(1L));
        Assert.assertNotNull((Object)exceptionalOccurrence);
        long exceptionalOccurrenceId = exceptionalOccurrence.getId();
        long userIdentityId = Long.parseLong(this.testuser1Identity.getId());
        List eventReminders = this.agendaEventReminderService.getEventReminders(eventId, userIdentityId);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)1L, (long)eventReminders.size());
        List exceptionalOccurrenceReminders = this.agendaEventReminderService.getEventReminders(exceptionalOccurrenceId, userIdentityId);
        Assert.assertNotNull((Object)exceptionalOccurrenceReminders);
        Assert.assertEquals((long)1L, (long)exceptionalOccurrenceReminders.size());
        EventReminder eventReminder = (EventReminder)eventReminders.get(0);
        Assert.assertNotNull((Object)eventReminder);
        eventReminder = eventReminder.clone();
        eventReminder.setId(0L);
        eventReminder.setBefore(eventReminder.getBefore() + 1);
        eventReminders.add(eventReminder);
        this.agendaEventReminderService.saveEventReminders(event, eventReminders, userIdentityId);
        eventReminders = this.agendaEventReminderService.getEventReminders(eventId, userIdentityId);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)2L, (long)eventReminders.size());
        exceptionalOccurrenceReminders = this.agendaEventReminderService.getEventReminders(exceptionalOccurrenceId, userIdentityId);
        Assert.assertNotNull((Object)exceptionalOccurrenceReminders);
        Assert.assertEquals((long)2L, (long)exceptionalOccurrenceReminders.size());
        exceptionalOccurrenceReminders.remove(0);
        this.agendaEventReminderService.saveEventReminders(exceptionalOccurrence, exceptionalOccurrenceReminders, userIdentityId);
        eventReminders = this.agendaEventReminderService.getEventReminders(eventId, userIdentityId);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)2L, (long)eventReminders.size());
        exceptionalOccurrenceReminders = this.agendaEventReminderService.getEventReminders(exceptionalOccurrenceId, userIdentityId);
        Assert.assertNotNull((Object)exceptionalOccurrenceReminders);
        Assert.assertEquals((long)1L, (long)exceptionalOccurrenceReminders.size());
        this.agendaEventReminderService.saveEventReminders(event, Collections.emptyList(), userIdentityId);
        eventReminders = this.agendaEventReminderService.getEventReminders(eventId, userIdentityId);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)0L, (long)eventReminders.size());
        exceptionalOccurrenceReminders = this.agendaEventReminderService.getEventReminders(exceptionalOccurrenceId, userIdentityId);
        Assert.assertNotNull((Object)exceptionalOccurrenceReminders);
        Assert.assertEquals((long)0L, (long)exceptionalOccurrenceReminders.size());
    }

    @Test
    public void testSaveUpcomingEventReminders() throws Exception {
        ZonedDateTime start = this.getDate().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        EventRecurrence recurrence = new EventRecurrence(0L, null, 0, EventRecurrenceType.DAILY, EventRecurrenceFrequency.DAILY, 1, null, null, null, null, null, null, null, null, null, null, null);
        event.setRecurrence(recurrence);
        long testuser1Id = Long.parseLong(this.testuser1Identity.getId());
        event = this.createEvent(event.clone(), testuser1Id, this.testuser1Identity, this.testuser2Identity);
        long eventId = event.getId();
        EventReminder upcomingEventsReminder = new EventReminder(5000L, 10000L, testuser1Id, 5, ReminderPeriodType.HOUR);
        List<EventReminder> upcomingEventsReminders = Collections.singletonList(upcomingEventsReminder);
        List eventReminders = this.agendaEventReminderService.getEventReminders(eventId, testuser1Id);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)1L, (long)eventReminders.size());
        this.agendaEventService.saveEventExceptionalOccurrence(eventId, start.plusDays(4L));
        this.agendaEventReminderService.saveUpcomingEventReminders(eventId, start.plusDays(5L), upcomingEventsReminders, testuser1Id);
        Event exceptionalOccurrence = this.agendaEventService.saveEventExceptionalOccurrence(eventId, start.plusDays(10L));
        Assert.assertNotNull((Object)exceptionalOccurrence);
        eventReminders = this.agendaEventReminderService.getEventReminders(exceptionalOccurrence.getId(), testuser1Id);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)1L, (long)eventReminders.size());
        EventReminder savedUpcomingEventReminder = (EventReminder)eventReminders.get(0);
        Assert.assertNotNull((Object)savedUpcomingEventReminder);
        Assert.assertNull((Object)savedUpcomingEventReminder.getUntilOccurrenceId());
        Assert.assertNull((Object)savedUpcomingEventReminder.getFromOccurrenceId());
        Assert.assertNotNull((Object)savedUpcomingEventReminder.getDatetime());
        eventReminders = this.agendaEventReminderService.getEventReminders(eventId, testuser1Id);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)2L, (long)eventReminders.size());
        savedUpcomingEventReminder = eventReminders.stream().filter(reminder -> reminder.getFromOccurrenceId() != null).findAny().orElse(null);
        Assert.assertNotNull((Object)savedUpcomingEventReminder);
        Assert.assertNull((Object)savedUpcomingEventReminder.getUntilOccurrenceId());
        EventReminder savedOriginalEventReminder = eventReminders.stream().filter(reminder -> reminder.getUntilOccurrenceId() != null).findAny().orElse(null);
        Assert.assertNotNull((Object)savedOriginalEventReminder);
        Assert.assertNull((Object)savedOriginalEventReminder.getFromOccurrenceId());
        exceptionalOccurrence = this.agendaEventService.saveEventExceptionalOccurrence(eventId, start.plusDays(11L));
        Assert.assertNotNull((Object)exceptionalOccurrence);
        eventReminders = this.agendaEventReminderService.getEventReminders(exceptionalOccurrence.getId(), testuser1Id);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)1L, (long)eventReminders.size());
        savedUpcomingEventReminder = (EventReminder)eventReminders.get(0);
        Assert.assertNotNull((Object)savedUpcomingEventReminder);
        Assert.assertNotNull((Object)savedUpcomingEventReminder.getDatetime());
        this.agendaEventService.saveEventExceptionalOccurrence(eventId, start.plusDays(4L));
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)1L, (long)eventReminders.size());
        savedUpcomingEventReminder = (EventReminder)eventReminders.get(0);
        Assert.assertNotNull((Object)savedUpcomingEventReminder);
        Assert.assertNotNull((Object)savedUpcomingEventReminder.getDatetime());
        Assert.assertNull((Object)savedUpcomingEventReminder.getFromOccurrenceId());
        Assert.assertNull((Object)savedUpcomingEventReminder.getUntilOccurrenceId());
    }

    @Test
    public void testGetEventReminders() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        boolean allDay = false;
        Event event = this.newEventInstance(start, start, allDay);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser5Identity);
        long eventId = event.getId();
        long userIdentityId = Long.parseLong(this.testuser1Identity.getId());
        List eventReminders = this.agendaEventReminderService.getEventReminders(eventId, userIdentityId);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)1L, (long)eventReminders.size());
        EventReminder eventReminderToStore = (EventReminder)REMINDERS.get(0);
        EventReminder eventReminder = (EventReminder)eventReminders.get(0);
        Assert.assertNotNull((Object)eventReminder);
        Assert.assertTrue((eventReminder.getId() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)eventReminder.getBefore(), (long)eventReminderToStore.getBefore());
        Assert.assertEquals((Object)eventReminder.getBeforePeriodType(), (Object)eventReminderToStore.getBeforePeriodType());
        Assert.assertEquals((long)userIdentityId, (long)eventReminder.getReceiverId());
        Assert.assertNotNull((Object)eventReminder.getDatetime());
        Assert.assertEquals((Object)event.getStart().minusMinutes(eventReminder.getBefore()).withZoneSameInstant(ZoneOffset.UTC), (Object)eventReminder.getDatetime().withZoneSameInstant(ZoneOffset.UTC));
    }

    @Test
    public void testGetDefaultReminders() throws Exception {
        List defaultReminders = this.agendaUserSettingsService.getDefaultReminders();
        Assert.assertNotNull((Object)defaultReminders);
        Assert.assertFalse((boolean)defaultReminders.isEmpty());
        try {
            defaultReminders.add(new EventReminderParameter());
            Assert.fail((String)"Shouldn't allow list modification");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSaveUserReminders() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        boolean allDay = false;
        Event event = this.newEventInstance(start, start, allDay);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser4Identity, this.testuser5Identity);
        long eventId = event.getId();
        long userIdentityId = Long.parseLong(this.testuser1Identity.getId());
        List eventReminders = this.agendaEventReminderService.getEventReminders(eventId, userIdentityId);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)1L, (long)eventReminders.size());
        long user4IdentityId = Long.parseLong(this.testuser4Identity.getId());
        eventReminders = Collections.singletonList(new EventReminder(user4IdentityId, 2, ReminderPeriodType.DAY));
        this.agendaEventReminderService.saveEventReminders(event, eventReminders, user4IdentityId);
        eventReminders = this.agendaEventReminderService.getEventReminders(eventId, user4IdentityId);
        Assert.assertEquals((long)1L, (long)eventReminders.size());
        eventReminders = this.agendaEventReminderService.getEventReminders(eventId);
        Assert.assertEquals((long)2L, (long)eventReminders.size());
        this.agendaEventReminderService.removeUserReminders(eventId, user4IdentityId);
        eventReminders = this.agendaEventReminderService.getEventReminders(eventId);
        Assert.assertEquals((long)1L, (long)eventReminders.size());
        eventReminders = this.agendaEventReminderService.getEventReminders(eventId, user4IdentityId);
        Assert.assertEquals((long)0L, (long)eventReminders.size());
    }

    @Test
    public void sendRemindersTest() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().withNano(0).plusMinutes(1L);
        ZonedDateTime end = start.plusMinutes(15L);
        boolean allDay = false;
        long userIdentityId = Long.parseLong(this.testuser1Identity.getId());
        WebNotificationService webNotificationService = (WebNotificationService)this.container.getComponentInstanceOfType(WebNotificationService.class);
        Event reccurrentEvent = this.newEventInstance(start, end, allDay);
        EventRecurrence recurrence = new EventRecurrence(0L, start.plusDays(2L).toLocalDate(), 0, EventRecurrenceType.DAILY, EventRecurrenceFrequency.DAILY, 1, null, null, null, null, null, null, null, null, null, null, null);
        reccurrentEvent.setRecurrence(recurrence);
        reccurrentEvent = this.createEvent(reccurrentEvent.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser2Identity);
        long recEventId = reccurrentEvent.getId();
        this.agendaEventService.saveEventExceptionalOccurrence(recEventId, start);
        this.agendaEventService.saveEventExceptionalOccurrence(recEventId, start.plusDays(1L));
        List exceptionalOccurrence = this.agendaEventService.getExceptionalOccurrenceEvents(recEventId, TimeZone.getTimeZone("Tunisia").toZoneId(), userIdentityId);
        Assert.assertNotNull((Object)exceptionalOccurrence);
        long firstExceptionalOccurrenceId = ((Event)exceptionalOccurrence.get(0)).getId();
        List eventReminders = this.agendaEventReminderService.getEventReminders(recEventId, userIdentityId);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)1L, (long)eventReminders.size());
        List exceptionalOccurrenceReminders = this.agendaEventReminderService.getEventReminders(firstExceptionalOccurrenceId, userIdentityId);
        Assert.assertNotNull((Object)exceptionalOccurrenceReminders);
        Assert.assertEquals((long)1L, (long)exceptionalOccurrenceReminders.size());
        webNotificationService.resetNumberOnBadge(this.testuser1Identity.getRemoteId());
        this.agendaEventReminderService.sendReminders();
        int notificationSize = webNotificationService.getNumberOnBadge(this.testuser1Identity.getRemoteId());
        Assert.assertEquals((long)1L, (long)notificationSize);
        webNotificationService.resetNumberOnBadge(this.testuser1Identity.getRemoteId());
        Event event = this.newEventInstance(start, start, allDay);
        event.setRecurrence(null);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity);
        long eventId = event.getId();
        eventReminders = this.agendaEventReminderService.getEventReminders(eventId, userIdentityId);
        Assert.assertNotNull((Object)eventReminders);
        Assert.assertEquals((long)1L, (long)eventReminders.size());
        EventReminder eventReminder = (EventReminder)eventReminders.get(0);
        Assert.assertNotNull((Object)eventReminder);
        this.agendaEventReminderService.sendReminders();
        Assert.assertEquals((long)(notificationSize + 1), (long)webNotificationService.getNumberOnBadge(this.testuser1Identity.getRemoteId()));
    }
}

