/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service;

import java.time.ZonedDateTime;
import java.util.List;
import org.apache.commons.codec.binary.StringUtils;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.RemoteEvent;
import org.exoplatform.agenda.model.RemoteProvider;
import org.exoplatform.agenda.plugin.RemoteProviderDefinitionPlugin;
import org.exoplatform.agenda.service.BaseAgendaEventTest;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.junit.Assert;
import org.junit.Test;

public class AgendaRemoteEventServiceTest
extends BaseAgendaEventTest {
    @Test
    public void testAddRemoteProviders() throws Exception {
        InitParams params = new InitParams();
        ValueParam param = new ValueParam();
        param.setName("connectorName");
        param.setValue("remoteProviderTest");
        params.addParameter((Parameter)param);
        param = new ValueParam();
        param.setName("connectorEnabled");
        param.setValue("false");
        params.addParameter((Parameter)param);
        RemoteProviderDefinitionPlugin plugin = new RemoteProviderDefinitionPlugin(params);
        RemoteProvider addedRemoteProvider = this.agendaRemoteEventService.saveRemoteProviderPlugin(plugin);
        Assert.assertNotNull((Object)addedRemoteProvider);
        Assert.assertTrue((addedRemoteProvider.getId() > 0L ? 1 : 0) != 0);
        Assert.assertFalse((boolean)addedRemoteProvider.isEnabled());
        Assert.assertEquals((Object)"remoteProviderTest", (Object)addedRemoteProvider.getName());
    }

    @Test
    public void testGetAndSaveRemoteProviders() throws Exception {
        List remoteProviders = this.agendaRemoteEventService.getRemoteProviders();
        Assert.assertNotNull((Object)remoteProviders);
        int initialisize = remoteProviders.size();
        RemoteProvider remoteProviderToSave = new RemoteProvider(0L, "testProvider", "Client API Key", "client secret key", false, Boolean.valueOf(true));
        RemoteProvider remoteProviderSaved = this.agendaRemoteEventService.saveRemoteProvider(remoteProviderToSave);
        Assert.assertNotNull((Object)remoteProviderSaved);
        Assert.assertTrue((remoteProviderSaved.getId() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)remoteProviderToSave.getName(), (Object)remoteProviderSaved.getName());
        Assert.assertEquals((Object)remoteProviderToSave.isEnabled(), (Object)remoteProviderSaved.isEnabled());
        remoteProviders = this.agendaRemoteEventService.getRemoteProviders();
        Assert.assertNotNull((Object)remoteProviders);
        Assert.assertEquals((long)((long)initialisize + 1L), (long)remoteProviders.size());
    }

    @Test
    public void testSaveRemoteProviderStatus() throws Exception {
        RemoteProvider remoteProviderToSave = new RemoteProvider(0L, "testProvider222", "Client API Key", "client secret key", false, Boolean.valueOf(true));
        RemoteProvider remoteProviderSaved = this.agendaRemoteEventService.saveRemoteProvider(remoteProviderToSave);
        Assert.assertNotNull((Object)remoteProviderSaved);
        Assert.assertFalse((boolean)remoteProviderSaved.isEnabled());
        this.agendaRemoteEventService.saveRemoteProviderStatus(remoteProviderSaved.getName(), false, true);
        RemoteProvider remoteProvider = this.agendaRemoteEventService.getRemoteProviders().stream().filter(provider -> StringUtils.equals((CharSequence)provider.getName(), (CharSequence)remoteProviderSaved.getName())).findFirst().orElse(null);
        Assert.assertNotNull((Object)remoteProvider);
        Assert.assertFalse((boolean)remoteProvider.isEnabled());
        this.agendaRemoteEventService.saveRemoteProviderStatus(remoteProviderSaved.getName(), true, true);
        remoteProvider = this.agendaRemoteEventService.getRemoteProviders().stream().filter(provider -> StringUtils.equals((CharSequence)provider.getName(), (CharSequence)remoteProviderSaved.getName())).findFirst().orElse(null);
        Assert.assertNotNull((Object)remoteProvider);
        Assert.assertTrue((boolean)remoteProvider.isEnabled());
    }

    @Test
    public void testSaveRemoteEvent() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        boolean allDay = false;
        long identityId1 = Long.parseLong(this.testuser1Identity.getId());
        Event event = this.newEventInstance(start, start, allDay);
        event = this.createEvent(event.clone(), identityId1, this.testuser5Identity);
        long eventId = event.getId();
        RemoteEvent remoteEvent = new RemoteEvent(0L, eventId, identityId1, "remoteEventId", this.remoteProvider.getId(), this.remoteProvider.getName());
        RemoteEvent savedRemoteEvent = this.agendaRemoteEventService.saveRemoteEvent(eventId, remoteEvent, identityId1);
        Assert.assertNotNull((Object)savedRemoteEvent);
        Assert.assertTrue((savedRemoteEvent.getId() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)remoteEvent.getEventId(), (long)savedRemoteEvent.getEventId());
        Assert.assertEquals((long)remoteEvent.getIdentityId(), (long)savedRemoteEvent.getIdentityId());
        Assert.assertEquals((Object)remoteEvent.getRemoteId(), (Object)savedRemoteEvent.getRemoteId());
        Assert.assertEquals((long)remoteEvent.getRemoteProviderId(), (long)savedRemoteEvent.getRemoteProviderId());
        Assert.assertEquals((Object)remoteEvent.getRemoteProviderName(), (Object)savedRemoteEvent.getRemoteProviderName());
        this.agendaRemoteEventService.saveRemoteEvent(eventId, null, identityId1);
        RemoteEvent foundRemoteEvent = this.agendaRemoteEventService.findRemoteEvent(eventId, identityId1);
        Assert.assertNull((Object)foundRemoteEvent);
    }

    @Test
    public void testFindRemoteEvent() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        boolean allDay = false;
        long identityId1 = Long.parseLong(this.testuser1Identity.getId());
        long identityId5 = Long.parseLong(this.testuser5Identity.getId());
        Event event = this.newEventInstance(start, start, allDay);
        event = this.createEvent(event.clone(), identityId1, this.testuser5Identity);
        long eventId = event.getId();
        RemoteEvent remoteEvent1 = new RemoteEvent(0L, eventId, identityId1, "remoteEventId", this.remoteProvider.getId(), this.remoteProvider.getName());
        this.agendaRemoteEventService.saveRemoteEvent(remoteEvent1);
        this.agendaRemoteEventService.saveRemoteEvent(eventId, remoteEvent1, identityId5);
        RemoteEvent foundRemoteEvent1 = this.agendaRemoteEventService.findRemoteEvent(eventId, identityId1);
        Assert.assertNotNull((Object)foundRemoteEvent1);
        RemoteEvent foundRemoteEvent5 = this.agendaRemoteEventService.findRemoteEvent(eventId, identityId5);
        Assert.assertNotNull((Object)foundRemoteEvent5);
        Assert.assertNotEquals((long)foundRemoteEvent1.getId(), (long)foundRemoteEvent5.getId());
    }

    @Test
    public void saveRemoteProviderApiKey() {
        Throwable exception1 = Assert.assertThrows(IllegalStateException.class, () -> this.agendaRemoteEventService.saveRemoteProviderApiKey(null, "key"));
        Assert.assertEquals((Object)"remoteProviderName is mandatory", (Object)exception1.getMessage());
        Throwable exception2 = Assert.assertThrows(IllegalStateException.class, () -> this.agendaRemoteEventService.saveRemoteProviderApiKey("notExistProvider", "key"));
        Assert.assertEquals((Object)"Remote provider not found with name notExistProvider", (Object)exception2.getMessage());
        RemoteProvider remoteProviderToSave = new RemoteProvider(0L, "testProviderSecretKey", "Client API Key", "", true, Boolean.valueOf(true));
        this.agendaRemoteEventService.saveRemoteProvider(remoteProviderToSave);
        RemoteProvider remoteProvider = this.agendaRemoteEventService.saveRemoteProviderApiKey("testProviderSecretKey", "secret key");
        Assert.assertNotNull((Object)remoteProvider);
        Assert.assertEquals((Object)"secret key", (Object)remoteProvider.getApiKey());
    }
}

