/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.dao;

import jakarta.persistence.TypedQuery;
import java.util.Collections;
import java.util.List;
import org.exoplatform.agenda.dao.EventDateVoteDAO;
import org.exoplatform.agenda.entity.EventDateOptionEntity;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class EventDateOptionDAO
extends GenericDAOJPAImpl<EventDateOptionEntity, Long> {
    private EventDateVoteDAO dateVoteDAO;

    public EventDateOptionDAO(EventDateVoteDAO dateVoteDAO) {
        this.dateVoteDAO = dateVoteDAO;
    }

    public void deleteEventDateOptions(long eventId) {
        List<EventDateOptionEntity> dateOptionEntities = this.findDateOptionsByEventId(eventId);
        for (EventDateOptionEntity eventDateOptionEntity : dateOptionEntities) {
            this.delete(eventDateOptionEntity);
        }
    }

    public void delete(EventDateOptionEntity entity) {
        this.dateVoteDAO.deleteDateOptionVotes(entity.getId());
        super.delete((Object)entity);
    }

    public List<EventDateOptionEntity> findDateOptionsByEventId(long eventId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("AgendaEventDateOption.findDateOptionsByEventId", EventDateOptionEntity.class);
        query.setParameter("eventId", (Object)eventId);
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptyList() : resultList;
    }
}

