/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.notification.pwa;

import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.plugin.PwaNotificationPlugin;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.core.space.spi.SpaceService;

public class EventReminderNotificationPwaPlugin
implements PwaNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(EventReminderNotificationPwaPlugin.class);
    private String notificationId = "EventReminderNotificationPlugin";
    private static final String TITLE_LABEL_KEY = "pwa.notification.EventReminderNotificationPwaPlugin.title";
    private ResourceBundleService resourceBundleService;
    private SpaceService spaceService;

    public EventReminderNotificationPwaPlugin(ResourceBundleService resourceBundleService, SpaceService spaceService) {
        this.spaceService = spaceService;
        this.resourceBundleService = resourceBundleService;
    }

    public SpaceService getSpaceService() {
        return this.spaceService;
    }

    public String getId() {
        return this.notificationId;
    }

    public PwaNotificationMessage process(NotificationInfo notification, LocaleConfig localeConfig) {
        PwaNotificationMessage notificationMessage = new PwaNotificationMessage();
        String key = TITLE_LABEL_KEY;
        String spaceId = notification.getValueOwnerParameter("ownerId");
        String title = this.resourceBundleService.getSharedString(key, localeConfig.getLocale()).replace("{0}", this.getSpaceName(spaceId));
        notificationMessage.setTitle(title);
        notificationMessage.setBody(notification.getValueOwnerParameter("eventTitle"));
        String url = notification.getValueOwnerParameter("Url").replace(CommonsUtils.getCurrentDomain(), "");
        notificationMessage.setUrl(url);
        return notificationMessage;
    }
}

