/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.storage;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.agenda.dao.RemoteEventDAO;
import org.exoplatform.agenda.dao.RemoteProviderDAO;
import org.exoplatform.agenda.entity.RemoteEventEntity;
import org.exoplatform.agenda.entity.RemoteProviderEntity;
import org.exoplatform.agenda.model.RemoteEvent;
import org.exoplatform.agenda.model.RemoteProvider;
import org.exoplatform.agenda.util.EntityMapper;

public class AgendaRemoteEventStorage {
    private RemoteProviderDAO remoteProviderDAO;
    private RemoteEventDAO remoteEventDAO;

    public AgendaRemoteEventStorage(RemoteProviderDAO remoteProviderDAO, RemoteEventDAO remoteEventDAO) {
        this.remoteProviderDAO = remoteProviderDAO;
        this.remoteEventDAO = remoteEventDAO;
    }

    public List<RemoteProvider> getRemoteProviders() {
        List remoteProviders = this.remoteProviderDAO.findAll();
        return remoteProviders == null ? Collections.emptyList() : remoteProviders.stream().map(remoteProviderEntity -> EntityMapper.fromEntity(remoteProviderEntity)).collect(Collectors.toList());
    }

    public RemoteProvider getRemoteProviderById(long remoteProviderId) {
        RemoteProviderEntity remoteProviderEntity = (RemoteProviderEntity)this.remoteProviderDAO.find(Long.valueOf(remoteProviderId));
        if (remoteProviderEntity == null) {
            return null;
        }
        return EntityMapper.fromEntity(remoteProviderEntity);
    }

    public RemoteProvider saveRemoteProvider(RemoteProvider remoteProvider) {
        RemoteProviderEntity remoteProviderEntity = EntityMapper.toEntity(remoteProvider);
        if (remoteProviderEntity.getId() == null) {
            RemoteProviderEntity existingRemoteProviderEntity = this.remoteProviderDAO.findByName(remoteProvider.getName());
            if (existingRemoteProviderEntity == null) {
                remoteProviderEntity = (RemoteProviderEntity)this.remoteProviderDAO.create(remoteProviderEntity);
            } else {
                remoteProviderEntity.setId(existingRemoteProviderEntity.getId());
                remoteProviderEntity = (RemoteProviderEntity)this.remoteProviderDAO.update(remoteProviderEntity);
            }
        } else {
            remoteProviderEntity = (RemoteProviderEntity)this.remoteProviderDAO.update(remoteProviderEntity);
        }
        return EntityMapper.fromEntity(remoteProviderEntity);
    }

    public RemoteProvider getRemoteProviderByName(String connectorName) {
        RemoteProviderEntity remoteProviderEntity = this.remoteProviderDAO.findByName(connectorName);
        if (remoteProviderEntity == null) {
            return null;
        }
        return EntityMapper.fromEntity(remoteProviderEntity);
    }

    public RemoteEventEntity deleteRemoteEvent(long eventId, long identityId) {
        RemoteEventEntity remoteEventEntity = this.remoteEventDAO.findRemoteEvent(eventId, identityId);
        if (remoteEventEntity != null) {
            this.remoteEventDAO.delete(remoteEventEntity);
        }
        return remoteEventEntity;
    }

    public RemoteEvent saveRemoteEvent(RemoteEvent remoteEvent) {
        long identityId = remoteEvent.getIdentityId();
        long eventId = remoteEvent.getEventId();
        RemoteEventEntity existingRemoteEventEntity = this.remoteEventDAO.findRemoteEvent(eventId, identityId);
        if (existingRemoteEventEntity == null) {
            if (StringUtils.isNotBlank((CharSequence)remoteEvent.getRemoteId()) && (remoteEvent.getRemoteProviderId() > 0L || StringUtils.isNotBlank((CharSequence)remoteEvent.getRemoteProviderName()))) {
                RemoteProviderEntity remoteProviderEntity = this.getRemoteProviderFromEvent(remoteEvent);
                remoteEvent.setRemoteProviderId(remoteProviderEntity.getId().longValue());
                remoteEvent.setRemoteProviderName(remoteProviderEntity.getName());
                RemoteEventEntity remoteEventEntity = EntityMapper.toEntity(remoteEvent);
                remoteEventEntity = (RemoteEventEntity)this.remoteEventDAO.create(remoteEventEntity);
                return EntityMapper.fromEntity(remoteEventEntity, remoteProviderEntity);
            }
            return null;
        }
        if (StringUtils.isBlank((CharSequence)remoteEvent.getRemoteId()) || remoteEvent.getRemoteProviderId() == 0L && StringUtils.isBlank((CharSequence)remoteEvent.getRemoteProviderName())) {
            this.remoteEventDAO.delete(existingRemoteEventEntity);
            return null;
        }
        RemoteProviderEntity remoteProviderEntity = this.getRemoteProviderFromEvent(remoteEvent);
        remoteEvent.setId(existingRemoteEventEntity.getId().longValue());
        remoteEvent.setRemoteProviderId(remoteProviderEntity.getId().longValue());
        RemoteEventEntity remoteEventEntity = EntityMapper.toEntity(remoteEvent);
        remoteEventEntity = (RemoteEventEntity)this.remoteEventDAO.update(remoteEventEntity);
        return EntityMapper.fromEntity(remoteEventEntity, remoteProviderEntity);
    }

    public RemoteEvent findRemoteEvent(long eventId, long userIdentityId) {
        RemoteEventEntity remoteEventEntity = this.remoteEventDAO.findRemoteEvent(eventId, userIdentityId);
        if (remoteEventEntity == null) {
            return null;
        }
        RemoteProviderEntity remoteProviderEntity = (RemoteProviderEntity)this.remoteProviderDAO.find(remoteEventEntity.getRemoteProviderId());
        return EntityMapper.fromEntity(remoteEventEntity, remoteProviderEntity);
    }

    public RemoteProviderEntity getRemoteProviderFromEvent(RemoteEvent remoteEvent) {
        RemoteProviderEntity remoteProviderEntity = null;
        if (remoteEvent.getRemoteProviderId() > 0L) {
            remoteProviderEntity = (RemoteProviderEntity)this.remoteProviderDAO.find(Long.valueOf(remoteEvent.getRemoteProviderId()));
        } else if (StringUtils.isNotBlank((CharSequence)remoteEvent.getRemoteProviderName())) {
            remoteProviderEntity = this.remoteProviderDAO.findByName(remoteEvent.getRemoteProviderName());
        }
        return remoteProviderEntity;
    }
}

