/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.rest;

import io.meeds.social.html.utils.HtmlUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.agenda.constant.EventAttendeeResponse;
import org.exoplatform.agenda.exception.AgendaException;
import org.exoplatform.agenda.exception.AgendaExceptionType;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventAttendee;
import org.exoplatform.agenda.model.EventConference;
import org.exoplatform.agenda.model.EventFilter;
import org.exoplatform.agenda.model.EventReminder;
import org.exoplatform.agenda.model.RemoteEvent;
import org.exoplatform.agenda.rest.model.EventAttendeeEntity;
import org.exoplatform.agenda.rest.model.EventEntity;
import org.exoplatform.agenda.rest.model.EventList;
import org.exoplatform.agenda.rest.model.EventReminderEntity;
import org.exoplatform.agenda.service.AgendaCalendarService;
import org.exoplatform.agenda.service.AgendaEventAttendeeService;
import org.exoplatform.agenda.service.AgendaEventConferenceService;
import org.exoplatform.agenda.service.AgendaEventDatePollService;
import org.exoplatform.agenda.service.AgendaEventReminderService;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.agenda.service.AgendaRemoteEventService;
import org.exoplatform.agenda.util.AgendaDateUtils;
import org.exoplatform.agenda.util.RestEntityBuilder;
import org.exoplatform.agenda.util.RestUtils;
import org.exoplatform.agenda.util.Utils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.http.PATCH;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.picocontainer.Startable;

@Path(value="/v1/agenda/events")
@Tag(name="/v1/agenda/events", description="Manages agenda events associated to users and spaces")
public class AgendaEventRest
implements ResourceContainer,
Startable {
    private static final String AGENDA_APP_URI = "agenda";
    private static final Log LOG = ExoLogger.getLogger(AgendaEventRest.class);
    private IdentityManager identityManager;
    private AgendaCalendarService agendaCalendarService;
    private AgendaEventService agendaEventService;
    private AgendaEventReminderService agendaEventReminderService;
    private AgendaEventAttendeeService agendaEventAttendeeService;
    private AgendaEventConferenceService agendaEventConferenceService;
    private AgendaRemoteEventService agendaRemoteEventService;
    private AgendaEventDatePollService agendaEventDatePollService;
    private ScheduledExecutorService scheduledExecutor;
    private PortalContainer container;
    private Map<Long, Long> eventsToDeleteQueue = new HashMap<Long, Long>();
    private String defaultSite = null;

    public AgendaEventRest(IdentityManager identityManager, UserPortalConfigService portalConfigService, AgendaCalendarService agendaCalendarService, AgendaEventService agendaEventService, AgendaEventConferenceService agendaEventConferenceService, AgendaRemoteEventService agendaRemoteEventService, AgendaEventDatePollService agendaEventDatePollService, AgendaEventReminderService agendaEventReminderService, AgendaEventAttendeeService agendaEventAttendeeService, PortalContainer container) {
        this.identityManager = identityManager;
        this.agendaCalendarService = agendaCalendarService;
        this.agendaEventService = agendaEventService;
        this.agendaEventReminderService = agendaEventReminderService;
        this.agendaEventAttendeeService = agendaEventAttendeeService;
        this.agendaEventConferenceService = agendaEventConferenceService;
        this.agendaRemoteEventService = agendaRemoteEventService;
        this.agendaEventDatePollService = agendaEventDatePollService;
        this.container = container;
        this.defaultSite = portalConfigService != null && portalConfigService.getMetaPortal() != null ? portalConfigService.getMetaPortal() : "dw";
    }

    public void start() {
        this.scheduledExecutor = Executors.newScheduledThreadPool(1);
    }

    public void stop() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves the list of events available for an owner of type user or space", description="Retrieves the list of events available for an owner of type user or space, identitifed by its identity technical identifier. If no designated owner, all events available for authenticated user will be retrieved.", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getEvents(@Parameter(description="Identity technical identifiers of calendar owners") @QueryParam(value="ownerIds") List<Long> ownerIds, @Parameter(description="Attendee identity identifier to filter on events where user is attendee", required=true) @QueryParam(value="attendeeIdentityId") long attendeeIdentityId, @Parameter(description="Properties to expand", required=false) @QueryParam(value="expand") String expand, @Parameter(description="Start datetime using RFC-3339 representation", required=true) @QueryParam(value="start") String start, @Parameter(description="End datetime using RFC-3339 representation", required=false) @QueryParam(value="end") String end, @Parameter(description="IANA Time zone identitifer", required=false) @QueryParam(value="timeZoneId") String timeZoneId, @Parameter(description="Limit of results to return, used only when end date isn't set") @Schema(defaultValue="10") @QueryParam(value="limit") int limit, @Parameter(description="Attendee Response statuses to filter events by attendee response", required=false) @QueryParam(value="responseTypes") List<EventAttendeeResponse> responseTypes) {
        if (StringUtils.isBlank((CharSequence)start)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Start datetime is mandatory").build();
        }
        if (StringUtils.isBlank((CharSequence)timeZoneId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Time zone is mandatory").build();
        }
        ZoneId userTimeZone = StringUtils.isBlank((CharSequence)timeZoneId) ? ZoneOffset.UTC : ZoneId.of(timeZoneId);
        ZonedDateTime endDatetime = null;
        if (StringUtils.isBlank((CharSequence)end)) {
            if (limit <= 0) {
                limit = 10;
            }
        } else {
            endDatetime = AgendaDateUtils.parseRFC3339ToZonedDateTime(end, userTimeZone);
        }
        ZonedDateTime startDatetime = AgendaDateUtils.parseRFC3339ToZonedDateTime(start, userTimeZone);
        if (endDatetime != null && (endDatetime.isBefore(startDatetime) || endDatetime.equals(startDatetime))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Start date must be before end date").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            EventFilter eventFilter = new EventFilter(attendeeIdentityId, ownerIds, responseTypes, startDatetime, endDatetime, limit);
            List events = this.agendaEventService.getEvents(eventFilter, userTimeZone, userIdentityId);
            HashMap attendeesByParentEventId = new HashMap();
            HashMap conferencesByParentEventId = new HashMap();
            HashMap remindersByParentEventId = new HashMap();
            HashMap dateOptionsByParentEventId = new HashMap();
            HashMap remoteEventByParentEventId = new HashMap();
            List expandProperties = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(StringUtils.split((String)expand.replaceAll(" ", ""), (String)","));
            List<EventEntity> eventEntities = events.stream().map(event -> {
                ZonedDateTime occurrenceId;
                EventEntity eventEntity = RestEntityBuilder.fromEvent(this.agendaCalendarService, this.agendaEventService, this.identityManager, event, userTimeZone);
                ZonedDateTime zonedDateTime = occurrenceId = event.getOccurrence() == null ? null : event.getOccurrence().getId();
                if (expandProperties.contains("all") || expandProperties.contains("attendees")) {
                    try {
                        RestUtils.fillAttendees(this.identityManager, this.agendaEventAttendeeService, eventEntity, occurrenceId, attendeesByParentEventId, 0L);
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Error retrieving event reminders, retrieve event without it", (Throwable)e);
                    }
                } else if (expandProperties.contains("response")) {
                    try {
                        RestUtils.fillAttendees(this.identityManager, this.agendaEventAttendeeService, eventEntity, occurrenceId, attendeesByParentEventId, userIdentityId);
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Error retrieving event reminders, retrieve event without it", (Throwable)e);
                    }
                }
                List attendees = eventEntity.getAttendees();
                if (CollectionUtils.isNotEmpty((Collection)responseTypes) && CollectionUtils.isNotEmpty((Collection)attendees)) {
                    for (EventAttendeeEntity attendee : attendees) {
                        if (Long.parseLong(attendee.getIdentity().getId()) != userIdentityId || responseTypes.contains(attendee.getResponse())) continue;
                        return null;
                    }
                }
                if (expandProperties.contains("all") || expandProperties.contains("conferences")) {
                    try {
                        RestUtils.fillConferences(this.agendaEventConferenceService, eventEntity, conferencesByParentEventId);
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Error retrieving event conferences, retrieve event without it", (Throwable)e);
                    }
                }
                if (expandProperties.contains("all") || expandProperties.contains("reminders")) {
                    try {
                        RestUtils.fillReminders(this.agendaEventReminderService, eventEntity, userIdentityId, remindersByParentEventId);
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Error retrieving event reminders, retrieve event without it", (Throwable)e);
                    }
                }
                if (expandProperties.contains("all") || expandProperties.contains("dateOptions")) {
                    try {
                        RestUtils.fillDateOptions(this.agendaEventDatePollService, eventEntity, userTimeZone, dateOptionsByParentEventId);
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Error retrieving event date options, retrieve event without it", (Throwable)e);
                    }
                }
                RestUtils.fillRemoteEvent(this.agendaRemoteEventService, eventEntity, userIdentityId);
                if (eventEntity.getParent() != null) {
                    RestUtils.fillRemoteEvent(this.agendaRemoteEventService, eventEntity.getParent(), userIdentityId, remoteEventByParentEventId);
                }
                if (RestUtils.isComputedOccurrence(eventEntity)) {
                    RestUtils.cleanupAttachedEntitiesIds(eventEntity);
                }
                return eventEntity;
            }).filter(Objects::nonNull).toList();
            EventList eventList = new EventList();
            eventList.setEvents(eventEntities);
            eventList.setStart(start);
            eventList.setEnd(end);
            eventList.setLimit(limit);
            return Response.ok((Object)eventList).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to access not authorized events of owner Id '{}'", new Object[]{RestUtils.getCurrentUser(), ownerIds, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of events", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{eventId}")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves an event identified by its technical identifier", description="Retrieves an event identified by its technical identifier", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getEventById(@Parameter(description="Event technical identifier", required=true) @PathParam(value="eventId") long eventId, @Parameter(description="Properties to expand") @QueryParam(value="expand") String expand, @Parameter(description="IANA Time zone identitifer") @QueryParam(value="timeZoneId") String timeZoneId, @Parameter(description="Whether to retrieve first occurrence or not") @QueryParam(value="firstOccurrence") boolean firstOccurrence) {
        if (eventId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event identifier must be a positive integer").build();
        }
        String currentUser = RestUtils.getCurrentUser();
        try {
            List<String> expandProperties = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(StringUtils.split((String)expand.replaceAll(" ", ""), (String)","));
            ZoneId userTimeZone = StringUtils.isBlank((CharSequence)timeZoneId) ? ZoneOffset.UTC : ZoneId.of(timeZoneId);
            EventEntity eventEntity = RestUtils.getEventByIdAndUser(this.identityManager, this.agendaCalendarService, this.agendaEventService, this.agendaRemoteEventService, this.agendaEventDatePollService, this.agendaEventReminderService, this.agendaEventConferenceService, this.agendaEventAttendeeService, eventId, firstOccurrence, RestUtils.getCurrentUserIdentityId(this.identityManager), null, userTimeZone, expandProperties);
            if (eventEntity == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)eventEntity).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to access not authorized event with Id '{}'", new Object[]{currentUser, eventId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn("Error retrieving event with id '{}'", new Object[]{eventId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="occurrence/{parentEventId}/{occurrenceId}")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves an event identified by its technical identifier", description="Retrieves an event identified by its technical identifier", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getEventOccurrence(@Parameter(description="Event technical identifier", required=true) @PathParam(value="parentEventId") long parentEventId, @Parameter(description="Event technical identifier", required=true) @PathParam(value="occurrenceId") String occurrenceId, @Parameter(description="Properties to expand") @QueryParam(value="expand") String expand, @Parameter(description="IANA Time zone identitifer") @QueryParam(value="timeZoneId") String timeZoneId) {
        if (parentEventId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event identifier must be a positive integer").build();
        }
        if (StringUtils.isBlank((CharSequence)"occurrenceId")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event occurrence identifier is mandatory").build();
        }
        try {
            List<String> expandProperties = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(StringUtils.split((String)expand.replaceAll(" ", ""), (String)","));
            ZoneId userTimeZone = StringUtils.isBlank((CharSequence)timeZoneId) ? ZoneOffset.UTC : ZoneId.of(timeZoneId);
            long identityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
            ZonedDateTime occurrenceDate = AgendaDateUtils.parseRFC3339ToZonedDateTime(occurrenceId, ZoneOffset.UTC);
            Event event = this.agendaEventService.getEventOccurrence(parentEventId, occurrenceDate, userTimeZone, identityId);
            if (event == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            EventEntity eventEntity = RestUtils.getEventEntity(this.identityManager, this.agendaCalendarService, this.agendaEventService, this.agendaRemoteEventService, this.agendaEventDatePollService, this.agendaEventReminderService, this.agendaEventConferenceService, this.agendaEventAttendeeService, event, occurrenceDate, userTimeZone, expandProperties);
            return Response.ok((Object)eventEntity).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to access not authorized event with parentId '{}' and occurrenceId '{}'", new Object[]{RestUtils.getCurrentUser(), parentEventId, occurrenceId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn("Error retrieving event with parentId '{}' and occurrenceId '{}'", new Object[]{RestUtils.getCurrentUser(), parentEventId, occurrenceId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{eventId}/exceptionalOccurrences")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves the list of exceptional occurrences of an event", description="Retrieves the list of exceptional occurrences of an event", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getEventExceptionalOccurrences(@Parameter(description="Event technical identifier", required=true) @PathParam(value="eventId") long parentEventId, @Parameter(description="Properties to expand") @QueryParam(value="expand") String expand, @Parameter(description="IANA Time zone identitifer") @QueryParam(value="timeZoneId") String timeZoneId) {
        List expandProperties = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(StringUtils.split((String)expand.replaceAll(" ", ""), (String)","));
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            ZoneId userTimeZone = StringUtils.isBlank((CharSequence)timeZoneId) ? ZoneOffset.UTC : ZoneId.of(timeZoneId);
            List events = this.agendaEventService.getExceptionalOccurrenceEvents(parentEventId, userTimeZone, userIdentityId);
            List eventEntities = events.stream().map(event -> RestUtils.getEventEntity(this.identityManager, this.agendaCalendarService, this.agendaEventService, this.agendaRemoteEventService, this.agendaEventDatePollService, this.agendaEventReminderService, this.agendaEventConferenceService, this.agendaEventAttendeeService, event, null, userTimeZone, expandProperties)).collect(Collectors.toList());
            return Response.ok(eventEntities).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to access not authorized events", new Object[]{RestUtils.getCurrentUser(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of events", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Create a new event", description="Create a new event", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response createEvent(@Parameter(description="IANA Time zone identitifer") @QueryParam(value="timeZoneId") String timeZoneId, @Parameter(description="Event object to create", required=true) EventEntity eventEntity) {
        if (eventEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)AgendaExceptionType.EVENT_MANDATORY.getCompleteMessage()).build();
        }
        if (eventEntity.getCalendar() == null || eventEntity.getCalendar().getOwner() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)AgendaExceptionType.CALENDAR_OWNER_NOT_FOUND).build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            Event event = RestUtils.createEventEntity(this.identityManager, this.agendaCalendarService, this.agendaEventService, eventEntity, userIdentityId, timeZoneId);
            return this.getEventById(event.getId(), "all", timeZoneId == null ? event.getTimeZoneId().getId() : timeZoneId, false);
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to create an event in calendar '{}'", new Object[]{RestUtils.getCurrentUser(), eventEntity.getCalendar(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (AgendaException e) {
            LOG.debug((Object)"Error in event validation", (Throwable)e);
            return Response.serverError().entity((Object)e.getAgendaExceptionType().getCompleteMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error creating an event", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Update an existing event", description="Update an existing event", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Object not found"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateEvent(@Parameter(description="Event object to update", required=true) EventEntity eventEntity, @Parameter(description="IANA Time zone identitifer") @QueryParam(value="timeZoneId") String timeZoneId) {
        if (eventEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)AgendaExceptionType.EVENT_MANDATORY.getCompleteMessage()).build();
        }
        if (eventEntity.getId() <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)AgendaExceptionType.EVENT_ID_MANDATORY.getCompleteMessage()).build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            RestUtils.checkCalendar(this.identityManager, this.agendaCalendarService, eventEntity);
            List attendeeEntities = eventEntity.getAttendees();
            ArrayList<EventAttendee> attendees = null;
            if (attendeeEntities != null && !attendeeEntities.isEmpty()) {
                attendees = new ArrayList<EventAttendee>();
                for (EventAttendeeEntity attendeeEntity : attendeeEntities) {
                    attendees.add(RestEntityBuilder.toEventAttendee(this.identityManager, eventEntity.getId(), attendeeEntity));
                }
            }
            Event event = RestEntityBuilder.toEvent(eventEntity);
            List reminderEntities = eventEntity.getReminders();
            ArrayList<EventReminder> reminders = null;
            if (reminderEntities != null && !reminderEntities.isEmpty()) {
                reminders = new ArrayList<EventReminder>();
                for (EventReminderEntity reminderEntity : reminderEntities) {
                    reminders.add(RestEntityBuilder.toEventReminder(eventEntity.getId(), reminderEntity));
                }
            }
            RemoteEvent remoteEvent = RestUtils.getRemoteEvent(eventEntity, userIdentityId);
            String userTimeZoneId = timeZoneId == null ? event.getTimeZoneId().getId() : timeZoneId;
            ZoneId userTimeZone = userTimeZoneId == null ? ZoneOffset.UTC : ZoneId.of(userTimeZoneId);
            List dateOptionEntities = eventEntity.getDateOptions();
            List dateOptions = dateOptionEntities == null ? Collections.emptyList() : dateOptionEntities.stream().map(dateOptionEntity -> RestEntityBuilder.toEventDateOption(dateOptionEntity, userTimeZone)).collect(Collectors.toList());
            this.agendaEventService.updateEvent(event, attendees, eventEntity.getConferences(), reminders, dateOptions, remoteEvent, eventEntity.isSendInvitation(), userIdentityId);
            return this.getEventById(event.getId(), "all", userTimeZoneId, false);
        }
        catch (AgendaException e) {
            LOG.debug((Object)"Error in event validation", (Throwable)e);
            return Response.serverError().entity((Object)e.getAgendaExceptionType().getCompleteMessage()).build();
        }
        catch (IllegalAccessException e) {
            LOG.error("User '{}' attempts to update a non authorized event", new Object[]{RestUtils.getCurrentUser(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error updating an event", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{eventId}")
    @PATCH
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Update an attribute of an existing event", description="Update an attribute of an existing event", method="PATCH")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Object not found"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateEventFields(@Parameter(description="Event technical identifier", required=true) @PathParam(value="eventId") long eventId, @Parameter(description="Update all event occurrences or only parent occurrence") @Schema(defaultValue="false") @QueryParam(value="updateAllOccurrences") boolean updateAllOccurrences, @Parameter(description="Whether notify attendees about the modification or not") @Schema(defaultValue="false") @QueryParam(value="sendInvitations") boolean sendInvitations, @Parameter(description="IANA Time zone identitifer", required=false) @QueryParam(value="timeZoneId") String timeZoneId, @Parameter(description="Event fields to patch", required=true) MultivaluedMap<String, String> eventFields) {
        if (eventId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)AgendaExceptionType.EVENT_ID_MANDATORY.getCompleteMessage()).build();
        }
        if (eventFields == null || eventFields.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)AgendaExceptionType.EVENT_FIELDS_MANDATORY.getCompleteMessage()).build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            Event event = this.agendaEventService.getEventById(eventId, (ZoneId)ZoneOffset.UTC, userIdentityId);
            if (event == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Event not found").build();
            }
            if (eventFields.containsKey((Object)"remoteId") || eventFields.containsKey((Object)"remoteProviderId") || eventFields.containsKey((Object)"remoteProviderName")) {
                String remoteId = eventFields.containsKey((Object)"remoteId") ? (String)((List)eventFields.get((Object)"remoteId")).get(0) : null;
                String remoteProviderId = eventFields.containsKey((Object)"remoteProviderId") ? (String)((List)eventFields.get((Object)"remoteProviderId")).get(0) : null;
                String remoteProviderName = eventFields.containsKey((Object)"remoteProviderName") ? (String)((List)eventFields.get((Object)"remoteProviderName")).get(0) : null;
                RemoteEvent remoteEvent = new RemoteEvent(0L, eventId, userIdentityId, remoteId, remoteProviderId == null ? 0L : Long.parseLong(remoteProviderId), remoteProviderName);
                this.agendaRemoteEventService.saveRemoteEvent(eventId, remoteEvent, userIdentityId);
            }
            eventFields.remove((Object)"remoteId");
            eventFields.remove((Object)"remoteProviderId");
            eventFields.remove((Object)"remoteProviderName");
            if (!eventFields.isEmpty()) {
                this.agendaEventService.updateEventFields(eventId, eventFields, updateAllOccurrences, sendInvitations, userIdentityId);
            }
            ZoneId userTimeZone = timeZoneId == null ? null : ZoneId.of(timeZoneId);
            EventEntity eventEntity = RestUtils.getEventByIdAndUser(this.identityManager, this.agendaCalendarService, this.agendaEventService, this.agendaRemoteEventService, this.agendaEventDatePollService, this.agendaEventReminderService, this.agendaEventConferenceService, this.agendaEventAttendeeService, eventId, false, userIdentityId, null, userTimeZone, Collections.singletonList("all"));
            return Response.ok((Object)eventEntity).build();
        }
        catch (AgendaException e) {
            LOG.debug((Object)"Error in event validation", (Throwable)e);
            return Response.serverError().entity((Object)e.getAgendaExceptionType().getCompleteMessage()).build();
        }
        catch (IllegalAccessException e) {
            LOG.error("User '{}' attempts to update a non authorized event", new Object[]{RestUtils.getCurrentUser(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error updating an event", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="{eventId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Delete an existing event or delay deleting an existing event with a fixed period.", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Object not found"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteEvent(@Parameter(description="Event technical identifier", required=true) @PathParam(value="eventId") long eventId, @Parameter(description="Time to effectively delete event", required=false) @QueryParam(value="delay") long delay, @Parameter(description="IANA Time zone identitifer", required=false) @QueryParam(value="timeZoneId") String timeZoneId) {
        if (eventId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event technical identifier must be positive").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            ZoneId userTimeZone = timeZoneId == null ? null : ZoneId.of(timeZoneId);
            EventEntity eventEntity = RestUtils.getEventByIdAndUser(this.identityManager, this.agendaCalendarService, this.agendaEventService, this.agendaRemoteEventService, this.agendaEventDatePollService, this.agendaEventReminderService, this.agendaEventConferenceService, this.agendaEventAttendeeService, eventId, false, userIdentityId, null, userTimeZone, Collections.singletonList("all"));
            if (eventEntity == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Event not found").build();
            }
            if (delay > 0L) {
                this.eventsToDeleteQueue.put(eventId, userIdentityId);
                this.scheduledExecutor.schedule(() -> {
                    if (this.eventsToDeleteQueue.containsKey(eventId)) {
                        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
                        RequestLifeCycle.begin((ExoContainer)this.container);
                        try {
                            this.eventsToDeleteQueue.remove(eventId);
                            this.agendaEventService.deleteEventById(eventId, userIdentityId);
                        }
                        catch (IllegalAccessException e) {
                            LOG.error("User '{}' attempts to delete a non authorized event", new Object[]{userIdentityId, e});
                        }
                        catch (Exception e) {
                            LOG.warn((Object)"Error deleting an event", (Throwable)e);
                        }
                        finally {
                            RequestLifeCycle.end();
                        }
                    }
                }, delay, TimeUnit.SECONDS);
            } else {
                this.eventsToDeleteQueue.remove(eventId);
                this.agendaEventService.deleteEventById(eventId, userIdentityId);
            }
            return Response.ok((Object)eventEntity).build();
        }
        catch (IllegalAccessException e) {
            LOG.error("User '{}' attempts to delete a non authorized event", new Object[]{RestUtils.getCurrentUser(), e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error deleting an event", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{eventId}/undoDelete")
    @POST
    @RolesAllowed(value={"users"})
    @Operation(summary="Undo deleting event if not yet effectively deleted", description="Undo deleting event if not yet effectively deleted", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Forbidden operation"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response undoDeleteEvent(@Parameter(description="Event technical identifier", required=true) @PathParam(value="eventId") long eventId) {
        if (eventId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event identifier must be a positive integer").build();
        }
        if (this.eventsToDeleteQueue.containsKey(eventId)) {
            long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
            Long originalModifierUserId = this.eventsToDeleteQueue.get(eventId);
            if (originalModifierUserId != userIdentityId) {
                LOG.warn("User {} attempts to cancel deletion of an event deleted by user {}", new Object[]{userIdentityId, originalModifierUserId});
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            this.eventsToDeleteQueue.remove(eventId);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event id was already deleted or isn't planned to be deleted").build();
    }

    @POST
    @Path(value="{eventId}/selectDateOption/{dateOptionId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Select an Date Option for an event having multiple dates options", description="Select an Date Option for an event having multiple dates options", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Object not found"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response selectEventDateOption(@Parameter(description="Event technical identifier", required=true) @PathParam(value="eventId") long eventId, @Parameter(description="Event date option technical identifier", required=true) @PathParam(value="dateOptionId") long dateOptionId) {
        if (eventId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event identifier must be a positive integer").build();
        }
        if (dateOptionId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event date option identifier must be a positive integer").build();
        }
        Identity identity = RestUtils.getCurrentUserIdentity(this.identityManager);
        if (identity == null) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        long userIdentityId = Long.parseLong(identity.getId());
        try {
            this.agendaEventService.selectEventDateOption(eventId, dateOptionId, userIdentityId);
            return Response.noContent().build();
        }
        catch (ObjectNotFoundException e) {
            LOG.debug("User '{}' attempts to select date option a not existing event '{}'", new Object[]{userIdentityId, eventId, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Event Date Option not found").build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to select Date Option on a not authorized event with Id '{}'", new Object[]{RestUtils.getCurrentUser(), eventId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn("Error voting on event with id '{}' with date option '{}'", new Object[]{eventId, dateOptionId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{eventId}/reminders")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieve preferred reminders for currently authenticated user for an event", description="Retrieve preferred reminders for currently authenticated user for an event identified by its technical identifier.", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getEventRemindersById(@Parameter(description="Event technical identifier", required=true) @PathParam(value="eventId") long eventId) {
        if (eventId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event identifier must be a positive integer").build();
        }
        long identityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            List reminders = this.agendaEventReminderService.getEventReminders(eventId, identityId);
            if (reminders == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)reminders).build();
        }
        catch (Exception e) {
            LOG.warn("Error retrieving event reminders with id '{}'", new Object[]{eventId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{eventId}/reminders")
    @PUT
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Update the list of preferred reminders for authenticated user on a selected event.", description="Update the list of preferred reminders for authenticated user on a selected event", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response saveEventReminders(@Parameter(description="Event technical identifier", required=true) @PathParam(value="eventId") long eventId, @Parameter(description="Event occurrence identifier", required=true) @QueryParam(value="occurrenceId") String occurrenceId, @Parameter(description="Whether apply on Event occurrence and its upcoming or not", required=true) @QueryParam(value="upcoming") boolean upcoming, @Parameter(description="List of reminders to store on event for currently authenticated user", required=true) List<EventReminder> reminders) {
        if (eventId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event identifier must be a positive integer").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            Event event = this.agendaEventService.getEventById(eventId, null, userIdentityId);
            if (event == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Event with id " + eventId + " is not found")).build();
            }
            if (StringUtils.isBlank((CharSequence)occurrenceId)) {
                this.agendaEventReminderService.saveEventReminders(event, reminders, userIdentityId);
            } else {
                if (event.getRecurrence() == null) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event is not recurrent, no occurrenceId is needed").build();
                }
                ZonedDateTime occurrenceIdDateTime = AgendaDateUtils.parseRFC3339ToZonedDateTime(occurrenceId, ZoneOffset.UTC);
                if (upcoming) {
                    this.agendaEventReminderService.saveUpcomingEventReminders(eventId, occurrenceIdDateTime, reminders, userIdentityId);
                } else {
                    Event occurrenceEvent = this.agendaEventService.saveEventExceptionalOccurrence(eventId, occurrenceIdDateTime);
                    this.agendaEventReminderService.saveEventReminders(occurrenceEvent, reminders, userIdentityId);
                }
            }
            return Response.noContent().build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to access reminders for a not authorized event with Id '{}'", new Object[]{userIdentityId, eventId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn("Error updating event reminders with id '{}'", new Object[]{eventId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{eventId}/response")
    @GET
    @Produces(value={"text/plain"})
    @Operation(summary="Retrieves currently authenticated user response to an event", description="Retrieves currently authenticated (using token or effectively authenticated) user response to an event.", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Forbidden operation"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getEventResponse(@Parameter(description="Event technical identifier", required=true) @PathParam(value="eventId") long eventId, @Parameter(description="Event occurrence identifier") @QueryParam(value="occurrenceId") String occurrenceId, @Parameter(description="User token to ", required=false) @QueryParam(value="token") String token) {
        if (eventId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event identifier must be a positive integer").build();
        }
        long identityId = 0L;
        try {
            Identity identity = null;
            identity = StringUtils.isNotBlank((CharSequence)token) ? this.agendaEventAttendeeService.decryptUserIdentity(eventId, token, null) : RestUtils.getCurrentUserIdentity(this.identityManager);
            if (identity == null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            identityId = Long.parseLong(identity.getId());
            ZonedDateTime occurrenceIdDateTime = AgendaDateUtils.parseRFC3339ToZonedDateTime(occurrenceId, ZoneOffset.UTC);
            EventAttendeeResponse response = this.agendaEventAttendeeService.getEventResponse(eventId, occurrenceIdDateTime, identityId);
            return Response.ok((Object)response.getValue()).build();
        }
        catch (ObjectNotFoundException e) {
            LOG.debug("User '{}' attempts to get event response of a not existing event '{}'", new Object[]{identityId, eventId, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Event not found").build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to access invitation response for a not authorized event with Id '{}'", new Object[]{RestUtils.getCurrentUser(), eventId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn("Error retrieving event response with id '{}'", new Object[]{eventId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{eventId}/votes")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Registers voted date poll options for currently authenticated user", description="Registers voted date poll options for currently authenticated user", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Forbidden operation"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response voteEvent(@Parameter(description="Event technical identifier", required=true) @PathParam(value="eventId") long eventId, @Parameter(description="Accepted event date options technical identifier") @FormParam(value="dateOptionId") List<Long> dateOptionId) {
        if (eventId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event identifier must be a positive integer").build();
        }
        if (dateOptionId == null) {
            dateOptionId = Collections.emptyList();
        }
        long identityId = 0L;
        try {
            Identity identity = RestUtils.getCurrentUserIdentity(this.identityManager);
            if (identity == null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            identityId = Long.parseLong(identity.getId());
            this.agendaEventDatePollService.saveEventVotes(eventId, dateOptionId, identityId);
            return Response.noContent().build();
        }
        catch (ObjectNotFoundException e) {
            LOG.debug("User '{}' attempts to vote on non existing event '{}'", new Object[]{identityId, eventId, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Event with id " + eventId + " not found")).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to vote on a not authorized event with Id '{}'", new Object[]{RestUtils.getCurrentUser(), eventId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn("Error voting on event with id '{}'", new Object[]{eventId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{eventId}/votes/{dateOptionId}")
    @POST
    @RolesAllowed(value={"users"})
    @Operation(summary="Registers voted date poll option for currently authenticated user", description="Registers voted date poll option for currently authenticated user", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Forbidden operation"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response voteEventDateOption(@Parameter(description="Event technical identifier", required=true) @PathParam(value="eventId") long eventId, @Parameter(description="Event date option technical identifier", required=true) @PathParam(value="dateOptionId") long dateOptionId) {
        if (eventId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event identifier must be a positive integer").build();
        }
        if (dateOptionId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event date option identifier must be a positive integer").build();
        }
        long identityId = 0L;
        try {
            Identity identity = RestUtils.getCurrentUserIdentity(this.identityManager);
            if (identity == null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            identityId = Long.parseLong(identity.getId());
            this.agendaEventDatePollService.voteDateOption(dateOptionId, identityId);
            return Response.noContent().build();
        }
        catch (ObjectNotFoundException e) {
            LOG.debug("User '{}' attempts to vote on non existing event '{}' with date option '{}'", new Object[]{identityId, eventId, dateOptionId, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Date option with id " + dateOptionId + " not found")).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to vote on a not authorized event with Id '{}'", new Object[]{RestUtils.getCurrentUser(), eventId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn("Error voting on event with id '{}' with date option '{}'", new Object[]{eventId, dateOptionId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{eventId}/votes/{dateOptionId}")
    @DELETE
    @RolesAllowed(value={"users"})
    @Operation(summary="Dismisses vote on date poll option for currently authenticated user", description="Dismisses vote on date poll option for currently authenticated user", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="403", description="Forbidden operation"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response dismissEventDateOption(@Parameter(description="Event technical identifier", required=true) @PathParam(value="eventId") long eventId, @Parameter(description="Event date option technical identifier", required=true) @PathParam(value="dateOptionId") long dateOptionId) {
        if (eventId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event identifier must be a positive integer").build();
        }
        if (dateOptionId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event date option identifier must be a positive integer").build();
        }
        long identityId = 0L;
        try {
            Identity identity = RestUtils.getCurrentUserIdentity(this.identityManager);
            if (identity == null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            identityId = Long.parseLong(identity.getId());
            this.agendaEventDatePollService.dismissDateOption(dateOptionId, identityId);
            return Response.noContent().build();
        }
        catch (ObjectNotFoundException e) {
            LOG.debug("User '{}' attempts to dismiss vote on non existing event '{}' with date option '{}'", new Object[]{identityId, eventId, dateOptionId, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Date option with id " + dateOptionId + " not found")).build();
        }
        catch (Exception e) {
            LOG.warn("Error dismissing vote on event with id '{}' with date option '{}'", new Object[]{eventId, dateOptionId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="{eventId}/response/send")
    @GET
    @Operation(summary="Send event invitation response for currently authenticated user", description="Send event invitation response for currently authenticated user (using token or effectively authenticated)", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response sendEventResponse(@Parameter(description="Event technical identifier", required=true) @PathParam(value="eventId") long eventId, @Parameter(description="Event occurrence identifier") @QueryParam(value="occurrenceId") String occurrenceId, @Parameter(description="Response to event invitation. Possible values: ACCEPTED, DECLINED or TENTATIVE.", required=true) @QueryParam(value="response") String responseString, @Parameter(description="Whether apply response on upcoming event of a recurrent event or not") @QueryParam(value="upcoming") boolean upcoming, @Parameter(description="User token used to identify user and his response to apply new reponse even when user is not authenticated") @QueryParam(value="token") String token, @Parameter(description="Whether redirect to Event details after applying new response or not") @Schema(defaultValue="false") @QueryParam(value="redirect") boolean redirect) {
        if (eventId <= 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event identifier must be a positive integer").build();
        }
        if (StringUtils.isBlank((CharSequence)responseString)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event response is mandatory").build();
        }
        EventAttendeeResponse response = EventAttendeeResponse.fromValue((String)responseString);
        if (response == null || response == EventAttendeeResponse.NEEDS_ACTION) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event response is not recognized").build();
        }
        if (upcoming && StringUtils.isBlank((CharSequence)occurrenceId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Event occurrenceId is mandatory when having upcoming = true").build();
        }
        String currentUser = RestUtils.getCurrentUser();
        try {
            Identity identity = null;
            if (StringUtils.isNotBlank((CharSequence)token)) {
                identity = this.agendaEventAttendeeService.decryptUserIdentity(eventId, token, response);
                currentUser = identity.getRemoteId();
            } else if (StringUtils.isNotBlank((CharSequence)currentUser)) {
                identity = this.identityManager.getOrCreateIdentity("organization", currentUser);
            }
            if (identity == null) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            long identityId = Long.parseLong(identity.getId());
            if (!this.agendaEventAttendeeService.isEventAttendee(eventId, identityId)) {
                throw new IllegalAccessException("User " + currentUser + " isn't attendee of event with id " + eventId);
            }
            if (StringUtils.isBlank((CharSequence)occurrenceId)) {
                this.agendaEventAttendeeService.sendEventResponse(eventId, identityId, response);
            } else {
                ZonedDateTime occurrenceIdDateTime = AgendaDateUtils.parseRFC3339ToZonedDateTime(occurrenceId, ZoneOffset.UTC);
                if (upcoming) {
                    this.agendaEventAttendeeService.sendUpcomingEventResponse(eventId, occurrenceIdDateTime, identityId, response);
                } else {
                    Event occurrenceEvent = this.agendaEventService.getExceptionalOccurrenceEvent(eventId, occurrenceIdDateTime);
                    if (occurrenceEvent == null) {
                        occurrenceEvent = this.agendaEventService.saveEventExceptionalOccurrence(eventId, occurrenceIdDateTime);
                    }
                    this.agendaEventAttendeeService.sendEventResponse(occurrenceEvent.getId(), identityId, response);
                }
            }
            if (redirect) {
                URI location = new URI("/portal/" + this.defaultSite + "/agenda?eventId=" + eventId);
                return Response.seeOther((URI)location).build();
            }
            return Response.noContent().build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Event not found").build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to send invitation response for a not authorized event with Id '{}'", new Object[]{currentUser, eventId});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn("Error sending event invitation response for event with id '{}'", new Object[]{eventId, e});
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="search")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Search the list of events available with query for an owner of type user or space", description="Search the list of events available with query for an owner of type user or space, identified by its identity technical identifier. If no designated owner, all events available for authenticated user will be retrieved.", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response search(@Parameter(description="Term to search", required=true) @QueryParam(value="query") String query, @Parameter(description="IANA Time zone identitifer") @QueryParam(value="timeZoneId") String timeZoneId, @Parameter(description="Properties to expand") @QueryParam(value="expand") String expand, @Parameter(description="Offset") @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit") @Schema(defaultValue="20") @QueryParam(value="limit") int limit) throws Exception {
        if (offset < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Offset must be 0 or positive").build();
        }
        if (limit < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Limit must be positive").build();
        }
        List expandProperties = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(StringUtils.split((String)expand.replaceAll(" ", ""), (String)","));
        long currentUserId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        ZoneId userTimeZone = StringUtils.isBlank((CharSequence)timeZoneId) ? ZoneOffset.UTC : ZoneId.of(timeZoneId);
        List searchResults = this.agendaEventService.search(currentUserId, userTimeZone, query, offset, limit);
        List results = searchResults.stream().map(searchResult -> RestUtils.getEventSearchResultEntity(this.identityManager, this.agendaCalendarService, this.agendaEventService, this.agendaRemoteEventService, this.agendaEventDatePollService, this.agendaEventReminderService, this.agendaEventConferenceService, this.agendaEventAttendeeService, searchResult, null, userTimeZone, expandProperties)).collect(Collectors.toList());
        return Response.ok(results).build();
    }

    @Path(value="datePolls")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves the list of pending date polls for currently authenticated user", description="Retrieves the list of pending date polls for currently authenticated user.", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getDatePolls(@Parameter(description="Identity technical identifiers of calendar owners") @QueryParam(value="ownerIds") List<Long> ownerIds, @Parameter(description="Offset") @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit of results to return") @QueryParam(value="limit") int limit, @Parameter(description="Start datetime using RFC-3339 representation", required=true) @QueryParam(value="start") String start, @Parameter(description="End datetime using RFC-3339 representation") @QueryParam(value="end") String end, @Parameter(description="IANA Time zone identitifer") @QueryParam(value="timeZoneId") String timeZoneId, @Parameter(description="Properties to expand") @QueryParam(value="expand") String expand) {
        if (offset < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Offset must be 0 or positive").build();
        }
        ZoneId userTimeZone = StringUtils.isBlank((CharSequence)timeZoneId) ? ZoneOffset.UTC : ZoneId.of(timeZoneId);
        ZonedDateTime endDatetime = null;
        if (StringUtils.isBlank((CharSequence)end)) {
            if (limit <= 0) {
                limit = 10;
            }
        } else {
            endDatetime = AgendaDateUtils.parseRFC3339ToZonedDateTime(end, userTimeZone);
        }
        ZonedDateTime startDatetime = null;
        if (StringUtils.isBlank((CharSequence)start)) {
            if (limit <= 0) {
                limit = 10;
            }
        } else {
            startDatetime = AgendaDateUtils.parseRFC3339ToZonedDateTime(start, userTimeZone);
        }
        if (endDatetime != null && startDatetime != null && (endDatetime.isBefore(startDatetime) || endDatetime.equals(startDatetime))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Start date must be before end date").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        try {
            EventList eventList = new EventList();
            eventList.setLimit(limit);
            EventFilter eventFilter = startDatetime != null && endDatetime != null ? new EventFilter(ownerIds, startDatetime, endDatetime) : new EventFilter(ownerIds, offset, limit);
            List events = this.agendaEventService.getEventDatePolls(eventFilter, userTimeZone, userIdentityId);
            List expandProperties = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(StringUtils.split((String)expand.replaceAll(" ", ""), (String)","));
            List eventEntities = events.stream().map(event -> RestUtils.getEventEntity(this.identityManager, this.agendaCalendarService, this.agendaEventService, this.agendaRemoteEventService, this.agendaEventDatePollService, this.agendaEventReminderService, this.agendaEventConferenceService, this.agendaEventAttendeeService, event, null, userTimeZone, expandProperties)).collect(Collectors.toList());
            eventList.setEvents(eventEntities);
            eventList.setSize(this.agendaEventService.countEventDatePolls(ownerIds, userIdentityId));
            return Response.ok((Object)eventList).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of events", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="pending")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Retrieves the list of pending events for currently authenticated user", description="Retrieves the list of pending events for currently authenticated user.", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getPendingEvents(@Parameter(description="Identity technical identifiers of calendar owners") @QueryParam(value="ownerIds") List<Long> ownerIds, @Parameter(description="Offset") @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit of results to return") @QueryParam(value="limit") int limit, @Parameter(description="IANA Time zone identitifer") @QueryParam(value="timeZoneId") String timeZoneId, @Parameter(description="Properties to expand") @QueryParam(value="expand") String expand) {
        if (offset < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Offset must be 0 or positive").build();
        }
        if (limit < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Limit must be positive").build();
        }
        long userIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        ZoneId userTimeZone = StringUtils.isBlank((CharSequence)timeZoneId) ? ZoneOffset.UTC : ZoneId.of(timeZoneId);
        try {
            EventList eventList = new EventList();
            eventList.setLimit(limit);
            if (limit > 0) {
                List events = this.agendaEventService.getPendingEvents(ownerIds, userIdentityId, userTimeZone, offset, limit);
                List expandProperties = StringUtils.isBlank((CharSequence)expand) ? Collections.emptyList() : Arrays.asList(StringUtils.split((String)expand.replaceAll(" ", ""), (String)","));
                List eventEntities = events.stream().map(event -> RestUtils.getEventEntity(this.identityManager, this.agendaCalendarService, this.agendaEventService, this.agendaRemoteEventService, this.agendaEventDatePollService, this.agendaEventReminderService, this.agendaEventConferenceService, this.agendaEventAttendeeService, event, null, userTimeZone, expandProperties)).collect(Collectors.toList());
                eventList.setEvents(eventEntities);
            }
            eventList.setSize(this.agendaEventService.countPendingEvents(ownerIds, userIdentityId));
            return Response.ok((Object)eventList).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of pending events", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="ics")
    @GET
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Returns the ICS file generated from this event", description="Returns the ICS file generated from this event.", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query parameters"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getICSOfEvent(@Context HttpServletRequest request, @Parameter(description="The event Id") @QueryParam(value="eventId") long eventId, @Parameter(description="the timezone ID of the target user") @QueryParam(value="timeZoneId") String timeZoneId) {
        try {
            Identity currentUserIdentity;
            if (eventId <= 0L) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"the eventId param is required").build();
            }
            if (StringUtils.isBlank((CharSequence)timeZoneId)) {
                timeZoneId = TimeZone.getDefault().getID();
            }
            if ((currentUserIdentity = this.identityManager.getOrCreateUserIdentity(request.getRemoteUser())) == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"the identity Id is not the one of the current user").build();
            }
            Event event = this.agendaEventService.getEventById(eventId, ZoneId.of(timeZoneId), Long.parseLong(currentUserIdentity.getId()));
            String eventCreator = "";
            Identity eventCreatorIdentity = this.identityManager.getIdentity(String.valueOf(event.getCreatorId()));
            if (eventCreatorIdentity != null) {
                eventCreator = eventCreatorIdentity.getProfile().getFullName();
            }
            List eventConferences = this.agendaEventConferenceService.getEventConferences(event.getId());
            String conferenceURL = "";
            if (eventConferences != null && !eventConferences.isEmpty()) {
                conferenceURL = ((EventConference)eventConferences.getFirst()).getUrl();
            }
            byte[] iCSContent = Utils.generateIcsFile(String.valueOf(this.agendaCalendarService.getCalendarById(event.getCalendarId()).getOwnerId()), event.getSummary(), HtmlUtils.transform((String)event.getDescription(), null), AgendaDateUtils.toRFC3339Date(event.getStart()), AgendaDateUtils.toRFC3339Date(event.getEnd()), conferenceURL, String.valueOf(event.getModifierId()), eventCreator, event.getLocation(), Locale.of(Utils.getUserLanguage(request.getRemoteUser())), ZoneId.of(timeZoneId));
            return Response.ok((Object)new String(iCSContent, StandardCharsets.UTF_8)).build();
        }
        catch (Exception e) {
            LOG.error("Could not generate ICS for event {}", new Object[]{eventId, e});
            return Response.serverError().entity((Object)("Could not generate ICS for event " + eventId + " : " + e.getMessage())).build();
        }
    }
}

