/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.plugin;

import io.meeds.portal.plugin.AclPlugin;
import jakarta.annotation.PostConstruct;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AgendaEventAclPlugin
implements AclPlugin {
    public static final String OBJECT_TYPE = "agendaEvent";
    @Autowired
    private AgendaEventService agendaEventService;
    @Autowired
    private PortalContainer container;
    @Autowired
    private IdentityManager identityManager;

    @PostConstruct
    public void init() {
        ((UserACL)this.container.getComponentInstanceOfType(UserACL.class)).addAclPlugin((AclPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasPermission(String objectId, String permissionType, Identity identity) {
        Event event = this.agendaEventService.getEventById(Long.parseLong(objectId));
        if (event == null || identity == null) {
            return false;
        }
        return switch (permissionType) {
            case "VIEW" -> this.agendaEventService.canAccessEvent(event, this.getUserIdentityId(identity.getUserId()));
            case "EDIT", "DELETE" -> this.agendaEventService.canUpdateEvent(event, this.getUserIdentityId(identity.getUserId()));
            default -> false;
        };
    }

    private long getUserIdentityId(String username) {
        return Long.parseLong(this.identityManager.getOrCreateUserIdentity(username).getId());
    }
}

