/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.plugin;

import io.meeds.social.cms.model.ContentLinkExtension;
import io.meeds.social.cms.model.ContentLinkSearchResult;
import io.meeds.social.cms.plugin.ContentLinkPlugin;
import io.meeds.social.cms.service.ContentLinkPluginService;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.agenda.model.AgendaEventSearchFilter;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventSearchResult;
import org.exoplatform.agenda.service.AgendaEventService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.jsoup.Jsoup;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AgendaEventContentLinkPlugin
implements ContentLinkPlugin {
    public static final String OBJECT_TYPE = "agendaEvent";
    private static final String TITLE_KEY = "contentLink.agendaEvent";
    private static final String ICON = "fa fa-calendar-day";
    private static final String COMMAND = "event";
    private static final ContentLinkExtension EXTENSION = new ContentLinkExtension("agendaEvent", "contentLink.agendaEvent", "fa fa-calendar-day", "event", true);
    @Autowired
    private PortalContainer container;
    @Autowired
    private UserACL userAcl;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private AgendaEventService agendaEventService;

    @PostConstruct
    public void init() {
        ((ContentLinkPluginService)this.container.getComponentInstanceOfType(ContentLinkPluginService.class)).addPlugin((ContentLinkPlugin)this);
    }

    public ContentLinkExtension getExtension() {
        return EXTENSION;
    }

    public List<ContentLinkSearchResult> search(String keyword, Identity identity, Locale locale, int offset, int limit) {
        if (this.userAcl.isAnonymousUser(identity)) {
            return Collections.emptyList();
        }
        List events = this.agendaEventService.search(new AgendaEventSearchFilter(this.getUserIdentityId(identity.getUserId()), null, keyword, null, offset, limit));
        return CollectionUtils.isEmpty((Collection)events) ? Collections.emptyList() : events.stream().map(this::toContentLink).toList();
    }

    public String getContentTitle(String objectId, Locale locale) {
        Event event = this.agendaEventService.getEventById(Long.parseLong(objectId));
        return event == null ? null : event.getSummary();
    }

    private ContentLinkSearchResult toContentLink(EventSearchResult event) {
        if (event == null) {
            return null;
        }
        return new ContentLinkSearchResult(EXTENSION.getObjectType(), String.valueOf(event.getId()), Jsoup.parse((String)event.getSummary()).text(), EXTENSION.getIcon(), EXTENSION.isDrawer());
    }

    private long getUserIdentityId(String username) {
        return Long.parseLong(this.identityManager.getOrCreateUserIdentity(username).getId());
    }
}

