/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.search;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.agenda.model.AgendaEventSearchFilter;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventSearchResult;
import org.exoplatform.agenda.search.AgendaSearchConnector;
import org.exoplatform.agenda.service.AgendaEventServiceImpl;
import org.exoplatform.agenda.service.BaseAgendaEventTest;
import org.exoplatform.agenda.util.Utils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.search.es.client.ElasticSearchingClient;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;

@RunWith(value=MockitoJUnitRunner.class)
public class AgendaSearchConnectorTest
extends BaseAgendaEventTest {
    private static final String ES_INDEX = "event_alias";
    public static final String FAKE_ES_QUERY = "{offset: @offset@, limit: @limit@, term1: @term@, term2: @term@, permissions: @permissions@}";
    @Mock
    IdentityManager identityManager;
    @Mock
    AgendaEventServiceImpl agendaEventService;
    @Mock
    SpaceService spaceService;
    @Mock
    ConfigurationManager configurationManager;
    @Mock
    ElasticSearchingClient client;
    AgendaSearchConnector agendaSearchConnector;
    String searchResult = null;
    boolean developingValue = false;

    @Override
    @Before
    public void setUp() throws ObjectNotFoundException {
        super.setUp();
        try {
            this.searchResult = IOUtil.getStreamContentAsString((InputStream)this.getClass().getClassLoader().getResourceAsStream("agenda-search-result.json"));
            Mockito.reset((Object[])new ConfigurationManager[]{this.configurationManager});
            Mockito.when((Object)this.configurationManager.getInputStream("FILE_PATH")).thenReturn((Object)new ByteArrayInputStream(FAKE_ES_QUERY.getBytes()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error retrieving ES Query content", e);
        }
        this.developingValue = PropertyManager.isDevelopping();
        PropertyManager.setProperty((String)"exo.product.developing", (String)"false");
        PropertyManager.refresh();
        this.agendaSearchConnector = new AgendaSearchConnector(this.configurationManager, this.identityManager, this.spaceService, this.agendaEventStorage, this.client, this.getParams());
    }

    @Override
    @After
    public void tearDown() throws ObjectNotFoundException {
        super.tearDown();
        PropertyManager.setProperty((String)"exo.product.developing", (String)String.valueOf(this.developingValue));
        PropertyManager.refresh();
    }

    @Test
    public void testSearchArguments() {
        String term = "searchTerm";
        try {
            this.agendaSearchConnector.search(new AgendaEventSearchFilter(-1L, ZoneId.of("US/Hawaii"), term, null, null, null, 0, 10));
            Assert.fail((String)"Should throw IllegalArgumentException: viewer identity id is mandatory");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.getId()).thenReturn((Object)"1");
        try {
            this.agendaSearchConnector.search(new AgendaEventSearchFilter(Long.parseLong(identity.getId()), ZoneId.of("US/Hawaii"), null, null, null, null, 0, 10));
            Assert.fail((String)"Should throw IllegalArgumentException: filter is mandatory");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.agendaSearchConnector.search(new AgendaEventSearchFilter(Long.parseLong(identity.getId()), ZoneId.of("US/Hawaii"), term, null, null, null, -1, 10));
            Assert.fail((String)"Should throw IllegalArgumentException: offset should be positive");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.agendaSearchConnector.search(new AgendaEventSearchFilter(Long.parseLong(identity.getId()), ZoneId.of("US/Hawaii"), term, null, null, null, 0, -1));
            Assert.fail((String)"Should throw IllegalArgumentException: limit should be positive");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSearchNoResult() {
        String term = "searchTerm";
        HashSet<Long> permissions = new HashSet<Long>(Arrays.asList(1L));
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.getId()).thenReturn((Object)"1");
        Mockito.when((Object)identity.getRemoteId()).thenReturn((Object)"testuser1");
        Mockito.when((Object)Utils.getIdentityById((IdentityManager)this.identityManager, (long)1L)).thenReturn((Object)identity);
        String expectedESQuery = FAKE_ES_QUERY.replaceAll("@term@", term).replaceAll("@permissions@", StringUtils.join(permissions, (String)",")).replaceAll("@offset@", "0").replaceAll("@limit@", "10");
        Mockito.when((Object)this.client.sendRequest((String)Mockito.eq((Object)expectedESQuery), (String)Mockito.eq((Object)ES_INDEX))).thenReturn((Object)"{}");
        Mockito.when((Object)this.spaceService.getMemberSpaces((String)Mockito.eq((Object)"testuser1"))).thenAnswer((Answer)new Answer<ListAccess<Space>>(){

            public ListAccess<Space> answer(InvocationOnMock invocation) throws Throwable {
                ListAccess userSpaces = (ListAccess)Mockito.mock(ListAccess.class);
                boolean spacesCount = true;
                Mockito.when((Object)userSpaces.getSize()).thenReturn((Object)1);
                Mockito.when((Object)((Space[])userSpaces.load(Mockito.anyInt(), Mockito.anyInt()))).thenAnswer((Answer)new Answer<Space[]>(){

                    public Space[] answer(InvocationOnMock invocation) throws Throwable {
                        Object[] args = invocation.getArguments();
                        int size = Integer.parseInt(args[1].toString());
                        Space[] spaces = new Space[size];
                        spaces[0] = new Space();
                        String prettyName = "testspace1";
                        int spaceIdentityIndex = 1;
                        spaces[0].setId(String.valueOf(spaceIdentityIndex));
                        spaces[0].setPrettyName(prettyName);
                        Identity spaceIdentity = new Identity(String.valueOf(spaceIdentityIndex));
                        spaceIdentity.setProviderId("space");
                        spaceIdentity.setRemoteId(prettyName);
                        Mockito.when((Object)AgendaSearchConnectorTest.this.identityManager.getOrCreateIdentity((String)Mockito.eq((Object)"space"), (String)Mockito.eq((Object)prettyName))).thenReturn((Object)spaceIdentity);
                        return spaces;
                    }
                });
                return userSpaces;
            }
        });
        List result = this.agendaSearchConnector.search(new AgendaEventSearchFilter(Long.parseLong(identity.getId()), ZoneId.of("US/Hawaii"), term, null, null, null, 0, 10));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testSearchWithResult() throws Exception {
        String term = "searchTerm";
        HashSet<Long> permissions = new HashSet<Long>(Arrays.asList(1L));
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.getId()).thenReturn((Object)"1");
        Mockito.when((Object)identity.getRemoteId()).thenReturn((Object)"testuser1");
        Mockito.when((Object)Utils.getIdentityById((IdentityManager)this.identityManager, (long)1L)).thenReturn((Object)identity);
        String expectedESQuery = FAKE_ES_QUERY.replaceAll("@term@", term).replaceAll("@permissions@", StringUtils.join(permissions, (String)",")).replaceAll("@offset@", "0").replaceAll("@limit@", "10");
        Mockito.when((Object)this.client.sendRequest((String)Mockito.eq((Object)expectedESQuery), (String)Mockito.eq((Object)ES_INDEX))).thenReturn((Object)this.searchResult);
        long startTime = 1602979200000L;
        long endTime = 1603151999000L;
        ZonedDateTime start = ZonedDateTime.ofInstant(Instant.ofEpochMilli(startTime), ZoneId.systemDefault());
        ZonedDateTime end = ZonedDateTime.ofInstant(Instant.ofEpochMilli(endTime), ZoneId.systemDefault());
        boolean allDay = true;
        Event event = this.newEventInstance(start, end, allDay);
        event = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity);
        Mockito.lenient().when((Object)this.agendaEventService.getEventById(Mockito.eq((long)1L))).thenReturn((Object)event);
        Mockito.when((Object)this.spaceService.getMemberSpaces((String)Mockito.eq((Object)"testuser1"))).thenAnswer((Answer)new Answer<ListAccess<Space>>(){

            public ListAccess<Space> answer(InvocationOnMock invocation) throws Throwable {
                ListAccess userSpaces = (ListAccess)Mockito.mock(ListAccess.class);
                boolean spacesCount = true;
                Mockito.when((Object)userSpaces.getSize()).thenReturn((Object)1);
                Mockito.when((Object)((Space[])userSpaces.load(Mockito.anyInt(), Mockito.anyInt()))).thenAnswer((Answer)new Answer<Space[]>(){

                    public Space[] answer(InvocationOnMock invocation) throws Throwable {
                        Object[] args = invocation.getArguments();
                        int size = Integer.parseInt(args[1].toString());
                        Space[] spaces = new Space[size];
                        spaces[0] = new Space();
                        String prettyName = "testspace1";
                        int spaceIdentityIndex = 1;
                        spaces[0].setId(String.valueOf(spaceIdentityIndex));
                        spaces[0].setPrettyName(prettyName);
                        Identity spaceIdentity = new Identity(String.valueOf(spaceIdentityIndex));
                        spaceIdentity.setProviderId("space");
                        spaceIdentity.setRemoteId(prettyName);
                        Mockito.when((Object)AgendaSearchConnectorTest.this.identityManager.getOrCreateIdentity((String)Mockito.eq((Object)"space"), (String)Mockito.eq((Object)prettyName))).thenReturn((Object)spaceIdentity);
                        return spaces;
                    }
                });
                return userSpaces;
            }
        });
        List result = this.agendaSearchConnector.search(new AgendaEventSearchFilter(Long.parseLong(identity.getId()), ZoneId.of("US/Hawaii"), term, null, null, null, 0, 10));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        EventSearchResult eventSearchResult = (EventSearchResult)result.iterator().next();
        Assert.assertEquals((long)1L, (long)eventSearchResult.getId());
        Assert.assertTrue((boolean)eventSearchResult.getSummary().contains("searchMatchExcerpt"));
        Assert.assertTrue((boolean)eventSearchResult.getSummary().contains(term));
        Assert.assertEquals((Object)event.getDescription(), (Object)eventSearchResult.getDescription());
        Assert.assertEquals((long)1L, (long)eventSearchResult.getCalendarId());
        Assert.assertEquals((Object)event.getLocation(), (Object)eventSearchResult.getLocation());
        ZonedDateTime eventStartDateInMS = Utils.toDateTime((String)String.valueOf(startTime), (ZoneId)ZoneId.of("US/Hawaii"));
        ZonedDateTime eventEndDateInMS = Utils.toDateTime((String)String.valueOf(endTime), (ZoneId)ZoneId.of("US/Hawaii"));
        Assert.assertEquals((Object)eventStartDateInMS, (Object)eventSearchResult.getStart());
        Assert.assertEquals((Object)eventEndDateInMS, (Object)eventSearchResult.getEnd());
        Assert.assertEquals((long)1L, (long)eventSearchResult.getExcerpts().size());
    }

    private InitParams getParams() {
        InitParams params = new InitParams();
        PropertiesParam propertiesParam = new PropertiesParam();
        propertiesParam.setName("constructor.params");
        propertiesParam.setProperty("index", ES_INDEX);
        ValueParam valueParam = new ValueParam();
        valueParam.setName("query.file.path");
        valueParam.setValue("FILE_PATH");
        params.addParameter((Parameter)propertiesParam);
        params.addParameter((Parameter)valueParam);
        return params;
    }
}

