/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.agenda.service.notification.plugin;

import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.exoplatform.agenda.constant.AgendaEventModificationType;
import org.exoplatform.agenda.constant.EventRecurrenceFrequency;
import org.exoplatform.agenda.model.Event;
import org.exoplatform.agenda.model.EventRecurrence;
import org.exoplatform.agenda.notification.plugin.AgendaNotificationPlugin;
import org.exoplatform.agenda.service.BaseAgendaEventTest;
import org.exoplatform.agenda.util.NotificationUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.junit.Assert;
import org.junit.Test;

public class AgendaNotificationPluginTest
extends BaseAgendaEventTest {
    public static final ArgumentLiteral<String> EVENT_TITLE = new ArgumentLiteral(String.class, "eventTitle");

    @Test
    public void testMakeNotificationWhenCreateEvent() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        Event event = this.newEventInstance(start, start, false);
        Event createdEvent = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser2Identity, this.testuser3Identity, this.spaceIdentity);
        InitParams initParams = new InitParams();
        ValueParam value = new ValueParam();
        value.setName("EventAddedNotificationPlugin");
        value.setValue("#111111");
        initParams.addParam((Object)value);
        value.setName("agenda.notification.plugin.key");
        value.setValue("111");
        initParams.addParam((Object)value);
        AgendaNotificationPlugin agendaNotificationPlugin = new AgendaNotificationPlugin(initParams, this.identityManager, this.agendaCalendarService, this.spaceService);
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(NotificationUtils.EVENT_AGENDA, (Object)createdEvent).append(NotificationUtils.EVENT_ATTENDEE, (Object)this.agendaEventAttendeeService.getEventAttendees(createdEvent.getId()).getEventAttendees()).append(EVENT_TITLE, (Object)createdEvent.getSummary()).append(NotificationUtils.EVENT_MODIFICATION_TYPE, (Object)AgendaEventModificationType.ADDED.name());
        String eventUrl = System.getProperty("gatein.email.domain.url").concat("portal/classic/agenda?eventId=").concat(String.valueOf(createdEvent.getId()));
        long nbAttendee = this.agendaEventAttendeeService.getEventAttendees(createdEvent.getId()).size();
        long ownerId = this.agendaCalendarService.getCalendarById(createdEvent.getCalendarId()).getOwnerId();
        NotificationInfo notificationInfo = agendaNotificationPlugin.makeNotification(ctx);
        Assert.assertEquals((Object)String.valueOf(createdEvent.getId()), (Object)notificationInfo.getValueOwnerParameter("eventId"));
        Assert.assertEquals((Object)String.valueOf(ownerId), (Object)notificationInfo.getValueOwnerParameter("ownerId"));
        Assert.assertEquals((Object)createdEvent.getSummary(), (Object)notificationInfo.getValueOwnerParameter("eventTitle"));
        Assert.assertEquals((long)nbAttendee, (long)notificationInfo.getSendToUserIds().size());
        Assert.assertTrue((boolean)notificationInfo.getValueOwnerParameter("Url").startsWith(eventUrl));
    }

    @Test
    public void testMakeNotificationWhenUpdateEvent() throws Exception {
        ZonedDateTime start = ZonedDateTime.now().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        Space space = this.createSpace("Test space notifications2", this.testuser4Identity.getRemoteId());
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
        Event createdEvent = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser1Identity, this.testuser2Identity, this.testuser3Identity, spaceIdentity);
        Event updatedEvent = this.agendaEventService.getEventById(createdEvent.getId(), null, Long.parseLong(this.testuser1Identity.getId()));
        List eventAttendees = this.agendaEventAttendeeService.getEventAttendees(updatedEvent.getId()).getEventAttendees();
        this.agendaEventService.updateEvent(updatedEvent, eventAttendees, null, null, null, null, true, Long.parseLong(this.testuser1Identity.getId()));
        InitParams initParams = new InitParams();
        ValueParam value = new ValueParam();
        value.setName("EventModifiedNotificationPlugin");
        value.setValue("#222222");
        initParams.addParam((Object)value);
        value.setName("agenda.notification.plugin.key");
        value.setValue("222");
        initParams.addParam((Object)value);
        AgendaNotificationPlugin agendaNotificationPlugin = new AgendaNotificationPlugin(initParams, this.identityManager, this.agendaCalendarService, this.spaceService);
        updatedEvent.setUpdated(start);
        updatedEvent.setModifierId(Long.parseLong(this.testuser1Identity.getId()));
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(NotificationUtils.EVENT_AGENDA, (Object)updatedEvent).append(NotificationUtils.EVENT_ATTENDEE, (Object)this.agendaEventAttendeeService.getEventAttendees(updatedEvent.getId()).getEventAttendees()).append(EVENT_TITLE, (Object)updatedEvent.getSummary()).append(NotificationUtils.EVENT_MODIFICATION_TYPE, (Object)AgendaEventModificationType.UPDATED.name());
        String eventUrl = System.getProperty("gatein.email.domain.url").concat("portal/classic/agenda?eventId=").concat(String.valueOf(createdEvent.getId()));
        long nbAttendee = this.agendaEventAttendeeService.getEventAttendees(updatedEvent.getId()).size();
        long ownerId = this.agendaCalendarService.getCalendarById(updatedEvent.getCalendarId()).getOwnerId();
        NotificationInfo notificationInfo = agendaNotificationPlugin.makeNotification(ctx);
        Assert.assertEquals((Object)String.valueOf(updatedEvent.getId()), (Object)notificationInfo.getValueOwnerParameter("eventId"));
        Assert.assertEquals((Object)String.valueOf(ownerId), (Object)notificationInfo.getValueOwnerParameter("ownerId"));
        Assert.assertEquals((Object)updatedEvent.getSummary(), (Object)notificationInfo.getValueOwnerParameter("eventTitle"));
        Assert.assertEquals((Object)String.valueOf(nbAttendee + 1L), (Object)String.valueOf(notificationInfo.getSendToUserIds().size()));
        Assert.assertTrue((boolean)notificationInfo.getValueOwnerParameter("Url").startsWith(eventUrl));
        NotificationContext ctx2 = NotificationContextImpl.cloneInstance().append(NotificationUtils.EVENT_AGENDA, (Object)updatedEvent).append(NotificationUtils.EVENT_ATTENDEE, (Object)this.agendaEventAttendeeService.getEventAttendees(updatedEvent.getId()).getEventAttendees()).append(EVENT_TITLE, (Object)updatedEvent.getSummary()).append(NotificationUtils.EVENT_MODIFICATION_TYPE, (Object)AgendaEventModificationType.UPDATED);
        try {
            agendaNotificationPlugin.makeNotification(ctx2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMakeNotificationWhenCreateRecurrentEvent() throws Exception {
        ZonedDateTime start = this.getDate().withNano(0);
        boolean allDay = true;
        Event event = this.newEventInstance(start, start, allDay);
        Event createdEvent = this.createEvent(event.clone(), Long.parseLong(this.testuser1Identity.getId()), this.testuser2Identity, this.testuser3Identity);
        InitParams initParams = new InitParams();
        ValueParam value = new ValueParam();
        value.setName("EventAddedNotificationPlugin");
        value.setValue("#333333");
        initParams.addParam((Object)value);
        value.setName("agenda.notification.plugin.key");
        value.setValue("333");
        initParams.addParam((Object)value);
        AgendaNotificationPlugin agendaNotificationPlugin = new AgendaNotificationPlugin(initParams, this.identityManager, this.agendaCalendarService, this.spaceService);
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(NotificationUtils.EVENT_AGENDA, (Object)createdEvent).append(NotificationUtils.EVENT_ATTENDEE, (Object)this.agendaEventAttendeeService.getEventAttendees(createdEvent.getId()).getEventAttendees()).append(EVENT_TITLE, (Object)createdEvent.getSummary()).append(NotificationUtils.EVENT_MODIFICATION_TYPE, (Object)AgendaEventModificationType.ADDED.name());
        String eventUrl = System.getProperty("gatein.email.domain.url").concat("portal/classic/agenda?eventId=").concat(String.valueOf(createdEvent.getId()));
        long nbAttendee = this.agendaEventAttendeeService.getEventAttendees(createdEvent.getId()).size();
        long ownerId = this.agendaCalendarService.getCalendarById(createdEvent.getCalendarId()).getOwnerId();
        NotificationInfo notificationInfo = agendaNotificationPlugin.makeNotification(ctx);
        Assert.assertEquals((Object)String.valueOf(createdEvent.getId()), (Object)notificationInfo.getValueOwnerParameter("eventId"));
        Assert.assertEquals((Object)String.valueOf(ownerId), (Object)notificationInfo.getValueOwnerParameter("ownerId"));
        Assert.assertEquals((Object)createdEvent.getSummary(), (Object)notificationInfo.getValueOwnerParameter("eventTitle"));
        Assert.assertEquals((long)nbAttendee, (long)notificationInfo.getSendToUserIds().size());
        Assert.assertTrue((boolean)notificationInfo.getValueOwnerParameter("Url").startsWith(eventUrl));
        Assert.assertEquals((Object)"daily", (Object)notificationInfo.getValueOwnerParameter("recurrenceDetails"));
        createdEvent.setCalendarId(this.spaceCalendar.getId());
        createdEvent.setStart(ZonedDateTime.now());
        createdEvent.setEnd(ZonedDateTime.now());
        createdEvent.setSummary("event recurrent");
        EventRecurrence recurrence = new EventRecurrence();
        createdEvent.setRecurrence(recurrence);
        recurrence.setFrequency(EventRecurrenceFrequency.WEEKLY);
        recurrence.setInterval(1);
        List<String> days = Arrays.asList("MO", "TU", "WE");
        recurrence.setByDay(days);
        List eventAttendees = this.agendaEventAttendeeService.getEventAttendees(createdEvent.getId()).getEventAttendees();
        this.agendaEventService.updateEvent(createdEvent, eventAttendees, Collections.emptyList(), Collections.emptyList(), null, null, true, Long.parseLong(this.testuser1Identity.getId()));
        InitParams initParams1 = new InitParams();
        ValueParam value1 = new ValueParam();
        value1.setName("EventAddedNotificationPlugin");
        value1.setValue("#333333");
        initParams1.addParam((Object)value1);
        value1.setName("agenda.notification.plugin.key");
        value1.setValue("333");
        initParams1.addParam((Object)value1);
        AgendaNotificationPlugin agendaNotificationPlugin1 = new AgendaNotificationPlugin(initParams1, this.identityManager, this.agendaCalendarService, this.spaceService);
        NotificationContext ctx1 = NotificationContextImpl.cloneInstance().append(NotificationUtils.EVENT_AGENDA, (Object)createdEvent).append(NotificationUtils.EVENT_ATTENDEE, (Object)this.agendaEventAttendeeService.getEventAttendees(createdEvent.getId()).getEventAttendees()).append(EVENT_TITLE, (Object)createdEvent.getSummary()).append(NotificationUtils.EVENT_MODIFICATION_TYPE, (Object)AgendaEventModificationType.ADDED.name());
        String eventUrl1 = System.getProperty("gatein.email.domain.url").concat("portal/classic/agenda?eventId=").concat(String.valueOf(createdEvent.getId()));
        long nbAttendee1 = this.agendaEventAttendeeService.getEventAttendees(createdEvent.getId()).size();
        long ownerId1 = this.agendaCalendarService.getCalendarById(createdEvent.getCalendarId()).getOwnerId();
        NotificationInfo notificationInfo1 = agendaNotificationPlugin1.makeNotification(ctx1);
        Assert.assertEquals((Object)String.valueOf(createdEvent.getId()), (Object)notificationInfo1.getValueOwnerParameter("eventId"));
        Assert.assertEquals((Object)String.valueOf(ownerId1), (Object)notificationInfo1.getValueOwnerParameter("ownerId"));
        Assert.assertEquals((Object)createdEvent.getSummary(), (Object)notificationInfo1.getValueOwnerParameter("eventTitle"));
        Assert.assertEquals((long)nbAttendee1, (long)notificationInfo1.getSendToUserIds().size());
        Assert.assertTrue((boolean)notificationInfo1.getValueOwnerParameter("Url").startsWith(eventUrl1));
        Assert.assertEquals((Object)"Weekly on monday,tuesday,wednesday", (Object)notificationInfo1.getValueOwnerParameter("recurrenceDetails"));
    }
}

