/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antibruteforce.plugin;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import org.exoplatform.antibruteforce.plugin.AntiBruteForceAuthenticationPlugin;
import org.exoplatform.antibruteforce.utils.Utils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.organization.AccountTemporaryLockedException;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class AntiBruteForceAuthenticationPluginTest {
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<Utils> UTILS = Mockito.mockStatic(Utils.class);
    @Mock
    private OrganizationService organizationService;
    @Mock
    private ListenerService listenerService;
    private AntiBruteForceAuthenticationPlugin antiBruteForceAuthenticationPlugin;

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS.close();
        UTILS.close();
    }

    @Before
    public void setUp() throws Exception {
        InitParams params = new InitParams();
        PropertiesParam maxAuthAttempts = new PropertiesParam();
        maxAuthAttempts.setProperty("maxAuthenticationAttempts", "5");
        PropertiesParam blockTime = new PropertiesParam();
        blockTime.setProperty("blockingTime", "10");
        params.addParameter((Parameter)maxAuthAttempts);
        params.addParameter((Parameter)blockTime);
        this.antiBruteForceAuthenticationPlugin = new AntiBruteForceAuthenticationPlugin(params, this.organizationService, this.listenerService);
    }

    @Test
    public void doCheck() throws Exception {
        UserProfile userProfile = (UserProfile)Mockito.mock(UserProfile.class);
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getUserName()).thenReturn((Object)"user");
        UserProfileHandler userProfileHandler = (UserProfileHandler)Mockito.mock(UserProfileHandler.class);
        Mockito.when((Object)this.organizationService.getUserProfileHandler()).thenReturn((Object)userProfileHandler);
        Mockito.when((Object)userProfileHandler.findUserProfileByName("user")).thenReturn((Object)userProfile);
        Mockito.when((Object)userProfile.getAttribute("authenticationAttempts")).thenReturn((Object)"5");
        Mockito.when((Object)userProfile.getAttribute("latestAuthFailureTime")).thenReturn((Object)String.valueOf(Timestamp.from(Instant.now()).getTime()));
        Assert.assertThrows(AccountTemporaryLockedException.class, () -> this.antiBruteForceAuthenticationPlugin.doCheck(user));
        Mockito.when((Object)userProfile.getAttribute("authenticationAttempts")).thenReturn((Object)"5");
        Mockito.when((Object)userProfile.getAttribute("latestAuthFailureTime")).thenReturn((Object)String.valueOf(Timestamp.from(Instant.now().minus(10L, ChronoUnit.MINUTES)).getTime()));
        try {
            this.antiBruteForceAuthenticationPlugin.doCheck(user);
        }
        catch (Exception e) {
            Assert.fail((String)"AccountTemporaryLockedException Should not be thrown here");
        }
    }

    @Test
    public void onCheckFail() throws Exception {
        User user = (User)Mockito.mock(User.class);
        UserProfile userProfile = (UserProfile)Mockito.mock(UserProfile.class);
        UserProfileHandler userProfileHandler = (UserProfileHandler)Mockito.mock(UserProfileHandler.class);
        UserHandler userHandler = (UserHandler)Mockito.mock(UserHandler.class);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)userHandler);
        Mockito.when((Object)userHandler.findUserByName("user")).thenReturn((Object)user);
        Mockito.when((Object)this.organizationService.getUserProfileHandler()).thenReturn((Object)userProfileHandler);
        Mockito.when((Object)userProfileHandler.findUserProfileByName("user")).thenReturn((Object)userProfile);
        Mockito.when((Object)userProfile.getAttribute("authenticationAttempts")).thenReturn((Object)"3");
        this.antiBruteForceAuthenticationPlugin.onCheckFail("user");
        ((UserProfile)Mockito.verify((Object)userProfile, (VerificationMode)Mockito.times((int)1))).setAttribute("authenticationAttempts", "4");
        UTILS.verifyNoInteractions();
        Mockito.when((Object)userProfile.getAttribute("authenticationAttempts")).thenReturn((Object)"4");
        this.antiBruteForceAuthenticationPlugin.onCheckFail("user");
        ((UserProfile)Mockito.verify((Object)userProfile, (VerificationMode)Mockito.times((int)1))).setAttribute("authenticationAttempts", "5");
        UTILS.verify(() -> Utils.sendAccountLockedEmail((User)((User)ArgumentMatchers.eq((Object)user)), (Locale)((Locale)ArgumentMatchers.any()), (OrganizationService)((OrganizationService)ArgumentMatchers.eq((Object)this.organizationService))), Mockito.times((int)1));
        Utils.sendAccountLockedEmail((User)user, (Locale)Locale.ENGLISH, (OrganizationService)this.organizationService);
    }

    @Test
    public void onCheckSuccess() throws Exception {
        User user = (User)Mockito.mock(User.class);
        UserProfile userProfile = (UserProfile)Mockito.mock(UserProfile.class);
        UserProfileHandler userProfileHandler = (UserProfileHandler)Mockito.mock(UserProfileHandler.class);
        UserHandler userHandler = (UserHandler)Mockito.mock(UserHandler.class);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)userHandler);
        Mockito.when((Object)userHandler.findUserByName("user")).thenReturn((Object)user);
        Mockito.when((Object)this.organizationService.getUserProfileHandler()).thenReturn((Object)userProfileHandler);
        Mockito.when((Object)userProfileHandler.findUserProfileByName("user")).thenReturn((Object)userProfile);
        this.antiBruteForceAuthenticationPlugin.onCheckSuccess("user");
        ((UserProfile)Mockito.verify((Object)userProfile, (VerificationMode)Mockito.times((int)1))).setAttribute("authenticationAttempts", "0");
    }
}

