/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antibruteforce.utils;

import java.util.Locale;
import org.exoplatform.antibruteforce.utils.Utils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.MailUtils;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.organization.idm.UserImpl;
import org.exoplatform.services.organization.impl.UserProfileImpl;
import org.exoplatform.services.resources.ExoResourceBundle;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.metadata.ControllerDescriptor;
import org.exoplatform.web.controller.router.Router;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class UtilsTest {
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<MailUtils> MAIL_UTILS = Mockito.mockStatic(MailUtils.class);
    User user;
    OrganizationService organizationService;
    MailService mailService;

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS.close();
        MAIL_UTILS.close();
    }

    @Before
    public void setUp() throws Exception {
        this.organizationService = (OrganizationService)Mockito.mock(OrganizationService.class);
        String userName = "ali";
        this.user = new UserImpl(userName);
        this.user.setFirstName("Ali");
        this.user.setEmail("ali@exo.com");
        UserProfileHandler userProfileHandler = (UserProfileHandler)Mockito.mock(UserProfileHandler.class);
        Mockito.when((Object)userProfileHandler.findUserProfileByName((String)ArgumentMatchers.any())).thenReturn((Object)new UserProfileImpl(userName));
        Mockito.when((Object)this.organizationService.getUserProfileHandler()).thenReturn((Object)userProfileHandler);
        this.mailService = (MailService)Mockito.mock(MailService.class);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(MailService.class)).thenReturn((Object)this.mailService);
        MAIL_UTILS.when(() -> MailUtils.getSenderEmail()).thenReturn((Object)"security@exo.com");
        MAIL_UTILS.when(() -> MailUtils.getSenderName()).thenReturn((Object)"Security Team");
        ExoResourceBundle bundle = new ExoResourceBundle("antibruteforce.accountLocked.email.subject=Locked email\r\nkey2=value");
        ResourceBundleService resourceBundleService = (ResourceBundleService)Mockito.mock(ResourceBundleService.class);
        Mockito.when((Object)resourceBundleService.getResourceBundle(ArgumentMatchers.anyString(), (Locale)ArgumentMatchers.any())).thenReturn((Object)bundle);
        COMMONS_UTILS.when(() -> CommonsUtils.getService(ResourceBundleService.class)).thenReturn((Object)resourceBundleService);
        WebAppController webAppController = (WebAppController)Mockito.mock(WebAppController.class);
        Mockito.when((Object)webAppController.getRouter()).thenReturn((Object)new Router(new ControllerDescriptor()));
        COMMONS_UTILS.when(() -> CommonsUtils.getService(WebAppController.class)).thenReturn((Object)webAppController);
    }

    @Test
    public void testSendAccountLockedEmail() {
        try {
            Utils.sendAccountLockedEmail((User)this.user, (Locale)Locale.getDefault(), (OrganizationService)this.organizationService);
            ((MailService)Mockito.verify((Object)this.mailService, (VerificationMode)Mockito.times((int)1))).sendMessage((Message)ArgumentMatchers.any());
        }
        catch (Exception e) {
            Assert.fail();
        }
    }
}

