/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antimalware.notification.provider;

import java.io.Writer;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.notification.LinkProviderUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="MalwareDetectionPlugin", template="war:/notification/templates/mail/MalwareDetectionPlugin.gtmpl")})
public class MailTemplateProvider
extends TemplateProvider {
    private IdentityManager identityManager;

    public MailTemplateProvider(InitParams initParams, IdentityManager identityManager) {
        super(initParams);
        this.identityManager = identityManager;
        this.templateBuilders.put(PluginKey.key((String)"MalwareDetectionPlugin"), new TemplateBuilder());
    }

    private class TemplateBuilder
    extends AbstractTemplateBuilder {
        private TemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext notificationContext) {
            NotificationInfo notificationInfo = notificationContext.getNotificationInfo();
            String pluginId = notificationInfo.getKey().getId();
            String language = this.getLanguage(notificationInfo);
            HTMLEntityEncoder encoder = HTMLEntityEncoder.getInstance();
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)MailTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            String infectedItemName = notificationInfo.getValueOwnerParameter("infectedItemName");
            MessageInfo messageInfo = new MessageInfo();
            Identity receiver = MailTemplateProvider.this.identityManager.getOrCreateIdentity("organization", notificationInfo.getTo());
            templateContext.put((Object)"FIRST_NAME", (Object)encoder.encode(receiver.getProfile().getProperty("firstName").toString()));
            templateContext.put((Object)"INFECTED_ITEM_NAME", (Object)infectedItemName);
            templateContext.put((Object)"FOOTER_LINK", (Object)LinkProviderUtils.getRedirectUrl((String)"notification_settings", (String)receiver.getRemoteId()));
            String subject = TemplateUtils.processSubject((TemplateContext)templateContext);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            notificationContext.setException(templateContext.getException());
            return messageInfo.subject(subject).body(body).end();
        }

        protected boolean makeDigest(NotificationContext notificationContext, Writer writer) {
            return false;
        }
    }
}

