/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antimalware.connector;

import jakarta.annotation.PostConstruct;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.antimalware.connector.MalwareDetectionItemConnector;
import org.exoplatform.antimalware.service.MalwareDetectionService;
import org.exoplatform.services.listener.ListenerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExternalFileSystemItemConnector
extends MalwareDetectionItemConnector {
    @Autowired
    private MalwareDetectionService malwareDetectionService;
    @Autowired
    private ListenerService listenerService;
    private static final String FILES = "files";
    private static final String JCR = "jcr";
    private static final String TYPE = "externalFileSystem";

    @PostConstruct
    public void init() {
        this.setType(TYPE);
        this.setEnable(true);
        this.malwareDetectionService.addMalwareDetectionItemConnector(this);
    }

    @Override
    public boolean canProcessInfectedItem(String infectedItemPath) {
        return !infectedItemPath.contains(File.separator + FILES + File.separator) && !infectedItemPath.contains(File.separator + JCR + File.separator);
    }

    @Override
    public List<Map<String, String>> getInfectedItems(String infectedItemPath) {
        HashMap<String, String> item = new HashMap<String, String>();
        item.put("infectedItemPath", infectedItemPath);
        item.put(TYPE, this.getType());
        return List.of(item);
    }

    @Override
    public void cleanInfectedItem(Map<String, String> infectedItem) {
        this.listenerService.broadcast("clean-file-infected", (Object)this.getType(), infectedItem);
    }

    @Override
    public void processInfectedItem(String infectedItemPath) {
        for (Map<String, String> infectedItem : this.getInfectedItems(infectedItemPath)) {
            this.cleanInfectedItem(infectedItem);
        }
    }
}

